package com.tydic.async.exterior.config.mq;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.async.call.bo.Response;
import com.tydic.async.call.future.DefaultAsyncFuture;
import lombok.extern.slf4j.Slf4j;

/**
 * 标题：类名称:ExteriorMqConsumer
 * 说明：描述一下类的作用TODO
 * 时间：2022/1/10 5:04 PM
 * 作者 @author hegy2017
 */
@Slf4j
public class ExteriorMqConsumer extends DefaultProxyMessageConfig implements ProxyMessageConsumer {

    @Override
    public ProxyConsumerStatus onMessage(ProxyMessage message) {
        log.info("外网拿到消息" + message.toString());
        String msg = JSONObject.parseObject(message.getContent(), String.class);
        Response rsp = new Response();
        rsp.setResult(msg);
        rsp.setId(10086L);
        DefaultAsyncFuture.received(rsp);
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }
}
