package com.tydic.async.exterior.config.mq;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.async.call.bo.Response;
import com.tydic.async.call.constant.AsyncConstant;
import com.tydic.async.call.future.DefaultAsyncFuture;
import lombok.extern.slf4j.Slf4j;

/**
 * 标题：类名称:ExteriorMqConsumer
 * 说明：描述一下类的作用TODO
 * 时间：2022/1/10 5:04 PM
 * 作者 @author hegy2017
 */
@Slf4j
public class ExteriorMqConsumer extends DefaultProxyMessageConfig implements ProxyMessageConsumer {

    @Override
    public ProxyConsumerStatus onMessage(ProxyMessage message) {

        JSONObject msgObject = JSONObject.parseObject(message.getContent(), JSONObject.class);
        if(log.isDebugEnabled()){
            log.debug("外网拿到消息" + msgObject);
        }
        //转换为响应的对象
        Long messageId  = (Long)msgObject.get(AsyncConstant.REQUEST_KEY);
        //移除消息id对象
        msgObject.remove(AsyncConstant.REQUEST_KEY);
        //设置返回对象
        Response rsp = new Response();
        rsp.setResult(msgObject);
        rsp.setId(messageId);
        DefaultAsyncFuture.received(rsp);
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }
}
