package com.tydic.async.exterior.config.mq;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.async.call.bo.MqMethodMeta;
import com.tydic.async.exterior.properties.ExteriorCallProperties;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * 标题：类名称:ExteriorMqProvider
 * 说明：外部消息生产者
 * 时间：2022/1/10 4:29 PM
 * 作者 @author hegy2017
 */
@Slf4j
@Component
public class ExteriorMqProvider {

    @Autowired
    private ExteriorCallProperties exteriorProperties;

    @Resource(name = "exteriorProvider")
    private ProxyMessageProducer proxyMessageProducer;

    /**
     * 发送消息
     *
     * @param meta
     * @return
     */
    public ProxySendResult provideMessage(MqMethodMeta meta) {
        ProxySendResult sendResult;

        if (log.isDebugEnabled()) {
            log.debug("初始消息为：" + JSONObject.toJSONString(meta));
        }

        if (null == meta.getInterfaceName()) {
            throw new ZTBusinessException("无服务名");
        }
        if (null == meta.getMethodName()) {
            throw new ZTBusinessException("无方法名");
        }
        if (null == meta.getParamTypeNames()) {
            throw new ZTBusinessException("无入参类型名");
        }
        try {
            sendResult = proxyMessageProducer.send(new ProxyMessage(exteriorProperties.getTopic(), exteriorProperties.getTag(),
                    JSONObject.toJSONString(meta)));

            if (log.isDebugEnabled()) {
                log.debug("外网发送消息成功");
            }
        } catch (Exception e) {
            throw new ZTBusinessException("消息发送失败！");
        }
        return sendResult;
    }

}
