package com.tydic.async.exterior.properties;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.io.Serializable;

/**
 * 标题：类名称:ExteriorInvokeProperties
 * 说明：外网消费队列的配置
 * 时间：2022/1/10 5:13 PM
 * 作者 @author hegy2017
 */
@Data
@ConfigurationProperties(prefix = "exterior.mq.invoke")
public class ExteriorInvokeProperties implements Serializable {

    private static final long serialVersionUID = -5221664915065955447L;
    /**
     * 队列主题
     */
    private String topic;

    /**
     * 队列标签
     */
    private String tag;

    /**
     * 队列ID
     */
    private String pid;

    /**
     * 队列模式
     */
    private String model;
}
