/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.async.exterior.processer;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.bo.RspBaseBO;
import com.tydic.async.call.annotation.AsyncInvoker;
import com.tydic.async.call.bo.AsyncRequest;
import com.tydic.async.call.bo.MqMethodMeta;
import com.tydic.async.call.future.DefaultAsyncFuture;
import com.tydic.async.exterior.config.mq.ExteriorMqProvider;
import com.tydic.async.exterior.properties.ExteriorCallProperties;
import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class AsyncInvokerBeanProcessor
implements BeanPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(AsyncInvokerBeanProcessor.class);
    private final ConcurrentMap<String, Object> proxyMap = new ConcurrentHashMap<String, Object>();
    @Autowired
    private ExteriorMqProvider exteriorMqProvider;
    @Autowired
    private ExteriorCallProperties exteriorProperties;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        Field[] fields;
        for (Field field : fields = bean.getClass().getDeclaredFields()) {
            try {
                Object value;
                AsyncInvoker asyncInvoker;
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                if ((asyncInvoker = field.getAnnotation(AsyncInvoker.class)) == null || (value = this.createProxy(field.getType())) == null) continue;
                field.set(bean, value);
            }
            catch (Throwable e) {
                log.error("Failed to init remote mq service at filed " + field.getName() + " in class " + bean.getClass().getName() + ", cause: " + e.getMessage(), e);
            }
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    private Object createProxy(Class clz) {
        if (!clz.isInterface()) {
            throw new IllegalStateException("The @MqInvoker property type " + clz.getName() + " is not a interface.");
        }
        String interfaceName = clz.getName();
        Object proxy = this.proxyMap.get(interfaceName);
        if (proxy == null) {
            Object newProxy = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{clz}, (proxy1, method, args) -> {
                if (log.isDebugEnabled()) {
                    log.debug("Execute dynamic proxy! method:{} ,args: {}", (Object)method, (Object)args);
                }
                if (method.getParameters().length != 1) {
                    throw new IllegalAccessException("MQ Service Currently only single parameter object type methods are supported");
                }
                AsyncRequest request = new AsyncRequest();
                if (!StringUtils.isEmpty((Object)this.exteriorProperties.getTimeout())) {
                    request.setTimeOut(this.exteriorProperties.getTimeout());
                }
                MqMethodMeta mqMethodMeta = new MqMethodMeta();
                mqMethodMeta.setInterfaceName(clz.getName());
                mqMethodMeta.setMethodName(method.getName());
                mqMethodMeta.setArgs(args);
                Class<?> returnType = method.getReturnType();
                String[] paramTypeNames = new String[args.length];
                for (int i = 0; i < args.length; ++i) {
                    paramTypeNames[i] = args[i].getClass().getName();
                }
                mqMethodMeta.setParamTypeNames(paramTypeNames);
                mqMethodMeta.setAsyncRequest(request);
                this.exteriorMqProvider.provideMessage(mqMethodMeta);
                DefaultAsyncFuture future = DefaultAsyncFuture.newFuture((AsyncRequest)request);
                try {
                    DefaultAsyncFuture.sent((AsyncRequest)request);
                    future.get((long)request.getTimeOut().intValue(), TimeUnit.MILLISECONDS);
                }
                catch (Exception e) {
                    log.error("future callback but catch this exception; the  message detail is " + e.getMessage());
                    future.cancel();
                    RspBaseBO rspBaseBO = new RspBaseBO();
                    rspBaseBO.setCode("1");
                    rspBaseBO.setMessage(e.getMessage());
                    future.setResult((Object)rspBaseBO);
                }
                return JSONObject.parseObject((String)String.valueOf(future.getResult()), returnType);
            });
            this.proxyMap.putIfAbsent(interfaceName, newProxy);
            proxy = this.proxyMap.get(interfaceName);
        }
        return proxy;
    }
}

