package com.tydic.async.exterior.config.mq;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.async.call.bo.MqMessageContext;
import com.tydic.async.call.bo.MqMethodMeta;
import com.tydic.async.call.constant.AsyncConstant;
import com.tydic.async.exterior.properties.ExteriorCallProperties;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * 标题：类名称:ExteriorMqProvider
 * 说明：外部消息生产者
 * 时间：2022/1/10 4:29 PM
 * 作者 @author hegy2017
 */
@Slf4j
@Component
public class ExteriorMqProvider {

    @Autowired
    private ExteriorCallProperties exteriorProperties;

    @Resource(name = "exteriorProvider")
    private ProxyMessageProducer proxyMessageProducer;

    /**
     * 发送消息
     *
     * @param meta
     * @return
     */
    public ProxySendResult provideMessage(MqMethodMeta meta) {
        ProxySendResult sendResult;

        if (log.isDebugEnabled()) {
            log.debug("init send message is ：" + JSONObject.toJSONString(meta));
        }

        if (null == meta.getInterfaceName()) {
            throw new ZTBusinessException("no such service name !");
        }
        if (null == meta.getMethodName()) {
            throw new ZTBusinessException("no such method name !");
        }
        if (null == meta.getParamTypeNames()) {
            throw new ZTBusinessException("no such param name !");
        }
        try {
            MqMessageContext<MqMethodMeta> msgContext = new MqMessageContext<>();
            msgContext.setData(meta);
            msgContext.setMsgType(AsyncConstant.MessageType.BEAN_MESSAGE);

            sendResult = proxyMessageProducer.send(new ProxyMessage(exteriorProperties.getTopic(), exteriorProperties.getTag(),
                    JSONObject.toJSONString(msgContext)));

            if (log.isDebugEnabled()) {
                log.debug("exterior send message success !");
            }
        } catch (Exception e) {
            e.printStackTrace();
            throw new ZTBusinessException("外部消息发送失败：" + e.getMessage());
        }
        return sendResult;
    }

}
