package com.tydic.async.exterior.config.mq;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.async.call.bo.CallReqContext;
import com.tydic.async.call.bo.MqMessageContext;
import com.tydic.async.call.constant.AsyncConstant;
import com.tydic.async.exterior.properties.ExteriorCallProperties;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * 标题：类名称:ExteriorMqProvider
 * 说明：外部消息生产者
 * 时间：2022/1/10 4:29 PM
 * 作者 @author hegy2017
 */
@Slf4j
@Component
public class ExteriorMqWebClientProvider {

    @Autowired
    private ExteriorCallProperties exteriorProperties;

    @Resource(name = "exteriorProvider" )
    private ProxyMessageProducer proxyMessageProducer;

    /**
     * 发送消息
     *
     * @param reqContext
     * @return
     */
    public ProxySendResult provideMessage(CallReqContext reqContext) {
        ProxySendResult sendResult;

        if (log.isDebugEnabled()) {
            log.debug("init send message is ：" + JSONObject.toJSONString(reqContext));
        }

        if (null == reqContext.getUrl()) {
            throw new ZTBusinessException("no call url !" );
        }

//        if (null == reqContext.getReqObj()) {
//            throw new ZTBusinessException("no such param name !" );
//        }
        try {
            MqMessageContext<CallReqContext> msgContext = new MqMessageContext<>();
            msgContext.setData(reqContext);
            msgContext.setMsgType(AsyncConstant.MessageType.WEB_MESSAGE);

            sendResult = proxyMessageProducer.send(new ProxyMessage(exteriorProperties.getTopic(), exteriorProperties.getTag(),
                    JSONObject.toJSONString(msgContext)));

            if (log.isDebugEnabled()) {
                log.debug("exterior send websocket message success !" );
            }
        } catch (Exception e) {
            e.printStackTrace();
            throw new ZTBusinessException("外部消息发送失败：" + e.getMessage());
        }
        return sendResult;
    }

}
