/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.async.exterior.config.mq;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.async.call.bo.MqMessageContext;
import com.tydic.async.call.bo.MqMethodMeta;
import com.tydic.async.exterior.properties.ExteriorCallProperties;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExteriorMqProvider {
    private static final Logger log = LoggerFactory.getLogger(ExteriorMqProvider.class);
    @Autowired
    private ExteriorCallProperties exteriorProperties;
    @Resource(name="exteriorProvider")
    private ProxyMessageProducer proxyMessageProducer;

    public ProxySendResult provideMessage(MqMethodMeta meta) {
        ProxySendResult sendResult;
        if (log.isDebugEnabled()) {
            log.debug("init send message is \uff1a" + JSONObject.toJSONString((Object)meta));
        }
        if (null == meta.getInterfaceName()) {
            throw new ZTBusinessException("no such service name !");
        }
        if (null == meta.getMethodName()) {
            throw new ZTBusinessException("no such method name !");
        }
        if (null == meta.getParamTypeNames()) {
            throw new ZTBusinessException("no such param name !");
        }
        try {
            MqMessageContext msgContext = new MqMessageContext();
            msgContext.setData((Object)meta);
            msgContext.setMsgType("BEAN");
            sendResult = this.proxyMessageProducer.send(new ProxyMessage(this.exteriorProperties.getTopic(), this.exteriorProperties.getTag(), JSONObject.toJSONString((Object)msgContext)));
            if (log.isDebugEnabled()) {
                log.debug("exterior send message success !");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ZTBusinessException("\u5916\u90e8\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff1a" + e.getMessage());
        }
        return sendResult;
    }
}

