/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.async.exterior.webclient;

import com.alibaba.fastjson.JSONObject;
import com.tydic.async.call.bo.AsyncRequest;
import com.tydic.async.call.bo.CallReqContext;
import com.tydic.async.call.future.DefaultAsyncFuture;
import com.tydic.async.exterior.config.mq.ExteriorMqWebClientProvider;
import java.io.IOException;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WebclientService {
    private static final Logger log = LoggerFactory.getLogger(WebclientService.class);
    @Autowired
    private ExteriorMqWebClientProvider exteriorMqWebClientProvider;

    public Object doService(HttpServletRequest request, CallReqContext reqContext) {
        AsyncRequest asyncRequest = new AsyncRequest();
        reqContext.setMessageId(Long.valueOf(asyncRequest.getId()));
        this.initReqContext(request, reqContext);
        this.exteriorMqWebClientProvider.provideMessage(reqContext);
        DefaultAsyncFuture future = DefaultAsyncFuture.newFuture((AsyncRequest)asyncRequest);
        try {
            DefaultAsyncFuture.sent((AsyncRequest)asyncRequest);
            future.get((long)asyncRequest.getTimeOut().intValue(), TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            log.error("future callback but catch this exception; the  message detail is " + e.getMessage());
            future.cancel();
        }
        return JSONObject.parseObject((String)String.valueOf(future.getResult()));
    }

    private void initReqContext(HttpServletRequest request, CallReqContext reqContext) {
        String method = request.getMethod();
        if (StringUtils.isEmpty((CharSequence)reqContext.getMethod())) {
            reqContext.setMethod(method);
        }
        reqContext.setReqData(WebclientService.readAsBytes(request));
        reqContext.getReqObj(reqContext);
        ConcurrentHashMap<String, String> headersMap = new ConcurrentHashMap<String, String>(16);
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            headersMap.put(headerName, request.getHeader(headerName));
        }
        if (StringUtils.isEmpty((CharSequence)((CharSequence)headersMap.get("Content-Type")))) {
            headersMap.put("Content-Type", "application/json");
        }
        reqContext.setHeadersMap(headersMap);
        String ip = request.getRemoteAddr();
        reqContext.setFromIp(ip);
        reqContext.setReqAcceptStartTime(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readAsBytes(HttpServletRequest request) {
        int len = request.getContentLength();
        byte[] buffer = new byte[len];
        ServletInputStream in = null;
        try {
            in = request.getInputStream();
            in.read(buffer, 0, len);
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return buffer;
    }
}

