package com.tydic.datasync.event.handler;

import com.alibaba.fastjson.JSONArray;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.datasync.event.bo.ChannelEvent;
import com.tydic.datasync.event.bo.DataSyncConstant;
import com.tydic.datasync.event.config.mq.EventMqProvider;
import com.tydic.dyc.base.events.Event;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 标题：类名称:EventMsgSenderService
 * 说明：描述一下类的作用TODO
 * 时间：2022/9/20 6:05 PM
 * 作者 @author hegy2017
 */
@Component
@Slf4j
public class EventMsgSenderService {

    /**
     * 缓存对象
     */
    @Autowired
    private CacheClient cacheClient;

    /**
     * 消息队列
     */
    @Autowired
    private EventMqProvider eventMqProvider;

    public void sendMsg(String traceId, String eventsMsg) {
        if (StringUtils.isEmpty(eventsMsg)) {
            return;
        }

        log.info("traceId:" + traceId + " 数据同步组件，应用层发送mq内容为：" + eventsMsg);
        JSONArray eventArray = JSONArray.parseArray(eventsMsg);
        List<Event> traceEventList = JSONArray.parseArray(eventArray.toString(), Event.class);

        /**
         * 1.集合分组，通过模块编码分组
         */
        Map<String, List<Event>> eventGroupMap = traceEventList.stream().
                collect(Collectors.groupingBy(Event::getModel));

        /**
         * 2.循环消息队列发送，key:mqEvent-UOC-a123sl10al1123s
         */
        for (Map.Entry<String, List<Event>> entry : eventGroupMap.entrySet()) {
            StringBuilder sb = new StringBuilder();
            sb.append(DataSyncConstant.CACHE_PREFIX);
            sb.append(DataSyncConstant.CONNECTOR_SYMBOL);
            sb.append(entry.getKey());
            sb.append(DataSyncConstant.CONNECTOR_SYMBOL);
            sb.append(traceId);
            //封装消息
            ChannelEvent mqMessage = new ChannelEvent();
            mqMessage.setTraceId(sb.toString());
            mqMessage.setTraceEventList(entry.getValue());

            //发送MQ消息
            log.info("traceId:" + traceId + " 发送mq消息,内容为:" + entry.getValue());
            eventMqProvider.provideMessage(entry.getKey(), mqMessage);
            log.info("traceId:" + traceId + " 发送mq消息,key:" + entry.getKey());

        }

        //发送完成后，删除当前的redis缓存
        cacheClient.delete(traceId);
        log.info("traceId:" + traceId + " 发送mq消息,已完成清楚！");
    }


}
