package com.tydic.datasync.event.handler;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.datasync.event.bo.ChannelEvent;
import com.tydic.datasync.event.bo.DataSyncConstant;
import com.tydic.datasync.event.config.mq.EventMqProvider;
import com.tydic.dyc.base.events.Event;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import redis.clients.jedis.JedisPubSub;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 标题：类名称:RedisEventMessageHandler
 * 说明：描述一下类的作用TODO
 * 时间：2022/3/3 5:55 PM
 * 作者 @author hegy2017
 */
//@Component
@Slf4j
public class RedisEventMessagePubSub extends JedisPubSub {


    @Autowired
    private CacheClient cacheClient;

    @Autowired
    private EventMqProvider eventMqProvider;

    @Override
    public void onMessage(String channel, String message) {
        //获取message，转为对应的对象
        final ChannelEvent channelEvent = JSON.parseObject(message, ChannelEvent.class);
        /**
         * 1.集合分组，通过模块编码分组
         */
        Map<String, List<Event>> eventGroupMap = channelEvent.getTraceEventList().stream().
                collect(Collectors.groupingBy(Event::getModel));
        /**
         * 2.循环消息队列发送，发送前将消息写入缓存,定时任务进行多次消费,key:mqEvent-UOC-a123sl10al1123s
         */
        for (Map.Entry<String, List<Event>> entry : eventGroupMap.entrySet()) {
            StringBuilder sb = new StringBuilder();
            sb.append(DataSyncConstant.CACHE_PREFIX);
            sb.append(DataSyncConstant.CONNECTOR_SYMBOL);
            sb.append(entry.getKey());
            sb.append(DataSyncConstant.CONNECTOR_SYMBOL);
            sb.append(channelEvent.getTraceId());
            //加入缓存
            cacheClient.set(sb.toString(), entry.getValue());
            //封装消息
            ChannelEvent mqMessage = new ChannelEvent();
            mqMessage.setTraceId(sb.toString());
            mqMessage.setTraceEventList(entry.getValue());

            //发送MQ消息
            eventMqProvider.provideMessage(entry.getKey(), mqMessage);
        }

    }
}
