/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.datasync.event.config;

import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.datasync.event.advice.DataSyncAppEventByPointCutAdvice;
import com.tydic.datasync.event.advice.DataSyncDomainEventByPointCutAdvice;
import com.tydic.datasync.event.handler.EventMsgSenderService;
import com.tydic.datasync.event.properties.DataSyncEventProperties;
import org.aopalliance.aop.Advice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.aspectj.AspectJExpressionPointcutAdvisor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnProperty(name={"data.sync.event.open-event"}, havingValue="true")
@EnableConfigurationProperties(value={DataSyncEventProperties.class})
public class DataSyncEventConfigurableAdvisorConfig {
    private static final Logger log = LoggerFactory.getLogger(DataSyncEventConfigurableAdvisorConfig.class);
    private static final String PACKAGE_DELIMITER = ",";
    @Autowired
    private DataSyncEventProperties dataSyncEventProperties;
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private EventMsgSenderService msgSenderService;

    @Bean
    @Order(value=-1)
    public AspectJExpressionPointcutAdvisor multipleDataSourceAdvisor() {
        AspectJExpressionPointcutAdvisor advisor = new AspectJExpressionPointcutAdvisor();
        StringBuilder expressionBuilder = null;
        if (StringUtils.hasText((String)this.dataSyncEventProperties.getPointcutPackage())) {
            if (this.dataSyncEventProperties.getPointcutPackage().contains(PACKAGE_DELIMITER)) {
                String[] nativeRpcPackageSplit;
                for (String nativeRpcPackageString : nativeRpcPackageSplit = this.dataSyncEventProperties.getPointcutPackage().split(PACKAGE_DELIMITER)) {
                    if (!StringUtils.hasText((String)nativeRpcPackageString)) continue;
                    if (null == expressionBuilder) {
                        expressionBuilder = new StringBuilder();
                        expressionBuilder.append("(execution(* ").append(nativeRpcPackageString).append("..*(..)))");
                        continue;
                    }
                    expressionBuilder.append(" || (execution(* ").append(nativeRpcPackageString).append("..*(..)))");
                }
            } else {
                expressionBuilder = new StringBuilder();
                expressionBuilder.append("(execution(* ").append(this.dataSyncEventProperties.getPointcutPackage()).append("..*(..)))");
            }
        }
        String expression = String.valueOf(expressionBuilder);
        advisor.setExpression(expression);
        log.info("\u6570\u636e\u540c\u6b65\u5207\u9762\u8868\u8fbe\u5f0f\u4e3a\uff1a" + expression);
        if (this.dataSyncEventProperties.getUseDomain().booleanValue()) {
            log.info("\u6570\u636e\u540c\u6b65\u521d\u59cb\u5316\uff1a\u9886\u57df\u5c42");
            advisor.setAdvice((Advice)new DataSyncDomainEventByPointCutAdvice(this.cacheClient));
        } else {
            log.info("\u6570\u636e\u540c\u6b65\u521d\u59cb\u5316\uff1a\u5e94\u7528\u5c42");
            advisor.setAdvice((Advice)new DataSyncAppEventByPointCutAdvice(this.cacheClient, this.msgSenderService));
        }
        log.info("\u5207\u9762\u914d\u7f6e\u5b8c\u6210\uff0c\u5207\u70b9\u89c4\u5219\u4e3a\uff1a{}", (Object)expression);
        return advisor;
    }
}

