/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.license.creator.controller;

import com.ohaotian.license.core.exception.CommonException;
import com.ohaotian.license.core.model.LicenseCreatorParam;
import com.ohaotian.license.core.result.ResponseResult;
import com.ohaotian.license.core.service.AbstractServerInfo;
import com.ohaotian.license.creator.config.LicenseCreatorProperties;
import com.ohaotian.license.creator.service.LicenseCreatorService;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin
@RestController
@RequestMapping(value={"/license"})
public class LicenseCreatorController {
    @Value(value="${springboot.license.server.prefix}")
    private String licPrefixUrl;
    @Autowired
    private LicenseCreatorService creatorService;
    @Autowired
    private LicenseCreatorProperties properties;

    @PostMapping(value={"/generate"})
    public ResponseResult generate(@RequestBody LicenseCreatorParam param) throws Exception {
        if (StringUtils.isEmpty((Object)param.getLicensePath())) {
            String licDir;
            File file;
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
            String tempPath = this.properties.getTempPath();
            if (tempPath == null || "".equals(tempPath)) {
                tempPath = AbstractServerInfo.getServerTempPath();
            }
            if (!(file = new File(licDir = tempPath + "/license/" + format.format(System.currentTimeMillis()))).exists() && !file.mkdirs()) {
                throw new CommonException("\u521b\u5efa\u76ee\u5f55" + licDir + ",\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u662f\u662f\u5426\u6709\u521b\u5efa\u76ee\u5f55\u7684\u6743\u9650\u6216\u8005\u624b\u52a8\u8fdb\u884c\u521b\u5efa\uff01");
            }
            param.setLicensePath(licDir + "/license.lic");
        }
        param.setLicUrl(this.licPrefixUrl + "download?path=" + param.getLicensePath());
        return this.creatorService.generateLicense(param);
    }

    @GetMapping(value={"/download"})
    public void downLoad(@RequestParam(value="path") String path, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int length;
        File file = new File(path);
        if (!file.exists()) {
            response.setStatus(HttpStatus.NOT_FOUND.value());
            return;
        }
        FileInputStream is = new FileInputStream(file);
        String fileName = file.getName();
        response.setContentType("multipart/form-data");
        response.setCharacterEncoding("UTF-8");
        response.setContentType("text/html");
        this.setAttachmentCoding(request, response, fileName);
        BufferedInputStream bis = new BufferedInputStream(is);
        ServletOutputStream os = response.getOutputStream();
        byte[] buffer = new byte[10240];
        while ((length = bis.read(buffer, 0, buffer.length)) != -1) {
            os.write(buffer, 0, length);
        }
        os.close();
        bis.close();
        ((InputStream)is).close();
    }

    private void setAttachmentCoding(HttpServletRequest request, HttpServletResponse response, String fileName) {
        try {
            String browser = request.getHeader("User-Agent");
            if (-1 < browser.indexOf("MSIE 6.0") || -1 < browser.indexOf("MSIE 7.0")) {
                response.addHeader("content-disposition", "attachment;filename=" + new String(fileName.getBytes(), "ISO8859-1"));
            } else if (-1 < browser.indexOf("MSIE 8.0")) {
                response.addHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
            } else if (-1 < browser.indexOf("MSIE 9.0")) {
                response.addHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
            } else if (-1 < browser.indexOf("Chrome")) {
                response.addHeader("content-disposition", "attachment;filename*=UTF-8''" + URLEncoder.encode(fileName, "UTF-8"));
            } else if (-1 < browser.indexOf("Safari")) {
                response.addHeader("content-disposition", "attachment;filename=" + new String(fileName.getBytes(), "ISO8859-1"));
            } else {
                response.addHeader("content-disposition", "attachment;filename*=UTF-8''" + URLEncoder.encode(fileName, "UTF-8"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

