/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.agreement.ability.AgrAddDispatchInfoAbilityService;
import com.tydic.agreement.ability.bo.AgrAddDispatchInfoAbilityServiceReqBO;
import com.tydic.agreement.ability.bo.AgrAddDispatchInfoAbilityServiceRspBO;
import com.tydic.agreement.busi.AgrAddDispatchInfoBusiService;
import com.tydic.agreement.busi.bo.AgrAddDispatchInfoServiceReqBO;
import com.tydic.agreement.busi.bo.AgrAddDispatchInfoServiceRspBO;
import com.tydic.agreement.common.bo.AgrProjectDispatchConfigBO;
import com.tydic.agreement.common.bo.AgrProjectDispatchItemConfigBO;
import com.tydic.agreement.dao.ProjectDispatchConfigMapper;
import com.tydic.agreement.dao.po.ProjectDispatchConfigPO;
import com.tydic.order.uoc.constant.BusinessException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_TEST/2.0.0/com.tydic.agreement.ability.AgrAddDispatchInfoAbilityService"})
public class AgrAddDispatchInfoAbilityServiceImpl
implements AgrAddDispatchInfoAbilityService {
    private static final Logger log = LoggerFactory.getLogger(AgrAddDispatchInfoAbilityServiceImpl.class);
    @Autowired
    private CacheClient cacheService;
    @Autowired
    private AgrAddDispatchInfoBusiService agrAddDispatchInfoBusiService;
    @Autowired
    private ProjectDispatchConfigMapper projectDispatchConfigMapper;

    @PostMapping(value={"addDispatchConfig"})
    public AgrAddDispatchInfoAbilityServiceRspBO addDispatchConfig(@RequestBody AgrAddDispatchInfoAbilityServiceReqBO reqBO) {
        this.duplicateCommitList(reqBO);
        this.checkReqParams(reqBO);
        ProjectDispatchConfigPO projectDispatchConfigPO = new ProjectDispatchConfigPO();
        projectDispatchConfigPO.setProjectCode(reqBO.getProjectDispatchConfigBO().getProjectCode());
        int checkResult = this.projectDispatchConfigMapper.getCheckBy(projectDispatchConfigPO);
        if (checkResult > 0) {
            throw new com.ohaotian.plugin.base.exception.BusinessException("8888", "\u9879\u76ee\u7f16\u53f7[" + reqBO.getProjectDispatchConfigBO().getProjectCode() + "]\u5df2\u5b58\u5728\uff01\u8bf7\u4e0d\u8981\u91cd\u590d\u521b\u5efa");
        }
        AgrAddDispatchInfoServiceReqBO addDispatchInfoServiceReqBO = new AgrAddDispatchInfoServiceReqBO();
        AgrProjectDispatchConfigBO projectDispatchConfigBO = new AgrProjectDispatchConfigBO();
        BeanUtils.copyProperties((Object)reqBO.getProjectDispatchConfigBO(), (Object)projectDispatchConfigBO);
        ArrayList projectDispatchItemConfigBOS = new ArrayList();
        reqBO.getProjectDispatchItemConfigBOS().forEach(itemBo -> {
            AgrProjectDispatchItemConfigBO projectDispatchItemConfigBO = new AgrProjectDispatchItemConfigBO();
            BeanUtils.copyProperties((Object)itemBo, (Object)projectDispatchItemConfigBO);
            projectDispatchItemConfigBOS.add(projectDispatchItemConfigBO);
        });
        addDispatchInfoServiceReqBO.setProjectDispatchConfigBO(projectDispatchConfigBO);
        addDispatchInfoServiceReqBO.setProjectDispatchItemConfigBOS(projectDispatchItemConfigBOS);
        AgrAddDispatchInfoServiceRspBO addDispatchInfoServiceRspBO = this.agrAddDispatchInfoBusiService.addDispatchConfig(addDispatchInfoServiceReqBO);
        AgrAddDispatchInfoAbilityServiceRspBO rspBO = new AgrAddDispatchInfoAbilityServiceRspBO();
        rspBO.setRespCode(addDispatchInfoServiceRspBO.getRespCode());
        rspBO.setRespDesc(addDispatchInfoServiceRspBO.getRespDesc());
        return rspBO;
    }

    private void duplicateCommitList(AgrAddDispatchInfoAbilityServiceReqBO reqBO) {
        String reqMd;
        String orderInfoString = JSON.toJSONString((Object)reqBO);
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            reqMd = Hex.encodeHexString((byte[])md.digest(orderInfoString.getBytes(StandardCharsets.UTF_8)));
        }
        catch (NoSuchAlgorithmException e) {
            reqMd = reqBO.getUserId() + "agrAddDispatchInfoAbilityService";
        }
        Object o = null;
        try {
            o = this.cacheService.get(reqMd);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u6d3e\u5355\u9879\u76ee\u5e42\u7b49\u6821\u9a8c\u5931\u8d25\uff1a", (Throwable)e);
            reqMd = null;
        }
        if (null != o) {
            throw new BusinessException("0100", "\u64cd\u4f5c\u592a\u9891\u7e41\uff0c\u8bf710\u79d2\u540e\u91cd\u8bd5\uff01");
        }
        if (null != reqMd) {
            try {
                this.cacheService.set(reqMd, (Object)"", 10);
            }
            catch (Exception e) {
                log.error("\u65b0\u589e\u6d3e\u5355\u9879\u76ee\u589e\u52a0\u5e42\u7b49\u63a7\u5236\u5931\u8d25\uff1a", (Throwable)e);
            }
        }
    }

    private void checkReqParams(AgrAddDispatchInfoAbilityServiceReqBO reqBO) {
        if (reqBO == null) {
            throw new com.ohaotian.plugin.base.exception.BusinessException("8888", "\u65b0\u589e\u6d3e\u5355\u89c4\u5219\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getProjectDispatchConfigBO() == null) {
            throw new com.ohaotian.plugin.base.exception.BusinessException("8888", "\u65b0\u589e\u6d3e\u5355\u89c4\u5219\u65f6\u4e3b\u4f53\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getProjectDispatchItemConfigBOS())) {
            throw new com.ohaotian.plugin.base.exception.BusinessException("8888", "\u65b0\u589e\u6d3e\u5355\u89c4\u5219\u65f6\u8f6e\u6b21\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!StringUtils.hasText((String)reqBO.getProjectDispatchConfigBO().getProjectCode())) {
            throw new com.ohaotian.plugin.base.exception.BusinessException("8888", "\u65b0\u589e\u6d3e\u5355\u89c4\u5219\u65f6[\u9879\u76ee\u7f16\u53f7]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!StringUtils.hasText((String)reqBO.getProjectDispatchConfigBO().getProjectName())) {
            throw new com.ohaotian.plugin.base.exception.BusinessException("8888", "\u65b0\u589e\u6d3e\u5355\u89c4\u5219\u65f6[\u9879\u76ee\u540d\u79f0]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getProjectDispatchConfigBO().getUseSelectState() == null) {
            throw new com.ohaotian.plugin.base.exception.BusinessException("8888", "\u65b0\u589e\u6d3e\u5355\u89c4\u5219\u65f6[\u6d3e\u5355\u89c4\u5219\u72b6\u6001]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getProjectDispatchConfigBO().getProjectHandlerId() == null || reqBO.getProjectDispatchConfigBO().getProjectHandlerId() == 0L) {
            throw new com.ohaotian.plugin.base.exception.BusinessException("8888", "\u65b0\u589e\u6d3e\u5355\u89c4\u5219\u65f6[\u9879\u76ee\u7ecf\u529e\u4ebaID]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!StringUtils.hasText((String)reqBO.getProjectDispatchConfigBO().getProjectHandlerName())) {
            throw new com.ohaotian.plugin.base.exception.BusinessException("8888", "\u65b0\u589e\u6d3e\u5355\u89c4\u5219\u65f6[\u9879\u76ee\u7ecf\u529e\u4eba\u540d\u79f0]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getProjectDispatchConfigBO().getDispatchType() == null) {
            throw new com.ohaotian.plugin.base.exception.BusinessException("8888", "\u65b0\u589e\u6d3e\u5355\u89c4\u5219\u65f6[\u6d3e\u5355\u65b9\u5f0f]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getProjectDispatchConfigBO().getRejectTimesLimit() == null) {
            throw new com.ohaotian.plugin.base.exception.BusinessException("8888", "\u65b0\u589e\u6d3e\u5355\u89c4\u5219\u65f6[\u62d2\u5355\u6b21\u6570\u4e0a\u9650]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        for (AgrProjectDispatchItemConfigBO projectDispatchItemConfigBO : reqBO.getProjectDispatchItemConfigBOS()) {
            if (projectDispatchItemConfigBO.getDispatchSequence() == null) {
                throw new com.ohaotian.plugin.base.exception.BusinessException("8888", "\u65b0\u589e\u6d3e\u5355\u8f6e\u6b21\u65f6[\u6d3e\u5355\u987a\u5e8f]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (!StringUtils.hasText((String)projectDispatchItemConfigBO.getContractCode())) {
                throw new com.ohaotian.plugin.base.exception.BusinessException("8888", "\u65b0\u589e\u6d3e\u5355\u8f6e\u6b21\u65f6[\u5408\u540c\u7f16\u7801]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (!StringUtils.hasText((String)projectDispatchItemConfigBO.getContractName())) {
                throw new com.ohaotian.plugin.base.exception.BusinessException("8888", "\u65b0\u589e\u6d3e\u5355\u8f6e\u6b21\u65f6[\u5408\u540c\u540d\u79f0]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (!StringUtils.hasText((String)projectDispatchItemConfigBO.getEntAgreementCode())) {
                throw new com.ohaotian.plugin.base.exception.BusinessException("8888", "\u65b0\u589e\u6d3e\u5355\u8f6e\u6b21\u65f6[\u4f01\u4e1a\u534f\u8bae\u7f16\u53f7]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (projectDispatchItemConfigBO.getSupplierId() == null || projectDispatchItemConfigBO.getSupplierId() == 0L) {
                throw new com.ohaotian.plugin.base.exception.BusinessException("8888", "\u65b0\u589e\u6d3e\u5355\u8f6e\u6b21\u65f6[\u4f9b\u5e94\u5546ID]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (!StringUtils.hasText((String)projectDispatchItemConfigBO.getSupplierName())) {
                throw new com.ohaotian.plugin.base.exception.BusinessException("8888", "\u65b0\u589e\u6d3e\u5355\u8f6e\u6b21\u65f6[\u4f9b\u5e94\u5546\u540d\u79f0]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (projectDispatchItemConfigBO.getAmountLimit() != null) continue;
            throw new com.ohaotian.plugin.base.exception.BusinessException("8888", "\u65b0\u589e\u6d3e\u5355\u8f6e\u6b21\u65f6[\u4e0a\u9650\u91d1\u989d]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

