/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.agreement.ability.AgrAgrItemStockQryAbilityService;
import com.tydic.agreement.ability.bo.AgrAgrItemStockQryAbilityServiceReqBo;
import com.tydic.agreement.ability.bo.AgrAgrItemStockQryAbilityServiceRspBo;
import com.tydic.agreement.ability.bo.AgrAgrItemStockQryAbilityServiceRspDataBo;
import com.tydic.agreement.dao.AgrAgreementSkuMapper;
import com.tydic.agreement.dao.po.AgrAgreementSkuPO;
import java.math.BigDecimal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_TEST/2.0.0/com.tydic.agreement.ability.AgrAgrItemStockQryAbilityService"})
public class AgrAgrItemStockQryAbilityServiceImpl
implements AgrAgrItemStockQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(AgrAgrItemStockQryAbilityServiceImpl.class);
    @Autowired
    private AgrAgreementSkuMapper agrAgreementSkuMapper;
    @Value(value="${queryAgrItemStock.defaultStockStateId:33}")
    private Integer defaultStockStateId;
    @Value(value="${queryAgrItemStock.StockStateDesc:\u6709\u8d27 \u73b0\u8d27-\u4e0b\u5355\u7acb\u5373\u53d1\u8d27}")
    private String defaultStockStateDesc;
    @Value(value="${queryAgrItemStock.defaultStockStateIdNo:34}")
    private Integer defaultStockStateIdNo;
    @Value(value="${queryAgrItemStock.defaultStockStateDescNo:\u65e0\u8d27}")
    private String defaultStockStateDescNo;
    @Value(value="${queryAgrItemStock.defaultAreaId:1_0_0}")
    private String defaultAreaId;

    @PostMapping(value={"queryAgrItemStock"})
    public AgrAgrItemStockQryAbilityServiceRspBo queryAgrItemStock(@RequestBody AgrAgrItemStockQryAbilityServiceReqBo reqBo) {
        List<AgrAgreementSkuPO> agrAgreementSkuPOS;
        AgrAgrItemStockQryAbilityServiceRspBo rspBo = new AgrAgrItemStockQryAbilityServiceRspBo();
        List agrItemId = reqBo.getAgrItemId();
        if (ObjectUtil.isNotEmpty((Object)agrItemId) && ObjectUtil.isNotEmpty(agrAgreementSkuPOS = this.agrAgreementSkuMapper.querySkuItemStockByAgrItemsIds(agrItemId))) {
            for (AgrAgreementSkuPO tpo : agrAgreementSkuPOS) {
                AgrAgrItemStockQryAbilityServiceRspDataBo tdBo = new AgrAgrItemStockQryAbilityServiceRspDataBo();
                rspBo.getStockList().add(tdBo);
                tdBo.setAgrItemId(tpo.getAgreementSkuId());
                tdBo.setSkuId(tpo.getAgreementSkuId().toString());
                tdBo.setAreaId(this.defaultAreaId);
                BigDecimal buyNumber = tpo.getBuyNumber();
                BigDecimal orderedQuantity = tpo.getOrderedQuantity();
                if (ObjectUtil.isNotEmpty((Object)buyNumber) && ObjectUtil.isNotEmpty((Object)orderedQuantity)) {
                    BigDecimal remainNum = buyNumber.subtract(orderedQuantity);
                    if (remainNum.compareTo(BigDecimal.ZERO) > 0) {
                        tdBo.setRemainNum(remainNum);
                        tdBo.setStockStateId(this.defaultStockStateId);
                        tdBo.setStockStateDesc(this.defaultStockStateDesc);
                        continue;
                    }
                    tdBo.setRemainNum(BigDecimal.ZERO);
                    tdBo.setStockStateId(this.defaultStockStateIdNo);
                    tdBo.setStockStateDesc(this.defaultStockStateDescNo);
                    continue;
                }
                if (ObjectUtil.isNotEmpty((Object)buyNumber) && ObjectUtil.isEmpty((Object)orderedQuantity)) {
                    tdBo.setRemainNum(buyNumber);
                    tdBo.setStockStateId(this.defaultStockStateId);
                    tdBo.setStockStateDesc(this.defaultStockStateDesc);
                    continue;
                }
                tdBo.setRemainNum(BigDecimal.ZERO);
                tdBo.setStockStateId(this.defaultStockStateIdNo);
                tdBo.setStockStateDesc(this.defaultStockStateDescNo);
            }
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

