/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.ability.impl;

import cn.hutool.crypto.digest.MD5;
import com.tydic.agreement.ability.AgrAgreementCreateCheckAbilityService;
import com.tydic.agreement.ability.bo.AgrAgreementCreateCheckAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrAgreementCreateCheckAbilityRspBO;
import com.tydic.agreement.ability.bo.AgrRelBusiPropLabelBO;
import com.tydic.agreement.common.bo.AgrAgreementScopeBO;
import com.tydic.agreement.constant.AgrCommConstant;
import com.tydic.agreement.constant.AgrEnum;
import com.tydic.agreement.dao.AgrRelBusiPropLabelMapper;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.AgreementScopeMapper;
import com.tydic.agreement.dao.po.AgrRelBusiPropLabelPO;
import com.tydic.agreement.dao.po.AgreementPO;
import com.tydic.agreement.dao.po.AgreementScopePO;
import com.tydic.uccext.enums.BusiPropLabelPropEnum;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_TEST/2.0.0/com.tydic.agreement.ability.AgrAgreementCreateCheckAbilityService"})
public class AgrAgreementCreateCheckAbilityServiceImpl
implements AgrAgreementCreateCheckAbilityService {
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgreementScopeMapper agreementScopeMapper;
    @Autowired
    private AgrRelBusiPropLabelMapper agrRelBusiPropLabelMapper;

    @PostMapping(value={"dealAgreementCreateCheck"})
    public AgrAgreementCreateCheckAbilityRspBO dealAgreementCreateCheck(@RequestBody AgrAgreementCreateCheckAbilityReqBO reqBo) {
        AgrAgreementCreateCheckAbilityRspBO rspBo = new AgrAgreementCreateCheckAbilityRspBO();
        if (reqBo == null || !StringUtils.hasText((String)reqBo.getEcpProjectCode())) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u8bf7\u6c42\u5fc5\u4f20\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        AgreementPO agreementPO = new AgreementPO();
        agreementPO.setEcpProjectCode(reqBo.getEcpProjectCode());
        agreementPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        List<AgreementPO> agreementPOList = this.agreementMapper.getList(agreementPO);
        if (!CollectionUtils.isEmpty(agreementPOList)) {
            String contractCode;
            Long agreementId;
            Map<Long, String> agrExtContractCodeMap = agreementPOList.stream().collect(Collectors.toMap(AgreementPO::getAgreementId, AgreementPO::getExtContractCode, (a, b) -> a));
            if (!CollectionUtils.isEmpty((Collection)reqBo.getBusiPropLabels())) {
                Set labelCodes = reqBo.getBusiPropLabels().stream().filter(bo -> BusiPropLabelPropEnum.BUSI.getPropCode().equals(bo.getLabelProp())).map(AgrRelBusiPropLabelBO::getLabelCode).collect(Collectors.toSet());
                String labelCodesMD5Str = MD5.create().digestHex(labelCodes.toString());
                AgrRelBusiPropLabelPO agrRelBusiPropLabelPO = new AgrRelBusiPropLabelPO();
                agrRelBusiPropLabelPO.setAgreementIdIn(agreementPOList.stream().map(AgreementPO::getAgreementId).collect(Collectors.toList()));
                agrRelBusiPropLabelPO.setLabelProp(BusiPropLabelPropEnum.BUSI.getPropCode());
                List<AgrRelBusiPropLabelPO> agrRelBusiPropLabelPOList = this.agrRelBusiPropLabelMapper.getList(agrRelBusiPropLabelPO);
                if (!CollectionUtils.isEmpty(agrRelBusiPropLabelPOList)) {
                    Map<Long, List<AgrRelBusiPropLabelPO>> collectByAgrId = agrRelBusiPropLabelPOList.stream().collect(Collectors.groupingBy(AgrRelBusiPropLabelPO::getAgreementId));
                    for (Map.Entry<Long, List<AgrRelBusiPropLabelPO>> entry : collectByAgrId.entrySet()) {
                        agreementId = entry.getKey();
                        List<AgrRelBusiPropLabelPO> agrRelBusiPropLabelPOs = entry.getValue();
                        Set compareLabelCodes = agrRelBusiPropLabelPOs.stream().map(AgrRelBusiPropLabelPO::getLabelCode).collect(Collectors.toSet());
                        String compareLabelCodesMD5Str = MD5.create().digestHex(compareLabelCodes.toString());
                        if (compareLabelCodesMD5Str.equals(labelCodesMD5Str)) continue;
                        contractCode = agrExtContractCodeMap.get(agreementId);
                        rspBo.setCheckBusiPropResult("\u5f53\u524d\u534f\u8bae\u4e0e\u76f8\u540c\u9879\u76ee\u4e0b\u3010" + contractCode + "\u3011\u4e1a\u52a1\u5c5e\u6027\u4e0d\u4e00\u81f4");
                        break;
                    }
                } else {
                    rspBo.setRespCode("8888");
                    rspBo.setRespDesc("\u6821\u9a8c\u5931\u8d25\uff0c\u76f8\u540c\u9879\u76ee\u4e0b\u534f\u8bae\u672a\u67e5\u8be2\u5230\u4e1a\u52a1\u5c5e\u6027");
                    return rspBo;
                }
            }
            if (!CollectionUtils.isEmpty((Collection)reqBo.getAgrAgreementScopeBOs())) {
                Set scopeCodeAndModes = reqBo.getAgrAgreementScopeBOs().stream().map(AgrAgreementScopeBO::getScopeCode).collect(Collectors.toSet());
                String scopeCodeAndModesMD5Str = MD5.create().digestHex(scopeCodeAndModes.toString());
                AgreementScopePO agreementScopePO = new AgreementScopePO();
                agreementScopePO.setAgreementIds(agreementPOList.stream().map(AgreementPO::getAgreementId).collect(Collectors.toSet()));
                agreementScopePO.setVisible(AgrEnum.YesOrNo.NO.getCode().intValue());
                agreementScopePO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
                List<AgreementScopePO> agreementScopePOList = this.agreementScopeMapper.getList(agreementScopePO);
                if (!CollectionUtils.isEmpty(agreementScopePOList)) {
                    Map<Long, List<AgreementScopePO>> collectByAgreementId = agreementScopePOList.stream().collect(Collectors.groupingBy(AgreementScopePO::getAgreementId));
                    for (Map.Entry<Long, List<Serializable>> entry : collectByAgreementId.entrySet()) {
                        agreementId = entry.getKey();
                        List<Serializable> agreementScopePOs = entry.getValue();
                        Set compareScopeCodeAndModes = agreementScopePOs.stream().map(AgreementScopePO::getScopeCode).collect(Collectors.toSet());
                        String compareScopeCodeAndModesMD5Str = MD5.create().digestHex(compareScopeCodeAndModes.toString());
                        if (compareScopeCodeAndModesMD5Str.equals(scopeCodeAndModesMD5Str)) continue;
                        contractCode = agrExtContractCodeMap.get(agreementId);
                        rspBo.setCheckScopeResult("\u5f53\u524d\u534f\u8bae\u4e0e\u76f8\u540c\u9879\u76ee\u4e0b\u3010" + contractCode + "\u3011\u9002\u7528\u5355\u4f4d\u4e0d\u4e00\u81f4\uff0c\u662f\u5426\u7ee7\u7eed\uff1f");
                        break;
                    }
                } else {
                    rspBo.setRespCode("8888");
                    rspBo.setRespDesc("\u6821\u9a8c\u5931\u8d25\uff0c\u76f8\u540c\u9879\u76ee\u4e0b\u534f\u8bae\u672a\u67e5\u8be2\u5230\u9002\u7528\u5355\u4f4d");
                    return rspBo;
                }
            }
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

