/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.ability.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.agreement.ability.AgrAgreementScopeSyncQueueAbilityService;
import com.tydic.agreement.ability.bo.AgrAgreementScopeSyncQueueReqBO;
import com.tydic.agreement.ability.bo.AgrAgreementScopeSyncQueueRspBO;
import com.tydic.agreement.busi.AgrAgreementScopeSyncQueueBusiService;
import com.tydic.agreement.common.bo.AgreementScopeSyncQueueBO;
import com.tydic.agreement.dao.AgreementScopeSyncQueueMapper;
import com.tydic.agreement.dao.po.AgreementScopeSyncQueuePO;
import com.tydic.agreement.extend.ability.CnncAgrSyncScopeAbilityService;
import com.tydic.agreement.extend.ability.bo.AgrOrgScopeBO;
import com.tydic.agreement.extend.ability.bo.AgrOrgScopeSyncBO;
import com.tydic.agreement.extend.ability.bo.CnncAgrSyncScopeAbilityReqBO;
import com.tydic.agreement.extend.ability.bo.CnncAgrSyncScopeAbilityRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_TEST/2.0.0/com.tydic.agreement.ability.AgrAgreementScopeSyncQueueAbilityService"})
public class AgrAgreementScopeSyncQueueAbilityServiceImpl
implements AgrAgreementScopeSyncQueueAbilityService {
    private static final Logger log = LoggerFactory.getLogger(AgrAgreementScopeSyncQueueAbilityServiceImpl.class);
    private static final AtomicBoolean busyFlag = new AtomicBoolean(false);
    @Autowired
    private AgrAgreementScopeSyncQueueBusiService agrAgreementScopeSyncQueueBusiService;
    @Autowired
    private CnncAgrSyncScopeAbilityService cnncAgrSyncScopeAbilityService;
    @Autowired
    private AgreementScopeSyncQueueMapper agreementScopeSyncQueueMapper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"dealScopeSync"})
    public AgrAgreementScopeSyncQueueRspBO dealScopeSync(@RequestBody AgrAgreementScopeSyncQueueReqBO reqBO) {
        AgrAgreementScopeSyncQueueRspBO rspBO = new AgrAgreementScopeSyncQueueRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        try {
            boolean compareAndSet = busyFlag.compareAndSet(false, true);
            if (!compareAndSet) {
                rspBO.setRespDesc("\u5f53\u524d\u8282\u70b9\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                AgrAgreementScopeSyncQueueRspBO agrAgreementScopeSyncQueueRspBO = rspBO;
                return agrAgreementScopeSyncQueueRspBO;
            }
            AgrAgreementScopeSyncQueueRspBO queueRspBO = this.agrAgreementScopeSyncQueueBusiService.updateToInProcessAndGetList(reqBO);
            if (!"0000".equals(queueRspBO.getRespCode())) {
                throw new BusinessException("8888", queueRspBO.getRespDesc());
            }
            if (!CollectionUtils.isEmpty((Collection)queueRspBO.getQueueList())) {
                List<AgreementScopeSyncQueueBO> orgScopeSyncList = queueRspBO.getQueueList().stream().filter(bo -> bo.getOrgId() != null).collect(Collectors.toList());
                List<AgreementScopeSyncQueueBO> agrScopeSyncList = queueRspBO.getQueueList().stream().filter(bo -> bo.getAgreementId() != null && bo.getOrgId() == null).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(orgScopeSyncList)) {
                    CnncAgrSyncScopeAbilityReqBO cnncAgrSyncScopeAbilityReqBO = new CnncAgrSyncScopeAbilityReqBO();
                    Map<Long, List<AgreementScopeSyncQueueBO>> collect = orgScopeSyncList.stream().collect(Collectors.groupingBy(bo -> bo.getAgreementId() == null ? 0L : bo.getAgreementId()));
                    HashSet orgIds = new HashSet();
                    collect.forEach((agrId, bos) -> {
                        AgrOrgScopeSyncBO agrOrgScopeSyncBo = new AgrOrgScopeSyncBO();
                        agrOrgScopeSyncBo.setAgreementId(agrId);
                        Set orgScopeBos = bos.stream().map(queueBo -> {
                            AgrOrgScopeBO agrOrgScopeBo = new AgrOrgScopeBO();
                            agrOrgScopeBo.setOrgId(queueBo.getOrgId());
                            agrOrgScopeBo.setScopeModeChange(queueBo.getScopeModeChange());
                            return agrOrgScopeBo;
                        }).collect(Collectors.toSet());
                        agrOrgScopeSyncBo.setOrgScopes(orgScopeBos);
                        orgIds.add(agrOrgScopeSyncBo);
                    });
                    cnncAgrSyncScopeAbilityReqBO.setOrgIds(orgIds);
                    cnncAgrSyncScopeAbilityReqBO.setRetryFlag(Boolean.valueOf(true));
                    CnncAgrSyncScopeAbilityRspBO cnncAgrSyncScopeAbilityRspBO = this.cnncAgrSyncScopeAbilityService.syncOrgScope(cnncAgrSyncScopeAbilityReqBO);
                    this.updateDealResult(orgScopeSyncList, cnncAgrSyncScopeAbilityRspBO);
                }
                if (!CollectionUtils.isEmpty(agrScopeSyncList)) {
                    agrScopeSyncList.forEach(bo -> {
                        CnncAgrSyncScopeAbilityReqBO cnncAgrSyncScopeAbilityReqBO = new CnncAgrSyncScopeAbilityReqBO();
                        cnncAgrSyncScopeAbilityReqBO.setAgreementIds(Collections.singleton(bo.getAgreementId()));
                        CnncAgrSyncScopeAbilityRspBO cnncAgrSyncScopeAbilityRspBO = this.cnncAgrSyncScopeAbilityService.syncScope(cnncAgrSyncScopeAbilityReqBO);
                        this.updateDealResult(Collections.singletonList(bo), cnncAgrSyncScopeAbilityRspBO);
                    });
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            busyFlag.set(false);
        }
        return rspBO;
    }

    private void updateDealResult(List<AgreementScopeSyncQueueBO> scopeSyncList, CnncAgrSyncScopeAbilityRspBO cnncAgrSyncScopeBusiRspBO) {
        if ("0000".equals(cnncAgrSyncScopeBusiRspBO.getRespCode())) {
            if (CollectionUtils.isEmpty((Collection)cnncAgrSyncScopeBusiRspBO.getFailOrg())) {
                AgrAgreementScopeSyncQueueReqBO agrAgreementScopeSyncQueueReqBO = new AgrAgreementScopeSyncQueueReqBO();
                agrAgreementScopeSyncQueueReqBO.setQueueList(scopeSyncList);
                this.agrAgreementScopeSyncQueueBusiService.updateToSuccess(agrAgreementScopeSyncQueueReqBO);
            } else {
                AgrAgreementScopeSyncQueueReqBO agrAgreementScopeSyncQueueReqBO;
                List failList = scopeSyncList.stream().filter(bo -> cnncAgrSyncScopeBusiRspBO.getFailOrg().contains(bo.getOrgId())).collect(Collectors.toList());
                List successList = scopeSyncList.stream().filter(bo -> !cnncAgrSyncScopeBusiRspBO.getFailOrg().contains(bo.getOrgId())).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(failList)) {
                    agrAgreementScopeSyncQueueReqBO = new AgrAgreementScopeSyncQueueReqBO();
                    agrAgreementScopeSyncQueueReqBO.setQueueList(scopeSyncList);
                    this.agrAgreementScopeSyncQueueBusiService.updateToFail(agrAgreementScopeSyncQueueReqBO);
                }
                if (!CollectionUtils.isEmpty(successList)) {
                    agrAgreementScopeSyncQueueReqBO = new AgrAgreementScopeSyncQueueReqBO();
                    agrAgreementScopeSyncQueueReqBO.setQueueList(successList);
                    this.agrAgreementScopeSyncQueueBusiService.updateToSuccess(agrAgreementScopeSyncQueueReqBO);
                }
            }
        } else {
            AgrAgreementScopeSyncQueueReqBO agrAgreementScopeSyncQueueReqBO = new AgrAgreementScopeSyncQueueReqBO();
            agrAgreementScopeSyncQueueReqBO.setQueueList(scopeSyncList);
            agrAgreementScopeSyncQueueReqBO.setMsg(cnncAgrSyncScopeBusiRspBO.getRespDesc());
            this.agrAgreementScopeSyncQueueBusiService.updateToFail(agrAgreementScopeSyncQueueReqBO);
        }
    }

    @PostMapping(value={"dealScopeSyncInProcessCheck"})
    public AgrAgreementScopeSyncQueueRspBO dealScopeSyncInProcessCheck(@RequestBody AgrAgreementScopeSyncQueueReqBO reqBO) {
        return this.agrAgreementScopeSyncQueueBusiService.updateInProcessToFail(reqBO);
    }

    @PostMapping(value={"addOrgScopeSyncQueue"})
    public AgrAgreementScopeSyncQueueRspBO addOrgScopeSyncQueue(@RequestBody AgrAgreementScopeSyncQueueReqBO reqBO) {
        return this.agrAgreementScopeSyncQueueBusiService.addOrgScopeSyncQueue(reqBO);
    }

    @Async(value="TFFeedbackServiceThreadPool")
    @PostMapping(value={"dealScopeSyncAsync"})
    public void dealScopeSyncAsync() {
        if (!busyFlag.get()) {
            this.dealScopeSync(new AgrAgreementScopeSyncQueueReqBO());
        } else {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.dealScopeSync(new AgrAgreementScopeSyncQueueReqBO());
        }
    }

    @PostMapping(value={"checkAgreementScopeSyncQueueExist"})
    public AgrAgreementScopeSyncQueueRspBO checkAgreementScopeSyncQueueExist(@RequestBody AgrAgreementScopeSyncQueueReqBO reqBO) {
        AgrAgreementScopeSyncQueueRspBO rspBO = new AgrAgreementScopeSyncQueueRspBO();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getAgreementIds())) {
            AgreementScopeSyncQueuePO agreementScopeSyncQueuePo = new AgreementScopeSyncQueuePO();
            agreementScopeSyncQueuePo.setAgreementIdIn(reqBO.getAgreementIds());
            List<AgreementScopeSyncQueuePO> syncQueuePoList = this.agreementScopeSyncQueueMapper.getList(agreementScopeSyncQueuePo);
            if (!CollectionUtils.isEmpty(syncQueuePoList)) {
                Set agrIdSet = syncQueuePoList.stream().map(AgreementScopeSyncQueuePO::getAgreementId).filter(Objects::nonNull).collect(Collectors.toSet());
                rspBO.setCheckResult(new ArrayList(agrIdSet));
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

