/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.ability.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.agreement.ability.AgrAgreementSubmitAbilityService;
import com.tydic.agreement.ability.AgrAgreementSubmitCheckAbilityService;
import com.tydic.agreement.ability.bo.AgrAgreementSubmitAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrAgreementSubmitAbilityRspBO;
import com.tydic.agreement.ability.bo.AgrAgreementSubmitCheckAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrAgreementSubmitCheckAbilityRspBO;
import com.tydic.agreement.atom.AgrCheckAgreementExistAndStatusAtomService;
import com.tydic.agreement.atom.bo.AgrCheckAgreementExistAndStatusAtomReqBO;
import com.tydic.agreement.atom.bo.AgrCheckAgreementExistAndStatusAtomRspBO;
import com.tydic.agreement.busi.AgrAgreementSubmitBusiService;
import com.tydic.agreement.busi.bo.AgrAgreementSubmitBusiReqBO;
import com.tydic.agreement.busi.bo.AgrAgreementSubmitBusiRspBO;
import com.tydic.agreement.busi.bo.AgrQryAgreementByPageBusiReqBO;
import com.tydic.agreement.common.bo.AgrAgreementBO;
import com.tydic.agreement.constant.AgrCommConstant;
import com.tydic.agreement.constant.AgrEnum;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.AgreementSkuMapper;
import com.tydic.agreement.dao.po.AgreementSkuPO;
import com.tydic.agreement.utils.MoneyUtil;
import com.tydic.uccext.bo.CnncQryCommodityTypeListAbilityBo;
import com.tydic.uccext.bo.CnncQryCommodityTypeListAbilityReqBo;
import com.tydic.uccext.bo.CnncQryCommodityTypeListAbilityRspBo;
import com.tydic.uccext.service.CnncQryCommodityTypeListAbilityService;
import com.tydic.umcext.ability.member.UmcZhMemDetailQueryAbilityService;
import com.tydic.umcext.ability.member.bo.UmcZhMemDetailQueryAbilityReqBO;
import com.tydic.umcext.ability.member.bo.UmcZhMemDetailQueryAbilityRspBO;
import com.tydic.umcext.ability.taxCode.UmcQryTaxCodeListService;
import com.tydic.umcext.ability.taxCode.bo.UmcQryTaxCodeListReqBO;
import com.tydic.umcext.ability.taxCode.bo.UmcQryTaxCodeListRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_TEST/2.0.0/com.tydic.agreement.ability.AgrAgreementSubmitAbilityService"})
public class AgrAgreementSubmitAbilityServiceImpl
implements AgrAgreementSubmitAbilityService {
    private static final Logger log = LoggerFactory.getLogger(AgrAgreementSubmitAbilityServiceImpl.class);
    @Autowired
    private AgrAgreementSubmitBusiService agrAgreementSubmitBusiService;
    @Autowired
    private AgrCheckAgreementExistAndStatusAtomService agrCheckAgreementExistAndStatusAtomService;
    @Value(value="${SKU_CORRECT_UPDATE_TOPIC:SKU_CORRECT_UPDATE_TOPIC}")
    private String SKU_CORRECT_UPDATE_TOPIC;
    @Value(value="${SKU_CORRECT_UPDATE_TAG:*}")
    private String SKU_CORRECT_UPDATE_TAG;
    @Resource(name="skuCorrectProvider")
    private ProxyMessageProducer skuCorrectProvider;
    @Autowired
    private AgreementSkuMapper agreementSkuMapper;
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private UmcZhMemDetailQueryAbilityService umcZhMemDetailQueryAbilityService;
    @Autowired
    private UmcQryTaxCodeListService umcQryTaxCodeListService;
    @Autowired
    private AgrAgreementSubmitCheckAbilityService agrAgreementSubmitCheckAbilityService;
    @Autowired
    private CnncQryCommodityTypeListAbilityService cnncQryCommodityTypeListAbilityService;

    @PostMapping(value={"submitAgreementInfo"})
    public AgrAgreementSubmitAbilityRspBO submitAgreementInfo(@RequestBody AgrAgreementSubmitAbilityReqBO abilityReqBO) {
        AgrAgreementSubmitAbilityRspBO abilityRspBO = new AgrAgreementSubmitAbilityRspBO();
        if (abilityReqBO == null) {
            throw new BusinessException("22000", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (abilityReqBO.getAgreementId() == null) {
            throw new BusinessException("0001", "\u534f\u8baeId\u3010agreementId\u3011\u4e3a\u7a7a");
        }
        if (abilityReqBO.getOperType() == null) {
            throw new BusinessException("0001", "\u64cd\u4f5c\u7c7b\u578b\u3010operType\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        AgrCheckAgreementExistAndStatusAtomReqBO atomReqBO = new AgrCheckAgreementExistAndStatusAtomReqBO();
        atomReqBO.setAgreementId(abilityReqBO.getAgreementId());
        atomReqBO.setSupplierId(abilityReqBO.getSupplierId());
        AgrCheckAgreementExistAndStatusAtomRspBO atomRspBO = this.agrCheckAgreementExistAndStatusAtomService.checkAgreementExistAndStatus(atomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            BeanUtils.copyProperties((Object)((Object)atomRspBO), (Object)abilityRspBO);
            return abilityRspBO;
        }
        AgrAgreementBO agrAgreementBo = atomRspBO.getAgrAgreementBO();
        if (AgrCommConstant.AgrSaveOrSubmit.SUBMIT.equals(abilityReqBO.getOperType())) {
            this.checkAgreementSkuData(agrAgreementBo);
            if (AgrEnum.YesOrNo.YES.getCode().toString().equals(agrAgreementBo.getCreateOrder())) {
                UmcZhMemDetailQueryAbilityReqBO umcZhMemDetailQueryAbilityReqBO = new UmcZhMemDetailQueryAbilityReqBO();
                umcZhMemDetailQueryAbilityReqBO.setMemId(agrAgreementBo.getProducerId());
                UmcZhMemDetailQueryAbilityRspBO umcZhMemDetailQueryAbilityRspBO = this.umcZhMemDetailQueryAbilityService.memDetailQuery(umcZhMemDetailQueryAbilityReqBO);
                if (!"0000".equals(umcZhMemDetailQueryAbilityRspBO.getRespCode()) || umcZhMemDetailQueryAbilityRspBO.getUmcMemDetailInfoAbilityRspBO() == null) {
                    throw new BusinessException("8888", "\u672a\u67e5\u8be2\u5230\u534f\u8bae\u7ecf\u529e\u4eba\u4fe1\u606f");
                }
                Long companyId = umcZhMemDetailQueryAbilityRspBO.getUmcMemDetailInfoAbilityRspBO().getCompanyId();
                String orgTreePath = umcZhMemDetailQueryAbilityRspBO.getUmcMemDetailInfoAbilityRspBO().getOrgTreePath();
                AgrQryAgreementByPageBusiReqBO agrQryAgreementByPageBusiReqBO = new AgrQryAgreementByPageBusiReqBO();
                agrQryAgreementByPageBusiReqBO.setAgreementIds(Collections.singletonList(agrAgreementBo.getAgreementId()));
                agrQryAgreementByPageBusiReqBO.setCompanyId(companyId);
                agrQryAgreementByPageBusiReqBO.setOrgPath(orgTreePath);
                List<AgrAgreementBO> listWithScope = this.agreementMapper.getListPageByScope(agrQryAgreementByPageBusiReqBO, (Page<AgrAgreementBO>)new Page(1, 1));
                if (CollectionUtils.isEmpty(listWithScope)) {
                    throw new BusinessException("8888", "\u672c\u5355\u4f4d\u4e0d\u5c5e\u4e8e\u534f\u8bae\u5e94\u7528\u8303\u56f4\uff0c\u8bf7\u68c0\u67e5\u3002");
                }
            }
            AgrAgreementSubmitCheckAbilityReqBO agrAgreementSubmitCheckAbilityReqBO = new AgrAgreementSubmitCheckAbilityReqBO();
            agrAgreementSubmitCheckAbilityReqBO.setAgreementId(abilityReqBO.getAgreementId());
            AgrAgreementSubmitCheckAbilityRspBO agrAgreementSubmitCheckAbilityRspBO = this.agrAgreementSubmitCheckAbilityService.dealAgreementSubmitCheck(agrAgreementSubmitCheckAbilityReqBO);
            if ("0000".equals(agrAgreementSubmitCheckAbilityRspBO.getRespCode()) && StringUtils.hasText((String)agrAgreementSubmitCheckAbilityRspBO.getCheckAllSkuBindSpuResult())) {
                throw new BusinessException("8888", agrAgreementSubmitCheckAbilityRspBO.getCheckAllSkuBindSpuResult());
            }
        }
        AgrAgreementSubmitBusiReqBO busiReqBO = new AgrAgreementSubmitBusiReqBO();
        BeanUtils.copyProperties((Object)abilityReqBO, (Object)busiReqBO);
        busiReqBO.setAgrAgreementBO(agrAgreementBo);
        AgrAgreementSubmitBusiRspBO busiRspBO = this.agrAgreementSubmitBusiService.submitAgreementInfo(busiReqBO);
        BeanUtils.copyProperties((Object)busiRspBO, (Object)abilityRspBO);
        return abilityRspBO;
    }

    private void checkAgreementSkuData(AgrAgreementBO agrAgreementBo) {
        boolean anyMatchMeasureScale;
        BigDecimal allSkuSalePriceSum;
        AgreementSkuPO agreementSkuPo = new AgreementSkuPO();
        agreementSkuPo.setAgreementId(agrAgreementBo.getAgreementId());
        List<AgreementSkuPO> agreementSkuList = this.agreementSkuMapper.getList(agreementSkuPo);
        if (CollectionUtils.isEmpty(agreementSkuList)) {
            throw new BusinessException("8888", "\u672a\u67e5\u8be2\u5230\u8be5\u534f\u8bae\u4e0b\u7684\u660e\u7ec6\u4fe1\u606f");
        }
        ArrayList<Long> skuIds = new ArrayList<Long>();
        ArrayList<Long> agreementSkuIdList = new ArrayList<Long>();
        ArrayList<Long> catalogIds = new ArrayList<Long>();
        for (AgreementSkuPO agreementSkuPO : agreementSkuList) {
            if (!AgrEnum.EcpContractType.GDZJ.getCode().equals(agrAgreementBo.getEcpContractType()) && !Arrays.asList(AgrEnum.Variety.GC.getCode(), AgrEnum.Variety.FW.getCode()).contains(agreementSkuPO.getCatalogVariety()) && null == agreementSkuPO.getSupplyCycle()) {
                skuIds.add(agreementSkuPO.getAgreementSkuId());
            }
            if (!StringUtils.hasText((String)agreementSkuPO.getTaxCatalog())) {
                agreementSkuIdList.add(agreementSkuPO.getAgreementSkuId());
            }
            if (!StringUtils.hasText((String)agreementSkuPO.getCatalogId())) continue;
            catalogIds.add(Long.parseLong(agreementSkuPO.getCatalogId()));
        }
        CnncQryCommodityTypeListAbilityReqBo abilityReqBo = new CnncQryCommodityTypeListAbilityReqBo();
        abilityReqBo.setCommodityTypeIds(catalogIds);
        abilityReqBo.setQueryHaveSku(Boolean.valueOf(false));
        abilityReqBo.setCommodityTypeStatus(Integer.valueOf(0));
        abilityReqBo.setPageSize(-1);
        abilityReqBo.setPageNo(-1);
        CnncQryCommodityTypeListAbilityRspBo abilityRspBo = this.cnncQryCommodityTypeListAbilityService.qryCommodityTypeList(abilityReqBo);
        if (!"0000".equals(abilityRspBo.getRespCode())) {
            throw new ZTBusinessException(abilityRspBo.getRespDesc());
        }
        if (!CollectionUtils.isEmpty((Collection)abilityRspBo.getRows())) {
            List commodityTypeListAbilityBos = JSONArray.parseArray((String)JSONObject.toJSONString((Object)abilityRspBo.getRows()), CnncQryCommodityTypeListAbilityBo.class);
            StringJoiner sj = new StringJoiner(",");
            commodityTypeListAbilityBos.forEach(type -> sj.add("[" + type.getCommodityTypeId() + " " + type.getCommodityTypeName() + "]"));
            throw new ZTBusinessException("\u5b58\u5728\u4ee5\u4e0b\u505c\u7528\u7684\u56db\u7ea7\u5206\u7c7b,\u8bf7\u4fee\u6b63\u540e\u518d\u91cd\u65b0\u63d0\u4ea4\uff1a" + sj);
        }
        List skuIdlist = skuIds.stream().filter(agreementSkuIdList::contains).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(skuIdlist)) {
            throw new BusinessException("8888", "\u8bf7\u5148\u7ef4\u62a4\u5b8c\u6210\u6240\u6709\u660e\u7ec6\u9879\u7684[\u4f9b\u8d27\u5468\u671f]\u3001[\u7a0e\u6536\u5206\u7c7b\u7f16\u7801]\u7b49\u6570\u636e\u540e\u518d\u63d0\u4ea4");
        }
        if (!CollectionUtils.isEmpty(skuIds)) {
            throw new BusinessException("8888", "\u8bf7\u5148\u7ef4\u62a4\u5b8c\u6210\u6240\u6709\u660e\u7ec6\u9879\u7684[\u4f9b\u8d27\u5468\u671f]\u7b49\u6570\u636e\u540e\u518d\u63d0\u4ea4");
        }
        if (!CollectionUtils.isEmpty(agreementSkuIdList)) {
            throw new BusinessException("8888", "\u8bf7\u5148\u7ef4\u62a4\u5b8c\u6210\u6240\u6709\u660e\u7ec6\u9879\u7684[\u7a0e\u6536\u5206\u7c7b\u7f16\u7801]\u7b49\u6570\u636e\u540e\u518d\u63d0\u4ea4");
        }
        if (AgrEnum.YesOrNo.YES.getCode().toString().equals(agrAgreementBo.getCreateOrder()) && agrAgreementBo.getAgreementTentativeAmount() != null && (allSkuSalePriceSum = agreementSkuList.stream().map(AgreementSkuPO::getSalePriceSum).map(MoneyUtil::l2b2).reduce(BigDecimal.ZERO, BigDecimal::add)).compareTo(agrAgreementBo.getAgreementTentativeAmount()) > 0) {
            throw new BusinessException("8888", "\u534f\u8bae\u660e\u7ec6\u7684\u603b\u4ef7\u8d85\u51fa\u534f\u8bae\u6682\u5b9a\u603b\u4ef7\uff0c\u65e0\u6cd5\u4e00\u6b21\u6027\u4e0b\u5355\u3002");
        }
        boolean anyMatchTaxRate = agreementSkuList.stream().anyMatch(po -> null == po.getTaxRate());
        if (anyMatchTaxRate) {
            throw new BusinessException("8888", "\u60a8\u7684\u7a0e\u7387\u7f3a\u5931\uff0c\u8bf7\u8054\u7cfb\u8fd0\u8425\u5904\u7406");
        }
        List taxCodeList = agreementSkuList.stream().map(AgreementSkuPO::getTaxCatalog).filter(org.apache.commons.lang3.StringUtils::isNotBlank).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(taxCodeList)) {
            UmcQryTaxCodeListReqBO umcQryTaxCodeListReqBO = new UmcQryTaxCodeListReqBO();
            umcQryTaxCodeListReqBO.setTaxCodeList(taxCodeList);
            umcQryTaxCodeListReqBO.setPageNo(-1);
            umcQryTaxCodeListReqBO.setPageSize(-1);
            UmcQryTaxCodeListRspBO umcQryTaxCodeListRspBO = this.umcQryTaxCodeListService.qryTaxCodeList(umcQryTaxCodeListReqBO);
            if ("0000".equals(umcQryTaxCodeListRspBO.getRespCode()) && !CollectionUtils.isEmpty((Collection)umcQryTaxCodeListRspBO.getRows())) {
                HashMap taxCodeRateMap = new HashMap();
                for (Object taxCodeRateBO : umcQryTaxCodeListRspBO.getRows()) {
                    if (taxCodeRateMap.containsKey(taxCodeRateBO.getTaxCode()) && !CollectionUtils.isEmpty((Collection)taxCodeRateBO.getTaxRateList())) {
                        ((List)taxCodeRateMap.get(taxCodeRateBO.getTaxCode())).addAll(taxCodeRateBO.getTaxRateList());
                        continue;
                    }
                    ArrayList taxCodeRateList = new ArrayList();
                    if (!CollectionUtils.isEmpty((Collection)taxCodeRateBO.getTaxRateList())) {
                        taxCodeRateList.addAll(taxCodeRateBO.getTaxRateList());
                    }
                    taxCodeRateMap.put(taxCodeRateBO.getTaxCode(), taxCodeRateList);
                }
                ArrayList<String> agreementSkuIds = new ArrayList<String>();
                for (AgreementSkuPO po2 : agreementSkuList) {
                    List taxCodeRateList;
                    if (CollectionUtils.isEmpty((Collection)((Collection)taxCodeRateMap.get(po2.getTaxCatalog()))) || (taxCodeRateList = (List)taxCodeRateMap.get(po2.getTaxCatalog())).contains(po2.getTaxRate().toString())) continue;
                    agreementSkuIds.add(po2.getAgreementSkuId().toString());
                }
                if (!CollectionUtils.isEmpty(agreementSkuIds)) {
                    StringJoiner sj = new StringJoiner(",", "[", "]");
                    agreementSkuIds.forEach(sj::add);
                    throw new BusinessException("8888", "\u534f\u8bae\u660e\u7ec6\u7f16\u7801\u4e3a" + sj + "\u7684\u7a0e\u7387\u4e0e\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e0d\u5339\u914d\uff0c\u8bf7\u8054\u7cfb\u8fd0\u8425\u5904\u7406");
                }
            }
        }
        if (anyMatchMeasureScale = agreementSkuList.stream().anyMatch(po -> po.getUnitOfMeasureScale() == null || po.getUnitOfMeasureScale() <= 0 || po.getMaterialUnitOfMeasureScale() == null || po.getMaterialUnitOfMeasureScale() <= 0)) {
            throw new BusinessException("8888", "\u8bf7\u5148\u7ef4\u62a4\u5b8c\u6210\u6240\u6709\u660e\u7ec6\u9879\u7684[\u8ba1\u91cf\u5355\u4f4d\u8f6c\u6362\u6bd4\u4f8b]\u540e\u518d\u63d0\u4ea4");
        }
    }
}

