/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.ability.impl;

import com.tydic.agreement.ability.AgrBindStandardSpuCheckAbilityService;
import com.tydic.agreement.ability.bo.AgrBindStandardSpuCheckAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrBindStandardSpuCheckAbilityRspBO;
import com.tydic.agreement.constant.AgrCommConstant;
import com.tydic.agreement.constant.AgrEnum;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.AgreementSkuMapper;
import com.tydic.agreement.dao.ProjectDispatchConfigMapper;
import com.tydic.agreement.dao.po.AgreementPO;
import com.tydic.agreement.dao.po.ProjectDispatchConfigPO;
import com.tydic.uccext.bo.UccStandardSpuDetailInfoBO;
import com.tydic.uccext.bo.UccStandardSpuDetailsAbilityReqBO;
import com.tydic.uccext.bo.UccStandardSpuDetailsAbilityRspBO;
import com.tydic.uccext.service.UccStandardSpuDetailsAbilityService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_TEST/2.0.0/com.tydic.agreement.ability.AgrBindStandardSpuCheckAbilityService"})
public class AgrBindStandardSpuCheckAbilityServiceImpl
implements AgrBindStandardSpuCheckAbilityService {
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgreementSkuMapper agreementSkuMapper;
    @Autowired
    private ProjectDispatchConfigMapper projectDispatchConfigMapper;
    @Autowired
    private UccStandardSpuDetailsAbilityService uccStandardSpuDetailsAbilityService;

    @PostMapping(value={"dealBindSpuCheck"})
    public AgrBindStandardSpuCheckAbilityRspBO dealBindSpuCheck(@RequestBody AgrBindStandardSpuCheckAbilityReqBO reqBO) {
        Set<Long> agrIds;
        AgrBindStandardSpuCheckAbilityRspBO rspBO = new AgrBindStandardSpuCheckAbilityRspBO();
        if (reqBO == null || !StringUtils.hasText((String)reqBO.getSpuId()) || reqBO.getAgreementId() == null || reqBO.getAgreementSkuId() == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u6c42\u5fc5\u4f20\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        AgreementPO agreementPO = new AgreementPO();
        agreementPO.setAgreementId(reqBO.getAgreementId());
        AgreementPO agreementPOReq = this.agreementMapper.getModelBy(agreementPO);
        if (agreementPOReq == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u534f\u8bae\u4fe1\u606f");
            return rspBO;
        }
        if (null != reqBO.getModifyAgrSkuFlag() && reqBO.getModifyAgrSkuFlag().booleanValue() && AgrEnum.RelSystem.OPS.toString().equalsIgnoreCase(agreementPOReq.getRelSystem()) && AgrEnum.EcpCenterPurchaseType.YIJI.getCode().equals(agreementPOReq.getEcpPurType()) && StringUtils.hasText((String)agreementPOReq.getEcpProjectCode())) {
            UccStandardSpuDetailsAbilityReqBO spuDetailAbilityReqBO = new UccStandardSpuDetailsAbilityReqBO();
            spuDetailAbilityReqBO.setSpuIds(Collections.singletonList(reqBO.getSpuId()));
            UccStandardSpuDetailsAbilityRspBO abilityRspBO = this.uccStandardSpuDetailsAbilityService.qryUccStandardSpuDetails(spuDetailAbilityReqBO);
            if (!"0000".equals(abilityRspBO.getRespCode())) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc(abilityRspBO.getRespDesc());
                return rspBO;
            }
            if (!CollectionUtils.isEmpty((Collection)abilityRspBO.getSpuDetailInfos())) {
                UccStandardSpuDetailInfoBO uccStandardSpuDetailInfoBO = (UccStandardSpuDetailInfoBO)abilityRspBO.getSpuDetailInfos().get(0);
                if (!(Objects.equals(reqBO.getMeasureName(), uccStandardSpuDetailInfoBO.getSpuMeasure()) && Objects.equals(reqBO.getMaterialMeasureName(), uccStandardSpuDetailInfoBO.getMaterialMeasure()) && Objects.equals(reqBO.getUnitOfMeasureScale(), uccStandardSpuDetailInfoBO.getSpuMeasureConvert()) && Objects.equals(reqBO.getMaterialUnitOfMeasureScale(), uccStandardSpuDetailInfoBO.getMaterialMeasureConvert()))) {
                    rspBO.setSubmitDiffSkuResult("\u8be5\u534f\u8bae\u660e\u7ec6\u8ba1\u91cf\u5355\u4f4d\u6216\u8f6c\u6362\u5173\u7cfb\u4e0e\u6807\u51c6\u5546\u54c1\u4e0d\u4e00\u81f4\uff0c\u4e0d\u53ef\u7ed1\u5b9a");
                    rspBO.setRespCode("0000");
                    return rspBO;
                }
            }
        }
        if (CollectionUtils.isEmpty(agrIds = this.agreementSkuMapper.getAgrIdBySpuId(reqBO.getSpuId()))) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        if (AgrEnum.RelSystem.OPS.toString().equalsIgnoreCase(agreementPOReq.getRelSystem()) && AgrEnum.EcpCenterPurchaseType.YIJI.getCode().equals(agreementPOReq.getEcpPurType()) && StringUtils.hasText((String)agreementPOReq.getEcpProjectCode())) {
            ProjectDispatchConfigPO projectDispatchConfigPO = new ProjectDispatchConfigPO();
            projectDispatchConfigPO.setProjectCode(agreementPOReq.getEcpProjectCode());
            projectDispatchConfigPO.setState(AgrCommConstant.DISPATCH_STATE.EFFECT);
            int checkBy = this.projectDispatchConfigMapper.getCheckBy(projectDispatchConfigPO);
            if (checkBy > 0) {
                Set<Long> agrSkuIds;
                agrIds.remove(reqBO.getAgreementId());
                if (!CollectionUtils.isEmpty(agrIds)) {
                    AgreementPO agreementPOBind = new AgreementPO();
                    agreementPOBind.setAgreementIds(new ArrayList<Long>(agrIds));
                    List<AgreementPO> agreementPOBindList = this.agreementMapper.getList(agreementPOBind);
                    agreementPOBindList = agreementPOBindList.stream().filter(po -> AgrEnum.RelSystem.OPS.toString().equalsIgnoreCase(po.getRelSystem()) && AgrEnum.EcpCenterPurchaseType.YIJI.getCode().equals(po.getEcpPurType())).collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(agreementPOBindList)) {
                        ProjectDispatchConfigPO projectDispatchConfigPO1 = new ProjectDispatchConfigPO();
                        projectDispatchConfigPO1.setProjectCodeIn(agreementPOBindList.stream().map(AgreementPO::getEcpProjectCode).collect(Collectors.toList()));
                        projectDispatchConfigPO1.setState(AgrCommConstant.DISPATCH_STATE.EFFECT);
                        List<ProjectDispatchConfigPO> projectDispatchConfigPOList = this.projectDispatchConfigMapper.getList(projectDispatchConfigPO1);
                        if (!CollectionUtils.isEmpty(projectDispatchConfigPOList)) {
                            Map<String, String> projectCodeName = projectDispatchConfigPOList.stream().collect(Collectors.toMap(ProjectDispatchConfigPO::getProjectCode, ProjectDispatchConfigPO::getProjectName, (a, b) -> a));
                            Set projectCodeSet = projectDispatchConfigPOList.stream().map(ProjectDispatchConfigPO::getProjectCode).collect(Collectors.toSet());
                            projectCodeSet.stream().filter(code -> StringUtils.hasText((String)code) && !Objects.equals(code, agreementPOReq.getEcpProjectCode())).findAny().ifPresent(projectCode -> {
                                String projectName = (String)projectCodeName.get(projectCode);
                                rspBO.setCheckSpuBindSameProjectResult("\u5f53\u524d\u6807\u51c6\u5546\u54c1\u5df2\u7ed1\u5b9a\u6d3e\u5355\u9879\u76ee[" + projectCode + "-" + projectName + "]\u7684\u7269\u9879,\u4e0d\u53ef\u7ed1\u5b9a\u5176\u4ed6\u6d3e\u5355\u9879\u76ee\u7684\u7269\u9879");
                            });
                        }
                    }
                }
                if (!(CollectionUtils.isEmpty(agrSkuIds = this.agreementSkuMapper.getAgrSkuIdBySpuIds(Collections.singletonList(reqBO.getSpuId()), Collections.singletonList(reqBO.getAgreementId()))) || agrSkuIds.size() <= 1 && agrSkuIds.contains(reqBO.getAgreementSkuId()))) {
                    agrSkuIds.stream().filter(id -> !id.equals(reqBO.getAgreementSkuId())).findAny().ifPresent(agrSkuId -> rspBO.setCheckDiffSkuResult("\u8be5\u6807\u51c6\u5546\u54c1\u5df2\u7ed1\u5b9a\u672c\u534f\u8bae\u7684\u660e\u7ec6" + agrSkuId + "\uff0c\u4e0d\u53ef\u91cd\u590d\u7ed1\u5b9a"));
                }
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

