/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.ability.impl;

import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.agreement.ability.AgrBudgetAmtConsumeAbilityService;
import com.tydic.agreement.ability.bo.AgrBudgetAmtCheckResultBO;
import com.tydic.agreement.ability.bo.AgrBudgetAmtConsumeReqBO;
import com.tydic.agreement.ability.bo.AgrBudgetAmtConsumeRspBO;
import com.tydic.agreement.ability.bo.BudgetAmtConsumeBO;
import com.tydic.agreement.busi.AgrBudgetAmtConsumeBusiService;
import com.tydic.agreement.constant.AgrCommConstant;
import com.tydic.agreement.dao.AgrAgreementBudgetAmtMapper;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.po.AgrAgreementBudgetAmtPO;
import com.tydic.agreement.dao.po.AgreementPO;
import com.tydic.contract.api.order.bo.QryContractOrderInfoReqBO;
import com.tydic.contract.api.order.bo.QryContractOrderInfoRspBO;
import com.tydic.contract.api.order.service.QryContractOrderInfoService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_TEST/2.0.0/com.tydic.agreement.ability.AgrBudgetAmtConsumeAbilityService"})
public class AgrBudgetAmtConsumeAbilityServiceImpl
implements AgrBudgetAmtConsumeAbilityService {
    @Autowired
    private AgrBudgetAmtConsumeBusiService agrBudgetAmtConsumeBusiService;
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgrAgreementBudgetAmtMapper agreementBudgetAmtMapper;
    @Autowired
    private QryContractOrderInfoService qryContractOrderInfoService;

    @PostMapping(value={"budgetConsume"})
    public AgrBudgetAmtConsumeRspBO budgetConsume(@RequestBody AgrBudgetAmtConsumeReqBO reqBO) {
        if (reqBO == null || CollectionUtils.isEmpty((Collection)reqBO.getBudgetAmtConsumeList()) || reqBO.getOrderId() == null || reqBO.getObjId() == null || reqBO.getObjType() == null || !StringUtils.hasText((String)reqBO.getOrderSource())) {
            throw new BusinessException("8888", "\u4e0b\u5355\u91d1\u989d\u66f4\u65b0\u5fc5\u4f20\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getCheckFlag() == null || reqBO.getCheckFlag().booleanValue()) {
            AgrBudgetAmtConsumeRspBO rspBo = this.budgetConsumeCheck(reqBO);
            if (!"0000".equals(rspBo.getRespCode())) {
                throw new BusinessException(rspBo.getRespCode(), rspBo.getRespDesc());
            }
            AgrBudgetAmtCheckResultBO resultBo = rspBo.getCheckResult().stream().filter(AgrBudgetAmtCheckResultBO::getOverLimit).findFirst().orElse(null);
            if (resultBo != null) {
                throw new BusinessException("8888", resultBo.getResultMsg());
            }
        }
        AgrAgreementBudgetAmtPO budgetAmtPO = new AgrAgreementBudgetAmtPO();
        budgetAmtPO.setOrderId(reqBO.getOrderId());
        budgetAmtPO.setObjId(reqBO.getObjId());
        budgetAmtPO.setObjType(reqBO.getObjType().getTypeCode());
        int checkBy = this.agreementBudgetAmtMapper.getCheckBy(budgetAmtPO);
        if (checkBy > 0) {
            throw new BusinessException("8888", "\u8be5\u8ba2\u5355\u5df2\u5b58\u5728\u5904\u7406\u8bb0\u5f55");
        }
        reqBO.getBudgetAmtConsumeList().stream().collect(Collectors.groupingBy(BudgetAmtConsumeBO::getPackCode)).forEach((packCode, amountList) -> {
            BigDecimal totalOrderAmount;
            BigDecimal reduce = amountList.stream().map(BudgetAmtConsumeBO::getUsedAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (reduce.compareTo(BigDecimal.ZERO) < 0 && ((totalOrderAmount = this.agreementBudgetAmtMapper.getBudgetAmtByOrderAndPackCode(reqBO.getOrderId(), (String)packCode)).compareTo(BigDecimal.ZERO) <= 0 || totalOrderAmount.compareTo(reduce.negate()) < 0)) {
                throw new BusinessException("8888", "\u672c\u6b21\u9000\u56de\u5408\u540c\u91d1\u989d\u8d85\u51fa\u8ba2\u5355\u5df2\u6263\u51cf\u91d1\u989d");
            }
        });
        return this.agrBudgetAmtConsumeBusiService.updateOrderConsume(reqBO);
    }

    @PostMapping(value={"budgetConsumeCheck"})
    public AgrBudgetAmtConsumeRspBO budgetConsumeCheck(@RequestBody AgrBudgetAmtConsumeReqBO reqBO) {
        AgrBudgetAmtConsumeRspBO rspBO = new AgrBudgetAmtConsumeRspBO();
        if (reqBO == null || CollectionUtils.isEmpty((Collection)reqBO.getBudgetAmtConsumeList())) {
            throw new BusinessException("8888", "\u4e0b\u5355\u91d1\u989d\u6821\u9a8c\u5fc5\u4f20\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        reqBO.getBudgetAmtConsumeList().forEach(bo -> {
            if (!StringUtils.hasText((String)bo.getPackCode())) {
                throw new BusinessException("8888", "\u4e0b\u5355\u91d1\u989d\u6821\u9a8c[\u9879\u76ee\u7f16\u53f7]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (bo.getAgreementId() == null && bo.getContractId() == null) {
                throw new BusinessException("8888", "\u4e0b\u5355\u91d1\u989d\u6821\u9a8c[\u534f\u8bae\u7f16\u53f7]/[\u5408\u540c\u7f16\u53f7]\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
            }
            if (bo.getUsedAmt() == null) {
                throw new BusinessException("8888", "\u4e0b\u5355\u91d1\u989d\u6821\u9a8c[\u91d1\u989d]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        });
        ArrayList budgetAmtConsumeBOS = new ArrayList();
        Map<String, List<BudgetAmtConsumeBO>> collectByPackCode = reqBO.getBudgetAmtConsumeList().stream().collect(Collectors.groupingBy(BudgetAmtConsumeBO::getPackCode));
        collectByPackCode.forEach((packCode, bos) -> {
            if (bos.size() > 1) {
                BigDecimal reduce = bos.stream().map(BudgetAmtConsumeBO::getUsedAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
                BudgetAmtConsumeBO bo = new BudgetAmtConsumeBO();
                bo.setPackCode(packCode);
                bo.setUsedAmt(reduce);
                budgetAmtConsumeBOS.add(bo);
            } else {
                budgetAmtConsumeBOS.addAll(bos);
            }
        });
        Map<String, BudgetAmtConsumeBO> usedAmountByPackCode = budgetAmtConsumeBOS.stream().collect(Collectors.toMap(BudgetAmtConsumeBO::getPackCode, Function.identity(), (key1, key2) -> key2));
        AgrAgreementBudgetAmtPO budgetAmountPO = new AgrAgreementBudgetAmtPO();
        budgetAmountPO.setPackCodes(new ArrayList<String>(collectByPackCode.keySet()));
        List<AgrAgreementBudgetAmtPO> totalOrderAmountByAgr = this.agreementBudgetAmtMapper.getTotalOrderAmountByAgr(budgetAmountPO);
        Map<String, AgrAgreementBudgetAmtPO> logAmountMapByCode = totalOrderAmountByAgr.stream().collect(Collectors.toMap(AgrAgreementBudgetAmtPO::getPackCode, po -> po, (a, b) -> a));
        ArrayList<AgrBudgetAmtCheckResultBO> checkResultList = new ArrayList<AgrBudgetAmtCheckResultBO>();
        if (StringUtils.hasText((String)reqBO.getOrderSource())) {
            switch (reqBO.getOrderSource()) {
                case "1": {
                    this.checkAgr(reqBO, logAmountMapByCode, checkResultList, usedAmountByPackCode);
                    break;
                }
                case "2": {
                    this.checkContract(reqBO, logAmountMapByCode, checkResultList, usedAmountByPackCode);
                    break;
                }
                default: {
                    throw new BusinessException("0002", "\u8ba2\u5355\u6765\u6e90\u3010" + reqBO.getOrderSource() + "\u3011\u4e0d\u652f\u6301");
                }
            }
        }
        rspBO.setCheckResult(checkResultList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void checkContract(AgrBudgetAmtConsumeReqBO reqBO, Map<String, AgrAgreementBudgetAmtPO> logAmountMapByCode, List<AgrBudgetAmtCheckResultBO> checkResultList, Map<String, BudgetAmtConsumeBO> usedAmountByPackCode) {
        Set contractIds = reqBO.getBudgetAmtConsumeList().stream().map(BudgetAmtConsumeBO::getContractId).collect(Collectors.toSet());
        QryContractOrderInfoReqBO contractOrderInfoReqBO = new QryContractOrderInfoReqBO();
        contractOrderInfoReqBO.setContractStatus(Integer.valueOf(4));
        contractOrderInfoReqBO.setPageNo(-1);
        contractOrderInfoReqBO.setPageSize(-1);
        contractOrderInfoReqBO.setContractType(Integer.valueOf(3));
        contractOrderInfoReqBO.setContractIds(new ArrayList(contractIds));
        RspPage contractOrderInfoRspBORspPage = this.qryContractOrderInfoService.selectListByCondition(contractOrderInfoReqBO);
        if (!"0000".equals(contractOrderInfoRspBORspPage.getCode())) {
            throw new BusinessException("8888", contractOrderInfoRspBORspPage.getMessage());
        }
        List contractOrderInfoRspBOS = contractOrderInfoRspBORspPage.getRows();
        if (CollectionUtils.isEmpty((Collection)contractOrderInfoRspBOS)) {
            throw new BusinessException("8888", "\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u5173\u8054\u7684\u5408\u540c\u4fe1\u606f");
        }
        Map<Long, QryContractOrderInfoRspBO> contractOrderInfoMap = contractOrderInfoRspBOS.stream().collect(Collectors.toMap(QryContractOrderInfoRspBO::getContractId, po -> po, (a, b) -> a));
        Map contractOrderInfoRspBOMap = contractOrderInfoRspBOS.stream().filter(Objects::nonNull).collect(Collectors.toMap(QryContractOrderInfoRspBO::getPackCode, Function.identity(), (existing, current) -> {
            if (existing == null) {
                return current;
            }
            if (current.getBudgetAmt() == null) {
                return existing;
            }
            return existing.getBudgetAmt() != null && existing.getBudgetAmt().compareTo(current.getBudgetAmt()) <= 0 ? existing : current;
        }));
        for (BudgetAmtConsumeBO orderAmountConsumeBo : reqBO.getBudgetAmtConsumeList()) {
            AgrAgreementBudgetAmtPO budgetAmtPO;
            AgrBudgetAmtCheckResultBO checkResultBo = new AgrBudgetAmtCheckResultBO();
            QryContractOrderInfoRspBO conPo = contractOrderInfoMap.get(orderAmountConsumeBo.getPackCode());
            if (conPo == null) {
                throw new BusinessException("8888", "\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u5173\u8054\u7684\u5408\u540c\u4fe1\u606f");
            }
            if (orderAmountConsumeBo.getUsedAmt().compareTo(BigDecimal.ZERO) > 0 && !Objects.equals(conPo.getContractStatus(), AgrCommConstant.AgreementStatus.ENABLE)) {
                throw new BusinessException("8888", "\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u5173\u8054\u7684\u6709\u6548\u5408\u540c\u4fe1\u606f");
            }
            QryContractOrderInfoRspBO orderInfoRspBO = (QryContractOrderInfoRspBO)contractOrderInfoRspBOMap.get(orderAmountConsumeBo.getPackCode());
            if (null == orderInfoRspBO) continue;
            BigDecimal total = orderInfoRspBO.getBudgetAmt() == null ? BigDecimal.ZERO : orderInfoRspBO.getBudgetAmt();
            BigDecimal remBudgetAmt = orderInfoRspBO.getRemBudgetAmt() == null ? BigDecimal.ZERO : orderInfoRspBO.getRemBudgetAmt();
            orderAmountConsumeBo.setMinBudgetAmt(total);
            orderAmountConsumeBo.setRemBudgetAmt(remBudgetAmt);
            checkResultBo.setContractId(orderInfoRspBO.getContractId());
            checkResultBo.setBudgetAmt(total);
            checkResultList.add(checkResultBo);
            if (total == null) continue;
            BigDecimal usedBudgetAmt = total.subtract(remBudgetAmt);
            BudgetAmtConsumeBO budgetAmtConsumeBO = usedAmountByPackCode.get(orderAmountConsumeBo.getPackCode());
            BigDecimal usedAmt = BigDecimal.ZERO;
            if (null != budgetAmtConsumeBO) {
                BigDecimal bigDecimal = usedAmt = budgetAmtConsumeBO.getUsedAmt() == null ? BigDecimal.ZERO : budgetAmtConsumeBO.getUsedAmt();
            }
            if (usedAmt.compareTo(BigDecimal.ZERO) >= 0 && usedAmt.compareTo(remBudgetAmt) > 0) {
                checkResultBo.setOverLimit(Boolean.valueOf(true));
                checkResultBo.setResultMsg("\u8ba2\u5355\u91d1\u989d\u5df2\u8d85\u51fa\u5408\u540c[" + conPo.getPlaAgreementCode() + "]\u7684\u6807\u6bb5\u91d1\u989d");
                checkResultBo.setUsedBudgetAmt(usedBudgetAmt);
                continue;
            }
            if (usedAmt.compareTo(BigDecimal.ZERO) < 0 && total.subtract(remBudgetAmt).compareTo(BigDecimal.ZERO) < 0) {
                checkResultBo.setOverLimit(Boolean.valueOf(true));
                checkResultBo.setResultMsg("\u8ba2\u5355\u9000\u6b3e\u91d1\u989d\u5df2\u8d85\u51fa\u5408\u540c[" + conPo.getContractCode() + "]\u7684\u5df2\u4e0b\u5355\u91d1\u989d");
                checkResultBo.setUsedBudgetAmt(usedBudgetAmt);
                continue;
            }
            if (!CollectionUtils.isEmpty(logAmountMapByCode) && (budgetAmtPO = logAmountMapByCode.get(orderAmountConsumeBo.getPackCode())) != null) {
                BigDecimal logOrdered = budgetAmtPO.getConsumerBudgetAmt();
                BigDecimal totalLogOrdered = orderAmountConsumeBo.getUsedAmt().add(logOrdered);
                if (usedAmt.compareTo(BigDecimal.ZERO) >= 0 && totalLogOrdered.compareTo(total) > 0) {
                    checkResultBo.setOverLimit(Boolean.valueOf(true));
                    checkResultBo.setResultMsg("\u8ba2\u5355\u91d1\u989d\u5df2\u8d85\u51fa\u5408\u540c[" + conPo.getContractCode() + "]\u7684\u6807\u6bb5\u91d1\u989d");
                    checkResultBo.setUsedBudgetAmt(logOrdered);
                    continue;
                }
                if (usedAmt.compareTo(BigDecimal.ZERO) < 0 && totalLogOrdered.compareTo(BigDecimal.ZERO) < 0) {
                    checkResultBo.setOverLimit(Boolean.valueOf(true));
                    checkResultBo.setResultMsg("\u8ba2\u5355\u9000\u6b3e\u91d1\u989d\u5df2\u8d85\u51fa\u5408\u540c[" + conPo.getContractCode() + "]\u7684\u5df2\u4e0b\u5355\u91d1\u989d");
                    checkResultBo.setUsedBudgetAmt(logOrdered);
                    continue;
                }
            }
            checkResultBo.setUsedBudgetAmt(usedBudgetAmt);
            checkResultBo.setOverLimit(Boolean.valueOf(false));
        }
    }

    private void checkAgr(AgrBudgetAmtConsumeReqBO reqBO, Map<String, AgrAgreementBudgetAmtPO> logAmountMapByCode, List<AgrBudgetAmtCheckResultBO> checkResultList, Map<String, BudgetAmtConsumeBO> usedAmountByPackCode) {
        Set agreementIds = reqBO.getBudgetAmtConsumeList().stream().map(BudgetAmtConsumeBO::getAgreementId).collect(Collectors.toSet());
        AgreementPO agreementPo = new AgreementPO();
        agreementPo.setAgreementIds(new ArrayList<Long>(agreementIds));
        agreementPo.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        List<AgreementPO> agreementPos = this.agreementMapper.getList(agreementPo);
        Map<Long, AgreementPO> agrMapByAgrId = agreementPos.stream().collect(Collectors.toMap(AgreementPO::getAgreementId, po -> po, (a, b) -> a));
        List<AgreementPO> minBudgetAmtList = this.agreementMapper.getMinBudgetAmtList(agreementPo);
        Map<String, AgreementPO> minBudgetAmtMapByCode = minBudgetAmtList.stream().collect(Collectors.toMap(AgreementPO::getEcpProjectCode, po -> po, (a, b) -> a));
        for (BudgetAmtConsumeBO orderAmountConsumeBo : reqBO.getBudgetAmtConsumeList()) {
            AgrAgreementBudgetAmtPO budgetAmtPO;
            AgrBudgetAmtCheckResultBO checkResultBo = new AgrBudgetAmtCheckResultBO();
            AgreementPO agrPo = agrMapByAgrId.get(orderAmountConsumeBo.getAgreementId());
            if (agrPo == null) {
                throw new BusinessException("8888", "\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u5173\u8054\u7684\u534f\u8bae\u4fe1\u606f");
            }
            orderAmountConsumeBo.setPlaAgreementCode(agreementPo.getPlaAgreementCode());
            if (!(orderAmountConsumeBo.getUsedAmt().compareTo(BigDecimal.ZERO) <= 0 || Objects.equals(agrPo.getIsDelete(), AgrCommConstant.IsDelete.NORMAL) && Objects.equals(agrPo.getAgreementStatus(), AgrCommConstant.AgreementStatus.ENABLE))) {
                throw new BusinessException("8888", "\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u5173\u8054\u7684\u6709\u6548\u534f\u8bae\u4fe1\u606f");
            }
            AgreementPO agreementPO = minBudgetAmtMapByCode.get(orderAmountConsumeBo.getPackCode());
            if (agreementPO == null) continue;
            BigDecimal total = agreementPO.getBudgetAmt() == null ? BigDecimal.ZERO : agreementPO.getBudgetAmt();
            BigDecimal remBudgetAmt = agreementPO.getRemBudgetAmt() == null ? BigDecimal.ZERO : agreementPO.getRemBudgetAmt();
            orderAmountConsumeBo.setMinBudgetAmt(total);
            orderAmountConsumeBo.setRemBudgetAmt(remBudgetAmt);
            checkResultBo.setAgreementId(agreementPO.getAgreementId());
            checkResultBo.setBudgetAmt(total);
            checkResultList.add(checkResultBo);
            if (total == null) continue;
            BigDecimal usedBudgetAmt = total.subtract(remBudgetAmt);
            BudgetAmtConsumeBO budgetAmtConsumeBO = usedAmountByPackCode.get(orderAmountConsumeBo.getPackCode());
            BigDecimal usedAmt = BigDecimal.ZERO;
            if (null != budgetAmtConsumeBO) {
                BigDecimal bigDecimal = usedAmt = budgetAmtConsumeBO.getUsedAmt() == null ? BigDecimal.ZERO : budgetAmtConsumeBO.getUsedAmt();
            }
            if (usedAmt.compareTo(BigDecimal.ZERO) >= 0 && usedAmt.compareTo(remBudgetAmt) > 0) {
                checkResultBo.setOverLimit(Boolean.valueOf(true));
                checkResultBo.setResultMsg("\u8ba2\u5355\u91d1\u989d\u5df2\u8d85\u51fa\u534f\u8bae[" + agrPo.getPlaAgreementCode() + "]\u7684\u6807\u6bb5\u91d1\u989d");
                checkResultBo.setUsedBudgetAmt(usedBudgetAmt);
                continue;
            }
            if (usedAmt.compareTo(BigDecimal.ZERO) < 0 && total.subtract(remBudgetAmt).compareTo(BigDecimal.ZERO) < 0) {
                checkResultBo.setOverLimit(Boolean.valueOf(true));
                checkResultBo.setResultMsg("\u8ba2\u5355\u9000\u6b3e\u91d1\u989d\u5df2\u8d85\u51fa\u534f\u8bae[" + agrPo.getPlaAgreementCode() + "]\u7684\u5df2\u4e0b\u5355\u91d1\u989d");
                checkResultBo.setUsedBudgetAmt(usedBudgetAmt);
                continue;
            }
            if (!CollectionUtils.isEmpty(logAmountMapByCode) && (budgetAmtPO = logAmountMapByCode.get(orderAmountConsumeBo.getPackCode())) != null) {
                BigDecimal logOrdered = budgetAmtPO.getConsumerBudgetAmt();
                BigDecimal totalLogOrdered = orderAmountConsumeBo.getUsedAmt().add(logOrdered);
                if (usedAmt.compareTo(BigDecimal.ZERO) >= 0 && totalLogOrdered.compareTo(total) > 0) {
                    checkResultBo.setOverLimit(Boolean.valueOf(true));
                    checkResultBo.setResultMsg("\u8ba2\u5355\u91d1\u989d\u5df2\u8d85\u51fa\u534f\u8bae[" + agrPo.getPlaAgreementCode() + "]\u7684\u6807\u6bb5\u91d1\u989d");
                    checkResultBo.setUsedBudgetAmt(logOrdered);
                    continue;
                }
                if (usedAmt.compareTo(BigDecimal.ZERO) < 0 && totalLogOrdered.compareTo(BigDecimal.ZERO) < 0) {
                    checkResultBo.setOverLimit(Boolean.valueOf(true));
                    checkResultBo.setResultMsg("\u8ba2\u5355\u9000\u6b3e\u91d1\u989d\u5df2\u8d85\u51fa\u534f\u8bae[" + agrPo.getPlaAgreementCode() + "]\u7684\u5df2\u4e0b\u5355\u91d1\u989d");
                    checkResultBo.setUsedBudgetAmt(logOrdered);
                    continue;
                }
            }
            checkResultBo.setUsedBudgetAmt(usedBudgetAmt);
            checkResultBo.setOverLimit(Boolean.valueOf(false));
        }
    }
}

