/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.agreement.ability.AgrBusiRedoAbilityService;
import com.tydic.agreement.ability.AgrSpuPriceChangeSyncAbilityService;
import com.tydic.agreement.ability.bo.AgrBusiRedoQueueBO;
import com.tydic.agreement.ability.bo.AgrBusiRedoReqBO;
import com.tydic.agreement.ability.bo.AgrBusiRedoRspBO;
import com.tydic.agreement.ability.bo.AgrSpuPriceChangeSyncAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrSpuPriceChangeSyncAbilityRspBO;
import com.tydic.agreement.ability.bo.AgrSyncBusiPropLabelAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrSyncBusiPropLabelAbilityRspBO;
import com.tydic.agreement.ability.bo.AgrSyncErjiAgreementAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrSyncErjiAgreementAbilityRspBO;
import com.tydic.agreement.busi.AgrBusiRedoBusiService;
import com.tydic.agreement.busi.AgrSyncBusiPropLabelBusiService;
import com.tydic.agreement.busi.AgrSyncErjiAgreementBusiService;
import com.tydic.agreement.constant.AgrBusiRedoTypeEnum;
import com.tydic.agreement.external.ucc.AgrExternalStandardSpuSyncService;
import com.tydic.agreement.external.ucc.bo.AgrExternalStandardSpuSyncApplyInfoReqBO;
import com.tydic.agreement.external.ucc.bo.AgrExternalStandardSpuSyncApplyInfoRspBO;
import com.tydic.order.extend.ability.saleorder.PebExtAgreementCreateOrderAbilityService;
import com.tydic.order.extend.bo.saleorder.PebExtAgreementCreateOrderReqBO;
import com.tydic.order.extend.bo.saleorder.PebExtAgreementCreateOrderRspBO;
import com.tydic.uccext.bo.UccExtSyncBusiPropLabelFromAgreementOrContractReqBO;
import com.tydic.uccext.bo.UccExtSyncErjiAgreementAbilityReqBO;
import com.tydic.umcext.ability.member.UmcZhMemDetailQueryAbilityService;
import com.tydic.umcext.ability.member.bo.UmcZhMemDetailQueryAbilityReqBO;
import com.tydic.umcext.ability.member.bo.UmcZhMemDetailQueryAbilityRspBO;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_TEST/2.0.0/com.tydic.agreement.ability.AgrBusiRedoAbilityService"})
public class AgrBusiRedoAbilityServiceImpl
implements AgrBusiRedoAbilityService {
    private static final Logger log = LoggerFactory.getLogger(AgrBusiRedoAbilityServiceImpl.class);
    private final AtomicBoolean busyFlag = new AtomicBoolean(false);
    @Autowired
    private AgrBusiRedoBusiService agrBusiRedoBusiService;
    @Value(value="${SYNC_BUSI_PROP_LABEL_TOPIC}")
    private String syncBusiPropLabelTopic;
    @Value(value="${SYNC_BUSI_PROP_LABEL_TAG}")
    private String syncBusiPropLabelTag;
    @Resource(name="syncAgreementBusiPropLabelProvider")
    private ProxyMessageProducer syncAgreementBusiPropLabelProvider;
    @Autowired
    private AgrSyncBusiPropLabelBusiService agrSyncBusiPropLabelBusiService;
    @Value(value="${SYNC_ERJI_AGR_TO_UCC_TOPIC}")
    private String topic;
    @Value(value="${SYNC_ERJI_AGR_TO_UCC_TAG}")
    private String tag;
    @Resource(name="syncErjiAgreementProvider")
    private ProxyMessageProducer syncErjiAgreementProvider;
    @Autowired
    private AgrSyncErjiAgreementBusiService agrSyncErjiAgreementBusiService;
    @Autowired
    private PebExtAgreementCreateOrderAbilityService pebExtAgreementCreateOrderAbilityService;
    @Autowired
    private UmcZhMemDetailQueryAbilityService umcZhMemDetailQueryAbilityService;
    @Autowired
    private AgrExternalStandardSpuSyncService agrExternalStandardSpuSyncService;
    @Autowired
    private AgrSpuPriceChangeSyncAbilityService agrSpuPriceChangeSyncAbilityService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"dealRedoTask"})
    public AgrBusiRedoRspBO dealRedoTask(@RequestBody AgrBusiRedoReqBO redoReqBo) {
        AgrBusiRedoRspBO rspBo = new AgrBusiRedoRspBO();
        boolean compareAndSet = this.busyFlag.compareAndSet(false, true);
        if (!compareAndSet) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u5f53\u524d\u4e1a\u52a1\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            return rspBo;
        }
        try {
            rspBo = this.agrBusiRedoBusiService.updateRedoTaskInProcessing(redoReqBo);
            if (!"0000".equals(rspBo.getRespCode())) {
                AgrBusiRedoRspBO agrBusiRedoRspBO = rspBo;
                return agrBusiRedoRspBO;
            }
            if (CollectionUtils.isEmpty((Collection)rspBo.getRedoQueueList())) {
                rspBo.setRespCode("0000");
                rspBo.setRespDesc("\u6210\u529f");
                AgrBusiRedoRspBO agrBusiRedoRspBO = rspBo;
                return agrBusiRedoRspBO;
            }
            for (AgrBusiRedoQueueBO bo : rspBo.getRedoQueueList()) {
                try {
                    AgrBusiRedoTypeEnum type = AgrBusiRedoTypeEnum.getByType((int)bo.getBusiType());
                    if (type == null) {
                        bo.setFinish(Boolean.valueOf(true));
                        throw new BusinessException("8888", "\u6682\u4e0d\u652f\u6301\u7684\u4e1a\u52a1\u8865\u507f\u7c7b\u578b");
                    }
                    switch (type) {
                        case BusiPropLabelSyncMq: {
                            this.dealBusiPropLabelSyncMq(bo);
                            break;
                        }
                        case BusiPropLabelSyncMqSaveLog: {
                            this.dealBusiPropLabelSyncMqSaveLog(bo);
                            break;
                        }
                        case ErjiAgrSyncMq: {
                            this.dealErjiAgrSyncMq(bo);
                            break;
                        }
                        case ErjiAgrSyncMqSaveLog: {
                            this.dealErjiAgrSyncMqSaveLog(bo);
                            break;
                        }
                        case GDZJAgrCreateOrder: {
                            this.dealGDZJAgrCreateOrder(bo);
                            break;
                        }
                        case SPU_SYNC_APPLY_INFO: {
                            this.dealSpuSyncApplyInfo(bo);
                            break;
                        }
                        case SPU_PRICE_CHANGE_SYNC: {
                            this.dealSpuPriceChangeSync(bo);
                        }
                    }
                }
                catch (Exception e) {
                    AgrBusiRedoReqBO AgrBusiRedoReqBo = new AgrBusiRedoReqBO();
                    AgrBusiRedoReqBo.setBusiRedoQueue(bo);
                    AgrBusiRedoReqBo.setMsg(e.getMessage());
                    this.agrBusiRedoBusiService.updateRedoTaskFailed(AgrBusiRedoReqBo);
                    continue;
                }
                AgrBusiRedoReqBO AgrBusiRedoReqBo = new AgrBusiRedoReqBO();
                AgrBusiRedoReqBo.setBusiRedoQueue(bo);
                this.agrBusiRedoBusiService.updateRedoTaskCompleted(AgrBusiRedoReqBo);
            }
            AgrBusiRedoRspBO agrBusiRedoRspBO = rspBo;
            return agrBusiRedoRspBO;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            rspBo.setRespCode("8888");
            rspBo.setRespDesc(e.getMessage());
            AgrBusiRedoRspBO agrBusiRedoRspBO = rspBo;
            return agrBusiRedoRspBO;
        }
        finally {
            this.busyFlag.set(false);
        }
    }

    private void dealSpuPriceChangeSync(AgrBusiRedoQueueBO bo) {
        AgrSpuPriceChangeSyncAbilityReqBO reqBO = (AgrSpuPriceChangeSyncAbilityReqBO)JSONObject.parseObject((String)bo.getRequestParam(), AgrSpuPriceChangeSyncAbilityReqBO.class);
        AgrSpuPriceChangeSyncAbilityRspBO rspBO = this.agrSpuPriceChangeSyncAbilityService.dealSpuPriceChangeSync(reqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            throw new BusinessException("8888", rspBO.getRespDesc());
        }
    }

    private void dealSpuSyncApplyInfo(AgrBusiRedoQueueBO bo) {
        AgrExternalStandardSpuSyncApplyInfoReqBO reqBO = (AgrExternalStandardSpuSyncApplyInfoReqBO)JSONObject.parseObject((String)bo.getRequestParam(), AgrExternalStandardSpuSyncApplyInfoReqBO.class);
        AgrExternalStandardSpuSyncApplyInfoRspBO rspBO = this.agrExternalStandardSpuSyncService.syncApplyInfo(reqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            throw new BusinessException("8888", rspBO.getRespDesc());
        }
    }

    private void dealGDZJAgrCreateOrder(AgrBusiRedoQueueBO bo) {
        PebExtAgreementCreateOrderReqBO pebExtAgreementCreateOrderReqBO = (PebExtAgreementCreateOrderReqBO)JSONObject.parseObject((String)bo.getRequestParam(), PebExtAgreementCreateOrderReqBO.class);
        UmcZhMemDetailQueryAbilityReqBO umcZhMemDetailQueryAbilityReqBO = new UmcZhMemDetailQueryAbilityReqBO();
        umcZhMemDetailQueryAbilityReqBO.setMemId(pebExtAgreementCreateOrderReqBO.getMemId());
        UmcZhMemDetailQueryAbilityRspBO umcZhMemDetailQueryAbilityRspBO = this.umcZhMemDetailQueryAbilityService.memDetailQuery(umcZhMemDetailQueryAbilityReqBO);
        if (!"0000".equals(umcZhMemDetailQueryAbilityRspBO.getRespCode()) || umcZhMemDetailQueryAbilityRspBO.getUmcMemDetailInfoAbilityRspBO() == null) {
            throw new BusinessException("8888", "\u672a\u67e5\u8be2\u5230\u534f\u8bae\u7ecf\u529e\u4eba\u4fe1\u606f");
        }
        pebExtAgreementCreateOrderReqBO.setUserId(umcZhMemDetailQueryAbilityRspBO.getUmcMemDetailInfoAbilityRspBO().getUserId());
        pebExtAgreementCreateOrderReqBO.setUsername(umcZhMemDetailQueryAbilityRspBO.getUmcMemDetailInfoAbilityRspBO().getRegAccount());
        pebExtAgreementCreateOrderReqBO.setName(umcZhMemDetailQueryAbilityRspBO.getUmcMemDetailInfoAbilityRspBO().getMemName2());
        pebExtAgreementCreateOrderReqBO.setCompanyId(umcZhMemDetailQueryAbilityRspBO.getUmcMemDetailInfoAbilityRspBO().getCompanyId());
        pebExtAgreementCreateOrderReqBO.setCompanyName(umcZhMemDetailQueryAbilityRspBO.getUmcMemDetailInfoAbilityRspBO().getCompanyName());
        pebExtAgreementCreateOrderReqBO.setOrgId(umcZhMemDetailQueryAbilityRspBO.getUmcMemDetailInfoAbilityRspBO().getOrgId());
        pebExtAgreementCreateOrderReqBO.setOrgName(umcZhMemDetailQueryAbilityRspBO.getUmcMemDetailInfoAbilityRspBO().getOrgName());
        pebExtAgreementCreateOrderReqBO.setOrgPath(umcZhMemDetailQueryAbilityRspBO.getUmcMemDetailInfoAbilityRspBO().getOrgTreePath());
        PebExtAgreementCreateOrderRspBO pebExtAgreementCreateOrderRspBO = this.pebExtAgreementCreateOrderAbilityService.dealPebExtAgreementCreateOrder(pebExtAgreementCreateOrderReqBO);
        if (!"0000".equals(pebExtAgreementCreateOrderRspBO.getRespCode())) {
            throw new BusinessException("8888", pebExtAgreementCreateOrderRspBO.getRespDesc());
        }
    }

    private void dealErjiAgrSyncMqSaveLog(AgrBusiRedoQueueBO bo) {
        AgrSyncErjiAgreementAbilityReqBO reqBo = (AgrSyncErjiAgreementAbilityReqBO)JSONObject.parseObject((String)bo.getRequestParam(), AgrSyncErjiAgreementAbilityReqBO.class);
        AgrSyncErjiAgreementAbilityRspBO agrSyncBusiPropLabelAbilityRspBo = this.agrSyncErjiAgreementBusiService.dealSyncErjiAgreement(reqBo);
        if (!"0000".equals(agrSyncBusiPropLabelAbilityRspBo.getRespCode())) {
            throw new BusinessException("8888", agrSyncBusiPropLabelAbilityRspBo.getRespDesc());
        }
    }

    private void dealErjiAgrSyncMq(AgrBusiRedoQueueBO bo) {
        UccExtSyncErjiAgreementAbilityReqBO uccExtSyncErjiAgreementAbilityReqBo = (UccExtSyncErjiAgreementAbilityReqBO)JSONObject.parseObject((String)bo.getRequestParam(), UccExtSyncErjiAgreementAbilityReqBO.class);
        ProxySendResult proxySendResult = this.syncErjiAgreementProvider.send(new ProxyMessage(this.topic, this.tag, JSONObject.toJSONString((Object)uccExtSyncErjiAgreementAbilityReqBo)));
        String msgId = proxySendResult.getMsgId();
        AgrSyncErjiAgreementAbilityReqBO reqBo = new AgrSyncErjiAgreementAbilityReqBO();
        reqBo.setMsgId(msgId);
        reqBo.setAgrId(uccExtSyncErjiAgreementAbilityReqBo.getAgreementId());
        AgrSyncErjiAgreementAbilityRspBO agrSyncBusiPropLabelAbilityRspBo = this.agrSyncErjiAgreementBusiService.dealSyncErjiAgreement(reqBo);
        if (!"0000".equals(agrSyncBusiPropLabelAbilityRspBo.getRespCode())) {
            AgrBusiRedoReqBO agrBusiRedoReqBo = new AgrBusiRedoReqBO();
            AgrBusiRedoQueueBO agrBusiRedoQueueBo = new AgrBusiRedoQueueBO();
            agrBusiRedoQueueBo.setBusiType(Integer.valueOf(AgrBusiRedoTypeEnum.ErjiAgrSyncMqSaveLog.getTypeCode()));
            agrBusiRedoQueueBo.setRequestParam(JSONObject.toJSONString((Object)reqBo));
            agrBusiRedoReqBo.setBusiRedoQueue(agrBusiRedoQueueBo);
            this.agrBusiRedoBusiService.addRedoTask(agrBusiRedoReqBo);
        }
    }

    private void dealBusiPropLabelSyncMqSaveLog(AgrBusiRedoQueueBO bo) {
        AgrSyncBusiPropLabelAbilityReqBO reqBo = (AgrSyncBusiPropLabelAbilityReqBO)JSONObject.parseObject((String)bo.getRequestParam(), AgrSyncBusiPropLabelAbilityReqBO.class);
        AgrSyncBusiPropLabelAbilityRspBO agrSyncBusiPropLabelAbilityRspBo = this.agrSyncBusiPropLabelBusiService.dealSyncBusiPropLabel(reqBo);
        if (!"0000".equals(agrSyncBusiPropLabelAbilityRspBo.getRespCode())) {
            throw new BusinessException("8888", agrSyncBusiPropLabelAbilityRspBo.getRespDesc());
        }
    }

    private void dealBusiPropLabelSyncMq(AgrBusiRedoQueueBO bo) {
        UccExtSyncBusiPropLabelFromAgreementOrContractReqBO uccExtSyncBusiPropLabelFromAgreementOrContractReqBo = (UccExtSyncBusiPropLabelFromAgreementOrContractReqBO)JSONObject.parseObject((String)bo.getRequestParam(), UccExtSyncBusiPropLabelFromAgreementOrContractReqBO.class);
        ProxySendResult proxySendResult = this.syncAgreementBusiPropLabelProvider.send(new ProxyMessage(this.syncBusiPropLabelTopic, this.syncBusiPropLabelTag, bo.getRequestParam()));
        String msgId = proxySendResult.getMsgId();
        AgrSyncBusiPropLabelAbilityReqBO reqBo = new AgrSyncBusiPropLabelAbilityReqBO();
        reqBo.setAgrId(uccExtSyncBusiPropLabelFromAgreementOrContractReqBo.getLabelSource().getSourceId());
        reqBo.setVersion(uccExtSyncBusiPropLabelFromAgreementOrContractReqBo.getLabelSource().getVersion());
        reqBo.setMsgId(msgId);
        AgrSyncBusiPropLabelAbilityRspBO agrSyncBusiPropLabelAbilityRspBo = this.agrSyncBusiPropLabelBusiService.dealSyncBusiPropLabel(reqBo);
        if (!"0000".equals(agrSyncBusiPropLabelAbilityRspBo.getRespCode())) {
            AgrBusiRedoReqBO agrBusiRedoReqBo = new AgrBusiRedoReqBO();
            AgrBusiRedoQueueBO agrBusiRedoQueueBo = new AgrBusiRedoQueueBO();
            agrBusiRedoQueueBo.setBusiType(Integer.valueOf(AgrBusiRedoTypeEnum.BusiPropLabelSyncMqSaveLog.getTypeCode()));
            agrBusiRedoQueueBo.setRequestParam(JSONObject.toJSONString((Object)reqBo));
            agrBusiRedoReqBo.setBusiRedoQueue(agrBusiRedoQueueBo);
            this.agrBusiRedoBusiService.addRedoTask(agrBusiRedoReqBo);
        }
    }

    @PostMapping(value={"dealRunningTask"})
    public AgrBusiRedoRspBO dealRunningTask(@RequestBody AgrBusiRedoReqBO redoReqBo) {
        return this.agrBusiRedoBusiService.dealRunningTask(redoReqBo);
    }
}

