/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.ability.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.agreement.ability.AgrCreateAgreementSkuAbilityService;
import com.tydic.agreement.ability.bo.AgrCreateAgreementSkuAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrCreateAgreementSkuAbilityRspBO;
import com.tydic.agreement.busi.AgrCreateAgreementSkuBusiService;
import com.tydic.agreement.busi.bo.AgrCreateAgreementSkuBusiReqBO;
import com.tydic.agreement.busi.bo.AgrCreateAgreementSkuBusiRspBO;
import com.tydic.agreement.common.bo.AgrAgreementSkuBO;
import com.tydic.agreement.constant.AgrEnum;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Objects;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_TEST/2.0.0/com.tydic.agreement.ability.AgrCreateAgreementSkuAbilityService"})
public class AgrCreateAgreementSkuAbilityServiceImpl
implements AgrCreateAgreementSkuAbilityService {
    @Autowired
    private AgrCreateAgreementSkuBusiService agrCreateAgreementSkuBusiService;

    @PostMapping(value={"createAgreementSku"})
    public AgrCreateAgreementSkuAbilityRspBO createAgreementSku(@RequestBody AgrCreateAgreementSkuAbilityReqBO abilityReqBO) {
        AgrCreateAgreementSkuAbilityRspBO rsp = new AgrCreateAgreementSkuAbilityRspBO();
        this.validateParam(abilityReqBO);
        AgrCreateAgreementSkuBusiReqBO agrCreateAgreementSkuBusiReqBO = new AgrCreateAgreementSkuBusiReqBO();
        BeanUtils.copyProperties((Object)abilityReqBO, (Object)agrCreateAgreementSkuBusiReqBO);
        AgrCreateAgreementSkuBusiRspBO agrCreateAgreementSkuBusiRspBO = this.agrCreateAgreementSkuBusiService.createAgreementSku(agrCreateAgreementSkuBusiReqBO);
        BeanUtils.copyProperties((Object)agrCreateAgreementSkuBusiRspBO, (Object)rsp);
        return rsp;
    }

    private void validateParam(AgrCreateAgreementSkuAbilityReqBO abilityReqBO) {
        if (null == abilityReqBO.getMemIdIn()) {
            throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6\u521b\u5efaAPI\u5165\u53c2\u3010memIdIn\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == abilityReqBO.getAgreementId()) {
            throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6\u521b\u5efaAPI\u5165\u53c2\u3010agreementId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)abilityReqBO.getAgrAgreementSkuBOs())) {
            throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6\u521b\u5efaAPI\u5165\u53c2\u3010agrAgreementSkuBOs\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        for (AgrAgreementSkuBO bo : abilityReqBO.getAgrAgreementSkuBOs()) {
            Long salePriceSum;
            if (null == bo.getBuyNumber()) {
                throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6\u521b\u5efaAPI\u5165\u53c2\u3010agrAgreementSkuBOs.buyNumber\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            String buyNumber = bo.getBuyNumber().toPlainString();
            if (buyNumber.contains(".")) {
                if (buyNumber.length() - 1 - buyNumber.indexOf(".") > 6) {
                    throw new BusinessException("0001", "\u5546\u54c1\u6570\u91cf\u53ea\u652f\u63016\u4f4d\u5c0f\u6570");
                }
                if (buyNumber.indexOf(".") > 12) {
                    throw new BusinessException("0001", "\u5546\u54c1\u6570\u91cf\u6574\u6570\u4f4d\u53ea\u652f\u630112\u4f4d");
                }
            } else if (buyNumber.length() > 12) {
                throw new BusinessException("0001", "\u5546\u54c1\u6570\u91cf\u6574\u6570\u4f4d\u53ea\u652f\u630112\u4f4d");
            }
            if (null == bo.getBuyPrice()) {
                throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6\u521b\u5efaAPI\u5165\u53c2\u3010agrAgreementSkuBOs.buyPrice\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (bo.getBuyPrice() <= 0L) {
                throw new BusinessException("0001", "\u91c7\u8d2d\u5355\u4ef7\u5fc5\u987b\u5927\u4e8e0\uff01");
            }
            if (null == bo.getBuyPriceSum()) {
                throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6\u521b\u5efaAPI\u5165\u53c2\u3010agrAgreementSkuBOs.buyPriceSum\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (null == bo.getMarkupRate()) {
                bo.setMarkupRate(Double.valueOf(0.0));
            }
            if (null == bo.getSupplyCycle()) {
                throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6\u521b\u5efaAPI\u5165\u53c2\u3010\u4f9b\u8d27\u5468\u671f\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (null == bo.getTaxRate()) {
                throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6\u521b\u5efaAPI\u5165\u53c2\u3010\u7a0e\u7387\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (bo.getItemSource() == null) {
                bo.setItemSource(AgrEnum.ItemSource.FROM_AGREEMENT.getType());
            }
            if (bo.getContractCovered() == null && Objects.equals(AgrEnum.ItemSource.FROM_AGREEMENT.getType(), bo.getItemSource())) {
                bo.setContractCovered(Integer.valueOf(AgrEnum.YesOrNo.YES.getCode().byteValue()));
            }
            if (!StringUtils.hasText((String)bo.getMaterialId())) {
                throw new BusinessException("0001", "\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (bo.getCatalogVariety() != null && Objects.equals(AgrEnum.Variety.WZ.getCode(), bo.getCatalogVariety()) && !StringUtils.hasText((String)bo.getProducingArea())) {
                throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6\u4e3a\u7269\u8d44\u7c7b\uff0c\u7269\u8d44\u4ea7\u5730\u4e0d\u80fd\u4e3a\u7a7a");
            }
            Long buyPriceSum = new BigDecimal(bo.getBuyPrice()).multiply(bo.getBuyNumber()).longValue();
            if (buyPriceSum.toString().length() > 18) {
                throw new BusinessException("0001", "\u603b\u4ef7\u6574\u6570\u4f4d\u53ea\u652f\u630114\u4f4d\uff0c\u8bf7\u6839\u636e\u5355\u4ef7\u8c03\u6574\u6570\u91cf");
            }
            Long salePrice = new BigDecimal(bo.getBuyPrice()).add(new BigDecimal(bo.getBuyPrice()).multiply(new BigDecimal(bo.getMarkupRate()))).divide(new BigDecimal("100")).longValue();
            if (StringUtils.hasText((String)bo.getMarkupValue())) {
                salePrice = salePrice + new BigDecimal(bo.getMarkupValue()).multiply(new BigDecimal("10000")).longValue();
            }
            if ((salePriceSum = Long.valueOf(new BigDecimal(salePrice).multiply(bo.getBuyNumber()).longValue())).toString().length() <= 18) continue;
            throw new BusinessException("0001", "\u603b\u4ef7\u6574\u6570\u4f4d\u53ea\u652f\u630114\u4f4d\uff0c\u8bf7\u6839\u636e\u5355\u4ef7\u8c03\u6574\u6570\u91cf");
        }
    }
}

