/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.ability.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.agreement.ability.AgrCreateAgreementSkuChangeAbilityService;
import com.tydic.agreement.ability.bo.AgrCreateAgreementSkuChangeAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrCreateAgreementSkuChangeAbilityRspBO;
import com.tydic.agreement.atom.AgrDicDictionaryAtomService;
import com.tydic.agreement.busi.AgrCreateAgreementSkuChangeBusiService;
import com.tydic.agreement.busi.bo.AgrCreateAgreementSkuChangeBusiReqBO;
import com.tydic.agreement.busi.bo.AgrCreateAgreementSkuChangeBusiRspBO;
import com.tydic.agreement.common.bo.AgrAgreementSkuChangeBO;
import com.tydic.agreement.constant.AgrCommConstant;
import com.tydic.agreement.constant.AgrEnum;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.AgreementSkuMapper;
import com.tydic.agreement.dao.po.AgreementPO;
import com.tydic.agreement.dao.po.AgreementSkuPO;
import com.tydic.uccext.bo.CnncQryCommodityTypeListAbilityBo;
import com.tydic.uccext.bo.CnncQryCommodityTypeListAbilityReqBo;
import com.tydic.uccext.bo.CnncQryCommodityTypeListAbilityRspBo;
import com.tydic.uccext.service.CnncQryCommodityTypeListAbilityService;
import com.tydic.uccext.service.UccQryCommodityTypeByMaterialService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_TEST/2.0.0/com.tydic.agreement.ability.AgrCreateAgreementSkuChangeAbilityService"})
public class AgrCreateAgreementSkuChangeAbilityServiceImpl
implements AgrCreateAgreementSkuChangeAbilityService {
    @Autowired
    private AgrCreateAgreementSkuChangeBusiService agrCreateAgreementSkuChangeBusiService;
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgreementSkuMapper agreementSkuMapper;
    @Autowired
    private UccQryCommodityTypeByMaterialService uccQryCommodityTypeByMaterialService;
    @Autowired
    private AgrDicDictionaryAtomService agrDicDictionaryAtomService;
    @Autowired
    private CnncQryCommodityTypeListAbilityService cnncQryCommodityTypeListAbilityService;

    @PostMapping(value={"createAgreementSkuChange"})
    public AgrCreateAgreementSkuChangeAbilityRspBO createAgreementSkuChange(@RequestBody AgrCreateAgreementSkuChangeAbilityReqBO abilityReqBO) {
        AgrCreateAgreementSkuChangeAbilityRspBO rsp = new AgrCreateAgreementSkuChangeAbilityRspBO();
        this.validateParam(abilityReqBO);
        if (null != abilityReqBO.getMajorChangeType() && AgrCommConstant.AgreementChangeType.SUPPLEMENT.toString().equals(abilityReqBO.getMajorChangeType().toString())) {
            AgreementPO agreementPO = new AgreementPO();
            agreementPO.setAgreementId(abilityReqBO.getAgreementId());
            agreementPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
            AgreementPO agreement = this.agreementMapper.getModelBy(agreementPO);
            if (null == agreement) {
                throw new BusinessException("0101", "\u672a\u67e5\u8be2\u5230\u534f\u8bae\u4fe1\u606f");
            }
            if (AgrEnum.RelSystem.ECP.toString().equalsIgnoreCase(agreement.getRelSystem())) {
                for (AgrAgreementSkuChangeBO agrAgreementSkuChangeBO : abilityReqBO.getAgrAgreementSkuChangeBOs()) {
                    if (null != agrAgreementSkuChangeBO.getSupplyCycle() && BigDecimal.ZERO.compareTo(new BigDecimal(agrAgreementSkuChangeBO.getSupplyCycle())) >= 0) {
                        throw new BusinessException("0101", "\u8bf7\u586b\u5199\u5927\u4e8e0\u7684\u6b63\u6574\u6570\uff01");
                    }
                    if (AgrEnum.EcpContractType.GDZJ.getCode().equals(agreement.getEcpContractType()) || Arrays.asList(AgrEnum.Variety.GC.getCode(), AgrEnum.Variety.FW.getCode()).contains(agrAgreementSkuChangeBO.getCatalogVariety()) || null != agrAgreementSkuChangeBO.getSupplyCycle()) continue;
                    throw new BusinessException("0101", "\u4f9b\u8d27\u5468\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
            }
        }
        AgrCreateAgreementSkuChangeBusiReqBO agrCreateAgreementSkuChangeBusiReqBO = new AgrCreateAgreementSkuChangeBusiReqBO();
        BeanUtils.copyProperties((Object)abilityReqBO, (Object)agrCreateAgreementSkuChangeBusiReqBO);
        AgrCreateAgreementSkuChangeBusiRspBO agrCreateAgreementSkuChangeBusiRspBO = this.agrCreateAgreementSkuChangeBusiService.createAgreementSkuChange(agrCreateAgreementSkuChangeBusiReqBO);
        BeanUtils.copyProperties((Object)agrCreateAgreementSkuChangeBusiRspBO, (Object)rsp);
        return rsp;
    }

    @PostMapping(value={"deleteAgreementSkuChange"})
    public AgrCreateAgreementSkuChangeAbilityRspBO deleteAgreementSkuChange(@RequestBody AgrCreateAgreementSkuChangeAbilityReqBO abilityReqBO) {
        if (null == abilityReqBO.getAgreementId()) {
            throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6\u53d8\u66f4\u6e05\u9664API\u5165\u53c2\u3010agreementId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)abilityReqBO.getChangeCode())) {
            throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6\u53d8\u66f4\u6e05\u9664API\u5165\u53c2\u3010changeCode\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        AgrCreateAgreementSkuChangeAbilityRspBO rsp = new AgrCreateAgreementSkuChangeAbilityRspBO();
        AgrCreateAgreementSkuChangeBusiReqBO agrCreateAgreementSkuChangeBusiReqBO = new AgrCreateAgreementSkuChangeBusiReqBO();
        BeanUtils.copyProperties((Object)abilityReqBO, (Object)agrCreateAgreementSkuChangeBusiReqBO);
        AgrCreateAgreementSkuChangeBusiRspBO agrCreateAgreementSkuChangeBusiRspBO = this.agrCreateAgreementSkuChangeBusiService.deleteAgreementSkuChange(agrCreateAgreementSkuChangeBusiReqBO);
        BeanUtils.copyProperties((Object)agrCreateAgreementSkuChangeBusiRspBO, (Object)rsp);
        return rsp;
    }

    private void validateParam(AgrCreateAgreementSkuChangeAbilityReqBO abilityReqBO) {
        if (null == abilityReqBO.getMemIdIn()) {
            throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6\u53d8\u66f4\u65b0\u589eAPI\u5165\u53c2\u3010memIdIn\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == abilityReqBO.getAgreementId()) {
            throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6\u53d8\u66f4\u65b0\u589eAPI\u5165\u53c2\u3010agreementId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)abilityReqBO.getChangeCode())) {
            throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6\u53d8\u66f4\u65b0\u589eAPI\u5165\u53c2\u3010changeCode\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)abilityReqBO.getAgrAgreementSkuChangeBOs())) {
            throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6\u53d8\u66f4\u65b0\u589eAPI\u5165\u53c2\u3010agrAgreementSkuChangeBOs\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        HashSet<Long> typeIds = new HashSet<Long>();
        for (AgrAgreementSkuChangeBO bo : abilityReqBO.getAgrAgreementSkuChangeBOs()) {
            Object buyNumber;
            if (null == bo.getChangeType()) {
                throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6\u53d8\u66f4\u65b0\u589eAPI\u5165\u53c2\u3010agrAgreementSkuChangeBOs.changeType\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)bo.getCatalogId())) {
                typeIds.add(Long.parseLong(bo.getCatalogId()));
            }
            if (bo.getCatalogVariety() != null && Objects.equals(AgrEnum.Variety.WZ.getCode(), bo.getCatalogVariety()) && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)bo.getProducingArea())) {
                throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6\u4e3a\u7269\u8d44\u7c7b\uff0c\u7269\u8d44\u4ea7\u5730\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null != abilityReqBO.getMajorChangeType() && Arrays.asList(AgrCommConstant.AgreementChangeType.ECP_MATERIAL_CHANGE.toString(), AgrCommConstant.AgreementChangeType.OPS_MATERIAL_CHANGE.toString()).contains(abilityReqBO.getMajorChangeType().toString())) {
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)bo.getMaterialId())) {
                    bo.setMaterialUnitOfMeasureScale(Integer.valueOf(1));
                    bo.setUnitOfMeasureScale(Integer.valueOf(1));
                    continue;
                }
                if (bo.getAgreementSkuId() == null) continue;
                AgreementSkuPO skuPO = new AgreementSkuPO();
                skuPO.setAgreementSkuId(bo.getAgreementSkuId());
                skuPO = this.agreementSkuMapper.getModelBy(skuPO);
                bo.setProducingArea(skuPO.getProducingArea());
                bo.setTaxRate(skuPO.getTaxRate());
                bo.setMeasureName(skuPO.getMeasureName());
                if (Objects.equals(bo.getMaterialMeasureName(), skuPO.getMeasureName())) {
                    bo.setMaterialUnitOfMeasureScale(Integer.valueOf(1));
                    bo.setUnitOfMeasureScale(Integer.valueOf(1));
                    continue;
                }
                if (null == bo.getUnitOfMeasureScale() || null == bo.getMaterialUnitOfMeasureScale()) {
                    throw new BusinessException("0002", "\u8ba1\u91cf\u5355\u4f4d\u4e0e\u7269\u8d44\u7f16\u7801\u8ba1\u91cf\u5355\u4f4d\u4e0d\u4e00\u81f4\uff0c\u8ba1\u91cf\u5355\u4f4d\u6bd4\u4f8b/\u7269\u8d44\u7f16\u7801\u8ba1\u91cf\u5355\u4f4d\u6bd4\u4f8b\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (bo.getUnitOfMeasureScale() <= 0 || bo.getMaterialUnitOfMeasureScale() <= 0) {
                    throw new BusinessException("0002", "\u8ba1\u91cf\u5355\u4f4d\u6bd4\u4f8b/\u7269\u8d44\u7f16\u7801\u8ba1\u91cf\u5355\u4f4d\u6bd4\u4f8b\u53ea\u53ef\u5f55\u5165\u5927\u4e8e0\u6b63\u6574\u6570");
                }
                String conversionScale = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "MEASURE_CONVERSION_RELATIONSHIPS", bo.getMeasureName() + ":" + bo.getMaterialMeasureName());
                if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)conversionScale)) continue;
                String[] split = conversionScale.split(":");
                if (split.length == 2) {
                    bo.setUnitOfMeasureScale(Integer.valueOf(split[0]));
                    bo.setMaterialUnitOfMeasureScale(Integer.valueOf(split[1]));
                    continue;
                }
                throw new BusinessException("0001", "\u8ba1\u91cf\u5355\u4f4d\u8f6c\u6362\u6bd4\u4f8b\u914d\u7f6e\u9519\u8bef");
            }
            if (AgrCommConstant.AgreementSkuChangeType.ADD.equals(bo.getChangeType())) {
                if (null == bo.getBuyNumber()) {
                    throw new BusinessException("0001", "\u6570\u91cf\u3010buyNumber\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (null == bo.getBuyPrice()) {
                    throw new BusinessException("0001", "\u91c7\u8d2d\u5355\u4ef7\u3010buyPrice\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (bo.getBuyPrice() <= 0L) {
                    throw new BusinessException("0001", "\u91c7\u8d2d\u5355\u4ef7\u5fc5\u987b\u5927\u4e8e0\uff01");
                }
                if (null == bo.getBuyPriceSum()) {
                    throw new BusinessException("0001", "\u91c7\u8d2d\u603b\u4ef7\u3010buyPriceSum\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (null == bo.getMarkupRate()) {
                    bo.setMarkupRate(Double.valueOf(0.0));
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)bo.getMarkupValue())) {
                    bo.setMarkupValue("0");
                }
                if (null == bo.getItemSource()) {
                    bo.setItemSource(AgrEnum.ItemSource.FROM_AGREEMENT.getType());
                }
                if (null == bo.getContractCovered() && Objects.equals(AgrEnum.ItemSource.FROM_AGREEMENT.getType(), bo.getItemSource())) {
                    bo.setContractCovered(Integer.valueOf(AgrEnum.YesOrNo.YES.getCode().byteValue()));
                }
                if (!StringUtils.hasText((String)bo.getMaterialId())) {
                    throw new BusinessException("0001", "\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                }
            } else if (AgrCommConstant.AgreementSkuChangeType.UPDATE.equals(bo.getChangeType())) {
                if (bo.getAgreementSkuId() == null) {
                    throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6ID\u3010agreementSkuId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (null == bo.getBuyPrice()) {
                    throw new BusinessException("0001", "\u91c7\u8d2d\u5355\u4ef7\u3010buyPrice\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (bo.getBuyPrice() <= 0L) {
                    throw new BusinessException("0001", "\u91c7\u8d2d\u5355\u4ef7\u5fc5\u987b\u5927\u4e8e0\uff01");
                }
                if (null == bo.getBuyPriceSum()) {
                    throw new BusinessException("0001", "\u91c7\u8d2d\u603b\u4ef7\u3010buyPriceSum\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (null == bo.getMarkupRate()) {
                    bo.setMarkupRate(Double.valueOf(0.0));
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)bo.getMarkupValue())) {
                    bo.setMarkupValue("0");
                }
            } else if (AgrCommConstant.AgreementSkuChangeType.DELETE.equals(bo.getChangeType())) {
                if (bo.getAgreementSkuId() == null) {
                    throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6ID\u3010agreementSkuId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
            } else {
                throw new BusinessException("0001", "\u64cd\u4f5c\u7c7b\u578b\u3010" + bo.getChangeType() + "\u3011\u4e0d\u652f\u6301");
            }
            if (!AgrCommConstant.AgreementSkuChangeType.DELETE.equals(bo.getChangeType())) {
                buyNumber = bo.getBuyNumber();
                if (StringUtils.hasText((String)bo.getExtField1()) && StringUtils.hasText((String)bo.getExtField2())) {
                    BigDecimal orderedQuantity = BigDecimal.ZERO;
                    if (bo.getAgreementSkuId() != null) {
                        AgreementSkuPO skuPO = new AgreementSkuPO();
                        skuPO.setAgreementSkuId(bo.getAgreementSkuId());
                        skuPO = this.agreementSkuMapper.getModelBy(skuPO);
                        if (skuPO.getOrderedQuantity() != null) {
                            orderedQuantity = skuPO.getOrderedQuantity();
                        }
                    }
                    buyNumber = new BigDecimal(bo.getExtField1()).add(orderedQuantity);
                }
                bo.setBuyPriceSum(Long.valueOf(new BigDecimal(bo.getBuyPrice()).multiply((BigDecimal)buyNumber).longValue()));
                bo.setSalePrice(Long.valueOf(new BigDecimal(bo.getBuyPrice()).add(new BigDecimal(bo.getBuyPrice()).multiply(new BigDecimal(bo.getMarkupRate().toString())).divide(new BigDecimal("100"), 8, RoundingMode.HALF_UP)).longValue()));
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)bo.getMarkupValue())) {
                    bo.setSalePrice(Long.valueOf(bo.getSalePrice() + new BigDecimal(bo.getMarkupValue()).multiply(new BigDecimal("10000")).longValue()));
                }
                bo.setSalePriceSum(Long.valueOf(new BigDecimal(bo.getSalePrice()).multiply((BigDecimal)buyNumber).longValue()));
            }
            if (((String)(buyNumber = bo.getBuyNumber().toPlainString())).contains(".")) {
                if (((String)buyNumber).length() - 1 - ((String)buyNumber).indexOf(".") > 6) {
                    throw new BusinessException("0001", "\u5546\u54c1\u6570\u91cf\u53ea\u652f\u63016\u4f4d\u5c0f\u6570\uff01");
                }
                if (((String)buyNumber).indexOf(".") > 12) {
                    throw new BusinessException("0001", "\u5546\u54c1\u6570\u91cf\u6574\u6570\u4f4d\u53ea\u652f\u630112\u4f4d\uff01");
                }
            } else if (((String)buyNumber).length() > 12) {
                throw new BusinessException("0001", "\u5546\u54c1\u6570\u91cf\u6574\u6570\u4f4d\u53ea\u652f\u630112\u4f4d\uff01");
            }
            if (bo.getBuyPriceSum().toString().length() > 18) {
                throw new BusinessException("0001", "\u603b\u4ef7\u6574\u6570\u4f4d\u53ea\u652f\u630114\u4f4d\uff0c\u8bf7\u6839\u636e\u5355\u4ef7\u8c03\u6574\u6570\u91cf\uff01");
            }
            if (bo.getSalePriceSum().toString().length() > 18) {
                throw new BusinessException("0001", "\u603b\u4ef7\u6574\u6570\u4f4d\u53ea\u652f\u630114\u4f4d\uff0c\u8bf7\u6839\u636e\u5355\u4ef7\u8c03\u6574\u6570\u91cf\uff01");
            }
            if (null == abilityReqBO.getMajorChangeType() || !AgrCommConstant.AgreementChangeType.SUPPLEMENT.toString().equals(abilityReqBO.getMajorChangeType().toString())) continue;
            bo.setMaterialMeasureName(bo.getMeasureName());
            bo.setMaterialUnitOfMeasureScale(Integer.valueOf(1));
            bo.setUnitOfMeasureScale(Integer.valueOf(1));
        }
        if (!CollectionUtils.isEmpty(typeIds)) {
            CnncQryCommodityTypeListAbilityReqBo cnncQryCommodityTypeListAbilityReqBo = new CnncQryCommodityTypeListAbilityReqBo();
            cnncQryCommodityTypeListAbilityReqBo.setCommodityTypeIds(new ArrayList(typeIds));
            cnncQryCommodityTypeListAbilityReqBo.setQueryHaveSku(Boolean.valueOf(false));
            cnncQryCommodityTypeListAbilityReqBo.setPageSize(-1);
            cnncQryCommodityTypeListAbilityReqBo.setPageNo(-1);
            cnncQryCommodityTypeListAbilityReqBo.setCommodityTypeStatus(Integer.valueOf(0));
            CnncQryCommodityTypeListAbilityRspBo commodityTypeListAbilityRspBo = this.cnncQryCommodityTypeListAbilityService.qryCommodityTypeList(cnncQryCommodityTypeListAbilityReqBo);
            if (!"0000".equals(commodityTypeListAbilityRspBo.getRespCode())) {
                throw new BusinessException("8888", commodityTypeListAbilityRspBo.getRespDesc());
            }
            if (!CollectionUtils.isEmpty((Collection)commodityTypeListAbilityRspBo.getRows()) && !CollectionUtils.isEmpty((Collection)commodityTypeListAbilityRspBo.getRows())) {
                List commodityTypeListAbilityBos = JSONArray.parseArray((String)JSONObject.toJSONString((Object)commodityTypeListAbilityRspBo.getRows()), CnncQryCommodityTypeListAbilityBo.class);
                StringJoiner sj = new StringJoiner(",");
                commodityTypeListAbilityBos.forEach(type -> sj.add("[" + type.getCommodityTypeId() + " " + type.getCommodityTypeName() + "]"));
                throw new BusinessException("8888", "\u5b58\u5728\u4ee5\u4e0b\u505c\u7528\u7684\u56db\u7ea7\u5206\u7c7b,\u8bf7\u4fee\u6b63\u540e\u518d\u91cd\u65b0\u63d0\u4ea4\uff1a" + sj);
            }
        }
    }
}

