/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.ability.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.agreement.ability.AgrJudgeIsProjectDispatchAbilityService;
import com.tydic.agreement.ability.bo.AgrJudgeIsProjectDispatchAbilityServiceReqBO;
import com.tydic.agreement.ability.bo.AgrJudgeIsProjectDispatchAbilityServiceRspBO;
import com.tydic.agreement.ability.bo.AgrJudgeIsProjectDispatchBO;
import com.tydic.agreement.common.bo.AgrSimpleAgreementBO;
import com.tydic.agreement.constant.AgrCommConstant;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.ProjectDispatchConfigMapper;
import com.tydic.agreement.dao.po.ProjectDispatchConfigPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_TEST/2.0.0/com.tydic.agreement.ability.AgrJudgeIsProjectDispatchAbilityService"})
public class AgrJudgeIsProjectDispatchAbilityServiceImpl
implements AgrJudgeIsProjectDispatchAbilityService {
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private ProjectDispatchConfigMapper projectDispatchConfigMapper;

    @PostMapping(value={"judgeIsProjectDispatch"})
    public AgrJudgeIsProjectDispatchAbilityServiceRspBO judgeIsProjectDispatch(@RequestBody AgrJudgeIsProjectDispatchAbilityServiceReqBO reqBO) {
        this.checkParams(reqBO);
        AgrJudgeIsProjectDispatchAbilityServiceRspBO rspBO = new AgrJudgeIsProjectDispatchAbilityServiceRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        List<AgrSimpleAgreementBO> projectCodeList = this.agreementMapper.getProjectCodeList(reqBO.getAgrIds());
        if (CollectionUtils.isEmpty(projectCodeList)) {
            rspBO.setAgrJudgeIsProjectDispatchBOS(new ArrayList());
            return rspBO;
        }
        List<String> projectCodes = projectCodeList.stream().map(AgrSimpleAgreementBO::getEcpProjectCode).collect(Collectors.toList());
        ProjectDispatchConfigPO projectDispatchConfigPO = new ProjectDispatchConfigPO();
        projectDispatchConfigPO.setProjectCodeIn(projectCodes);
        projectDispatchConfigPO.setState(AgrCommConstant.DISPATCH_STATE.EFFECT);
        List<ProjectDispatchConfigPO> dispatchConfigPOS = this.projectDispatchConfigMapper.getList(projectDispatchConfigPO);
        if (CollectionUtils.isEmpty(projectCodeList)) {
            rspBO.setAgrJudgeIsProjectDispatchBOS(new ArrayList());
            return rspBO;
        }
        Map<String, ProjectDispatchConfigPO> projectCodeMap = dispatchConfigPOS.stream().collect(Collectors.toMap(ProjectDispatchConfigPO::getProjectCode, obj -> obj, (a, b) -> a));
        ArrayList agrJudgeIsProjectDispatchBOS = new ArrayList();
        projectCodeList.forEach(po -> {
            AgrJudgeIsProjectDispatchBO agrJudgeIsProjectDispatchBO = new AgrJudgeIsProjectDispatchBO();
            agrJudgeIsProjectDispatchBO.setAgrId(po.getAgreementId());
            agrJudgeIsProjectDispatchBO.setWhetherDispatchProject(Boolean.valueOf(projectCodeMap.get(po.getEcpProjectCode()) != null));
            agrJudgeIsProjectDispatchBOS.add(agrJudgeIsProjectDispatchBO);
        });
        rspBO.setAgrJudgeIsProjectDispatchBOS(agrJudgeIsProjectDispatchBOS);
        return rspBO;
    }

    private void checkParams(AgrJudgeIsProjectDispatchAbilityServiceReqBO reqBO) {
        if (reqBO == null) {
            throw new BusinessException("8888", "\u5224\u65ad\u534f\u8bae\u662f\u5426\u6d3e\u5355\u9879\u76ee\u5165\u53c2\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getAgrIds())) {
            throw new BusinessException("8888", "\u5224\u65ad\u534f\u8bae\u662f\u5426\u6d3e\u5355\u9879\u76ee\u534f\u8baeID\u5217\u8868\u5165\u53c2\u4e3a\u7a7a");
        }
    }
}

