/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.ability.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.agreement.ability.AgrBindStandardSpuCheckAbilityService;
import com.tydic.agreement.ability.AgrModifyAgreementSkuAbilityService;
import com.tydic.agreement.ability.bo.AgrBindStandardSpuCheckAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrBindStandardSpuCheckAbilityRspBO;
import com.tydic.agreement.ability.bo.AgrModifyAgreementSkuAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrModifyAgreementSkuAbilityRspBO;
import com.tydic.agreement.atom.AgrDicDictionaryAtomService;
import com.tydic.agreement.busi.AgrModifyAgreementSkuBusiService;
import com.tydic.agreement.busi.bo.AgrModifyAgreementSkuBusiReqBO;
import com.tydic.agreement.busi.bo.AgrModifyAgreementSkuBusiRspBO;
import com.tydic.agreement.common.bo.AgrAgreementSkuBO;
import com.tydic.agreement.constant.AgrEnum;
import com.tydic.uccext.bo.CnncQryCommodityTypeListAbilityBo;
import com.tydic.uccext.bo.CnncQryCommodityTypeListAbilityReqBo;
import com.tydic.uccext.bo.CnncQryCommodityTypeListAbilityRspBo;
import com.tydic.uccext.service.CnncQryCommodityTypeListAbilityService;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_TEST/2.0.0/com.tydic.agreement.ability.AgrModifyAgreementSkuAbilityService"})
public class AgrModifyAgreementSkuAbilityServiceImpl
implements AgrModifyAgreementSkuAbilityService {
    @Autowired
    private AgrModifyAgreementSkuBusiService agrModifyAgreementSkuBusiService;
    @Autowired
    private AgrDicDictionaryAtomService agrDicDictionaryAtomService;
    @Autowired
    private AgrBindStandardSpuCheckAbilityService agrBindStandardSpuCheckAbilityService;
    @Autowired
    private CnncQryCommodityTypeListAbilityService cnncQryCommodityTypeListAbilityService;

    @PostMapping(value={"modifyAgreementSku"})
    public AgrModifyAgreementSkuAbilityRspBO modifyAgreementSku(@RequestBody AgrModifyAgreementSkuAbilityReqBO abilityReqBO) {
        AgrModifyAgreementSkuAbilityRspBO rsp = new AgrModifyAgreementSkuAbilityRspBO();
        this.validateParam(abilityReqBO);
        AgrModifyAgreementSkuBusiReqBO agrModifyAgreementSkuBusiReqBO = new AgrModifyAgreementSkuBusiReqBO();
        BeanUtils.copyProperties((Object)abilityReqBO, (Object)agrModifyAgreementSkuBusiReqBO);
        AgrModifyAgreementSkuBusiRspBO agrModifyAgreementSkuBusiRspBO = this.agrModifyAgreementSkuBusiService.modifyAgreementSku(agrModifyAgreementSkuBusiReqBO);
        BeanUtils.copyProperties((Object)agrModifyAgreementSkuBusiRspBO, (Object)rsp);
        return rsp;
    }

    private void validateParam(AgrModifyAgreementSkuAbilityReqBO abilityReqBO) {
        if (null == abilityReqBO.getMemIdIn()) {
            throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6\u4fee\u6539API\u5165\u53c2\u3010memIdIn\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == abilityReqBO.getAgrAgreementSkuBO()) {
            throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6\u4fee\u6539API\u5165\u53c2\u3010agrAgreementSkuBO\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == abilityReqBO.getAgrAgreementSkuBO().getAgreementId()) {
            throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6\u4fee\u6539API\u5165\u53c2\u3010agrAgreementSkuBO.agreementId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (abilityReqBO.getAgrAgreementSkuBO().getCatalogVariety() != null && Objects.equals(AgrEnum.Variety.WZ.getCode(), abilityReqBO.getAgrAgreementSkuBO().getCatalogVariety()) && !StringUtils.hasText((String)abilityReqBO.getAgrAgreementSkuBO().getProducingArea())) {
            throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6\u4e3a\u7269\u8d44\u7c7b\uff0c\u7269\u8d44\u4ea7\u5730\u4e0d\u80fd\u4e3a\u7a7a");
        }
        AgrAgreementSkuBO bo = abilityReqBO.getAgrAgreementSkuBO();
        if (null != bo.getBuyNumber()) {
            String buyNumber = bo.getBuyNumber().toPlainString();
            if (buyNumber.contains(".")) {
                if (buyNumber.length() - 1 - buyNumber.indexOf(".") > 6) {
                    throw new BusinessException("0001", "\u5546\u54c1\u6570\u91cf\u53ea\u652f\u63016\u4f4d\u5c0f\u6570");
                }
                if (buyNumber.indexOf(".") > 12) {
                    throw new BusinessException("0001", "\u5546\u54c1\u6570\u91cf\u6574\u6570\u4f4d\u53ea\u652f\u630112\u4f4d");
                }
            } else if (buyNumber.length() > 12) {
                throw new BusinessException("0001", "\u5546\u54c1\u6570\u91cf\u6574\u6570\u4f4d\u53ea\u652f\u630112\u4f4d");
            }
            if (null != bo.getBuyPrice()) {
                Long salePriceSum;
                Long buyPriceSum;
                if (null == bo.getMarkupRate()) {
                    bo.setMarkupRate(Double.valueOf(0.0));
                }
                if ((buyPriceSum = Long.valueOf(new BigDecimal(bo.getBuyPrice()).multiply(bo.getBuyNumber()).longValue())).toString().length() > 18) {
                    throw new BusinessException("0001", "\u603b\u4ef7\u6574\u6570\u4f4d\u53ea\u652f\u630114\u4f4d\uff0c\u8bf7\u6839\u636e\u5355\u4ef7\u8c03\u6574\u6570\u91cf");
                }
                Long salePrice = new BigDecimal(bo.getBuyPrice()).add(new BigDecimal(bo.getBuyPrice()).multiply(new BigDecimal(bo.getMarkupRate()))).divide(new BigDecimal("100")).longValue();
                if (StringUtils.hasText((String)bo.getMarkupValue())) {
                    salePrice = salePrice + new BigDecimal(bo.getMarkupValue()).multiply(new BigDecimal("10000")).longValue();
                }
                if ((salePriceSum = Long.valueOf(new BigDecimal(salePrice).multiply(bo.getBuyNumber()).longValue())).toString().length() > 18) {
                    throw new BusinessException("0001", "\u603b\u4ef7\u6574\u6570\u4f4d\u53ea\u652f\u630114\u4f4d\uff0c\u8bf7\u6839\u636e\u5355\u4ef7\u8c03\u6574\u6570\u91cf");
                }
            }
        }
        if (!StringUtils.hasText((String)bo.getMaterialId())) {
            bo.setMaterialUnitOfMeasureScale(Integer.valueOf(1));
            bo.setUnitOfMeasureScale(Integer.valueOf(1));
        } else if (StringUtils.hasText((String)bo.getMeasureName()) && StringUtils.hasText((String)bo.getMaterialMeasureName())) {
            if (bo.getMeasureName().equals(bo.getMaterialMeasureName())) {
                bo.setMaterialUnitOfMeasureScale(Integer.valueOf(1));
                bo.setUnitOfMeasureScale(Integer.valueOf(1));
            } else {
                if (null == bo.getUnitOfMeasureScale() || null == bo.getMaterialUnitOfMeasureScale()) {
                    throw new BusinessException("0002", "\u8ba1\u91cf\u5355\u4f4d\u4e0e\u7269\u8d44\u7f16\u7801\u8ba1\u91cf\u5355\u4f4d\u4e0d\u4e00\u81f4\uff0c\u8ba1\u91cf\u5355\u4f4d\u6bd4\u4f8b/\u7269\u8d44\u7f16\u7801\u8ba1\u91cf\u5355\u4f4d\u6bd4\u4f8b\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (bo.getUnitOfMeasureScale() <= 0 || bo.getMaterialUnitOfMeasureScale() <= 0) {
                    throw new BusinessException("0002", "\u8ba1\u91cf\u5355\u4f4d\u6bd4\u4f8b/\u7269\u8d44\u7f16\u7801\u8ba1\u91cf\u5355\u4f4d\u6bd4\u4f8b\u53ea\u53ef\u5f55\u5165\u5927\u4e8e0\u6b63\u6574\u6570");
                }
                String conversionScale = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "MEASURE_CONVERSION_RELATIONSHIPS", bo.getMeasureName() + ":" + bo.getMaterialMeasureName());
                if (StringUtils.hasText((String)conversionScale)) {
                    String[] split = conversionScale.split(":");
                    if (split.length == 2) {
                        bo.setUnitOfMeasureScale(Integer.valueOf(split[0]));
                        bo.setMaterialUnitOfMeasureScale(Integer.valueOf(split[1]));
                    } else {
                        throw new BusinessException("0001", "\u8ba1\u91cf\u5355\u4f4d\u8f6c\u6362\u6bd4\u4f8b\u914d\u7f6e\u9519\u8bef");
                    }
                }
            }
        }
        if (StringUtils.hasText((String)bo.getSpuId())) {
            AgrBindStandardSpuCheckAbilityReqBO agrBindStandardSpuCheckAbilityReqBO = new AgrBindStandardSpuCheckAbilityReqBO();
            agrBindStandardSpuCheckAbilityReqBO.setSpuId(bo.getSpuId());
            agrBindStandardSpuCheckAbilityReqBO.setAgreementSkuId(bo.getAgreementSkuId());
            agrBindStandardSpuCheckAbilityReqBO.setAgreementId(bo.getAgreementId());
            agrBindStandardSpuCheckAbilityReqBO.setMeasureName(bo.getMeasureName());
            agrBindStandardSpuCheckAbilityReqBO.setMaterialMeasureName(bo.getMaterialMeasureName());
            agrBindStandardSpuCheckAbilityReqBO.setUnitOfMeasureScale(bo.getUnitOfMeasureScale());
            agrBindStandardSpuCheckAbilityReqBO.setMaterialUnitOfMeasureScale(bo.getMaterialUnitOfMeasureScale());
            agrBindStandardSpuCheckAbilityReqBO.setModifyAgrSkuFlag(Boolean.valueOf(true));
            AgrBindStandardSpuCheckAbilityRspBO agrBindStandardSpuCheckAbilityRspBO = this.agrBindStandardSpuCheckAbilityService.dealBindSpuCheck(agrBindStandardSpuCheckAbilityReqBO);
            if ("0000".equals(agrBindStandardSpuCheckAbilityRspBO.getRespCode())) {
                if (StringUtils.hasText((String)agrBindStandardSpuCheckAbilityRspBO.getCheckSpuBindSameProjectResult())) {
                    throw new BusinessException("8888", agrBindStandardSpuCheckAbilityRspBO.getCheckSpuBindSameProjectResult());
                }
                if (StringUtils.hasText((String)agrBindStandardSpuCheckAbilityRspBO.getCheckDiffSkuResult())) {
                    throw new BusinessException("8888", agrBindStandardSpuCheckAbilityRspBO.getCheckDiffSkuResult());
                }
                if (StringUtils.hasText((String)agrBindStandardSpuCheckAbilityRspBO.getSubmitDiffSkuResult())) {
                    throw new BusinessException("8888", agrBindStandardSpuCheckAbilityRspBO.getSubmitDiffSkuResult());
                }
            }
        }
        if (StringUtils.hasText((String)abilityReqBO.getAgrAgreementSkuBO().getCatalogId())) {
            CnncQryCommodityTypeListAbilityReqBo abilityReqBo = new CnncQryCommodityTypeListAbilityReqBo();
            abilityReqBo.setCommodityTypeId(Long.valueOf(abilityReqBO.getAgrAgreementSkuBO().getCatalogId()));
            abilityReqBo.setQueryHaveSku(Boolean.valueOf(false));
            abilityReqBo.setCommodityTypeStatus(Integer.valueOf(0));
            abilityReqBo.setPageSize(-1);
            abilityReqBo.setPageNo(-1);
            CnncQryCommodityTypeListAbilityRspBo abilityRspBo = this.cnncQryCommodityTypeListAbilityService.qryCommodityTypeList(abilityReqBo);
            if (!"0000".equals(abilityRspBo.getRespCode())) {
                throw new ZTBusinessException(abilityRspBo.getRespDesc());
            }
            if (!CollectionUtils.isEmpty((Collection)abilityRspBo.getRows())) {
                List commodityTypeListAbilityBos = JSONArray.parseArray((String)JSONObject.toJSONString((Object)abilityRspBo.getRows()), CnncQryCommodityTypeListAbilityBo.class);
                StringJoiner sj = new StringJoiner(",");
                commodityTypeListAbilityBos.forEach(type -> sj.add("[" + type.getCommodityTypeId() + " " + type.getCommodityTypeName() + "]"));
                throw new ZTBusinessException("\u5b58\u5728\u4ee5\u4e0b\u505c\u7528\u7684\u56db\u7ea7\u5206\u7c7b,\u8bf7\u4fee\u6b63\u540e\u518d\u91cd\u65b0\u63d0\u4ea4\uff1a" + sj);
            }
        }
    }
}

