/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.agreement.ability.AgrModifyDispatchInfoAbilityService;
import com.tydic.agreement.ability.bo.AgrModifyDispatchInfoAbilityServiceReqBO;
import com.tydic.agreement.ability.bo.AgrModifyDispatchInfoAbilityServiceRspBO;
import com.tydic.agreement.busi.AgrModifyDispatchInfoBusiService;
import com.tydic.agreement.busi.bo.AgrModifyDispatchInfoAbilityRspBO;
import com.tydic.agreement.busi.bo.AgrModifyDispatchInfoServiceReqBO;
import com.tydic.agreement.common.bo.AgrProjectDispatchConfigBO;
import com.tydic.agreement.common.bo.AgrProjectDispatchItemConfigBO;
import com.tydic.agreement.constant.AgrCommConstant;
import com.tydic.agreement.dao.ProjectDispatchConfigChangeMapper;
import com.tydic.agreement.dao.ProjectDispatchItemConfigChangeMapper;
import com.tydic.agreement.dao.ProjectDispatchItemConfigMapper;
import com.tydic.agreement.dao.po.ProjectDispatchConfigChangePO;
import com.tydic.agreement.dao.po.ProjectDispatchItemConfigChangePO;
import com.tydic.agreement.dao.po.ProjectDispatchItemConfigPO;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_TEST/2.0.0/com.tydic.agreement.ability.AgrModifyDispatchInfoAbilityService"})
public class AgrModifyDispatchInfoAbilityServiceImpl
implements AgrModifyDispatchInfoAbilityService {
    private static final Logger log = LoggerFactory.getLogger(AgrModifyDispatchInfoAbilityServiceImpl.class);
    @Autowired
    private CacheClient cacheService;
    @Autowired
    private ProjectDispatchConfigChangeMapper projectDispatchConfigChangeMapper;
    @Autowired
    private ProjectDispatchItemConfigChangeMapper projectDispatchItemConfigChangeMapper;
    @Autowired
    private ProjectDispatchItemConfigMapper projectDispatchItemConfigMapper;
    @Autowired
    private AgrModifyDispatchInfoBusiService agrModifyDispatchInfoBusiService;

    @PostMapping(value={"modifyDispatch"})
    public AgrModifyDispatchInfoAbilityServiceRspBO modifyDispatch(@RequestBody AgrModifyDispatchInfoAbilityServiceReqBO reqBO) {
        this.duplicateCommitList(reqBO);
        this.checkReqParams(reqBO);
        if (!CollectionUtils.isEmpty((Collection)reqBO.getProjectDispatchItemConfigBOS())) {
            this.checkWhetherExecutionCompleted(reqBO.getProjectDispatchConfigBO().getProjectCode());
        }
        this.checkWhetherAlreadyChangeInfo(reqBO.getProjectDispatchConfigBO().getProjectCode());
        AgrModifyDispatchInfoServiceReqBO modifyDispatchInfoServiceReqBO = new AgrModifyDispatchInfoServiceReqBO();
        AgrProjectDispatchConfigBO projectDispatchConfigBO = new AgrProjectDispatchConfigBO();
        BeanUtils.copyProperties((Object)reqBO.getProjectDispatchConfigBO(), (Object)projectDispatchConfigBO);
        modifyDispatchInfoServiceReqBO.setProjectDispatchConfigBO(projectDispatchConfigBO);
        if (!CollectionUtils.isEmpty((Collection)reqBO.getProjectDispatchItemConfigBOS())) {
            ArrayList projectDispatchItemConfigBOS = new ArrayList();
            reqBO.getProjectDispatchItemConfigBOS().forEach(bo -> {
                AgrProjectDispatchItemConfigBO projectDispatchItemConfigBO = new AgrProjectDispatchItemConfigBO();
                BeanUtils.copyProperties((Object)bo, (Object)projectDispatchItemConfigBO);
                projectDispatchItemConfigBOS.add(projectDispatchItemConfigBO);
            });
            modifyDispatchInfoServiceReqBO.setProjectDispatchItemConfigBOS(projectDispatchItemConfigBOS);
        }
        AgrModifyDispatchInfoAbilityRspBO modifyDispatchInfoAbilityRspBO = this.agrModifyDispatchInfoBusiService.modifyDispatch(modifyDispatchInfoServiceReqBO);
        AgrModifyDispatchInfoAbilityServiceRspBO rspBO = new AgrModifyDispatchInfoAbilityServiceRspBO();
        rspBO.setRespCode(modifyDispatchInfoAbilityRspBO.getRespCode());
        rspBO.setRespDesc(modifyDispatchInfoAbilityRspBO.getRespDesc());
        return rspBO;
    }

    private void checkWhetherExecutionCompleted(String projectCode) {
        ProjectDispatchItemConfigPO itemConfigPO = new ProjectDispatchItemConfigPO();
        itemConfigPO.setProjectCode(projectCode);
        itemConfigPO.setWhetherExecutionCompleted(AgrCommConstant.PROJECT_ROUNDS_EXECUTE.IN_EXECUTION);
        int checkBy = this.projectDispatchItemConfigMapper.getCheckBy(itemConfigPO);
        if (checkBy > 0) {
            throw new BusinessException("8888", "\u5f53\u524d\u9879\u76ee\u8fd8\u6709\u672a\u6d3e\u5355\u5b8c\u6210\u7684\u8f6e\u6b21\uff01\u8bf7\u5148\u6d3e\u5b8c\u5355\u540e\u5728\u65b0\u589e\u8f6e\u6b21");
        }
    }

    private void checkWhetherAlreadyChangeInfo(String projectCode) {
        ProjectDispatchConfigChangePO dispatchConfigChangePO = new ProjectDispatchConfigChangePO();
        dispatchConfigChangePO.setProjectCode(projectCode);
        int checkDispatchChangeBy = this.projectDispatchConfigChangeMapper.getCheckBy(dispatchConfigChangePO);
        if (checkDispatchChangeBy > 0) {
            throw new BusinessException("8888", "\u5f53\u524d\u9879\u76ee\u5df2\u5b58\u5728\u53d8\u66f4\u4fe1\u606f\uff0c\u8bf7\u5148\u5904\u7406\u5b8c\u540e\u5728\u8fdb\u884c\u53d8\u66f4");
        }
        ProjectDispatchItemConfigChangePO dispatchItemConfigChangePO = new ProjectDispatchItemConfigChangePO();
        dispatchItemConfigChangePO.setProjectCode(projectCode);
        int checkDispatchItemChangeBy = this.projectDispatchItemConfigChangeMapper.getCheckBy(dispatchItemConfigChangePO);
        if (checkDispatchItemChangeBy > 0) {
            throw new BusinessException("8888", "\u5f53\u524d\u9879\u76ee\u5df2\u5b58\u5728\u8f6e\u6b21\u53d8\u66f4\u4fe1\u606f\uff0c\u8bf7\u5148\u5904\u7406\u5b8c\u540e\u5728\u8fdb\u884c\u53d8\u66f4");
        }
    }

    private void duplicateCommitList(AgrModifyDispatchInfoAbilityServiceReqBO reqBO) {
        String reqMd;
        String modfiyDispatchInfoString = JSON.toJSONString((Object)reqBO);
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            reqMd = Hex.encodeHexString((byte[])md.digest(modfiyDispatchInfoString.getBytes(StandardCharsets.UTF_8)));
        }
        catch (NoSuchAlgorithmException e) {
            reqMd = reqBO.getUserId() + "agrAddDispatchInfoAbilityService";
        }
        Object o = null;
        try {
            o = this.cacheService.get(reqMd);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u6d3e\u5355\u9879\u76ee\u5e42\u7b49\u6821\u9a8c\u5931\u8d25\uff1a", (Throwable)e);
            reqMd = null;
        }
        if (null != o) {
            throw new BusinessException("0100", "\u64cd\u4f5c\u592a\u9891\u7e41\uff0c\u8bf710\u79d2\u540e\u91cd\u8bd5\uff01");
        }
        if (null != reqMd) {
            try {
                this.cacheService.set(reqMd, (Object)"", 10);
            }
            catch (Exception e) {
                log.error("\u4fee\u6539\u6d3e\u5355\u9879\u76ee\u589e\u52a0\u5e42\u7b49\u63a7\u5236\u5931\u8d25\uff1a", (Throwable)e);
            }
        }
    }

    private void checkReqParams(AgrModifyDispatchInfoAbilityServiceReqBO reqBO) {
        if (reqBO == null) {
            throw new BusinessException("8888", "\u4fee\u6539\u6d3e\u5355\u89c4\u5219\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getProjectDispatchConfigBO() == null) {
            throw new BusinessException("8888", "\u4fee\u6539\u6d3e\u5355\u89c4\u5219\u65f6\u4e3b\u4f53\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!StringUtils.hasText((String)reqBO.getProjectDispatchConfigBO().getProjectCode())) {
            throw new BusinessException("8888", "\u4fee\u6539\u6d3e\u5355\u89c4\u5219\u65f6[\u9879\u76ee\u7f16\u53f7]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!StringUtils.hasText((String)reqBO.getProjectDispatchConfigBO().getProjectName())) {
            throw new BusinessException("8888", "\u4fee\u6539\u6d3e\u5355\u89c4\u5219\u65f6[\u9879\u76ee\u540d\u79f0]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getProjectDispatchConfigBO().getUseSelectState() == null) {
            throw new BusinessException("8888", "\u4fee\u6539\u6d3e\u5355\u89c4\u5219\u65f6[\u6d3e\u5355\u89c4\u5219\u72b6\u6001]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getProjectDispatchConfigBO().getProjectHandlerId() == null || reqBO.getProjectDispatchConfigBO().getProjectHandlerId() == 0L) {
            throw new BusinessException("8888", "\u4fee\u6539\u6d3e\u5355\u89c4\u5219\u65f6[\u9879\u76ee\u7ecf\u529e\u4ebaID]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!StringUtils.hasText((String)reqBO.getProjectDispatchConfigBO().getProjectHandlerName())) {
            throw new BusinessException("8888", "\u4fee\u6539\u6d3e\u5355\u89c4\u5219\u65f6[\u9879\u76ee\u7ecf\u529e\u4eba\u540d\u79f0]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getProjectDispatchConfigBO().getDispatchType() == null) {
            throw new BusinessException("8888", "\u4fee\u6539\u6d3e\u5355\u89c4\u5219\u65f6[\u6d3e\u5355\u65b9\u5f0f]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getProjectDispatchConfigBO().getRejectTimesLimit() == null) {
            throw new BusinessException("8888", "\u4fee\u6539\u6d3e\u5355\u89c4\u5219\u65f6[\u62d2\u5355\u6b21\u6570\u4e0a\u9650]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getProjectDispatchItemConfigBOS())) {
            for (AgrProjectDispatchItemConfigBO projectDispatchItemConfigBO : reqBO.getProjectDispatchItemConfigBOS()) {
                if (projectDispatchItemConfigBO.getDispatchSequence() == null) {
                    throw new BusinessException("8888", "\u4fee\u6539\u6d3e\u5355\u8f6e\u6b21\u65f6[\u6d3e\u5355\u987a\u5e8f]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (!StringUtils.hasText((String)projectDispatchItemConfigBO.getContractCode())) {
                    throw new BusinessException("8888", "\u4fee\u6539\u6d3e\u5355\u8f6e\u6b21\u65f6[\u5408\u540c\u7f16\u7801]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (!StringUtils.hasText((String)projectDispatchItemConfigBO.getContractName())) {
                    throw new BusinessException("8888", "\u4fee\u6539\u6d3e\u5355\u8f6e\u6b21\u65f6[\u5408\u540c\u540d\u79f0]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (!StringUtils.hasText((String)projectDispatchItemConfigBO.getEntAgreementCode())) {
                    throw new BusinessException("8888", "\u4fee\u6539\u6d3e\u5355\u8f6e\u6b21\u65f6[\u4f01\u4e1a\u534f\u8bae\u7f16\u53f7]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (projectDispatchItemConfigBO.getSupplierId() == null || projectDispatchItemConfigBO.getSupplierId() == 0L) {
                    throw new BusinessException("8888", "\u4fee\u6539\u6d3e\u5355\u8f6e\u6b21\u65f6[\u4f9b\u5e94\u5546ID]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (!StringUtils.hasText((String)projectDispatchItemConfigBO.getSupplierName())) {
                    throw new BusinessException("8888", "\u4fee\u6539\u6d3e\u5355\u8f6e\u6b21\u65f6[\u4f9b\u5e94\u5546\u540d\u79f0]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (projectDispatchItemConfigBO.getAmountLimit() != null) continue;
                throw new BusinessException("8888", "\u4fee\u6539\u6d3e\u5355\u8f6e\u6b21\u65f6[\u4e0a\u9650\u91d1\u989d]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        }
    }
}

