/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.ability.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.agreement.ability.AgrOrderAmountConsumeAbilityService;
import com.tydic.agreement.ability.bo.AgrOrderAmountCheckResultBO;
import com.tydic.agreement.ability.bo.AgrOrderAmountConsumeReqBO;
import com.tydic.agreement.ability.bo.AgrOrderAmountConsumeRspBO;
import com.tydic.agreement.ability.bo.OrderAmountConsumeBO;
import com.tydic.agreement.busi.AgrOrderAmountConsumeBusiService;
import com.tydic.agreement.constant.AgrCommConstant;
import com.tydic.agreement.dao.AgrAgreementOrderMapper;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.po.AgrAgreementOrderPO;
import com.tydic.agreement.dao.po.AgreementPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_TEST/2.0.0/com.tydic.agreement.ability.AgrOrderAmountConsumeAbilityService"})
public class AgrOrderAmountConsumeAbilityServiceImpl
implements AgrOrderAmountConsumeAbilityService {
    @Autowired
    private AgrOrderAmountConsumeBusiService agrOrderAmountConsumeBusiService;
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgrAgreementOrderMapper agrAgreementOrderMapper;

    @PostMapping(value={"orderConsume"})
    public AgrOrderAmountConsumeRspBO orderConsume(@RequestBody AgrOrderAmountConsumeReqBO reqBO) {
        if (reqBO == null || CollectionUtils.isEmpty((Collection)reqBO.getOrderAmountConsumeList()) || reqBO.getOrderId() == null || reqBO.getObjId() == null || reqBO.getObjType() == null) {
            throw new BusinessException("8888", "\u4e0b\u5355\u91d1\u989d\u66f4\u65b0\u5fc5\u4f20\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getCheckFlag() == null || reqBO.getCheckFlag().booleanValue()) {
            AgrOrderAmountConsumeRspBO rspBo = this.orderConsumeCheck(reqBO);
            if (!"0000".equals(rspBo.getRespCode())) {
                throw new BusinessException(rspBo.getRespCode(), rspBo.getRespDesc());
            }
            AgrOrderAmountCheckResultBO resultBo = rspBo.getCheckResult().stream().filter(AgrOrderAmountCheckResultBO::getOverLimit).findFirst().orElse(null);
            if (resultBo != null) {
                throw new BusinessException("8888", resultBo.getResultMsg());
            }
        }
        AgrAgreementOrderPO agrAgreementOrderPo = new AgrAgreementOrderPO();
        agrAgreementOrderPo.setOrderId(reqBO.getOrderId());
        agrAgreementOrderPo.setObjId(reqBO.getObjId());
        agrAgreementOrderPo.setObjType(reqBO.getObjType().getTypeCode());
        int checkBy = this.agrAgreementOrderMapper.getCheckBy(agrAgreementOrderPo);
        if (checkBy > 0) {
            throw new BusinessException("8888", "\u8be5\u8ba2\u5355\u5df2\u5b58\u5728\u5904\u7406\u8bb0\u5f55");
        }
        reqBO.getOrderAmountConsumeList().stream().collect(Collectors.groupingBy(OrderAmountConsumeBO::getAgreementId)).forEach((agrId, amountList) -> {
            BigDecimal totalOrderAmount;
            BigDecimal reduce = amountList.stream().map(OrderAmountConsumeBO::getUsedAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (reduce.compareTo(BigDecimal.ZERO) < 0 && ((totalOrderAmount = this.agrAgreementOrderMapper.getTotalOrderAmountByOrderAndAgr(reqBO.getOrderId(), (Long)agrId)).compareTo(BigDecimal.ZERO) <= 0 || totalOrderAmount.compareTo(reduce.negate()) < 0)) {
                throw new BusinessException("8888", "\u672c\u6b21\u9000\u56de\u534f\u8bae\u91d1\u989d\u8d85\u51fa\u8ba2\u5355\u5df2\u6263\u51cf\u91d1\u989d");
            }
        });
        return this.agrOrderAmountConsumeBusiService.updateOrderConsume(reqBO);
    }

    @PostMapping(value={"orderConsumeCheck"})
    public AgrOrderAmountConsumeRspBO orderConsumeCheck(@RequestBody AgrOrderAmountConsumeReqBO reqBO) {
        AgrOrderAmountConsumeRspBO rspBO = new AgrOrderAmountConsumeRspBO();
        if (reqBO == null || CollectionUtils.isEmpty((Collection)reqBO.getOrderAmountConsumeList())) {
            throw new BusinessException("8888", "\u4e0b\u5355\u91d1\u989d\u6821\u9a8c\u5fc5\u4f20\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        reqBO.getOrderAmountConsumeList().forEach(bo -> {
            if (bo.getAgreementId() == null) {
                throw new BusinessException("8888", "\u4e0b\u5355\u91d1\u989d\u6821\u9a8c[\u534f\u8bae\u7f16\u53f7]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (bo.getUsedAmount() == null) {
                throw new BusinessException("8888", "\u4e0b\u5355\u91d1\u989d\u6821\u9a8c[\u91d1\u989d]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        });
        ArrayList orderAmountConsumeBos = new ArrayList();
        Map<Long, List<OrderAmountConsumeBO>> collectByAgrId = reqBO.getOrderAmountConsumeList().stream().collect(Collectors.groupingBy(OrderAmountConsumeBO::getAgreementId));
        collectByAgrId.forEach((agrId, bos) -> {
            if (bos.size() > 1) {
                BigDecimal reduce = bos.stream().map(OrderAmountConsumeBO::getUsedAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                OrderAmountConsumeBO bo = new OrderAmountConsumeBO();
                bo.setAgreementId(((OrderAmountConsumeBO)bos.get(0)).getAgreementId());
                bo.setUsedAmount(reduce);
                orderAmountConsumeBos.add(bo);
            } else {
                orderAmountConsumeBos.addAll(bos);
            }
        });
        reqBO.setOrderAmountConsumeList(orderAmountConsumeBos);
        AgreementPO agreementPo = new AgreementPO();
        agreementPo.setAgreementIds(new ArrayList<Long>(collectByAgrId.keySet()));
        List<AgreementPO> agreementPos = this.agreementMapper.getList(agreementPo);
        Map<Long, AgreementPO> agrMapByAgrId = agreementPos.stream().collect(Collectors.toMap(AgreementPO::getAgreementId, po -> po, (a, b) -> a));
        AgrAgreementOrderPO agrAgreementOrderPo = new AgrAgreementOrderPO();
        agrAgreementOrderPo.setAgreementIdIn(new ArrayList<Long>(collectByAgrId.keySet()));
        List<AgrAgreementOrderPO> totalOrderAmountByAgr = this.agrAgreementOrderMapper.getTotalOrderAmountByAgr(agrAgreementOrderPo);
        Map<Long, AgrAgreementOrderPO> logAmountMapByAgrId = totalOrderAmountByAgr.stream().collect(Collectors.toMap(AgrAgreementOrderPO::getAgreementId, po -> po, (a, b) -> a));
        ArrayList<AgrOrderAmountCheckResultBO> checkResultList = new ArrayList<AgrOrderAmountCheckResultBO>();
        for (OrderAmountConsumeBO orderAmountConsumeBo : reqBO.getOrderAmountConsumeList()) {
            AgrOrderAmountCheckResultBO checkResultBo = new AgrOrderAmountCheckResultBO();
            AgreementPO agrPo = agrMapByAgrId.get(orderAmountConsumeBo.getAgreementId());
            if (agrPo == null) {
                throw new BusinessException("8888", "\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u5173\u8054\u7684\u534f\u8bae\u4fe1\u606f");
            }
            orderAmountConsumeBo.setPlaAgreementCode(agreementPo.getPlaAgreementCode());
            if (!(orderAmountConsumeBo.getUsedAmount().compareTo(BigDecimal.ZERO) <= 0 || Objects.equals(agrPo.getIsDelete(), AgrCommConstant.IsDelete.NORMAL) && Objects.equals(agrPo.getAgreementStatus(), AgrCommConstant.AgreementStatus.ENABLE))) {
                throw new BusinessException("8888", "\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u5173\u8054\u7684\u6709\u6548\u534f\u8bae\u4fe1\u606f");
            }
            BigDecimal total = agrPo.getAgreementTentativeAmount();
            BigDecimal ordered = agrPo.getOrderAmount() == null ? BigDecimal.ZERO : agrPo.getOrderAmount();
            checkResultBo.setAgreementId(agrPo.getAgreementId());
            checkResultBo.setAgreementAmount(total);
            checkResultList.add(checkResultBo);
            if (total != null) {
                BigDecimal totalOrdered = orderAmountConsumeBo.getUsedAmount().add(ordered);
                if (orderAmountConsumeBo.getUsedAmount().compareTo(BigDecimal.ZERO) >= 0 && totalOrdered.compareTo(total) > 0) {
                    checkResultBo.setOverLimit(Boolean.valueOf(true));
                    checkResultBo.setResultMsg("\u8ba2\u5355\u91d1\u989d\u5df2\u8d85\u51fa\u534f\u8bae[" + agrPo.getPlaAgreementCode() + "]\u7684\u6682\u5b9a\u603b\u4ef7");
                    checkResultBo.setOrderAmount(ordered);
                    continue;
                }
                if (orderAmountConsumeBo.getUsedAmount().compareTo(BigDecimal.ZERO) < 0 && totalOrdered.compareTo(BigDecimal.ZERO) < 0) {
                    checkResultBo.setOverLimit(Boolean.valueOf(true));
                    checkResultBo.setResultMsg("\u8ba2\u5355\u9000\u6b3e\u91d1\u989d\u5df2\u8d85\u51fa\u534f\u8bae[" + agrPo.getPlaAgreementCode() + "]\u7684\u5df2\u4e0b\u5355\u91d1\u989d");
                    checkResultBo.setOrderAmount(ordered);
                    continue;
                }
                AgrAgreementOrderPO logOrderAmountPo = logAmountMapByAgrId.get(orderAmountConsumeBo.getAgreementId());
                if (logOrderAmountPo != null) {
                    BigDecimal logOrdered = logOrderAmountPo.getOrderAmount();
                    BigDecimal totalLogOrdered = orderAmountConsumeBo.getUsedAmount().add(logOrdered);
                    if (orderAmountConsumeBo.getUsedAmount().compareTo(BigDecimal.ZERO) >= 0 && totalLogOrdered.compareTo(total) > 0) {
                        checkResultBo.setOverLimit(Boolean.valueOf(true));
                        checkResultBo.setResultMsg("\u8ba2\u5355\u91d1\u989d\u5df2\u8d85\u51fa\u534f\u8bae[" + agrPo.getPlaAgreementCode() + "]\u7684\u6682\u5b9a\u603b\u4ef7");
                        checkResultBo.setOrderAmount(logOrdered);
                        continue;
                    }
                    if (orderAmountConsumeBo.getUsedAmount().compareTo(BigDecimal.ZERO) < 0 && totalLogOrdered.compareTo(BigDecimal.ZERO) < 0) {
                        checkResultBo.setOverLimit(Boolean.valueOf(true));
                        checkResultBo.setResultMsg("\u8ba2\u5355\u9000\u6b3e\u91d1\u989d\u5df2\u8d85\u51fa\u534f\u8bae[" + agrPo.getPlaAgreementCode() + "]\u7684\u5df2\u4e0b\u5355\u91d1\u989d");
                        checkResultBo.setOrderAmount(logOrdered);
                        continue;
                    }
                }
            }
            checkResultBo.setOverLimit(Boolean.valueOf(false));
            checkResultBo.setOrderAmount(ordered);
        }
        rspBO.setCheckResult(checkResultList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

