/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.ability.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.agreement.ability.AgrQryAgreementSkuAndMaterialAbilityService;
import com.tydic.agreement.ability.bo.AgrQryAgreementSkuAndMaterialAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrQryAgreementSkuAndMaterialAbilityRspBO;
import com.tydic.agreement.atom.AgrDicDictionaryAtomService;
import com.tydic.agreement.busi.bo.AgrQryAgreementSkuChgWithOriginalBusiReqBO;
import com.tydic.agreement.common.bo.AgrAgreementSkuChgWithOriginalBO;
import com.tydic.agreement.common.bo.AgrAgreementSkuMaterialBO;
import com.tydic.agreement.constant.AgrCommConstant;
import com.tydic.agreement.dao.AgrAgreementSkuMaterialMapper;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.AgreementSkuChangeMapper;
import com.tydic.agreement.dao.po.AgrAgreementSkuMaterialPO;
import com.tydic.agreement.dao.po.AgreementPO;
import com.tydic.agreement.dao.po.AgreementSkuChangePO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_TEST/2.0.0/com.tydic.agreement.ability.AgrQryAgreementSkuAndMaterialAbilityService"})
public class AgrQryAgreementSkuAndMaterialAbilityServiceImpl
implements AgrQryAgreementSkuAndMaterialAbilityService {
    @Autowired
    private AgreementSkuChangeMapper agreementSkuChangeMapper;
    @Autowired
    private AgrDicDictionaryAtomService agrDicDictionaryAtomService;
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgrAgreementSkuMaterialMapper agrAgreementSkuMaterialMapper;

    @PostMapping(value={"qryAgreementSkuAndMaterial"})
    public AgrQryAgreementSkuAndMaterialAbilityRspBO qryAgreementSkuAndMaterial(@RequestBody AgrQryAgreementSkuAndMaterialAbilityReqBO reqBO) {
        AgrQryAgreementSkuAndMaterialAbilityRspBO rsp = new AgrQryAgreementSkuAndMaterialAbilityRspBO();
        if (null == reqBO.getAgreementId()) {
            throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6\u53d8\u66f4\u67e5\u8be2API\u5165\u53c2\u3010agreementId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        AgreementPO agreementPO = new AgreementPO();
        agreementPO.setAgreementId(reqBO.getAgreementId());
        agreementPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        AgreementPO agreement = this.agreementMapper.getModelBy(agreementPO);
        if (agreement == null) {
            rsp.setRespCode("0000");
            rsp.setRespDesc("\u672a\u67e5\u8be2\u5230\u534f\u8bae\u4fe1\u606f");
            return rsp;
        }
        AgrQryAgreementSkuChgWithOriginalBusiReqBO originalBusiReqBO = new AgrQryAgreementSkuChgWithOriginalBusiReqBO();
        originalBusiReqBO.setAgreementId(reqBO.getAgreementId());
        originalBusiReqBO.setFreezeFlag(reqBO.getFreezeFlag());
        List<AgrAgreementSkuChgWithOriginalBO> rows = this.agreementSkuChangeMapper.getListWithOriginalBySku(originalBusiReqBO);
        if (CollectionUtils.isEmpty(rows)) {
            rsp.setRespCode("0000");
            rsp.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return rsp;
        }
        HashMap<Long, AgrAgreementSkuChgWithOriginalBO> map = new HashMap<Long, AgrAgreementSkuChgWithOriginalBO>();
        ArrayList<Long> agreementSkuIds = new ArrayList<Long>();
        for (AgrAgreementSkuChgWithOriginalBO bo : rows) {
            map.put(bo.getAgreementSkuId(), bo);
            agreementSkuIds.add(bo.getAgreementSkuId());
        }
        AgreementSkuChangePO agreementSkuChangePO = new AgreementSkuChangePO();
        agreementSkuChangePO.setAgreementId(reqBO.getAgreementId());
        agreementSkuChangePO.setSupplierId(reqBO.getSupplierId());
        agreementSkuChangePO.setAgreementSkuIds(agreementSkuIds);
        agreementSkuChangePO.setChangeCode(reqBO.getChangeCode());
        List<AgreementSkuChangePO> pos = this.agreementSkuChangeMapper.getList(agreementSkuChangePO);
        if (!CollectionUtils.isEmpty(pos)) {
            for (AgreementSkuChangePO po2 : pos) {
                AgrAgreementSkuChgWithOriginalBO bo1 = (AgrAgreementSkuChgWithOriginalBO)map.get(po2.getAgreementSkuId());
                String itemName = bo1.getItemName();
                BeanUtils.copyProperties((Object)po2, (Object)bo1);
                bo1.setItemName(itemName);
            }
        }
        AgrAgreementSkuMaterialPO agrAgreementSkuMaterialPO = new AgrAgreementSkuMaterialPO();
        agrAgreementSkuMaterialPO.setAgreementId(reqBO.getAgreementId());
        agrAgreementSkuMaterialPO.setExtField1(reqBO.getChangeCode());
        agrAgreementSkuMaterialPO.setIsDelete(0);
        List<AgrAgreementSkuMaterialPO> agrAgreementSkuMaterialPOS = this.agrAgreementSkuMaterialMapper.getList(agrAgreementSkuMaterialPO);
        HashMap agrAgreementSkuOldMaterialMap = new HashMap();
        if (!CollectionUtils.isEmpty(agrAgreementSkuMaterialPOS)) {
            agrAgreementSkuMaterialPOS.forEach(po -> agrAgreementSkuOldMaterialMap.put(po.getAgreementSkuId(), po));
        }
        Map<String, String> isOilMap = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcode("AGR", "IS_OIL_PCODE");
        Map<String, String> producingAreaMap = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcode("AGR", "AGR_PRODUCING_AREA");
        Map<String, String> conversionScaleMap = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcode("AGR", "MEASURE_CONVERSION_RELATIONSHIPS");
        for (AgrAgreementSkuChgWithOriginalBO bo : rows) {
            String[] split;
            String conversionScale;
            if (2 == agreement.getAgreementMode() || !"0".equals(reqBO.getIsProfessionalOrgExt())) {
                bo.setPreMarkupRate(null);
                bo.setPreMarkupValue(null);
                bo.setMarkupRate(null);
                bo.setMarkupValue(null);
            }
            if (StringUtils.hasText((String)bo.getExtField1()) && StringUtils.hasText((String)bo.getExtField2())) {
                bo.setBuyNumber(bo.getBuyNumber().add(new BigDecimal(bo.getExtField1()).subtract(new BigDecimal(bo.getExtField2()))));
            }
            if (null != bo.getIsOil()) {
                bo.setIsOilStr(isOilMap.get(bo.getIsOil().toString()));
            }
            if (null != bo.getPreIsOil()) {
                bo.setPreIsOilStr(isOilMap.get(bo.getPreIsOil().toString()));
            }
            if (!StringUtils.isEmpty((Object)bo.getProducingArea())) {
                bo.setProducingAreaStr(producingAreaMap.get(bo.getProducingArea()));
            }
            if (null != reqBO.getMeasureScaleFlag() && reqBO.getMeasureScaleFlag().booleanValue() && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(conversionScale = conversionScaleMap.get(bo.getMeasureName() + ":" + bo.getMaterialMeasureName()))) && (split = conversionScale.split(":")).length == 2) {
                bo.setUnitOfMeasureScale(Integer.valueOf(split[0]));
                bo.setMaterialUnitOfMeasureScale(Integer.valueOf(split[1]));
            }
            AgrAgreementSkuMaterialBO agrAgreementSkuMaterialBO = new AgrAgreementSkuMaterialBO();
            if (!CollectionUtils.isEmpty(agrAgreementSkuOldMaterialMap) && null != agrAgreementSkuOldMaterialMap.get(bo.getAgreementSkuId())) {
                BeanUtils.copyProperties(agrAgreementSkuOldMaterialMap.get(bo.getAgreementSkuId()), (Object)agrAgreementSkuMaterialBO);
            }
            bo.setAgrAgreementSkuMaterialBO(agrAgreementSkuMaterialBO);
        }
        rsp.setRows(rows);
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u534f\u8bae\u660e\u7ec6\u67e5\u8be2\u6210\u529f\uff01");
        return rsp;
    }
}

