/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.ability.impl;

import com.alibaba.excel.util.StringUtils;
import com.tydic.agreement.ability.AgrQryShoppingCartAgreementInfoAbilityService;
import com.tydic.agreement.ability.bo.AgrBusiPropLabelBO;
import com.tydic.agreement.ability.bo.AgrQryShoppingCartAgreementInfoAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrQryShoppingCartAgreementInfoAbilityRspBO;
import com.tydic.agreement.ability.bo.AgrQryShoppingCartAgreementInfoBO;
import com.tydic.agreement.atom.AgrDicDictionaryAtomService;
import com.tydic.agreement.constant.AgrEnum;
import com.tydic.agreement.dao.AgrRelBusiPropLabelMapper;
import com.tydic.agreement.dao.AgreementSkuMapper;
import com.tydic.agreement.dao.po.AgrRelBusiPropLabelPO;
import com.tydic.agreement.dao.po.AgreementSkuPO;
import com.tydic.agreement.utils.MoneyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_TEST/2.0.0/com.tydic.agreement.ability.AgrQryShoppingCartAgreementInfoAbilityService"})
public class AgrQryShoppingCartAgreementInfoAbilityServiceImpl
implements AgrQryShoppingCartAgreementInfoAbilityService {
    @Autowired
    private AgreementSkuMapper agreementSkuMapper;
    @Autowired
    private AgrDicDictionaryAtomService agrDicDictionaryAtomService;
    @Autowired
    private AgrRelBusiPropLabelMapper agrRelBusiPropLabelMapper;

    @PostMapping(value={"qryShoppingCartAgreementInfo"})
    public AgrQryShoppingCartAgreementInfoAbilityRspBO qryShoppingCartAgreementInfo(@RequestBody AgrQryShoppingCartAgreementInfoAbilityReqBO abilityReqBO) {
        AgrQryShoppingCartAgreementInfoAbilityRspBO rspBo = new AgrQryShoppingCartAgreementInfoAbilityRspBO();
        if (abilityReqBO == null || CollectionUtils.isEmpty((Collection)abilityReqBO.getAgreementDetailIds())) {
            rspBo.setRespCode("0001");
            rspBo.setRespDesc("\u8bf7\u6c42\u5fc5\u4f20\u53c2\u6570[\u534f\u8bae\u660e\u7ec6ID\u96c6\u5408]\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        ArrayList rspAgrInfos = new ArrayList();
        AgreementSkuPO agreementSkuPO = new AgreementSkuPO();
        agreementSkuPO.setAgreementSkuIds(abilityReqBO.getAgreementDetailIds());
        List<AgreementSkuPO> agreementSkuPOS = this.agreementSkuMapper.getShoppingCartAgreementInfo(agreementSkuPO);
        if (!CollectionUtils.isEmpty(agreementSkuPOS)) {
            Map<String, String> itemSourceStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcode("AGR", "AGR_ITEM_SOURCE");
            Map<String, String> producingAreaStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcode("AGR", "AGR_PRODUCING_AREA");
            Map<String, String> catalogVarietyStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcode("AGR", "AGREEMENT_VARIETY_PCODE");
            agreementSkuPOS.forEach(skuPO -> {
                AgrQryShoppingCartAgreementInfoBO infoBO = new AgrQryShoppingCartAgreementInfoBO();
                BeanUtils.copyProperties((Object)skuPO, (Object)infoBO);
                infoBO.setAgreementDetailId(skuPO.getAgreementDetailId());
                infoBO.setVariety(skuPO.getCatalogVariety());
                infoBO.setMeasureConvertSku(skuPO.getUnitOfMeasureScale());
                infoBO.setMeasureConvertMaterial(skuPO.getMaterialUnitOfMeasureScale());
                infoBO.setBuyPrice(MoneyUtil.l2b4(skuPO.getBuyPrice()));
                infoBO.setSalePrice(MoneyUtil.l2b4(skuPO.getSalePrice()));
                if (null != infoBO.getItemSource()) {
                    infoBO.setItemSourceStr((String)itemSourceStr.get(infoBO.getItemSource().toString()));
                }
                if (StringUtils.isNotBlank((CharSequence)infoBO.getProducingArea())) {
                    infoBO.setProducingAreaStr((String)producingAreaStr.get(infoBO.getProducingArea()));
                }
                if (null != infoBO.getVariety()) {
                    infoBO.setVarietyStr((String)catalogVarietyStr.get(infoBO.getVariety().toString()));
                }
                if (null != infoBO.getPurchaseWay()) {
                    String desc = AgrEnum.PurchaseWay.getDescByCode((String)infoBO.getPurchaseWay());
                    infoBO.setPurchaseWayStr(desc);
                }
                rspAgrInfos.add(infoBO);
            });
            List<Long> agreementIds = agreementSkuPOS.stream().map(AgreementSkuPO::getAgreementId).distinct().collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(agreementIds)) {
                AgrRelBusiPropLabelPO agrRelBusiPropLabelPO = new AgrRelBusiPropLabelPO();
                agrRelBusiPropLabelPO.setAgreementIdIn(agreementIds);
                List<AgrRelBusiPropLabelPO> agrRelBusiPropLabelPOS = this.agrRelBusiPropLabelMapper.getList(agrRelBusiPropLabelPO);
                if (!CollectionUtils.isEmpty(agrRelBusiPropLabelPOS)) {
                    Map<Long, List<AgrRelBusiPropLabelPO>> agrRelBusiPropLabelMap = agrRelBusiPropLabelPOS.stream().collect(Collectors.groupingBy(AgrRelBusiPropLabelPO::getAgreementId));
                    rspAgrInfos.forEach(infoBO -> {
                        if (agrRelBusiPropLabelMap.containsKey(infoBO.getAgreementId())) {
                            List busiPropLabelPOS = (List)agrRelBusiPropLabelMap.get(infoBO.getAgreementId());
                            List busiPropLabels = busiPropLabelPOS.stream().map(po -> {
                                AgrBusiPropLabelBO bo = new AgrBusiPropLabelBO();
                                bo.setLabelId(po.getLabelId());
                                bo.setLabelCode(po.getLabelCode());
                                bo.setLabelName(po.getLabelName());
                                bo.setLabelProp(po.getLabelProp());
                                bo.setLabelLevel(po.getLabelLevel());
                                bo.setLabelShow(po.getLabelShow());
                                bo.setCentralizedPurchasing(po.getCentralizedPurchasing());
                                bo.setRemark(po.getRemark());
                                return bo;
                            }).collect(Collectors.toList());
                            infoBO.setBusiPropLabels(busiPropLabels);
                        }
                    });
                }
            }
        }
        rspBo.setRspAgrInfos(rspAgrInfos);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

