/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.ability.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.agreement.ability.bo.AgrBusiPropLabelBO;
import com.tydic.agreement.ability.bo.AgrQrySpuRelSkuInfoAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrQrySpuRelSkuInfoAbilityRspBO;
import com.tydic.agreement.ability.bo.AgrQrySpuRelSkuInfoAbilityService;
import com.tydic.agreement.ability.bo.AgrQrySpuRelSkuInfoBO;
import com.tydic.agreement.constant.AgrCommConstant;
import com.tydic.agreement.dao.AgrRelBusiPropLabelMapper;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.AgreementSkuMapper;
import com.tydic.agreement.dao.ProjectDispatchConfigMapper;
import com.tydic.agreement.dao.po.AgrRelBusiPropLabelInfoPO;
import com.tydic.agreement.dao.po.ProjectDispatchConfigPO;
import com.tydic.agreement.utils.MoneyUtil;
import com.tydic.commodity.enumType.SkuSourceEnum;
import com.tydic.commodity.enumType.YesNoEnum;
import com.tydic.uccext.bo.CnncReplacementPriceBusiReqBo;
import com.tydic.uccext.bo.CnncReplacementPriceBusiRspBo;
import com.tydic.uccext.bo.ReplacePriceInfoBO;
import com.tydic.uccext.bo.UccStandardSpuDetailInfoBO;
import com.tydic.uccext.bo.UccStandardSpuDetailsAbilityReqBO;
import com.tydic.uccext.bo.UccStandardSpuDetailsAbilityRspBO;
import com.tydic.uccext.service.CnncReplacementPriceBusiService;
import com.tydic.uccext.service.UccStandardSpuDetailsAbilityService;
import com.tydic.umc.ability.UmcMemDetailQueryAbilityService;
import com.tydic.umc.ability.bo.UmcMemDetailInfoAbilityBO;
import com.tydic.umc.ability.bo.UmcMemDetailQueryAbilityReqBO;
import com.tydic.umc.ability.bo.UmcMemDetailQueryAbilityRspBO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_TEST/2.0.0/com.tydic.agreement.ability.bo.AgrQrySpuRelSkuInfoAbilityService"})
public class AgrQrySpuRelSkuInfoAbilityServiceImpl
implements AgrQrySpuRelSkuInfoAbilityService {
    @Value(value="${cnsc_org_id}")
    private Long cnscOrgId;
    @Value(value="${cnsc_org_name}")
    private String cnscOrgName;
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgreementSkuMapper agreementSkuMapper;
    @Autowired
    private AgrRelBusiPropLabelMapper agrRelBusiPropLabelMapper;
    @Autowired
    private ProjectDispatchConfigMapper projectDispatchConfigMapper;
    @Autowired
    private UmcMemDetailQueryAbilityService umcMemDetailQueryAbilityService;
    @Autowired
    private CnncReplacementPriceBusiService cnncReplacementPriceBusiService;
    @Autowired
    private UccStandardSpuDetailsAbilityService uccStandardSpuDetailsAbilityService;

    @PostMapping(value={"qrySpuRelSkuInfo"})
    public AgrQrySpuRelSkuInfoAbilityRspBO qrySpuRelSkuInfo(@RequestBody AgrQrySpuRelSkuInfoAbilityReqBO reqBO) {
        AgrQrySpuRelSkuInfoAbilityRspBO rspBO = new AgrQrySpuRelSkuInfoAbilityRspBO();
        if (reqBO == null || CollectionUtils.isEmpty((Collection)reqBO.getSpuIds())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u6c42\u5fc5\u4f20\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        Long companyId = reqBO.getCompanyId();
        String orgPath = reqBO.getOrgPath();
        if ("0".equals(reqBO.getIsProfessionalOrgExt())) {
            companyId = null;
            orgPath = null;
        }
        List<AgrQrySpuRelSkuInfoBO> canOrderedSkuInfoList = this.agreementSkuMapper.getCanOrderedSkuInfoList(reqBO.getSpuIds(), companyId, orgPath);
        UccStandardSpuDetailsAbilityReqBO uccStandardSpuDetailsAbilityReqBO = new UccStandardSpuDetailsAbilityReqBO();
        uccStandardSpuDetailsAbilityReqBO.setSpuIds(reqBO.getSpuIds());
        UccStandardSpuDetailsAbilityRspBO uccStandardSpuDetailsAbilityRspBO = this.uccStandardSpuDetailsAbilityService.qryUccStandardSpuDetails(uccStandardSpuDetailsAbilityReqBO);
        Map<Object, Object> spuMap = "0000".equals(uccStandardSpuDetailsAbilityRspBO.getRespCode()) && !CollectionUtils.isEmpty((Collection)uccStandardSpuDetailsAbilityRspBO.getSpuDetailInfos()) ? uccStandardSpuDetailsAbilityRspBO.getSpuDetailInfos().stream().collect(Collectors.toMap(UccStandardSpuDetailInfoBO::getSpuId, obj -> obj, (a, b) -> a)) : Collections.emptyMap();
        if (!CollectionUtils.isEmpty(canOrderedSkuInfoList)) {
            List<Object> projectDispatchConfigPOList;
            Set agrIds = canOrderedSkuInfoList.stream().map(AgrQrySpuRelSkuInfoBO::getAgreementId).collect(Collectors.toSet());
            List<AgrRelBusiPropLabelInfoPO> agrRelBusiPropLabels = this.agrRelBusiPropLabelMapper.getAgrRelBusiPropLabels(new ArrayList<Long>(agrIds), null);
            Map<Long, List<AgrRelBusiPropLabelInfoPO>> busiPropLabelMap = agrRelBusiPropLabels.stream().collect(Collectors.groupingBy(AgrRelBusiPropLabelInfoPO::getAgreementId));
            Set projectCodes = canOrderedSkuInfoList.stream().map(AgrQrySpuRelSkuInfoBO::getProjectCode).filter(StringUtils::hasText).collect(Collectors.toSet());
            if (!CollectionUtils.isEmpty(projectCodes)) {
                ProjectDispatchConfigPO projectDispatchConfigPO = new ProjectDispatchConfigPO();
                projectDispatchConfigPO.setProjectCodeIn(new ArrayList<String>(projectCodes));
                projectDispatchConfigPO.setState(AgrCommConstant.DISPATCH_STATE.EFFECT);
                projectDispatchConfigPOList = this.projectDispatchConfigMapper.getList(projectDispatchConfigPO);
            } else {
                projectDispatchConfigPOList = Collections.emptyList();
            }
            Map<String, Long> projectHandlerMap = projectDispatchConfigPOList.stream().collect(Collectors.toMap(ProjectDispatchConfigPO::getProjectCode, ProjectDispatchConfigPO::getProjectHandlerId, (a, b) -> a));
            HashMap memDetailMap = new HashMap(projectHandlerMap.size());
            List<AgrQrySpuRelSkuInfoBO> collectDataList = canOrderedSkuInfoList.stream().map(po -> {
                AgrQrySpuRelSkuInfoBO agrQrySpuRelSkuInfoBO = new AgrQrySpuRelSkuInfoBO();
                agrQrySpuRelSkuInfoBO.setSpuId(po.getSpuId());
                agrQrySpuRelSkuInfoBO.setSpuName(po.getSpuName());
                agrQrySpuRelSkuInfoBO.setAgreementSkuId(po.getAgreementSkuId());
                agrQrySpuRelSkuInfoBO.setAgreementId(po.getAgreementId());
                agrQrySpuRelSkuInfoBO.setItemName(po.getItemName());
                agrQrySpuRelSkuInfoBO.setShopName(po.getShopName());
                agrQrySpuRelSkuInfoBO.setContacts(po.getContacts());
                agrQrySpuRelSkuInfoBO.setRelaPhone1(po.getRelaPhone1());
                agrQrySpuRelSkuInfoBO.setRelaPhone2(po.getRelaPhone2());
                agrQrySpuRelSkuInfoBO.setSupplierId(po.getSupplierId());
                agrQrySpuRelSkuInfoBO.setSupplierName(po.getSupplierName());
                agrQrySpuRelSkuInfoBO.setSupplierShopId(po.getSupplierShopId());
                agrQrySpuRelSkuInfoBO.setContractId(po.getContractId());
                agrQrySpuRelSkuInfoBO.setProjectCode(po.getProjectCode());
                agrQrySpuRelSkuInfoBO.setSupplyCycle(po.getSupplyCycle());
                agrQrySpuRelSkuInfoBO.setBuyPriceLong(po.getBuyPriceLong());
                agrQrySpuRelSkuInfoBO.setPrice(MoneyUtil.l2b2(po.getBuyPriceLong()));
                agrQrySpuRelSkuInfoBO.setSalePriceLong(po.getSalePriceLong());
                agrQrySpuRelSkuInfoBO.setSalePrice(MoneyUtil.l2b2(po.getSalePriceLong()));
                agrQrySpuRelSkuInfoBO.setTaxCode(po.getTaxCode());
                agrQrySpuRelSkuInfoBO.setRate(po.getRate());
                agrQrySpuRelSkuInfoBO.setRemainNum(po.getRemainNum());
                agrQrySpuRelSkuInfoBO.setProjectCode(po.getProjectCode());
                agrQrySpuRelSkuInfoBO.setMeasureName(po.getMeasureName());
                agrQrySpuRelSkuInfoBO.setMaterialMeasureName(po.getMaterialMeasureName());
                agrQrySpuRelSkuInfoBO.setMeasureScale(po.getMeasureScale());
                agrQrySpuRelSkuInfoBO.setMaterialMeasureScale(po.getMaterialMeasureScale());
                agrQrySpuRelSkuInfoBO.setAgreementMode(po.getAgreementMode());
                if (StringUtils.hasText((String)po.getProjectName()) && StringUtils.hasText((String)po.getProjectCode())) {
                    agrQrySpuRelSkuInfoBO.setProjectName(po.getProjectName().substring(po.getProjectCode().length() + 1));
                }
                if (po.getSupplyCycle() != null) {
                    agrQrySpuRelSkuInfoBO.setArriveDay(String.valueOf(po.getSupplyCycle()));
                } else {
                    agrQrySpuRelSkuInfoBO.setArriveDay("0");
                }
                agrQrySpuRelSkuInfoBO.setCommodityTypeId(po.getCommodityTypeId());
                agrQrySpuRelSkuInfoBO.setSkuSource(SkuSourceEnum.AGREEMENT_DETAIL_SOURCE.getSource());
                List agrRelBusiPropLabelInfoPOS = (List)busiPropLabelMap.get(po.getAgreementId());
                if (!CollectionUtils.isEmpty((Collection)agrRelBusiPropLabelInfoPOS)) {
                    List agrBusiPropLabelBOS = JSONArray.parseArray((String)JSONObject.toJSONString((Object)agrRelBusiPropLabelInfoPOS), AgrBusiPropLabelBO.class).stream().filter(bo -> YesNoEnum.YES.getType().equals(bo.getLabelShow())).sorted(Comparator.comparing(AgrBusiPropLabelBO::getLabelProp).thenComparing(AgrBusiPropLabelBO::getLabelLevel)).collect(Collectors.toList());
                    agrQrySpuRelSkuInfoBO.setBusiPropLabels(agrBusiPropLabelBOS);
                }
                if (projectHandlerMap.containsKey(po.getProjectCode())) {
                    agrQrySpuRelSkuInfoBO.setDispatchFlag(Boolean.TRUE);
                    UccStandardSpuDetailInfoBO uccStandardSpuDetailInfoBO = (UccStandardSpuDetailInfoBO)spuMap.get(po.getSpuId());
                    agrQrySpuRelSkuInfoBO.setTaxCode(uccStandardSpuDetailInfoBO.getTaxCode());
                    if (StringUtils.hasText((String)uccStandardSpuDetailInfoBO.getTaxRate())) {
                        agrQrySpuRelSkuInfoBO.setRate(new BigDecimal(uccStandardSpuDetailInfoBO.getTaxRate()));
                    }
                    agrQrySpuRelSkuInfoBO.setSalePrice(uccStandardSpuDetailInfoBO.getSalePrice());
                    agrQrySpuRelSkuInfoBO.setSalePriceLong(MoneyUtil.b2l(uccStandardSpuDetailInfoBO.getSalePrice()));
                    Long projectHandlerMemId = (Long)projectHandlerMap.get(po.getProjectCode());
                    UmcMemDetailInfoAbilityBO umcMemDetailInfoAbilityBO = null;
                    if (memDetailMap.containsKey(projectHandlerMemId)) {
                        umcMemDetailInfoAbilityBO = (UmcMemDetailInfoAbilityBO)memDetailMap.get(projectHandlerMemId);
                    } else {
                        UmcMemDetailQueryAbilityReqBO umcMemDetailQueryAbilityReqBO = new UmcMemDetailQueryAbilityReqBO();
                        umcMemDetailQueryAbilityReqBO.setMemId(projectHandlerMemId);
                        UmcMemDetailQueryAbilityRspBO umcMemDetailQueryAbilityRspBO = this.umcMemDetailQueryAbilityService.memDetailQuery(umcMemDetailQueryAbilityReqBO);
                        if ("0000".equals(umcMemDetailQueryAbilityRspBO.getRespCode()) && umcMemDetailQueryAbilityRspBO.getUmcMemDetailInfoAbilityRspBO() != null) {
                            memDetailMap.put(projectHandlerMemId, umcMemDetailQueryAbilityRspBO.getUmcMemDetailInfoAbilityRspBO());
                            umcMemDetailInfoAbilityBO = umcMemDetailQueryAbilityRspBO.getUmcMemDetailInfoAbilityRspBO();
                        }
                    }
                    if (umcMemDetailInfoAbilityBO != null) {
                        agrQrySpuRelSkuInfoBO.setContacts(umcMemDetailInfoAbilityBO.getMemName2());
                        agrQrySpuRelSkuInfoBO.setRelaPhone1(umcMemDetailInfoAbilityBO.getRegMobile());
                    } else {
                        agrQrySpuRelSkuInfoBO.setContacts(null);
                        agrQrySpuRelSkuInfoBO.setRelaPhone1(null);
                    }
                }
                return agrQrySpuRelSkuInfoBO;
            }).collect(Collectors.toList());
            collectDataList.stream().collect(Collectors.groupingBy(AgrQrySpuRelSkuInfoBO::getSpuId)).forEach((spuId, collectList) -> {
                Integer maxSupplyCycle = collectList.stream().filter(AgrQrySpuRelSkuInfoBO::getDispatchFlag).map(AgrQrySpuRelSkuInfoBO::getSupplyCycle).max(Comparator.comparing(Integer::intValue)).orElse(0);
                collectList.stream().filter(AgrQrySpuRelSkuInfoBO::getDispatchFlag).forEach(bo -> bo.setArriveDay(String.valueOf(maxSupplyCycle)));
                ArrayList<AgrBusiPropLabelBO> agrBusiPropLabelBOList = new ArrayList<AgrBusiPropLabelBO>();
                Set<String> labelCode = collectList.stream().filter(AgrQrySpuRelSkuInfoBO::getDispatchFlag).map(AgrQrySpuRelSkuInfoBO::getBusiPropLabels).flatMap(Collection::stream).map(AgrBusiPropLabelBO::getLabelCode).collect(Collectors.toSet());
                labelCode.forEach(code -> collectList.stream().filter(AgrQrySpuRelSkuInfoBO::getDispatchFlag).map(AgrQrySpuRelSkuInfoBO::getBusiPropLabels).flatMap(Collection::stream).filter(bo -> Objects.equals(code, bo.getLabelCode())).findFirst().ifPresent(agrBusiPropLabelBOList::add));
                agrBusiPropLabelBOList.sort(Comparator.comparing(AgrBusiPropLabelBO::getLabelProp).thenComparing(AgrBusiPropLabelBO::getLabelLevel));
                collectList.stream().filter(AgrQrySpuRelSkuInfoBO::getDispatchFlag).forEach(bo -> bo.setBusiPropLabels(agrBusiPropLabelBOList));
            });
            if (null != reqBO.getCompanyId()) {
                if (!"2".equals(reqBO.getMemUserType()) && !"1".equals(reqBO.getMemUserType())) {
                    CnncReplacementPriceBusiReqBo cnncReplacementPriceBusiReqBo = new CnncReplacementPriceBusiReqBo();
                    BeanUtils.copyProperties((Object)reqBO, (Object)cnncReplacementPriceBusiReqBo);
                    List replacePriceInfoBOList = collectDataList.stream().map(bo -> {
                        ReplacePriceInfoBO replacePriceInfoBO = new ReplacePriceInfoBO();
                        if (StringUtils.hasText((String)bo.getCommodityTypeId())) {
                            replacePriceInfoBO.setCommodityTypeId(Long.valueOf(Long.parseLong(bo.getCommodityTypeId())));
                        }
                        replacePriceInfoBO.setAgreementPrice(bo.getBuyPriceLong());
                        replacePriceInfoBO.setSkuSource(SkuSourceEnum.AGREEMENT_DETAIL_SOURCE.getSource());
                        replacePriceInfoBO.setSupplierShopId(bo.getSupplierShopId());
                        replacePriceInfoBO.setSalePrice(bo.getSalePriceLong());
                        replacePriceInfoBO.setSkuId(bo.getAgreementSkuId());
                        replacePriceInfoBO.setCommodityId(bo.getAgreementSkuId());
                        replacePriceInfoBO.setAgreementId(bo.getAgreementId());
                        replacePriceInfoBO.setVendorId(bo.getSupplierId());
                        replacePriceInfoBO.setContractId(bo.getContractId());
                        return replacePriceInfoBO;
                    }).collect(Collectors.toList());
                    cnncReplacementPriceBusiReqBo.setReplacePriceInfo(replacePriceInfoBOList);
                    CnncReplacementPriceBusiRspBo cnncReplacementPriceBusiRspBo = this.cnncReplacementPriceBusiService.replacePrice(cnncReplacementPriceBusiReqBo);
                    if (!"0000".equals(cnncReplacementPriceBusiRspBo.getRespCode())) {
                        throw new BusinessException("8888", cnncReplacementPriceBusiRspBo.getRespDesc());
                    }
                    Map<Long, ReplacePriceInfoBO> replacePriceMap = cnncReplacementPriceBusiRspBo.getRows().stream().collect(Collectors.toMap(ReplacePriceInfoBO::getSkuId, obj -> obj, (a, b) -> a));
                    collectDataList.forEach(bo -> {
                        ReplacePriceInfoBO replacePriceInfo = (ReplacePriceInfoBO)replacePriceMap.get(bo.getAgreementSkuId());
                        if (replacePriceInfo != null) {
                            bo.setSalePriceLong(replacePriceInfo.getSalePrice());
                            bo.setSalePrice(MoneyUtil.l2b2(bo.getSalePriceLong()));
                            bo.setBusiMode(replacePriceInfo.getBusiMode());
                            bo.setBusiModeStr(replacePriceInfo.getBusiModeStr());
                        }
                    });
                } else if (reqBO.getPsDiscountRate() != null) {
                    collectDataList.stream().filter(bo -> bo.getDispatchFlag() == false).forEach(bo -> {
                        BigDecimal agreementPrice;
                        BigDecimal salePrice = MoneyUtil.l2b2(bo.getSalePriceLong());
                        if (salePrice.compareTo(agreementPrice = MoneyUtil.l2b2(bo.getBuyPriceLong())) != 0) {
                            BigDecimal difValue = salePrice.subtract(agreementPrice);
                            BigDecimal salePriceDiscount = difValue.multiply(reqBO.getPsDiscountRate().divide(BigDecimal.valueOf(100L), 4, RoundingMode.UP)).add(agreementPrice);
                            bo.setSalePriceLong(MoneyUtil.b2l(salePriceDiscount));
                            bo.setSalePrice(MoneyUtil.l2b4(bo.getSalePriceLong()));
                        }
                    });
                }
            } else {
                if (!CollectionUtils.isEmpty((Collection)reqBO.getOuterUserTypes()) && reqBO.getOuterUserTypes().contains("6")) {
                    collectDataList.stream().filter(bo -> bo.getDispatchFlag() == false).forEach(bo -> {
                        if (null != bo.getSupplierId() && bo.getSupplierId().equals(reqBO.getSupId())) {
                            bo.setSalePriceLong(bo.getBuyPriceLong());
                            bo.setSalePrice(bo.getPrice());
                        }
                    });
                }
                if (reqBO.getPsDiscountRate() != null) {
                    collectDataList.stream().filter(bo -> bo.getDispatchFlag() == false).forEach(bo -> {
                        BigDecimal agreementPrice;
                        BigDecimal salePrice = MoneyUtil.l2b2(bo.getSalePriceLong());
                        if (salePrice.compareTo(agreementPrice = MoneyUtil.l2b2(bo.getBuyPriceLong())) != 0) {
                            BigDecimal difValue = salePrice.subtract(agreementPrice);
                            BigDecimal salePriceDiscount = difValue.multiply(reqBO.getPsDiscountRate().divide(BigDecimal.valueOf(100L), 4, RoundingMode.UP)).add(agreementPrice);
                            bo.setSalePriceLong(MoneyUtil.b2l(salePriceDiscount));
                            bo.setSalePrice(MoneyUtil.l2b4(bo.getSalePriceLong()));
                        }
                    });
                }
            }
            ArrayList rspDataList = new ArrayList();
            collectDataList.stream().collect(Collectors.groupingBy(AgrQrySpuRelSkuInfoBO::getSpuId)).forEach((spuId, collectList) -> {
                collectList.stream().filter(AgrQrySpuRelSkuInfoBO::getDispatchFlag).findAny().ifPresent(bo -> {
                    bo.setSupplierId(this.cnscOrgId);
                    bo.setSupplierName(this.cnscOrgName);
                    bo.setShopName(this.cnscOrgName);
                    bo.setItemName(bo.getSpuName());
                    bo.setAgreementSkuId(null);
                    bo.setAgreementId(null);
                    bo.setSkuSource(SkuSourceEnum.STANDARD_SPU_SOURCE.getSource());
                    rspDataList.add(bo);
                });
                collectList.stream().filter(bo -> bo.getDispatchFlag() == false).forEach(rspDataList::add);
            });
            rspBO.setSpuRelSkuInfos(rspDataList);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

