/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.ability.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.agreement.ability.AgrQueryCurrentRoundDispatchRuleAbilityService;
import com.tydic.agreement.ability.bo.AgrQueryCurrentRoundDispatchRuleAbilityServiceReqBO;
import com.tydic.agreement.ability.bo.AgrQueryCurrentRoundDispatchRuleAbilityServiceRspBO;
import com.tydic.agreement.ability.bo.AgrQueryDispatchInfoBO;
import com.tydic.agreement.ability.bo.AgrQueryDispatchRoundInfoBO;
import com.tydic.agreement.constant.AgrCommConstant;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.ProjectDispatchConfigMapper;
import com.tydic.agreement.dao.ProjectDispatchItemConfigMapper;
import com.tydic.agreement.dao.po.AgreementPO;
import com.tydic.agreement.dao.po.ProjectDispatchConfigPO;
import com.tydic.agreement.dao.po.ProjectDispatchItemConfigPO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_TEST/2.0.0/com.tydic.agreement.ability.AgrQueryCurrentRoundDispatchRuleAbilityService"})
public class AgrQueryCurrentRoundDispatchRuleAbilityServiceImpl
implements AgrQueryCurrentRoundDispatchRuleAbilityService {
    @Autowired
    private ProjectDispatchConfigMapper projectDispatchConfigMapper;
    @Autowired
    private ProjectDispatchItemConfigMapper projectDispatchItemConfigMapper;
    @Autowired
    private AgreementMapper agreementMapper;

    @PostMapping(value={"queryCurrentRoundDispatchRule"})
    public AgrQueryCurrentRoundDispatchRuleAbilityServiceRspBO queryCurrentRoundDispatchRule(@RequestBody AgrQueryCurrentRoundDispatchRuleAbilityServiceReqBO reqBO) {
        List<ProjectDispatchItemConfigPO> projectDispatchItemConfigPOS;
        this.checkParams(reqBO);
        AgrQueryCurrentRoundDispatchRuleAbilityServiceRspBO rspBO = new AgrQueryCurrentRoundDispatchRuleAbilityServiceRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        ProjectDispatchConfigPO projectDispatchConfigPO = new ProjectDispatchConfigPO();
        projectDispatchConfigPO.setProjectCode(reqBO.getProjectCode());
        projectDispatchConfigPO = this.projectDispatchConfigMapper.getModelBy(projectDispatchConfigPO);
        if (projectDispatchConfigPO == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u5f53\u524d\u9879\u76ee\u7f16\u53f7\u6240\u5bf9\u5e94\u7684\u6d3e\u5355\u89c4\u5219\u4e3b\u4f53\u4fe1\u606f\uff01");
            return rspBO;
        }
        AgrQueryDispatchInfoBO dispatchInfoBO = new AgrQueryDispatchInfoBO();
        BeanUtils.copyProperties((Object)projectDispatchConfigPO, (Object)dispatchInfoBO);
        ProjectDispatchItemConfigPO projectDispatchItemConfigPO = new ProjectDispatchItemConfigPO();
        projectDispatchItemConfigPO.setProjectCode(projectDispatchConfigPO.getProjectCode());
        projectDispatchItemConfigPO.setDispatchRounds(projectDispatchConfigPO.getCurrentRounds());
        projectDispatchItemConfigPO.setRoundsState(AgrCommConstant.IsDelete.NORMAL.intValue());
        projectDispatchItemConfigPO.setWhetherExecutionCompleted(AgrCommConstant.PROJECT_ROUNDS_EXECUTE.IN_EXECUTION);
        if (StringUtils.hasText((String)reqBO.getEntAgreementCode())) {
            projectDispatchItemConfigPO.setEntAgreementCode(reqBO.getEntAgreementCode());
        }
        if (CollectionUtils.isEmpty(projectDispatchItemConfigPOS = this.projectDispatchItemConfigMapper.getList(projectDispatchItemConfigPO))) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u5f53\u524d\u9879\u76ee\u7f16\u53f7\u6240\u5bf9\u5e94\u7684\u6d3e\u5355\u8f6e\u6b21\u4fe1\u606f\uff01");
            return rspBO;
        }
        ArrayList dispatchRoundInfoBOS = new ArrayList();
        projectDispatchItemConfigPOS.forEach(po -> {
            AgrQueryDispatchRoundInfoBO dispatchRoundInfoBO = new AgrQueryDispatchRoundInfoBO();
            BeanUtils.copyProperties((Object)po, (Object)dispatchRoundInfoBO);
            dispatchRoundInfoBOS.add(dispatchRoundInfoBO);
        });
        List<String> contractCodes = dispatchRoundInfoBOS.stream().map(AgrQueryDispatchRoundInfoBO::getContractCode).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(contractCodes)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8f6e\u6b21\u5f53\u4e2d\u7684\u5408\u540c\u7f16\u7801\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        List<AgreementPO> agreementIdByContractCode = this.agreementMapper.getAgreementIdByContractCode(contractCodes);
        if (CollectionUtils.isEmpty(agreementIdByContractCode)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8f6e\u6b21\u5f53\u4e2d\u7684\u5408\u540c\u7f16\u7801\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u534f\u8bae\u4fe1\u606f\uff01");
            return rspBO;
        }
        Map<String, Long> contractCodeRealAgreement = agreementIdByContractCode.stream().collect(Collectors.toMap(AgreementPO::getExtContractCode, AgreementPO::getAgreementId, (a, b) -> a));
        dispatchRoundInfoBOS.forEach(bo -> {
            Long agreementId = (Long)contractCodeRealAgreement.get(bo.getContractCode());
            bo.setAgreementId(agreementId);
        });
        rspBO.setDispatchInfoBO(dispatchInfoBO);
        rspBO.setDispatchRoundInfoBOS(dispatchRoundInfoBOS);
        return rspBO;
    }

    private void checkParams(AgrQueryCurrentRoundDispatchRuleAbilityServiceReqBO reqBO) {
        if (reqBO == null) {
            throw new BusinessException("8888", "\u67e5\u8be2\u5f53\u524d\u8f6e\u6b21\u6d3e\u5355\u89c4\u5219\u5165\u53c2\u4e3a\u7a7a\uff01");
        }
        if (!StringUtils.hasText((String)reqBO.getProjectCode())) {
            throw new BusinessException("8888", "\u67e5\u8be2\u5f53\u524d\u8f6e\u6b21\u6d3e\u5355\u89c4\u5219\u9879\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

