/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.ability.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.agreement.ability.AgrQueryProjectLinkContractListAbilityService;
import com.tydic.agreement.ability.bo.AgrQueryProjectLinkContractListAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrQueryProjectLinkContractListAbilityRspBO;
import com.tydic.agreement.ability.bo.OpsContractInfoBO;
import com.tydic.agreement.dao.OpsContractMapper;
import com.tydic.agreement.dao.po.OpsContractPO;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_TEST/2.0.0/com.tydic.agreement.ability.AgrQueryProjectLinkContractListAbilityService"})
public class AgrQueryProjectLinkContractListAbilityServiceImpl
implements AgrQueryProjectLinkContractListAbilityService {
    @Autowired
    private OpsContractMapper opsContractMapper;
    @Value(value="${cnsc_org_id}")
    private Long cnscOrgId;

    @PostMapping(value={"queryProjectLinkContractList"})
    public AgrQueryProjectLinkContractListAbilityRspBO queryProjectLinkContractList(@RequestBody AgrQueryProjectLinkContractListAbilityReqBO reqBO) {
        AgrQueryProjectLinkContractListAbilityRspBO rspBO = new AgrQueryProjectLinkContractListAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        this.checkParams(reqBO);
        OpsContractPO opsContractPO = new OpsContractPO();
        opsContractPO.setPackCode(reqBO.getProjectCode());
        String yijijicai = "1";
        opsContractPO.setCenterPurchaseType(yijijicai);
        opsContractPO.setCreatorOrgId(this.cnscOrgId);
        List<OpsContractPO> opsContractPOList = this.opsContractMapper.getList(opsContractPO);
        if (CollectionUtils.isEmpty(opsContractPOList)) {
            return rspBO;
        }
        List<OpsContractInfoBO> opsContractInfoBOS = this.getOpsContractInfoBOS(opsContractPOList);
        rspBO.setOpsContractInfoBOS(opsContractInfoBOS);
        return rspBO;
    }

    private List<OpsContractInfoBO> getOpsContractInfoBOS(List<OpsContractPO> opsContractPOList) {
        ArrayList<OpsContractInfoBO> opsContractInfoBOS = new ArrayList<OpsContractInfoBO>();
        for (OpsContractPO contractPO : opsContractPOList) {
            OpsContractInfoBO opsContractInfoBO = new OpsContractInfoBO();
            opsContractInfoBO.setContractCode(contractPO.getContractCode());
            opsContractInfoBO.setContractName(contractPO.getContractName());
            opsContractInfoBO.setEntAgreementCode(contractPO.getCustomerContractCode());
            opsContractInfoBO.setSupplierId(contractPO.getVendorId());
            opsContractInfoBO.setSupplierName(contractPO.getVendorName());
            opsContractInfoBOS.add(opsContractInfoBO);
        }
        return opsContractInfoBOS;
    }

    private void checkParams(AgrQueryProjectLinkContractListAbilityReqBO reqBO) {
        if (reqBO == null) {
            throw new BusinessException("8888", "\u67e5\u8be2\u9879\u76ee\u5173\u8054\u5408\u540c\u5217\u8868\u4fe1\u606f\u5165\u53c2\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getProjectCode())) {
            throw new BusinessException("8888", "\u67e5\u8be2\u9879\u76ee\u5173\u8054\u5408\u540c\u5217\u8868\u4fe1\u606f\u9879\u76ee\u7f16\u53f7\u4e3a\u7a7a");
        }
    }
}

