/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.agreement.ability.AgrSsmGetQuotaDataTimeTaskService;
import com.tydic.agreement.ability.bo.AgrFormulaBO;
import com.tydic.agreement.ability.bo.AgrSsmGetQuotaDataTimeTaskReqBO;
import com.tydic.agreement.ability.bo.AgrSsmGetQuotaDataTimeTaskRspBO;
import com.tydic.agreement.ability.bo.QuotaDataOriginBO;
import com.tydic.agreement.ability.bo.QuotaListBO;
import com.tydic.agreement.atom.AgrDetailsSyncCommMsgAtomService;
import com.tydic.agreement.atom.bo.AgrDetailsSyncCommMsgAtomReqBO;
import com.tydic.agreement.dao.AgrFormulaLogMapper;
import com.tydic.agreement.dao.AgrFormulaMapper;
import com.tydic.agreement.dao.AgrFormulaVariableLogMapper;
import com.tydic.agreement.dao.AgrFormulaVariableMapper;
import com.tydic.agreement.dao.QuotaDataOriginMapper;
import com.tydic.agreement.dao.QuotaListMapper;
import com.tydic.agreement.dao.po.AgrFormulaLogPO;
import com.tydic.agreement.dao.po.AgrFormulaPO;
import com.tydic.agreement.dao.po.AgrFormulaVariableLogPO;
import com.tydic.agreement.dao.po.AgrFormulaVariablePO;
import com.tydic.agreement.dao.po.QuotaDataOriginPO;
import com.tydic.agreement.dao.po.QuotaListPO;
import com.tydic.agreement.extend.busi.CnncAgrUpdateSkuByFormulaService;
import com.tydic.agreement.extend.busi.bo.CnncAgrUpdateSkuByFormulaReqBO;
import com.tydic.agreement.extend.busi.bo.CnncAgrUpdateSkuByFormulaRspBO;
import com.tydic.agreement.external.ssm.SsmGetQuotaListService;
import com.tydic.agreement.external.ssm.SsmGetTokenService;
import com.tydic.agreement.external.ssm.bo.SsmGetQuotaListReqBO;
import com.tydic.agreement.external.ssm.bo.SsmGetQuotaListRspBO;
import com.tydic.agreement.external.ssm.bo.SsmGetTokenRspBO;
import com.tydic.commodity.bo.busi.SkuChangePriceBO;
import com.tydic.uccext.bo.CnncUccDealAgrMessageReqBo;
import com.tydic.uccext.bo.CnncUccDealAgrMessageRspBO;
import com.tydic.uccext.service.CnncDealAgrMessageAbilityService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_TEST/2.0.0/com.tydic.agreement.ability.AgrSsmGetQuotaDataTimeTaskService"})
public class AgrSsmGetQuotaDataTimeTaskServiceImpl
implements AgrSsmGetQuotaDataTimeTaskService {
    private static final Logger log = LoggerFactory.getLogger(AgrSsmGetQuotaDataTimeTaskServiceImpl.class);
    @Value(value="${SSM_COPPER_QUOTA:s20015437/s20015439/s20015438/s20015440/s20015441}")
    private String SSM_COPPER_QUOTA;
    @Value(value="${SSM_COPPER_QUOTA:s20016448/s20016450/s20016449/s20016451/s20016452}")
    private String SSM_AL_QUOTA;
    private static final String SSM_COPPER_QUOTA_IDS = "s20015437,s20015439,s20015438,s20015440,s20015441";
    private static final String SSM_AL_QUOTA_IDS = "s20016448,s20016450,s20016449,s20016451,s20016452";
    @Value(value="${SMM1_COPPER:SMM\u4e00\u53f7\u7535\u89e3\u94dc\u5747\u4ef7}")
    private String SMM1_COPPER = "SMM\u4e00\u53f7\u7535\u89e3\u94dc\u5747\u4ef7";
    @Value(value="${SMMA00_AL:SMMA00\u94dd\u5747\u4ef7}")
    private String SMMA00_AL = "SMMA00\u94dd\u5747\u4ef7";
    @Autowired
    private SsmGetQuotaListService ssmGetQuotaListService;
    @Autowired
    private SsmGetTokenService ssmGetTokenService;
    @Autowired
    private CnncAgrUpdateSkuByFormulaService cnncAgrUpdateSkuByFormulaService;
    @Autowired
    private CnncDealAgrMessageAbilityService cnncDealAgrMessageAbilityService;
    @Autowired
    private QuotaDataOriginMapper quotaDataOriginMapper;
    @Autowired
    private QuotaListMapper quotaListMapper;
    @Autowired
    private AgrFormulaMapper agrFormulaMapper;
    @Autowired
    private AgrFormulaVariableMapper agrFormulaVariableMapper;
    @Autowired
    private AgrFormulaLogMapper agrFormulaLogMapper;
    @Autowired
    private AgrFormulaVariableLogMapper agrFormulaVariableLogMapper;
    @Autowired
    private AgrDetailsSyncCommMsgAtomService agrDetailsSyncCommMsgAtomService;

    @PostMapping(value={"timeTask"})
    public AgrSsmGetQuotaDataTimeTaskRspBO timeTask(@RequestBody AgrSsmGetQuotaDataTimeTaskReqBO reqBO) {
        SsmGetTokenRspBO ssmGetTokenRspBO;
        AgrSsmGetQuotaDataTimeTaskRspBO rspBO = new AgrSsmGetQuotaDataTimeTaskRspBO();
        HashMap<String, QuotaDataOriginBO> quotaDataOriginPOMap = new HashMap<String, QuotaDataOriginBO>();
        Calendar current = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String date = sdf.format(current.getTime());
        SsmGetQuotaListReqBO ssmGetQuotaListReqBO = new SsmGetQuotaListReqBO();
        ssmGetQuotaListReqBO.setStartDate(date);
        ssmGetQuotaListReqBO.setEndDate(date);
        if (!StringUtils.isBlank((CharSequence)reqBO.getEndDate())) {
            ssmGetQuotaListReqBO.setEndDate(reqBO.getEndDate());
        }
        if (!StringUtils.isBlank((CharSequence)reqBO.getStartDate())) {
            ssmGetQuotaListReqBO.setStartDate(reqBO.getStartDate());
        }
        if (!StringUtils.isBlank((CharSequence)reqBO.getQuotaIds())) {
            ssmGetQuotaListReqBO.setQuotaIds(reqBO.getQuotaIds());
        }
        if (!(ssmGetTokenRspBO = this.ssmGetTokenService.getToken()).getRespCode().equals("0000") || StringUtils.isBlank((CharSequence)ssmGetTokenRspBO.getToken())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("token \u83b7\u53d6\u5931\u8d25!" + ssmGetTokenRspBO.getRespDesc());
            return rspBO;
        }
        ssmGetQuotaListReqBO.setToken(ssmGetTokenRspBO.getToken());
        ssmGetQuotaListReqBO.setQuotaIds(SSM_COPPER_QUOTA_IDS);
        SsmGetQuotaListRspBO ssmGetQuotaListRspBO1 = this.ssmGetQuotaListService.getQuotaList(ssmGetQuotaListReqBO);
        if (ssmGetQuotaListRspBO1.getRespCode().equals("0000")) {
            this.processData(ssmGetQuotaListRspBO1.getData(), quotaDataOriginPOMap);
        }
        ssmGetQuotaListReqBO.setQuotaIds(SSM_AL_QUOTA_IDS);
        SsmGetQuotaListRspBO ssmGetQuotaListRspBO2 = this.ssmGetQuotaListService.getQuotaList(ssmGetQuotaListReqBO);
        if (ssmGetQuotaListRspBO2.getRespCode().equals("0000")) {
            this.processData(ssmGetQuotaListRspBO2.getData(), quotaDataOriginPOMap);
        }
        ArrayList<QuotaDataOriginBO> changeList = new ArrayList();
        if (reqBO.getCheckFlag().equals(0)) {
            changeList = this.compare(quotaDataOriginPOMap);
        }
        this.insertData(ssmGetQuotaListRspBO2.getData());
        this.insertData(ssmGetQuotaListRspBO1.getData());
        if (!CollectionUtils.isEmpty(changeList) && Objects.equals(reqBO.getCheckFlag(), 0)) {
            AgrFormulaPO agrFormulaPO = new AgrFormulaPO();
            ArrayList<String> VariableList = new ArrayList<String>();
            VariableList.add(this.SMM1_COPPER);
            VariableList.add(this.SMMA00_AL);
            agrFormulaPO.setContainsVariable(VariableList);
            agrFormulaPO.setStatus("1");
            List<AgrFormulaPO> agrFormulaPOS = this.agrFormulaMapper.selectByConditionPage(agrFormulaPO, (Page<AgrFormulaBO>)new Page(-1, -1));
            if (CollectionUtils.isEmpty(agrFormulaPOS)) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6210\u529f!");
                return rspBO;
            }
            ArrayList<Long> FormulaIds = new ArrayList<Long>();
            agrFormulaPOS.forEach(agrFormulaPO1 -> FormulaIds.add(agrFormulaPO1.getFormulaId()));
            AgrFormulaVariablePO agrFormulaVariablePO = new AgrFormulaVariablePO();
            agrFormulaVariablePO.setFormulaIds(FormulaIds);
            List<AgrFormulaVariablePO> agrFormulaVariablePOList = this.agrFormulaVariableMapper.selectByCondition(agrFormulaVariablePO);
            Map agrFormulaVariablePOMap = agrFormulaVariablePOList.stream().collect(Collectors.toMap(AgrFormulaVariablePO::getFormulaId, Function.identity(), (key1, key2) -> key2));
            CnncAgrUpdateSkuByFormulaReqBO cnncAgrUpdateSkuByFormulaReqBO = new CnncAgrUpdateSkuByFormulaReqBO();
            for (AgrFormulaPO po : agrFormulaPOS) {
                try {
                    if (agrFormulaVariablePOMap.get(po.getFormulaId()) != null) {
                        AgrFormulaVariablePO agrFormulaVariablePO1 = (AgrFormulaVariablePO)agrFormulaVariablePOMap.get(po.getFormulaId());
                        this.updateAgrFormulaVariable(agrFormulaVariablePO1, changeList, po);
                    }
                    cnncAgrUpdateSkuByFormulaReqBO.setFormulaId(po.getFormulaId());
                    CnncAgrUpdateSkuByFormulaRspBO cnncAgrUpdateSkuByFormulaRspBO = this.cnncAgrUpdateSkuByFormulaService.updateSkuByFormula(cnncAgrUpdateSkuByFormulaReqBO);
                    if (!"0000".equals(cnncAgrUpdateSkuByFormulaRspBO.getRespCode())) {
                        log.error("\u516c\u5f0f[" + po.getFormulaId() + "]SMM\u4ef7\u683c\u53d8\u5316\u8c03\u4ef7\u5931\u8d25:" + cnncAgrUpdateSkuByFormulaRspBO.getRespDesc());
                        continue;
                    }
                    if (CollectionUtils.isEmpty((Collection)cnncAgrUpdateSkuByFormulaRspBO.getSkuChangePriceBOs())) continue;
                    List skuChangePriceBOS = JSON.parseArray((String)JSON.toJSONString((Object)cnncAgrUpdateSkuByFormulaRspBO.getSkuChangePriceBOs()), SkuChangePriceBO.class);
                    CnncUccDealAgrMessageReqBo cnncUccDealAgrMessageReqBo = new CnncUccDealAgrMessageReqBo();
                    int j = Math.min(skuChangePriceBOS.size(), 10);
                    for (int i = 0; i < skuChangePriceBOS.size(); i += 10) {
                        List subList = skuChangePriceBOS.subList(i, j);
                        cnncUccDealAgrMessageReqBo.setSkuChangePriceBOs(subList);
                        log.debug("\u5546\u54c1\u540c\u6b65\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)cnncUccDealAgrMessageReqBo));
                        CnncUccDealAgrMessageRspBO cnncUccDealAgrMessageRspBO = this.cnncDealAgrMessageAbilityService.dealMessage(cnncUccDealAgrMessageReqBo);
                        log.debug("\u5546\u54c1\u540c\u6b65\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)cnncUccDealAgrMessageRspBO));
                        if (!"0000".equals(cnncUccDealAgrMessageRspBO.getRespCode())) {
                            log.error("SMM\u4ef7\u683c\u53d8\u5316\u516c\u5f0f\u57fa\u51c6\u540c\u6b65\u5546\u54c1\u5931\u8d25:" + cnncUccDealAgrMessageRspBO.getRespDesc());
                            throw new BusinessException("8888", "SMM\u4ef7\u683c\u53d8\u5316\u516c\u5f0f\u57fa\u51c6\u540c\u6b65\u5546\u54c1\u5931\u8d25:" + cnncUccDealAgrMessageRspBO.getRespDesc());
                        }
                        j = Math.min(j + 10, skuChangePriceBOS.size());
                    }
                    try {
                        List<Long> agrDetailIds = cnncAgrUpdateSkuByFormulaRspBO.getSkuChangePriceBOs().stream().map(e -> e.getAgreementSkuId()).collect(Collectors.toList());
                        AgrDetailsSyncCommMsgAtomReqBO agrDetailsSyncCommMsgAtomReqBO = new AgrDetailsSyncCommMsgAtomReqBO();
                        agrDetailsSyncCommMsgAtomReqBO.setAgrDetailIds(agrDetailIds);
                        this.agrDetailsSyncCommMsgAtomService.syncCommMsg(agrDetailsSyncCommMsgAtomReqBO);
                    }
                    catch (Exception e2) {
                        log.error("\u540c\u6b65\u534f\u8bae\u660e\u7ec6\u81f3\u5546\u54c1\u4e2d\u5fc3\u5f02\u5e38 {}", (Object)e2.getMessage());
                    }
                }
                catch (Exception e3) {
                    log.error("\u516c\u5f0f[" + po.getFormulaId() + "]SMM\u4ef7\u683c\u53d8\u5316\u8c03\u4ef7\u5f02\u5e38:", (Throwable)e3);
                    throw new BusinessException("8888", "\u516c\u5f0f[" + po.getFormulaId() + "]SMM\u4ef7\u683c\u53d8\u5316\u8c03\u4ef7\u5f02\u5e38:" + e3.getMessage());
                }
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f!");
        return rspBO;
    }

    private void processData(List<QuotaListBO> data, Map<String, QuotaDataOriginBO> quotaDataOriginPOMap) {
        for (QuotaListBO quotaListBO : data) {
            QuotaListPO quotaListPO = this.quotaListMapper.selectByPrimaryKey(quotaListBO.getQuotaId());
            if (quotaListPO == null) {
                quotaListPO = (QuotaListPO)JSON.parseObject((String)JSON.toJSONString((Object)quotaListBO), QuotaListPO.class);
                this.quotaListMapper.insert(quotaListPO);
            }
            if (CollectionUtils.isEmpty((Collection)quotaListBO.getData())) continue;
            for (QuotaDataOriginBO quotaDataOriginBO : quotaListBO.getData()) {
                quotaDataOriginBO.setQuotaId(quotaListBO.getQuotaId());
                if (!quotaDataOriginBO.getQuotaId().equals("s20016448") && !quotaDataOriginBO.getQuotaId().equals("s20015437")) continue;
                quotaDataOriginPOMap.put(quotaDataOriginBO.getQuotaId(), quotaDataOriginBO);
            }
        }
    }

    private void insertData(List<QuotaListBO> data) {
        for (QuotaListBO quotaListBO : data) {
            if (CollectionUtils.isEmpty((Collection)quotaListBO.getData())) continue;
            List insertList = JSON.parseArray((String)JSON.toJSONString((Object)quotaListBO.getData()), QuotaDataOriginPO.class);
            for (QuotaDataOriginPO quotaDataOriginPO : insertList) {
                quotaDataOriginPO.setQuotaId(quotaListBO.getQuotaId());
                this.quotaDataOriginMapper.deleteByBatch(quotaDataOriginPO.getQuotaId(), null, quotaDataOriginPO.getDate());
            }
            if (CollectionUtils.isEmpty((Collection)insertList)) continue;
            this.quotaDataOriginMapper.insertBatch(insertList);
        }
    }

    private List<QuotaDataOriginBO> compare(Map<String, QuotaDataOriginBO> quotaDataOriginPOMap) {
        ArrayList<QuotaDataOriginBO> changeList = new ArrayList<QuotaDataOriginBO>();
        if (CollectionUtils.isEmpty(quotaDataOriginPOMap)) {
            return changeList;
        }
        ArrayList<String> quotaIds = new ArrayList<String>(quotaDataOriginPOMap.keySet());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar current = Calendar.getInstance();
        current.add(5, 1);
        List<QuotaDataOriginBO> quotaDataOriginBOS = null;
        for (String str : quotaIds) {
            try {
                String s;
                Date date;
                do {
                    current.add(5, -1);
                } while (CollectionUtils.isEmpty(quotaDataOriginBOS = this.quotaDataOriginMapper.selectListByDate(str, null, date = sdf.parse(s = sdf.format(current.getTime())))));
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("\u5b9a\u65f6\u4efb\u52a1\u6bd4\u8f83\u53d8\u5316\u6307\u6807\u9519\u8bef:" + e);
                return changeList;
            }
            if (CollectionUtils.isEmpty(quotaDataOriginBOS)) continue;
            for (QuotaDataOriginBO quotaDataOriginBO : quotaDataOriginBOS) {
                if (!quotaDataOriginPOMap.containsKey(quotaDataOriginBO.getQuotaId())) continue;
                QuotaDataOriginBO quotaDataOriginPO = quotaDataOriginPOMap.get(quotaDataOriginBO.getQuotaId());
                if (quotaDataOriginBO.getValue().equals(quotaDataOriginPO.getValue())) continue;
                changeList.add(quotaDataOriginPO);
            }
        }
        return changeList;
    }

    private void updateAgrFormulaVariable(AgrFormulaVariablePO variablePO, List<QuotaDataOriginBO> changeList, AgrFormulaPO po) {
        AgrFormulaVariablePO agrFormulaVariablePO = new AgrFormulaVariablePO();
        agrFormulaVariablePO.setFormulaId(variablePO.getFormulaId());
        BeanUtils.copyProperties((Object)variablePO, (Object)agrFormulaVariablePO);
        for (QuotaDataOriginBO quotaDataOriginBO : changeList) {
            if (variablePO.getNameA() != null && variablePO.getNameA().equals(this.SMM1_COPPER) && quotaDataOriginBO.getQuotaId().equals("s20015437")) {
                agrFormulaVariablePO.setVariableA(quotaDataOriginBO.getValue());
            }
            if (variablePO.getNameB() != null && variablePO.getNameB().equals(this.SMM1_COPPER) && quotaDataOriginBO.getQuotaId().equals("s20015437")) {
                agrFormulaVariablePO.setVariableB(quotaDataOriginBO.getValue());
            }
            if (variablePO.getNameC() != null && variablePO.getNameC().equals(this.SMM1_COPPER) && quotaDataOriginBO.getQuotaId().equals("s20015437")) {
                agrFormulaVariablePO.setVariableC(quotaDataOriginBO.getValue());
            }
            if (variablePO.getNameD() != null && variablePO.getNameD().equals(this.SMM1_COPPER) && quotaDataOriginBO.getQuotaId().equals("s20015437")) {
                agrFormulaVariablePO.setVariableD(quotaDataOriginBO.getValue());
            }
            if (variablePO.getNameE() != null && variablePO.getNameE().equals(this.SMM1_COPPER) && quotaDataOriginBO.getQuotaId().equals("s20015437")) {
                agrFormulaVariablePO.setVariableE(quotaDataOriginBO.getValue());
            }
            if (variablePO.getNameA() != null && variablePO.getNameA().equals(this.SMMA00_AL) && quotaDataOriginBO.getQuotaId().equals("s20016448")) {
                agrFormulaVariablePO.setVariableA(quotaDataOriginBO.getValue());
            }
            if (variablePO.getNameB() != null && variablePO.getNameB().equals(this.SMMA00_AL) && quotaDataOriginBO.getQuotaId().equals("s20016448")) {
                agrFormulaVariablePO.setVariableB(quotaDataOriginBO.getValue());
            }
            if (variablePO.getNameC() != null && variablePO.getNameC().equals(this.SMMA00_AL) && quotaDataOriginBO.getQuotaId().equals("s20016448")) {
                agrFormulaVariablePO.setVariableC(quotaDataOriginBO.getValue());
            }
            if (variablePO.getNameD() != null && variablePO.getNameD().equals(this.SMMA00_AL) && quotaDataOriginBO.getQuotaId().equals("s20016448")) {
                agrFormulaVariablePO.setVariableD(quotaDataOriginBO.getValue());
            }
            if (agrFormulaVariablePO.getNameE() != null && agrFormulaVariablePO.getNameE().equals(this.SMMA00_AL) && quotaDataOriginBO.getQuotaId().equals("s20016448")) {
                agrFormulaVariablePO.setVariableE(quotaDataOriginBO.getValue());
            }
            if (StringUtils.isBlank((CharSequence)agrFormulaVariablePO.getVariableA()) && StringUtils.isBlank((CharSequence)agrFormulaVariablePO.getVariableB()) && StringUtils.isBlank((CharSequence)agrFormulaVariablePO.getVariableC()) && StringUtils.isBlank((CharSequence)agrFormulaVariablePO.getVariableD()) && StringUtils.isBlank((CharSequence)agrFormulaVariablePO.getVariableE())) continue;
            this.agrFormulaVariableMapper.update(agrFormulaVariablePO);
        }
        AgrFormulaVariableLogPO insertAgrFormulaVariableLogPO = new AgrFormulaVariableLogPO();
        BeanUtils.copyProperties((Object)agrFormulaVariablePO, (Object)insertAgrFormulaVariableLogPO);
        long id2 = Sequence.getInstance().nextId();
        insertAgrFormulaVariableLogPO.setVariableLogId(id2);
        this.agrFormulaVariableLogMapper.insert(insertAgrFormulaVariableLogPO);
        AgrFormulaLogPO insertAgrFormulaLogPO = new AgrFormulaLogPO();
        BeanUtils.copyProperties((Object)variablePO, (Object)insertAgrFormulaLogPO);
        long id = Sequence.getInstance().nextId();
        insertAgrFormulaLogPO.setFormulaLogId(id);
        insertAgrFormulaLogPO.setVariableLogId(id2);
        insertAgrFormulaLogPO.setCreateTime(new Date());
        insertAgrFormulaLogPO.setChangeType("2");
        insertAgrFormulaLogPO.setStatus("1");
        insertAgrFormulaLogPO.setOperTime(new Date());
        insertAgrFormulaLogPO.setOperId("1");
        insertAgrFormulaLogPO.setOperName("SMM\u5b9a\u65f6\u4efb\u52a1");
        insertAgrFormulaLogPO.setFormulaContent(po.getFormulaContent());
        insertAgrFormulaLogPO.setFormulaName(po.getFormulaName());
        insertAgrFormulaLogPO.setEffTime(po.getEffTime());
        insertAgrFormulaLogPO.setExpTime(po.getExpTime());
        this.agrFormulaLogMapper.insert(insertAgrFormulaLogPO);
    }
}

