/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.agreement.ability.AgrStandardSpuSyncApplyInfoAbilityService;
import com.tydic.agreement.ability.bo.AgrBusiRedoQueueBO;
import com.tydic.agreement.ability.bo.AgrBusiRedoReqBO;
import com.tydic.agreement.ability.bo.AgrStandardSpuBindInfoBO;
import com.tydic.agreement.ability.bo.AgrStandardSpuSyncApplyInfoAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrStandardSpuSyncApplyInfoAbilityRspBO;
import com.tydic.agreement.busi.AgrBusiRedoBusiService;
import com.tydic.agreement.constant.AgrBusiRedoTypeEnum;
import com.tydic.agreement.constant.AgrEnum;
import com.tydic.agreement.dao.AgreementSkuMapper;
import com.tydic.agreement.dao.po.AgreementSkuPO;
import com.tydic.agreement.external.ucc.AgrExternalStandardSpuSyncService;
import com.tydic.agreement.external.ucc.bo.AgrExternalStandardSpuSyncApplyInfoDataBO;
import com.tydic.agreement.external.ucc.bo.AgrExternalStandardSpuSyncApplyInfoReqBO;
import com.tydic.agreement.external.ucc.bo.AgrExternalStandardSpuSyncApplyInfoRspBO;
import com.tydic.agreement.external.ucc.bo.AgrExternalStandardSpuSyncApplyInfoSkuInfoBO;
import com.tydic.uccext.enums.UccStandardSpuStatusEnum;
import com.tydic.uccext.enums.UccStandardSpuSyncApplySkuTypeEnum;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class AgrStandardSpuSyncApplyInfoAbilityServiceImpl
implements AgrStandardSpuSyncApplyInfoAbilityService {
    @Value(value="${EComSkuHomePageUrlPrefix:}")
    private String homePageUrlPrefix;
    @Autowired
    private AgreementSkuMapper agreementSkuMapper;
    @Autowired
    private AgrExternalStandardSpuSyncService agrExternalStandardSpuSyncService;
    @Autowired
    private AgrBusiRedoBusiService agrBusiRedoBusiService;

    @Override
    public Future<AgrStandardSpuSyncApplyInfoAbilityRspBO> syncApplyInfo(AgrStandardSpuSyncApplyInfoAbilityReqBO reqBO) {
        AgrStandardSpuSyncApplyInfoAbilityRspBO rspBO = new AgrStandardSpuSyncApplyInfoAbilityRspBO();
        if (reqBO == null || CollectionUtils.isEmpty(reqBO.getBindInfoList())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u6c42\u5fc5\u4f20\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            return AsyncResult.forValue((Object)((Object)rspBO));
        }
        Map<Long, AgrStandardSpuBindInfoBO> bindInfoMap = reqBO.getBindInfoList().stream().filter(bo -> bo.getAgreementSkuId() != null).collect(Collectors.toMap(AgrStandardSpuBindInfoBO::getAgreementSkuId, obj -> obj, (a, b) -> a));
        if (CollectionUtils.isEmpty(bindInfoMap)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u6c42\u53c2\u6570\u9519\u8bef");
            return AsyncResult.forValue((Object)((Object)rspBO));
        }
        int pageSize = 50;
        int totalPage = 1;
        Page page = new Page();
        for (int pageNo = 1; pageNo <= totalPage; ++pageNo) {
            page.setPageNo(pageNo);
            page.setPageSize(pageSize);
            List<AgreementSkuPO> agreementSkuPOS = this.agreementSkuMapper.getAgrSkuSpuInfoList(new ArrayList<Long>(bindInfoMap.keySet()), (Page<AgreementSkuPO>)page);
            totalPage = page.getTotalPages();
            Map<String, List<AgreementSkuPO>> collectCatalog = agreementSkuPOS.stream().collect(Collectors.groupingBy(AgreementSkuPO::getThirdCatalogId));
            collectCatalog.forEach((l3CatalogCode, skuList) -> {
                AgrExternalStandardSpuSyncApplyInfoReqBO agrExternalStandardSpuSyncApplyInfoReqBO = new AgrExternalStandardSpuSyncApplyInfoReqBO();
                AgrExternalStandardSpuSyncApplyInfoDataBO standardCommoditySyncApplyInfoDataBO = new AgrExternalStandardSpuSyncApplyInfoDataBO();
                standardCommoditySyncApplyInfoDataBO.setSerialNo(Long.toString(Sequence.getInstance().nextId()));
                standardCommoditySyncApplyInfoDataBO.setPoolName("CNNC");
                standardCommoditySyncApplyInfoDataBO.setCategoryCode((String)l3CatalogCode);
                standardCommoditySyncApplyInfoDataBO.setCategoryName("");
                ArrayList<AgrExternalStandardSpuSyncApplyInfoSkuInfoBO> standardCommoditySyncApplyInfoSkuInfoBOS = new ArrayList<AgrExternalStandardSpuSyncApplyInfoSkuInfoBO>();
                skuList.forEach(skuPO -> {
                    AgrExternalStandardSpuSyncApplyInfoSkuInfoBO standardCommoditySyncApplyInfoSkuInfoBO;
                    AgrStandardSpuBindInfoBO agrStandardSpuBindInfoBO = (AgrStandardSpuBindInfoBO)bindInfoMap.get(skuPO.getAgreementSkuId());
                    if (StringUtils.hasText((String)agrStandardSpuBindInfoBO.getUnbindSpuId())) {
                        standardCommoditySyncApplyInfoSkuInfoBO = this.getSyncApplyInfoSkuInfoBO((AgreementSkuPO)skuPO);
                        standardCommoditySyncApplyInfoSkuInfoBO.setVCommodityId(agrStandardSpuBindInfoBO.getUnbindSpuId());
                        standardCommoditySyncApplyInfoSkuInfoBO.setIsBind(AgrEnum.YesOrNo.NO.getCode().toString());
                        standardCommoditySyncApplyInfoSkuInfoBO.setSkuStatus(UccStandardSpuStatusEnum.PUSH_TO_SPU_STATUS_OFF_SHELVES.getStatus());
                        standardCommoditySyncApplyInfoSkuInfoBOS.add(standardCommoditySyncApplyInfoSkuInfoBO);
                    }
                    if (StringUtils.hasText((String)agrStandardSpuBindInfoBO.getBindSpuId())) {
                        standardCommoditySyncApplyInfoSkuInfoBO = this.getSyncApplyInfoSkuInfoBO((AgreementSkuPO)skuPO);
                        standardCommoditySyncApplyInfoSkuInfoBO.setVCommodityId(agrStandardSpuBindInfoBO.getBindSpuId());
                        standardCommoditySyncApplyInfoSkuInfoBO.setIsBind(AgrEnum.YesOrNo.YES.getCode().toString());
                        standardCommoditySyncApplyInfoSkuInfoBO.setSkuStatus(UccStandardSpuStatusEnum.PUSH_TO_SPU_STATUS_ON_SHELVES.getStatus());
                        standardCommoditySyncApplyInfoSkuInfoBOS.add(standardCommoditySyncApplyInfoSkuInfoBO);
                    }
                });
                standardCommoditySyncApplyInfoDataBO.setSkuInfos(standardCommoditySyncApplyInfoSkuInfoBOS);
                if (!CollectionUtils.isEmpty(standardCommoditySyncApplyInfoSkuInfoBOS)) {
                    agrExternalStandardSpuSyncApplyInfoReqBO.setData(standardCommoditySyncApplyInfoDataBO);
                    AgrExternalStandardSpuSyncApplyInfoRspBO agrExternalStandardSpuSyncApplyInfoRspBO = this.agrExternalStandardSpuSyncService.syncApplyInfo(agrExternalStandardSpuSyncApplyInfoReqBO);
                    if (!"0000".equals(agrExternalStandardSpuSyncApplyInfoRspBO.getRespCode())) {
                        AgrBusiRedoReqBO agrBusiRedoReqBo = new AgrBusiRedoReqBO();
                        AgrBusiRedoQueueBO agrBusiRedoQueueBo = new AgrBusiRedoQueueBO();
                        agrBusiRedoQueueBo.setBusiType(Integer.valueOf(AgrBusiRedoTypeEnum.SPU_SYNC_APPLY_INFO.getTypeCode()));
                        agrBusiRedoQueueBo.setRequestParam(JSONObject.toJSONString((Object)agrExternalStandardSpuSyncApplyInfoReqBO));
                        agrBusiRedoReqBo.setBusiRedoQueue(agrBusiRedoQueueBo);
                        this.agrBusiRedoBusiService.addRedoTask(agrBusiRedoReqBo);
                    }
                }
            });
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return AsyncResult.forValue((Object)((Object)rspBO));
    }

    private AgrExternalStandardSpuSyncApplyInfoSkuInfoBO getSyncApplyInfoSkuInfoBO(AgreementSkuPO agreementSkuPO) {
        AgrExternalStandardSpuSyncApplyInfoSkuInfoBO standardCommoditySyncApplyInfoSkuInfoBO = new AgrExternalStandardSpuSyncApplyInfoSkuInfoBO();
        standardCommoditySyncApplyInfoSkuInfoBO.setSkuId(agreementSkuPO.getAgreementSkuId().toString());
        standardCommoditySyncApplyInfoSkuInfoBO.setType(UccStandardSpuSyncApplySkuTypeEnum.AGR_ITEM.getType());
        standardCommoditySyncApplyInfoSkuInfoBO.setSkuName(agreementSkuPO.getItemName());
        standardCommoditySyncApplyInfoSkuInfoBO.setShopId(String.valueOf(agreementSkuPO.getVendorId()));
        standardCommoditySyncApplyInfoSkuInfoBO.setShopName(agreementSkuPO.getVendorName());
        standardCommoditySyncApplyInfoSkuInfoBO.setBrandName(agreementSkuPO.getBrandName());
        standardCommoditySyncApplyInfoSkuInfoBO.setMarketPrice(0L);
        standardCommoditySyncApplyInfoSkuInfoBO.setSalesPrice(agreementSkuPO.getSalePrice());
        standardCommoditySyncApplyInfoSkuInfoBO.setStrikePrice(0L);
        standardCommoditySyncApplyInfoSkuInfoBO.setOrderPrice(0L);
        standardCommoditySyncApplyInfoSkuInfoBO.setPurchasePrice(agreementSkuPO.getBuyPrice());
        standardCommoditySyncApplyInfoSkuInfoBO.setLinkUrl(this.homePageUrlPrefix + agreementSkuPO.getAgreementSkuId() + "?supId=" + agreementSkuPO.getSpuId());
        return standardCommoditySyncApplyInfoSkuInfoBO;
    }
}

