/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.agreement.ability.AgrSyncBusiPropLabelAbilityService;
import com.tydic.agreement.ability.bo.AgrBusiRedoQueueBO;
import com.tydic.agreement.ability.bo.AgrBusiRedoReqBO;
import com.tydic.agreement.ability.bo.AgrSyncBusiPropLabelAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrSyncBusiPropLabelAbilityRspBO;
import com.tydic.agreement.busi.AgrBusiRedoBusiService;
import com.tydic.agreement.busi.AgrSyncBusiPropLabelBusiService;
import com.tydic.agreement.constant.AgrBusiRedoTypeEnum;
import com.tydic.agreement.constant.AgrCommConstant;
import com.tydic.agreement.dao.AgrRelBusiPropLabelMapper;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.po.AgrRelBusiPropLabelPO;
import com.tydic.agreement.dao.po.AgreementPO;
import com.tydic.uccext.bo.UccExtSyncBusiPropLabelFromAgreementOrContractReqBO;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class AgrSyncBusiPropLabelAbilityServiceImpl
implements AgrSyncBusiPropLabelAbilityService {
    private static final Logger log = LoggerFactory.getLogger(AgrSyncBusiPropLabelAbilityServiceImpl.class);
    @Value(value="${SYNC_BUSI_PROP_LABEL_TOPIC}")
    private String topic;
    @Value(value="${SYNC_BUSI_PROP_LABEL_TAG}")
    private String tag;
    @Resource(name="syncAgreementBusiPropLabelProvider")
    private ProxyMessageProducer syncAgreementBusiPropLabelProvider;
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgrRelBusiPropLabelMapper agrRelBusiPropLabelMapper;
    @Autowired
    private AgrSyncBusiPropLabelBusiService agrSyncBusiPropLabelBusiService;
    @Autowired
    private AgrBusiRedoBusiService agrBusiRedoBusiService;

    @Override
    public AgrSyncBusiPropLabelAbilityRspBO dealSyncBusiPropLabel(AgrSyncBusiPropLabelAbilityReqBO reqBo) {
        AgrSyncBusiPropLabelAbilityRspBO rspBo = new AgrSyncBusiPropLabelAbilityRspBO();
        if (reqBo == null || CollectionUtils.isEmpty((Map)reqBo.getAgreementIds())) {
            rspBo.setRespCode("0001");
            rspBo.setRespDesc("\u8bf7\u6c42\u5fc5\u4f20\u53c2\u6570\u534f\u8baeID\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        Set<Object> agrIds = reqBo.getAgreementIds().keySet();
        if (StringUtils.hasText((String)reqBo.getSyncSource()) && "change".equals(reqBo.getSyncSource())) {
            AgreementPO agreementPo = new AgreementPO();
            agreementPo.setAgreementIds(new ArrayList<Long>(agrIds));
            agreementPo.setAgreementMode(AgrCommConstant.agreementMode.PLAT_AGREEMENT);
            agreementPo.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
            List<AgreementPO> list = this.agreementMapper.getList(agreementPo);
            agrIds = !CollectionUtils.isEmpty(list) ? list.stream().map(AgreementPO::getAgreementId).collect(Collectors.toSet()) : new HashSet();
            for (Map.Entry entry : reqBo.getAgreementIds().entrySet()) {
                Long agrId2 = (Long)entry.getKey();
                Byte changeType = (Byte)entry.getValue();
                if (!AgrCommConstant.AgreementChangeType.SUPPLEMENT.equals(changeType)) continue;
                agrIds.add(agrId2);
            }
        }
        if (!CollectionUtils.isEmpty(agrIds)) {
            AgrRelBusiPropLabelPO agrRelBusiPropLabelPo = new AgrRelBusiPropLabelPO();
            agrRelBusiPropLabelPo.setAgreementIdIn(new ArrayList<Long>(agrIds));
            List<AgrRelBusiPropLabelPO> relBusiPropLabelPos = this.agrRelBusiPropLabelMapper.getList(agrRelBusiPropLabelPo);
            if (!CollectionUtils.isEmpty(relBusiPropLabelPos)) {
                Map<Long, List<AgrRelBusiPropLabelPO>> collectLabelByAgrId = relBusiPropLabelPos.stream().collect(Collectors.groupingBy(AgrRelBusiPropLabelPO::getAgreementId));
                collectLabelByAgrId.forEach((agrId, labels) -> {
                    Integer version = labels.stream().map(AgrRelBusiPropLabelPO::getVersion).max(Comparator.comparing(Integer::intValue)).orElse(null);
                    if (version != null) {
                        UccExtSyncBusiPropLabelFromAgreementOrContractReqBO uccExtSyncBusiPropLabelFromAgreementOrContractReqBo = new UccExtSyncBusiPropLabelFromAgreementOrContractReqBO();
                        BeanUtils.copyProperties((Object)reqBo, (Object)uccExtSyncBusiPropLabelFromAgreementOrContractReqBo);
                        uccExtSyncBusiPropLabelFromAgreementOrContractReqBo.setSourceCenter(UccExtSyncBusiPropLabelFromAgreementOrContractReqBO.SourceCenter.AGREEMENT);
                        UccExtSyncBusiPropLabelFromAgreementOrContractReqBO.BusiPropLabelSourceBO busiPropLabelSourceBo = new UccExtSyncBusiPropLabelFromAgreementOrContractReqBO.BusiPropLabelSourceBO();
                        busiPropLabelSourceBo.setSourceId(agrId);
                        busiPropLabelSourceBo.setVersion(version);
                        Byte changeType = (Byte)reqBo.getAgreementIds().get(agrId);
                        if (changeType == null) {
                            busiPropLabelSourceBo.setAgrOperType(UccExtSyncBusiPropLabelFromAgreementOrContractReqBO.AgrOperType.ADD);
                        } else if (AgrCommConstant.AgreementChangeType.SUPPLEMENT.equals(changeType)) {
                            busiPropLabelSourceBo.setAgrOperType(UccExtSyncBusiPropLabelFromAgreementOrContractReqBO.AgrOperType.SUPPLEMENT_CHANGE);
                        } else if (AgrCommConstant.AgreementChangeType.OTHER.equals(changeType) || AgrCommConstant.AgreementChangeType.OPS_CHANGE.equals(changeType)) {
                            busiPropLabelSourceBo.setAgrOperType(UccExtSyncBusiPropLabelFromAgreementOrContractReqBO.AgrOperType.OTHER_CHANGE);
                        }
                        uccExtSyncBusiPropLabelFromAgreementOrContractReqBo.setLabelSource(busiPropLabelSourceBo);
                        String msgId = null;
                        try {
                            ProxySendResult proxySendResult = this.syncAgreementBusiPropLabelProvider.send(new ProxyMessage(this.topic, this.tag, JSONObject.toJSONString((Object)uccExtSyncBusiPropLabelFromAgreementOrContractReqBo)));
                            msgId = proxySendResult.getMsgId();
                            reqBo.setMsgId(msgId);
                            reqBo.setAgrId(agrId);
                            reqBo.setVersion(version);
                            AgrSyncBusiPropLabelAbilityRspBO agrSyncBusiPropLabelAbilityRspBo = this.agrSyncBusiPropLabelBusiService.dealSyncBusiPropLabel(reqBo);
                            if (!"0000".equals(agrSyncBusiPropLabelAbilityRspBo.getRespCode())) {
                                AgrBusiRedoReqBO agrBusiRedoReqBo = new AgrBusiRedoReqBO();
                                AgrBusiRedoQueueBO agrBusiRedoQueueBo = new AgrBusiRedoQueueBO();
                                agrBusiRedoQueueBo.setBusiType(Integer.valueOf(AgrBusiRedoTypeEnum.BusiPropLabelSyncMqSaveLog.getTypeCode()));
                                agrBusiRedoQueueBo.setRequestParam(JSONObject.toJSONString((Object)reqBo));
                                agrBusiRedoReqBo.setBusiRedoQueue(agrBusiRedoQueueBo);
                                this.agrBusiRedoBusiService.addRedoTask(agrBusiRedoReqBo);
                            }
                        }
                        catch (Exception e) {
                            log.error("\u53d1\u9001mq\u540c\u6b65\u4e1a\u52a1\u6807\u7b7e\u5230\u5546\u54c1\u4e2d\u5fc3\u5f02\u5e38", (Throwable)e);
                            AgrBusiRedoReqBO agrBusiRedoReqBo = new AgrBusiRedoReqBO();
                            AgrBusiRedoQueueBO agrBusiRedoQueueBo = new AgrBusiRedoQueueBO();
                            agrBusiRedoQueueBo.setBusiType(Integer.valueOf(AgrBusiRedoTypeEnum.BusiPropLabelSyncMq.getTypeCode()));
                            agrBusiRedoQueueBo.setRequestParam(JSONObject.toJSONString((Object)uccExtSyncBusiPropLabelFromAgreementOrContractReqBo));
                            agrBusiRedoReqBo.setBusiRedoQueue(agrBusiRedoQueueBo);
                            this.agrBusiRedoBusiService.addRedoTask(agrBusiRedoReqBo);
                        }
                    }
                });
            }
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

