/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.agreement.ability.AgrSyncErjiAgreementAbilityService;
import com.tydic.agreement.ability.bo.AgrBusiRedoQueueBO;
import com.tydic.agreement.ability.bo.AgrBusiRedoReqBO;
import com.tydic.agreement.ability.bo.AgrSyncErjiAgreementAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrSyncErjiAgreementAbilityRspBO;
import com.tydic.agreement.busi.AgrBusiRedoBusiService;
import com.tydic.agreement.busi.AgrSyncErjiAgreementBusiService;
import com.tydic.agreement.constant.AgrBusiRedoTypeEnum;
import com.tydic.agreement.constant.AgrCommConstant;
import com.tydic.agreement.constant.AgrEnum;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.po.AgreementPO;
import com.tydic.uccext.bo.UccExtSyncErjiAgreementAbilityReqBO;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AgrSyncErjiAgreementAbilityServiceImpl
implements AgrSyncErjiAgreementAbilityService {
    private static final Logger log = LoggerFactory.getLogger(AgrSyncErjiAgreementAbilityServiceImpl.class);
    private final Set<String> syncEcpPurTypes = Stream.of(AgrEnum.EcpCenterPurchaseType.FJZCG.getCode(), AgrEnum.EcpCenterPurchaseType.ERJIZJ.getCode(), AgrEnum.EcpCenterPurchaseType.ERJIZZ.getCode(), AgrEnum.EcpCenterPurchaseType.ERJISQ.getCode(), AgrEnum.EcpCenterPurchaseType.EJJC.getCode()).collect(Collectors.toSet());
    @Value(value="${SYNC_ERJI_AGR_TO_UCC_TOPIC}")
    private String topic;
    @Value(value="${SYNC_ERJI_AGR_TO_UCC_TAG}")
    private String tag;
    @Resource(name="syncErjiAgreementProvider")
    private ProxyMessageProducer syncErjiAgreementProvider;
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgrSyncErjiAgreementBusiService agrSyncErjiAgreementBusiService;
    @Autowired
    private AgrBusiRedoBusiService agrBusiRedoBusiService;

    @Override
    public AgrSyncErjiAgreementAbilityRspBO dealSyncErjiAgreement(AgrSyncErjiAgreementAbilityReqBO reqBo) {
        AgrSyncErjiAgreementAbilityRspBO rspBo = new AgrSyncErjiAgreementAbilityRspBO();
        if (reqBo == null || CollectionUtils.isEmpty((Collection)reqBo.getAgreementIds())) {
            rspBo.setRespCode("0001");
            rspBo.setRespDesc("\u8bf7\u6c42\u5fc5\u4f20\u53c2\u6570\u534f\u8baeID\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        List<Long> agrIds = reqBo.getAgreementIds();
        AgreementPO agreementPo = new AgreementPO();
        agreementPo.setAgreementIds(agrIds);
        agreementPo.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        List<AgreementPO> agreementPos = this.agreementMapper.getList(agreementPo);
        agrIds = !CollectionUtils.isEmpty(agreementPos) ? agreementPos.stream().filter(po -> this.syncEcpPurTypes.contains(po.getEcpPurType())).map(AgreementPO::getAgreementId).collect(Collectors.toList()) : null;
        if (!CollectionUtils.isEmpty((Collection)agrIds)) {
            agrIds.forEach(agrId -> {
                UccExtSyncErjiAgreementAbilityReqBO uccExtSyncErjiAgreementAbilityReqBo = new UccExtSyncErjiAgreementAbilityReqBO();
                BeanUtils.copyProperties((Object)reqBo, (Object)uccExtSyncErjiAgreementAbilityReqBo);
                uccExtSyncErjiAgreementAbilityReqBo.setAgreementId(agrId);
                try {
                    ProxySendResult proxySendResult = this.syncErjiAgreementProvider.send(new ProxyMessage(this.topic, this.tag, JSONObject.toJSONString((Object)uccExtSyncErjiAgreementAbilityReqBo)));
                    String msgId = proxySendResult.getMsgId();
                    reqBo.setMsgId(msgId);
                    reqBo.setAgrId(agrId);
                    AgrSyncErjiAgreementAbilityRspBO agrSyncBusiPropLabelAbilityRspBo = this.agrSyncErjiAgreementBusiService.dealSyncErjiAgreement(reqBo);
                    if (!"0000".equals(agrSyncBusiPropLabelAbilityRspBo.getRespCode())) {
                        AgrBusiRedoReqBO agrBusiRedoReqBo = new AgrBusiRedoReqBO();
                        AgrBusiRedoQueueBO agrBusiRedoQueueBo = new AgrBusiRedoQueueBO();
                        agrBusiRedoQueueBo.setBusiType(Integer.valueOf(AgrBusiRedoTypeEnum.ErjiAgrSyncMqSaveLog.getTypeCode()));
                        agrBusiRedoQueueBo.setRequestParam(JSONObject.toJSONString((Object)reqBo));
                        agrBusiRedoReqBo.setBusiRedoQueue(agrBusiRedoQueueBo);
                        this.agrBusiRedoBusiService.addRedoTask(agrBusiRedoReqBo);
                    }
                }
                catch (Exception e) {
                    log.error("\u53d1\u9001mq\u540c\u6b65\u4e1a\u52a1\u4e8c\u7ea7\u5355\u4f4d\u534f\u8bae\u5230\u5546\u54c1\u4e2d\u5fc3\u5f02\u5e38", (Throwable)e);
                    AgrBusiRedoReqBO agrBusiRedoReqBo = new AgrBusiRedoReqBO();
                    AgrBusiRedoQueueBO agrBusiRedoQueueBo = new AgrBusiRedoQueueBO();
                    agrBusiRedoQueueBo.setBusiType(Integer.valueOf(AgrBusiRedoTypeEnum.ErjiAgrSyncMq.getTypeCode()));
                    agrBusiRedoQueueBo.setRequestParam(JSONObject.toJSONString((Object)uccExtSyncErjiAgreementAbilityReqBo));
                    agrBusiRedoReqBo.setBusiRedoQueue(agrBusiRedoQueueBo);
                    this.agrBusiRedoBusiService.addRedoTask(agrBusiRedoReqBo);
                }
            });
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

