/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.ability.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.agreement.ability.AgreementDetailOrderedQuantityUpdateAbilityService;
import com.tydic.agreement.ability.bo.AgrDetailOrderedQuantityCheckResultBO;
import com.tydic.agreement.ability.bo.AgreementBuyInfoBO;
import com.tydic.agreement.ability.bo.AgreementDetailBuyInfoBO;
import com.tydic.agreement.ability.bo.AgreementDetailOrderedQuantityUpdateReqBO;
import com.tydic.agreement.ability.bo.AgreementDetailOrderedQuantityUpdateRspBO;
import com.tydic.agreement.atom.AgrDetailsSyncCommMsgAtomService;
import com.tydic.agreement.atom.bo.AgrDetailsSyncCommMsgAtomReqBO;
import com.tydic.agreement.busi.AgreementDetailOrderedQuantityUpdateBusiService;
import com.tydic.agreement.constant.AgrCommConstant;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.AgreementSkuBuyNumberChangeLogMapper;
import com.tydic.agreement.dao.AgreementSkuMapper;
import com.tydic.agreement.dao.po.AgreementPO;
import com.tydic.agreement.dao.po.AgreementSkuBuyNumberChangeLogPO;
import com.tydic.agreement.dao.po.AgreementSkuPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_TEST/2.0.0/com.tydic.agreement.ability.AgreementDetailOrderedQuantityUpdateAbilityService"})
public class AgreementDetailOrderedQuantityUpdateAbilityServiceImpl
implements AgreementDetailOrderedQuantityUpdateAbilityService {
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgreementSkuMapper agreementSkuMapper;
    @Autowired
    private AgreementSkuBuyNumberChangeLogMapper agreementSkuBuyNumberChangeLogMapper;
    @Autowired
    private AgreementDetailOrderedQuantityUpdateBusiService agreementDetailOrderedQuantityUpdateBusiService;
    @Autowired
    private AgrDetailsSyncCommMsgAtomService agrDetailsSyncCommMsgAtomService;

    @PostMapping(value={"updateAgreementDetailOrderedQuantity"})
    public AgreementDetailOrderedQuantityUpdateRspBO updateAgreementDetailOrderedQuantity(@RequestBody AgreementDetailOrderedQuantityUpdateReqBO reqBo) {
        AgreementDetailOrderedQuantityUpdateRspBO rspBo;
        if (reqBo == null || CollectionUtils.isEmpty((Collection)reqBo.getAgreementBuyList()) || reqBo.getOrderId() == null || reqBo.getObjId() == null || reqBo.getObjType() == null) {
            throw new BusinessException("8888", "\u4e0b\u5355\u6570\u91cf\u66f4\u65b0\u5fc5\u4f20\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getCheckFlag() == null || reqBo.getCheckFlag().booleanValue()) {
            rspBo = this.checkAgreementDetailOrderedQuantity(reqBo);
            if (!"0000".equals(rspBo.getRespCode())) {
                throw new BusinessException(rspBo.getRespCode(), rspBo.getRespDesc());
            }
            AgrDetailOrderedQuantityCheckResultBO checkResultBO = rspBo.getCheckResult().stream().filter(AgrDetailOrderedQuantityCheckResultBO::getOverLimit).findFirst().orElse(null);
            if (checkResultBO != null) {
                throw new BusinessException("8888", checkResultBO.getResultMsg());
            }
        }
        AgreementSkuBuyNumberChangeLogPO changeLogPo = new AgreementSkuBuyNumberChangeLogPO();
        changeLogPo.setOrderId(reqBo.getOrderId());
        changeLogPo.setObjId(reqBo.getObjId());
        changeLogPo.setObjType(reqBo.getObjType().getTypeCode());
        int checkBy = this.agreementSkuBuyNumberChangeLogMapper.getCheckBy(changeLogPo);
        if (checkBy > 0) {
            throw new BusinessException("8888", "\u8be5\u8ba2\u5355\u5df2\u5b58\u5728\u5904\u7406\u8bb0\u5f55");
        }
        Map<Long, List<AgreementBuyInfoBO>> collectAgr = reqBo.getAgreementBuyList().stream().collect(Collectors.groupingBy(AgreementBuyInfoBO::getAgreementId));
        collectAgr.forEach((agrId, agrBuyList) -> {
            Map<Long, List<AgreementDetailBuyInfoBO>> collectAgrDetail = agrBuyList.stream().map(AgreementBuyInfoBO::getDetailBuyList).flatMap(Collection::stream).collect(Collectors.groupingBy(AgreementDetailBuyInfoBO::getAgreementDetailId));
            collectAgrDetail.forEach((agrDetailId, detailList) -> {
                BigDecimal totalChangeNum;
                BigDecimal reduce = detailList.stream().map(AgreementDetailBuyInfoBO::getQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (reduce.compareTo(BigDecimal.ZERO) < 0 && ((totalChangeNum = this.agreementSkuBuyNumberChangeLogMapper.getTotalChangeNumByOrderAndAgr(reqBo.getOrderId(), (Long)agrId, (Long)agrDetailId)).compareTo(BigDecimal.ZERO) <= 0 || totalChangeNum.compareTo(reduce.negate()) < 0)) {
                    throw new BusinessException("8888", "\u672c\u6b21\u9000\u56de\u534f\u8bae\u660e\u7ec6\u6570\u91cf\u8d85\u51fa\u8ba2\u5355\u5df2\u6263\u51cf\u6570\u91cf");
                }
            });
        });
        rspBo = this.agreementDetailOrderedQuantityUpdateBusiService.updateAgreementDetailOrderedQuantity(reqBo);
        this.syncSku(reqBo);
        return rspBo;
    }

    private void syncSku(AgreementDetailOrderedQuantityUpdateReqBO reqBo) {
        ArrayList<Long> agrDetails = new ArrayList<Long>();
        if (!CollectionUtils.isEmpty((Collection)reqBo.getAgreementBuyList())) {
            reqBo.getAgreementBuyList().forEach(agr -> {
                if (!CollectionUtils.isEmpty((Collection)agr.getDetailBuyList())) {
                    List agrSkuIds = agr.getDetailBuyList().stream().map(AgreementDetailBuyInfoBO::getAgreementDetailId).collect(Collectors.toList());
                    agrDetails.addAll(agrSkuIds);
                }
            });
        }
        if (!CollectionUtils.isEmpty(agrDetails)) {
            AgrDetailsSyncCommMsgAtomReqBO agrDetailsSyncCommMsgAtomReqBO = new AgrDetailsSyncCommMsgAtomReqBO();
            agrDetailsSyncCommMsgAtomReqBO.setAgrDetailIds(agrDetails);
            this.agrDetailsSyncCommMsgAtomService.syncCommMsg(agrDetailsSyncCommMsgAtomReqBO);
        }
    }

    @PostMapping(value={"checkAgreementDetailOrderedQuantity"})
    public AgreementDetailOrderedQuantityUpdateRspBO checkAgreementDetailOrderedQuantity(@RequestBody AgreementDetailOrderedQuantityUpdateReqBO reqBo) {
        AgreementDetailOrderedQuantityUpdateRspBO rspBo = new AgreementDetailOrderedQuantityUpdateRspBO();
        if (reqBo == null || CollectionUtils.isEmpty((Collection)reqBo.getAgreementBuyList())) {
            throw new BusinessException("8888", "\u4e0b\u5355\u6570\u91cf\u6821\u9a8c\u5fc5\u4f20\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        reqBo.getAgreementBuyList().forEach(agr -> {
            if (agr.getAgreementId() == null) {
                throw new BusinessException("8888", "\u4e0b\u5355\u6570\u91cf\u6821\u9a8c[\u7269\u9879\u6240\u5c5e\u534f\u8baeID]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (CollectionUtils.isEmpty((Collection)agr.getDetailBuyList())) {
                throw new BusinessException("8888", "\u4e0b\u5355\u6570\u91cf\u6821\u9a8c[\u7269\u9879\u6570\u91cf]\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            agr.getDetailBuyList().forEach(detail -> {
                if (detail.getAgreementDetailId() == null) {
                    throw new BusinessException("8888", "\u4e0b\u5355\u6570\u91cf\u6821\u9a8c[\u7269\u9879\u660e\u7ec6ID]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (detail.getQuantity() == null) {
                    throw new BusinessException("8888", "\u4e0b\u5355\u6570\u91cf\u6821\u9a8c[\u7269\u9879\u6570\u91cf]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (reqBo.getOrderFlag() != null && reqBo.getOrderFlag().booleanValue() && detail.getQuantity().compareTo(BigDecimal.ZERO) < 0) {
                    throw new BusinessException("8888", "\u4e0b\u5355\u6570\u91cf\u6821\u9a8c,[\u7269\u9879\u6570\u91cf]\u53c2\u6570\u503c\u5f02\u5e38");
                }
            });
        });
        ArrayList mergeList = new ArrayList();
        Map<Long, List<AgreementBuyInfoBO>> collect = reqBo.getAgreementBuyList().stream().collect(Collectors.groupingBy(AgreementBuyInfoBO::getAgreementId));
        collect.forEach((agrId, bos) -> {
            if (bos.size() > 1) {
                ArrayList mergeDetailList = new ArrayList();
                bos.forEach(bo -> mergeDetailList.addAll(bo.getDetailBuyList()));
                AgreementBuyInfoBO bo2 = new AgreementBuyInfoBO();
                bo2.setAgreementId(agrId);
                bo2.setDetailBuyList(mergeDetailList);
                mergeList.add(bo2);
            } else {
                mergeList.addAll(bos);
            }
        });
        mergeList.forEach(agrBuy -> {
            ArrayList mergeDetailList = new ArrayList();
            Map<Long, List<AgreementDetailBuyInfoBO>> collectDetail = agrBuy.getDetailBuyList().stream().collect(Collectors.groupingBy(AgreementDetailBuyInfoBO::getAgreementDetailId));
            collectDetail.forEach((agrSkuId, bos) -> {
                if (bos.size() > 1) {
                    AgreementDetailBuyInfoBO reduce = bos.stream().reduce(new AgreementDetailBuyInfoBO(), this::merge);
                    mergeDetailList.add(reduce);
                } else {
                    mergeDetailList.addAll(bos);
                }
            });
            agrBuy.setDetailBuyList(mergeDetailList);
        });
        reqBo.setAgreementBuyList(mergeList);
        ArrayList checkResultList = new ArrayList();
        reqBo.getAgreementBuyList().forEach(agr -> {
            if (reqBo.getOrderFlag() != null && reqBo.getOrderFlag().booleanValue()) {
                AgreementPO agreementPo = new AgreementPO();
                agreementPo.setAgreementId(agr.getAgreementId());
                agreementPo.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
                agreementPo.setAgreementStatus(AgrCommConstant.AgreementStatus.ENABLE);
                agreementPo = this.agreementMapper.getModelBy(agreementPo);
                if (agreementPo == null) {
                    AgreementDetailBuyInfoBO detail = (AgreementDetailBuyInfoBO)agr.getDetailBuyList().get(0);
                    Long id = detail.getSkuId() == null ? detail.getAgreementDetailId() : detail.getSkuId();
                    String codeName = detail.getSkuId() == null ? "\u534f\u8bae\u660e\u7ec6\u7f16\u7801" : "\u5546\u54c1\u7f16\u7801";
                    throw new BusinessException("8888", "\u672a\u67e5\u8be2\u5230" + codeName + "[" + id + "]\u5173\u8054\u7684\u6709\u6548\u534f\u8bae\u4fe1\u606f");
                }
            }
            List<Long> agrDetailIds = agr.getDetailBuyList().stream().map(AgreementDetailBuyInfoBO::getAgreementDetailId).collect(Collectors.toList());
            AgreementSkuPO agreementSkuPo = new AgreementSkuPO();
            agreementSkuPo.setAgreementId(agr.getAgreementId());
            agreementSkuPo.setAgreementSkuIds(agrDetailIds);
            agreementSkuPo.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
            List<AgreementSkuPO> agreementSkuPoList = this.agreementSkuMapper.getList(agreementSkuPo);
            if (CollectionUtils.isEmpty(agreementSkuPoList)) {
                throw new BusinessException("8888", "\u672a\u67e5\u8be2\u5230\u534f\u8bae\u7269\u9879\u4fe1\u606f");
            }
            Map<Long, AgreementSkuPO> collectByAgrSkuId = agreementSkuPoList.stream().collect(Collectors.toMap(AgreementSkuPO::getAgreementSkuId, po -> po, (a, b) -> a));
            AgreementSkuBuyNumberChangeLogPO agreementSkuBuyNumberChangeLogPo = new AgreementSkuBuyNumberChangeLogPO();
            agreementSkuBuyNumberChangeLogPo.setAgreementId(agr.getAgreementId());
            agreementSkuBuyNumberChangeLogPo.setAgreementSkuIdIn(agrDetailIds);
            List<AgreementSkuBuyNumberChangeLogPO> totalByAgrDetail = this.agreementSkuBuyNumberChangeLogMapper.getTotalChangeNumByAgrDetail(agreementSkuBuyNumberChangeLogPo);
            Map<Long, AgreementSkuBuyNumberChangeLogPO> collectLogByAgrSkuId = totalByAgrDetail.stream().collect(Collectors.toMap(AgreementSkuBuyNumberChangeLogPO::getAgreementSkuId, po -> po, (a, b) -> a));
            for (AgreementDetailBuyInfoBO detail : agr.getDetailBuyList()) {
                Long id = detail.getSkuId() == null ? detail.getAgreementDetailId() : detail.getSkuId();
                String codeName = detail.getSkuId() == null ? "\u534f\u8bae\u660e\u7ec6\u7f16\u7801" : "\u5546\u54c1\u7f16\u7801";
                AgreementSkuPO agrSkuPo = collectByAgrSkuId.get(detail.getAgreementDetailId());
                if (agrSkuPo == null) {
                    throw new BusinessException("8888", "\u672a\u67e5\u8be2\u5230" + codeName + "[" + id + "]\u7684\u534f\u8bae\u7269\u9879\u4fe1\u606f");
                }
                BigDecimal total = agrSkuPo.getBuyNumber();
                BigDecimal ordered = agrSkuPo.getOrderedQuantity() == null ? BigDecimal.ZERO : agrSkuPo.getOrderedQuantity();
                AgrDetailOrderedQuantityCheckResultBO checkResultBo = new AgrDetailOrderedQuantityCheckResultBO();
                checkResultBo.setAgreementId(agrSkuPo.getAgreementId());
                checkResultBo.setAgreementDetailId(agrSkuPo.getAgreementSkuId());
                checkResultBo.setAgreementQuantity(total);
                checkResultList.add(checkResultBo);
                if (total != null) {
                    BigDecimal totalOrdered = detail.getQuantity().add(ordered);
                    if (detail.getQuantity().compareTo(BigDecimal.ZERO) >= 0 && totalOrdered.compareTo(total) > 0) {
                        checkResultBo.setOverLimit(Boolean.valueOf(true));
                        checkResultBo.setOrderedQuantity(ordered);
                        checkResultBo.setResultMsg(codeName + "[" + id + "]\u7684\u534f\u8bae\u7269\u9879\u5269\u4f59\u6570\u91cf\u4e0d\u8db3");
                        continue;
                    }
                    if (detail.getQuantity().compareTo(BigDecimal.ZERO) < 0 && totalOrdered.compareTo(BigDecimal.ZERO) < 0) {
                        checkResultBo.setOverLimit(Boolean.valueOf(true));
                        checkResultBo.setOrderedQuantity(ordered);
                        checkResultBo.setResultMsg(codeName + "[" + id + "]\u7684\u534f\u8bae\u7269\u9879\u56de\u9000\u6570\u91cf\u8d85\u8fc7\u5df2\u4e0b\u5355\u6570\u91cf");
                        continue;
                    }
                    AgreementSkuBuyNumberChangeLogPO changeLogPo = collectLogByAgrSkuId.get(detail.getAgreementDetailId());
                    if (changeLogPo != null) {
                        BigDecimal logOrdered = changeLogPo.getChangeNum();
                        BigDecimal totalLogOrdered = logOrdered.add(detail.getQuantity());
                        if (detail.getQuantity().compareTo(BigDecimal.ZERO) >= 0 && totalLogOrdered.compareTo(total) > 0) {
                            checkResultBo.setOverLimit(Boolean.valueOf(true));
                            checkResultBo.setOrderedQuantity(logOrdered);
                            checkResultBo.setResultMsg(codeName + "[" + id + "]\u7684\u534f\u8bae\u7269\u9879\u5269\u4f59\u6570\u91cf\u4e0d\u8db3");
                            continue;
                        }
                        if (detail.getQuantity().compareTo(BigDecimal.ZERO) < 0 && totalLogOrdered.compareTo(BigDecimal.ZERO) < 0) {
                            checkResultBo.setOverLimit(Boolean.valueOf(true));
                            checkResultBo.setOrderedQuantity(logOrdered);
                            checkResultBo.setResultMsg(codeName + "[" + id + "]\u7684\u534f\u8bae\u7269\u9879\u56de\u9000\u6570\u91cf\u8d85\u8fc7\u5df2\u4e0b\u5355\u6570\u91cf");
                            continue;
                        }
                    }
                }
                checkResultBo.setOverLimit(Boolean.valueOf(false));
                checkResultBo.setOrderedQuantity(ordered);
            }
        });
        rspBo.setCheckResult(checkResultList);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private AgreementDetailBuyInfoBO merge(AgreementDetailBuyInfoBO a, AgreementDetailBuyInfoBO b) {
        if (a.getAgreementDetailId() == null) {
            a.setAgreementDetailId(b.getAgreementDetailId());
        }
        if (a.getSkuId() == null) {
            a.setSkuId(b.getSkuId());
        }
        if (!StringUtils.hasText((String)a.getPlanDetailNo())) {
            a.setPlanDetailNo(b.getPlanDetailNo());
        } else if (!Objects.equals(a.getPlanDetailNo(), b.getPlanDetailNo())) {
            StringJoiner sj = new StringJoiner("-");
            if (StringUtils.hasText((String)a.getPlanDetailNo())) {
                sj.add(a.getPlanDetailNo());
            }
            if (StringUtils.hasText((String)b.getPlanDetailNo())) {
                sj.add(b.getPlanDetailNo());
            }
            a.setPlanDetailNo(sj.toString());
        }
        a.setQuantity((a.getQuantity() == null ? BigDecimal.ZERO : a.getQuantity()).add(b.getQuantity() == null ? BigDecimal.ZERO : b.getQuantity()));
        return a;
    }
}

