/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.ability.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.db.Page;
import com.tydic.agreement.ability.OpsContractHasCreateAgreementCheckAbilityService;
import com.tydic.agreement.ability.bo.OpsContractHasCreateAgreementCheckAbilityReqBO;
import com.tydic.agreement.ability.bo.OpsContractHasCreateAgreementCheckAbilityRspBO;
import com.tydic.agreement.constant.AgrCommConstant;
import com.tydic.agreement.constant.AgrEnum;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.OpsContractMapper;
import com.tydic.agreement.dao.po.AgreementPO;
import com.tydic.agreement.dao.po.OpsContractPO;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_TEST/2.0.0/com.tydic.agreement.ability.OpsContractHasCreateAgreementCheckAbilityService"})
public class OpsContractHasCreateAgreementCheckAbilityServiceImpl
implements OpsContractHasCreateAgreementCheckAbilityService {
    @Autowired
    private OpsContractMapper opsContractMapper;
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private CacheClient cacheService;
    @Value(value="${opsContractExpTime:1800}")
    private Integer opsContractExpTime;

    @PostMapping(value={"dealOpsAgreementCheck"})
    public OpsContractHasCreateAgreementCheckAbilityRspBO dealOpsAgreementCheck(@RequestBody OpsContractHasCreateAgreementCheckAbilityReqBO reqBo) {
        OpsContractHasCreateAgreementCheckAbilityRspBO rspBo = new OpsContractHasCreateAgreementCheckAbilityRspBO();
        if (reqBo == null || !StringUtils.hasText((String)reqBo.getOpsContractCode())) {
            rspBo.setRespCode("0001");
            rspBo.setRespDesc("\u8bf7\u6c42\u5fc5\u4f20\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        OpsContractPO opsContractPo = new OpsContractPO();
        if (null != reqBo.getAutoCreateAgrFlag() && !reqBo.getAutoCreateAgrFlag().booleanValue()) {
            opsContractPo.setContractCode(reqBo.getOpsContractCode());
            opsContractPo = this.opsContractMapper.getModelBy(opsContractPo);
            if (opsContractPo == null) {
                rspBo.setRespCode("8888");
                rspBo.setRespDesc("\u672a\u67e5\u8be2\u5230ops\u5408\u540c\u4fe1\u606f");
                return rspBo;
            }
        }
        AgreementPO agreementPo = new AgreementPO();
        agreementPo.setRelSystem(AgrEnum.RelSystem.OPS.toString());
        agreementPo.setExtContractCode(reqBo.getOpsContractCode());
        agreementPo.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        Page page = new Page(1, 2);
        List<AgreementPO> listPage = this.agreementMapper.getListPage(agreementPo, (Page<AgreementPO>)page);
        if (!CollectionUtils.isEmpty(listPage)) {
            rspBo.setCheckResult(Boolean.valueOf(true));
            if (reqBo.getAgreementId() != null) {
                List collect = listPage.stream().filter(po -> !Objects.equals(po.getAgreementId(), reqBo.getAgreementId())).collect(Collectors.toList());
                if (!collect.isEmpty()) {
                    rspBo.setPlaAgreementCode(((AgreementPO)collect.get(0)).getPlaAgreementCode());
                    rspBo.setAgreementName(((AgreementPO)collect.get(0)).getAgreementName());
                } else {
                    rspBo.setCheckResult(Boolean.valueOf(false));
                }
            } else {
                rspBo.setPlaAgreementCode(listPage.get(0).getPlaAgreementCode());
                rspBo.setAgreementName(listPage.get(0).getAgreementName());
            }
        } else {
            rspBo.setCheckResult(Boolean.valueOf(false));
        }
        if (!rspBo.getCheckResult().booleanValue() && null != reqBo.getAutoCreateAgrFlag() && !reqBo.getAutoCreateAgrFlag().booleanValue()) {
            String key = "contractCode_" + opsContractPo.getContractCode();
            String value = (String)this.cacheService.get(key, String.class);
            if (StringUtils.hasText((String)value)) {
                String[] split = value.split("_");
                if (split.length == 2 && !split[1].equals(reqBo.getUserIdIn().toString())) {
                    throw new BusinessException("22002", "\u5408\u540c\u7f16\u7801\u4e3a\u3010" + opsContractPo.getContractCode() + "\u3011\u7684\u5408\u540c\u6b63\u5728\u4f7f\u7528\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
                }
            } else {
                String vailue = "userIdIn_" + reqBo.getUserIdIn();
                this.cacheService.set(key, (Object)vailue, this.opsContractExpTime.intValue());
            }
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

