/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.agreement.ability.AgrAgreementScopeSyncQueueAbilityService;
import com.tydic.agreement.ability.AgrSkuUnbindStandardSpuAbilityService;
import com.tydic.agreement.ability.AgrSyncBusiPropLabelAbilityService;
import com.tydic.agreement.ability.AgrSyncErjiAgreementAbilityService;
import com.tydic.agreement.ability.OpsContractSyncAbilityService;
import com.tydic.agreement.ability.bo.AgrSkuUnbindStandardSpuAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrSyncBusiPropLabelAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrSyncErjiAgreementAbilityReqBO;
import com.tydic.agreement.ability.bo.OpsContractItemBO;
import com.tydic.agreement.ability.bo.OpsContractPaymentBO;
import com.tydic.agreement.ability.bo.OpsContractScopeBO;
import com.tydic.agreement.ability.bo.OpsContractSyncAbilityReqBO;
import com.tydic.agreement.ability.bo.OpsContractSyncAbilityRspBO;
import com.tydic.agreement.busi.OpsContractSyncBusiService;
import com.tydic.agreement.constant.AgrCommConstant;
import com.tydic.agreement.constant.AgrEnum;
import com.tydic.agreement.dao.AgrSyncContractInterfaceLogMapper;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.OpsContractMapper;
import com.tydic.agreement.dao.po.AgrSyncContractInterfaceLogPO;
import com.tydic.agreement.dao.po.OpsContractPO;
import com.tydic.commodity.bo.busi.UccCommdMeasureInfoReqBo;
import com.tydic.commodity.bo.busi.UccCommdMeasureInfoRspBo;
import com.tydic.commodity.bo.busi.UccCommdMeasureReqBo;
import com.tydic.commodity.bo.busi.UccEMdmCatalogBO;
import com.tydic.commodity.busi.api.UccCommdMeasureInfoBusiService;
import com.tydic.commodity.busi.api.UccCommodityMeasureBo;
import com.tydic.commodity.enumType.YesNoEnum;
import com.tydic.contract.api.ecp.ExtSyncContractService;
import com.tydic.contract.api.ecp.bo.ExtSyncContractReqBO;
import com.tydic.contract.api.ecp.bo.ExtSyncContractRspBO;
import com.tydic.enquiry.api.AddProjectInfoAbilityService;
import com.tydic.enquiry.api.QryProjectInfoListPageAbilityService;
import com.tydic.enquiry.api.bo.AddProjectInfoReqBO;
import com.tydic.enquiry.api.bo.AddProjectInfoRspBO;
import com.tydic.enquiry.api.bo.ProjectInfoBO;
import com.tydic.enquiry.api.bo.QryProjectInfoListPageReqBO;
import com.tydic.enquiry.api.bo.QryProjectInfoListPageRspBO;
import com.tydic.uccext.bo.CnncCatalogListQueryAbilityReqBO;
import com.tydic.uccext.bo.CnncCatalogListQueryAbilityRspBO;
import com.tydic.uccext.bo.UccMaterialCommodityTypeBO;
import com.tydic.uccext.bo.UccQryCommodityTypeByMaterialReqBO;
import com.tydic.uccext.bo.UccQryCommodityTypeByMaterialRspBO;
import com.tydic.uccext.service.CnncCatalogListQueryAbilityService;
import com.tydic.uccext.service.UccQryCommodityTypeByMaterialService;
import com.tydic.umc.common.EnterpriseOrgExtMapJoinBO;
import com.tydic.umcext.ability.org.UmcOrgExtMapOperateAbilityService;
import com.tydic.umcext.ability.org.bo.UmcOrgExtMapOperateAbilityReqBO;
import com.tydic.umcext.ability.org.bo.UmcOrgExtMapOperateAbilityRspBO;
import com.tydic.umcext.ability.supplier.UmcQrySupplierInfoDetailAbilityService;
import com.tydic.umcext.ability.supplier.UmcSupplierAccountEnableAbilityService;
import com.tydic.umcext.ability.supplier.bo.UmcQrySupplierInfoDetailAbilityReqBO;
import com.tydic.umcext.ability.supplier.bo.UmcQrySupplierInfoDetailAbilityRspBO;
import com.tydic.umcext.ability.supplier.bo.UmcSupplierAccountEnableAbilityReqBO;
import com.tydic.umcext.constant.UmcCommConstant;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_TEST/2.0.0/com.tydic.agreement.ability.OpsContractSyncAbilityService"})
public class OpsContractSyncAbilityServiceImpl
implements OpsContractSyncAbilityService {
    private static final Logger log = LoggerFactory.getLogger(OpsContractSyncAbilityServiceImpl.class);
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgrSyncContractInterfaceLogMapper agrSyncContractInterfaceLogMapper;
    @Autowired
    private OpsContractMapper opsContractMapper;
    @Autowired
    private OpsContractSyncBusiService opsContractSyncBusiService;
    @Autowired
    private AgrAgreementScopeSyncQueueAbilityService agrAgreementScopeSyncQueueAbilityService;
    @Autowired
    private UmcOrgExtMapOperateAbilityService umcOrgExtMapOperateAbilityService;
    @Autowired
    private UmcQrySupplierInfoDetailAbilityService umcQrySupplierInfoDetailAbilityService;
    @Autowired
    private AddProjectInfoAbilityService addProjectInfoAbilityService;
    @Autowired
    private QryProjectInfoListPageAbilityService qryProjectInfoListPageAbilityService;
    @Autowired
    private UccQryCommodityTypeByMaterialService uccQryCommodityTypeByMaterialService;
    @Autowired
    private UmcSupplierAccountEnableAbilityService umcSupplierAccountEnableAbilityService;
    @Autowired
    private UccCommdMeasureInfoBusiService uccCommdMeasureInfoBusiService;
    @Autowired
    private CnncCatalogListQueryAbilityService cnncCatalogListQueryAbilityService;
    @Autowired
    private ExtSyncContractService extSyncContractService;
    @Autowired
    private AgrSyncBusiPropLabelAbilityService agrSyncBusiPropLabelAbilityService;
    @Autowired
    private AgrSyncErjiAgreementAbilityService agrSyncErjiAgreementAbilityService;
    @Autowired
    private AgrSkuUnbindStandardSpuAbilityService agrSkuUnbindStandardSpuAbilityService;

    @PostMapping(value={"syncOpsContract"})
    public OpsContractSyncAbilityRspBO syncOpsContract(@RequestBody OpsContractSyncAbilityReqBO reqBo) {
        AgrSyncContractInterfaceLogPO agrSyncContractInterfaceLogPO4;
        long logId = Sequence.getInstance().nextId();
        boolean logFlag = true;
        try {
            AgrSyncContractInterfaceLogPO agrSyncContractInterfaceLogPO2 = new AgrSyncContractInterfaceLogPO();
            agrSyncContractInterfaceLogPO2.setLogId(logId);
            agrSyncContractInterfaceLogPO2.setCreateTime(new Date());
            agrSyncContractInterfaceLogPO2.setRelSystem(AgrEnum.RelSystem.OPS.toString());
            agrSyncContractInterfaceLogPO2.setInterfaceType(AgrEnum.SyncContractInterfaceType.receive.getType());
            agrSyncContractInterfaceLogPO2.setInterfaceName(AgrEnum.SyncContractInterfaceName.syncOpsContract.toString());
            agrSyncContractInterfaceLogPO2.setKeyParam(reqBo.getContractCode());
            agrSyncContractInterfaceLogPO2.setParams(JSON.toJSONString((Object)reqBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteBigDecimalAsPlain}));
            this.agrSyncContractInterfaceLogMapper.insert(agrSyncContractInterfaceLogPO2);
        }
        catch (Exception ignore) {
            logFlag = false;
        }
        OpsContractSyncAbilityRspBO rspBo = new OpsContractSyncAbilityRspBO();
        try {
            EnterpriseOrgExtMapJoinBO creatorOrg;
            OpsContractPO opsContractPo;
            this.validPrams(reqBo);
            if (AgrEnum.OpsSyncOperType.oper_create.getType().equals(reqBo.getReqOperType())) {
                opsContractPo = new OpsContractPO();
                opsContractPo.setContractCode(reqBo.getContractCode());
                opsContractPo.setContractId(reqBo.getContractId());
                int checkBy = this.opsContractMapper.getCheckBy(opsContractPo);
                if (checkBy > 0) {
                    throw new ZTBusinessException("\u5f53\u524d\u5408\u540c\u5df2\u5b58\u5728\uff0c\u4e0d\u53ef\u91cd\u590d\u65b0\u589e");
                }
            } else if (AgrEnum.OpsSyncOperType.oper_modify.getType().equals(reqBo.getReqOperType())) {
                opsContractPo = new OpsContractPO();
                opsContractPo.setContractCode(reqBo.getContractCode());
                opsContractPo = this.opsContractMapper.getModelBy(opsContractPo);
                if (!(opsContractPo == null || Objects.equals(reqBo.getPackCode(), opsContractPo.getPackCode()) && Objects.equals(reqBo.getPackName(), opsContractPo.getPackName()))) {
                    throw new ZTBusinessException("\u4e0d\u5141\u8bb8\u53d8\u66f4\u5305\u7f16\u53f7\u548c\u5305\u540d\u79f0");
                }
            }
            if ((creatorOrg = this.qryOrgId(reqBo.getCreatorOrgCode())) == null) {
                throw new ZTBusinessException("\u8d77\u8349\u4eba\u5355\u4f4d\u67e5\u8be2\u4e0d\u5b58\u5728");
            }
            EnterpriseOrgExtMapJoinBO vendorOrg = this.qryOrgId(reqBo.getVendorCode());
            if (vendorOrg == null) {
                throw new ZTBusinessException("\u4f9b\u5e94\u5546\u67e5\u8be2\u4e0d\u5b58\u5728");
            }
            reqBo.setCreatorOrgId(creatorOrg.getOrgId());
            reqBo.setCreatorOrgName(creatorOrg.getOrgName());
            QryProjectInfoListPageReqBO qryProjectInfoListPageReqBO = new QryProjectInfoListPageReqBO();
            qryProjectInfoListPageReqBO.setProjectCode(reqBo.getPackCode());
            QryProjectInfoListPageRspBO qryProjectInfoListPageRspBO = this.qryProjectInfoListPageAbilityService.qryProjectInfoListPage(qryProjectInfoListPageReqBO);
            if (!CollectionUtils.isEmpty((Collection)qryProjectInfoListPageRspBO.getProjectInfoList())) {
                reqBo.setEcpProjectId(((ProjectInfoBO)qryProjectInfoListPageRspBO.getProjectInfoList().get(0)).getProjectId().toString());
            } else {
                AddProjectInfoReqBO addProjectInfoReqBO = new AddProjectInfoReqBO();
                ProjectInfoBO projectInfoBO = new ProjectInfoBO();
                addProjectInfoReqBO.setProjectInfo(projectInfoBO);
                projectInfoBO.setProjectCode(reqBo.getPackCode());
                projectInfoBO.setProjectName(reqBo.getPackName());
                addProjectInfoReqBO.setCompanyId(creatorOrg.getOrgId());
                addProjectInfoReqBO.setCompanyName(creatorOrg.getOrgName());
                AddProjectInfoRspBO addProjectInfoRspBO = this.addProjectInfoAbilityService.addProjectInfo(addProjectInfoReqBO);
                if (!addProjectInfoRspBO.getRespCode().equals("0000")) {
                    if (!addProjectInfoRspBO.getRespDesc().contains("\u9879\u76ee\u7f16\u7801\u91cd\u590d")) {
                        throw new BusinessException("8888", addProjectInfoRspBO.getRespDesc());
                    }
                } else {
                    reqBo.setEcpProjectId(addProjectInfoRspBO.getProjectId().toString());
                }
            }
            UmcQrySupplierInfoDetailAbilityReqBO umcQrySupplierInfoDetailAbilityReqBO = new UmcQrySupplierInfoDetailAbilityReqBO();
            umcQrySupplierInfoDetailAbilityReqBO.setOrgIdWeb(vendorOrg.getOrgId());
            UmcQrySupplierInfoDetailAbilityRspBO umcQrySupplierInfoDetailAbilityRspBO = this.umcQrySupplierInfoDetailAbilityService.qrySupplierInfoDetail(umcQrySupplierInfoDetailAbilityReqBO);
            if (!"0000".equals(umcQrySupplierInfoDetailAbilityRspBO.getRespCode())) {
                throw new ZTBusinessException("\u67e5\u8be2\u4f9b\u5e94\u5546\u5931\u8d25:" + umcQrySupplierInfoDetailAbilityRspBO.getRespDesc());
            }
            if (umcQrySupplierInfoDetailAbilityRspBO.getSupplierId() == null) {
                throw new ZTBusinessException("\u4f9b\u5e94\u5546\u67e5\u8be2\u4e0d\u5b58\u5728");
            }
            reqBo.setVendorId(umcQrySupplierInfoDetailAbilityRspBO.getSupplierId());
            reqBo.setVendorOrgCode(umcQrySupplierInfoDetailAbilityRspBO.getOrgCode());
            reqBo.setVendorName(umcQrySupplierInfoDetailAbilityRspBO.getSupplierName());
            if (!CollectionUtils.isEmpty((Collection)reqBo.getScopeList())) {
                for (OpsContractScopeBO contractScopeBo : reqBo.getScopeList()) {
                    EnterpriseOrgExtMapJoinBO scopeOrg = this.qryOrgId(contractScopeBo.getOrgCode());
                    if (scopeOrg == null) {
                        log.error("\u67e5\u8be2\u5e94\u7528\u8303\u56f4[" + contractScopeBo + "]\u5bf9\u5e94\u7684\u5355\u4f4d\u4e0d\u5b58\u5728");
                        throw new ZTBusinessException("\u67e5\u8be2\u5e94\u7528\u8303\u56f4[" + contractScopeBo.getOrgCode() + "]\u5bf9\u5e94\u7684\u5355\u4f4d\u4e0d\u5b58\u5728");
                    }
                    contractScopeBo.setOrgId(scopeOrg.getOrgId());
                    contractScopeBo.setOrgName(scopeOrg.getOrgName());
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u5931\u8d25:" + e.getMessage());
            try {
                AgrSyncContractInterfaceLogPO agrSyncContractInterfaceLogPO3 = new AgrSyncContractInterfaceLogPO();
                agrSyncContractInterfaceLogPO3.setLogId(logId);
                agrSyncContractInterfaceLogPO3.setResult(rspBo.getRespDesc());
                agrSyncContractInterfaceLogPO3.setDealResult(AgrEnum.SuccessOrError.ERROR.getCode());
                if (logFlag) {
                    this.agrSyncContractInterfaceLogMapper.updateById(agrSyncContractInterfaceLogPO3);
                } else {
                    agrSyncContractInterfaceLogPO3.setCreateTime(new Date());
                    agrSyncContractInterfaceLogPO3.setRelSystem(AgrEnum.RelSystem.OPS.toString());
                    agrSyncContractInterfaceLogPO3.setInterfaceType(AgrEnum.SyncContractInterfaceType.receive.getType());
                    agrSyncContractInterfaceLogPO3.setInterfaceName(AgrEnum.SyncContractInterfaceName.syncOpsContract.toString());
                    agrSyncContractInterfaceLogPO3.setKeyParam(reqBo.getContractCode());
                    agrSyncContractInterfaceLogPO3.setParams(JSON.toJSONString((Object)reqBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteBigDecimalAsPlain}));
                    this.agrSyncContractInterfaceLogMapper.insert(agrSyncContractInterfaceLogPO3);
                }
            }
            catch (Exception agrSyncContractInterfaceLogPO3) {
                // empty catch block
            }
            return rspBo;
        }
        rspBo = this.opsContractSyncBusiService.syncOpsContract(reqBo);
        if ("0000".equals(rspBo.getRespCode())) {
            try {
                agrSyncContractInterfaceLogPO4 = new AgrSyncContractInterfaceLogPO();
                agrSyncContractInterfaceLogPO4.setLogId(logId);
                agrSyncContractInterfaceLogPO4.setResult(rspBo.getRespDesc());
                agrSyncContractInterfaceLogPO4.setDealResult(AgrEnum.SuccessOrError.SUCCESS.getCode());
                if (logFlag) {
                    this.agrSyncContractInterfaceLogMapper.updateById(agrSyncContractInterfaceLogPO4);
                } else {
                    agrSyncContractInterfaceLogPO4.setCreateTime(new Date());
                    agrSyncContractInterfaceLogPO4.setRelSystem(AgrEnum.RelSystem.OPS.toString());
                    agrSyncContractInterfaceLogPO4.setInterfaceType(AgrEnum.SyncContractInterfaceType.receive.getType());
                    agrSyncContractInterfaceLogPO4.setInterfaceName(AgrEnum.SyncContractInterfaceName.syncOpsContract.toString());
                    agrSyncContractInterfaceLogPO4.setKeyParam(reqBo.getContractCode());
                    agrSyncContractInterfaceLogPO4.setParams(JSON.toJSONString((Object)reqBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteBigDecimalAsPlain}));
                    this.agrSyncContractInterfaceLogMapper.insert(agrSyncContractInterfaceLogPO4);
                }
                this.agrAgreementScopeSyncQueueAbilityService.dealScopeSyncAsync();
                UmcSupplierAccountEnableAbilityReqBO umcSupplierAccountEnableAbilityReqBo = new UmcSupplierAccountEnableAbilityReqBO();
                umcSupplierAccountEnableAbilityReqBo.setSupplierIdList(Collections.singletonList(reqBo.getVendorId()));
                this.umcSupplierAccountEnableAbilityService.dealSupplierAccountEnable(umcSupplierAccountEnableAbilityReqBo);
                ExtSyncContractReqBO extSyncContractReqBO = (ExtSyncContractReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBo), ExtSyncContractReqBO.class);
                extSyncContractReqBO.setContractId(reqBo.getContractId());
                extSyncContractReqBO.setContractCode(reqBo.getContractCode());
                extSyncContractReqBO.setRelSystem(AgrEnum.RelSystem.OPS.toString());
                ExtSyncContractRspBO extSyncContractRspBO = this.extSyncContractService.syncContract(extSyncContractReqBO);
                if (rspBo.getAgreementId() != null) {
                    ArrayList<Long> agreementIds = new ArrayList<Long>();
                    agreementIds.add(rspBo.getAgreementId());
                    AgrSyncBusiPropLabelAbilityReqBO agrSyncBusiPropLabelAbilityReqBo = new AgrSyncBusiPropLabelAbilityReqBO();
                    HashMap agrMap = new HashMap();
                    agreementIds.forEach(agrId -> {
                        Byte cfr_ignored_0 = agrMap.put(agrId, null);
                    });
                    agrSyncBusiPropLabelAbilityReqBo.setAgreementIds(agrMap);
                    agrSyncBusiPropLabelAbilityReqBo.setSyncSource("add");
                    this.agrSyncBusiPropLabelAbilityService.dealSyncBusiPropLabel(agrSyncBusiPropLabelAbilityReqBo);
                    AgrSyncErjiAgreementAbilityReqBO agrSyncErjiAgreementAbilityReqBo = new AgrSyncErjiAgreementAbilityReqBO();
                    agrSyncErjiAgreementAbilityReqBo.setAgreementIds(agreementIds);
                    this.agrSyncErjiAgreementAbilityService.dealSyncErjiAgreement(agrSyncErjiAgreementAbilityReqBo);
                }
            }
            catch (Exception agrSyncContractInterfaceLogPO4) {
                // empty catch block
            }
            try {
                List<String> collectMeasureNames;
                if (!CollectionUtils.isEmpty((Collection)reqBo.getItemList()) && !CollectionUtils.isEmpty(collectMeasureNames = reqBo.getItemList().stream().map(OpsContractItemBO::getMeasureName).filter(StringUtils::hasText).distinct().collect(Collectors.toList()))) {
                    UccCommdMeasureInfoReqBo uccCommdMeasureInfoReqBo = new UccCommdMeasureInfoReqBo();
                    uccCommdMeasureInfoReqBo.setMeasureNames(collectMeasureNames);
                    UccCommdMeasureInfoRspBo uccCommdMeasureInfoRspBo = this.uccCommdMeasureInfoBusiService.queryByBinaryNames(uccCommdMeasureInfoReqBo);
                    if ("0000".equals(uccCommdMeasureInfoRspBo.getRespCode()) && !CollectionUtils.isEmpty((Collection)uccCommdMeasureInfoRspBo.getRows())) {
                        List uccCommodityMeasureBos = JSONArray.parseArray((String)JSONArray.toJSONString((Object)uccCommdMeasureInfoRspBo.getRows()), UccCommodityMeasureBo.class);
                        collectMeasureNames.removeAll(uccCommodityMeasureBos.stream().map(UccCommodityMeasureBo::getMeasureName).collect(Collectors.toList()));
                    }
                    if (!CollectionUtils.isEmpty(collectMeasureNames)) {
                        UccCommdMeasureReqBo uccCommdMeasureReqBo = new UccCommdMeasureReqBo();
                        uccCommdMeasureReqBo.setUsername("sys");
                        uccCommdMeasureReqBo.setMeasureType(Integer.valueOf(0));
                        collectMeasureNames.forEach(measureName -> {
                            uccCommdMeasureReqBo.setMeasureName(measureName);
                            this.uccCommdMeasureInfoBusiService.addMeasure(uccCommdMeasureReqBo);
                        });
                    }
                }
            }
            catch (Exception collectMeasureNames) {
                // empty catch block
            }
            try {
                AgrSkuUnbindStandardSpuAbilityReqBO agrSkuUnbindStandardSpuAbilityReqBO;
                if (!CollectionUtils.isEmpty((Collection)rspBo.getDeleteAgrSkuIds())) {
                    agrSkuUnbindStandardSpuAbilityReqBO = new AgrSkuUnbindStandardSpuAbilityReqBO();
                    agrSkuUnbindStandardSpuAbilityReqBO.setAgreementSkuIds(rspBo.getDeleteAgrSkuIds());
                    agrSkuUnbindStandardSpuAbilityReqBO.setDispatch(Boolean.FALSE);
                    this.agrSkuUnbindStandardSpuAbilityService.dealSkuUnbindStandardSpu(agrSkuUnbindStandardSpuAbilityReqBO);
                }
                if (!CollectionUtils.isEmpty((Collection)rspBo.getPriceChangeAgrSkuIds())) {
                    agrSkuUnbindStandardSpuAbilityReqBO = new AgrSkuUnbindStandardSpuAbilityReqBO();
                    agrSkuUnbindStandardSpuAbilityReqBO.setAgreementSkuIds(rspBo.getPriceChangeAgrSkuIds());
                    agrSkuUnbindStandardSpuAbilityReqBO.setDispatch(Boolean.TRUE);
                    this.agrSkuUnbindStandardSpuAbilityService.dealSkuUnbindStandardSpu(agrSkuUnbindStandardSpuAbilityReqBO);
                }
            }
            catch (Exception agrSkuUnbindStandardSpuAbilityReqBO) {}
        } else {
            try {
                agrSyncContractInterfaceLogPO4 = new AgrSyncContractInterfaceLogPO();
                agrSyncContractInterfaceLogPO4.setLogId(logId);
                agrSyncContractInterfaceLogPO4.setResult(rspBo.getRespDesc());
                agrSyncContractInterfaceLogPO4.setDealResult(AgrEnum.SuccessOrError.ERROR.getCode());
                if (logFlag) {
                    this.agrSyncContractInterfaceLogMapper.updateById(agrSyncContractInterfaceLogPO4);
                } else {
                    agrSyncContractInterfaceLogPO4.setCreateTime(new Date());
                    agrSyncContractInterfaceLogPO4.setRelSystem(AgrEnum.RelSystem.OPS.toString());
                    agrSyncContractInterfaceLogPO4.setInterfaceType(AgrEnum.SyncContractInterfaceType.receive.getType());
                    agrSyncContractInterfaceLogPO4.setInterfaceName(AgrEnum.SyncContractInterfaceName.syncOpsContract.toString());
                    agrSyncContractInterfaceLogPO4.setKeyParam(reqBo.getContractCode());
                    agrSyncContractInterfaceLogPO4.setParams(JSON.toJSONString((Object)reqBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteBigDecimalAsPlain}));
                    this.agrSyncContractInterfaceLogMapper.insert(agrSyncContractInterfaceLogPO4);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return rspBo;
    }

    private void validPrams(OpsContractSyncAbilityReqBO reqBo) {
        List paymentBOS;
        if (reqBo == null || !StringUtils.hasText((String)reqBo.getReqOperType())) {
            throw new ZTBusinessException("\u8bf7\u6c42\u64cd\u4f5c\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (!AgrEnum.OpsSyncOperType.oper_create.getType().equals(reqBo.getReqOperType()) && !AgrEnum.OpsSyncOperType.oper_modify.getType().equals(reqBo.getReqOperType())) {
            throw new ZTBusinessException("\u8bf7\u6c42\u64cd\u4f5c\u7c7b\u578b\u9519\u8bef");
        }
        if (!StringUtils.hasText((String)reqBo.getContractId())) {
            throw new ZTBusinessException("\u5408\u540cID\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBo.getContractCode())) {
            throw new ZTBusinessException("\u5408\u540c\u7f16\u7801\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBo.getContractName())) {
            throw new ZTBusinessException("\u5408\u540c\u540d\u79f0\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBo.getContractVersion())) {
            throw new ZTBusinessException("\u5408\u540c\u7248\u672c\u53f7\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBo.getPlanType())) {
            throw new ZTBusinessException("\u8ba1\u5212\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBo.getIsOnlineContract())) {
            throw new ZTBusinessException("\u662f\u5426\u7ebf\u4e0a\u5408\u540c\u4e3a\u7a7a");
        }
        if (AgrEnum.YesOrNo.YES.getCode().toString().equals(reqBo.getIsOnlineContract()) && !StringUtils.hasText((String)reqBo.getPackCode())) {
            throw new ZTBusinessException("\u5305\u7f16\u53f7\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBo.getContractType())) {
            throw new ZTBusinessException("\u5408\u540c\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBo.getPurchaseType())) {
            throw new ZTBusinessException("\u91c7\u8d2d\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBo.getCenterPurchaseType())) {
            throw new ZTBusinessException("\u96c6\u4e2d\u91c7\u8d2d\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBo.getPaymentMethod())) {
            throw new ZTBusinessException("\u8d26\u671f\u8d77\u7b97\u8282\u70b9\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)AgrEnum.OpsPaymentMethod.getCode((String)reqBo.getPaymentMethod()))) {
            throw new ZTBusinessException("\u8d26\u671f\u8d77\u7b97\u8282\u70b9\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        if (!StringUtils.hasText((String)reqBo.getPurchaseWay())) {
            throw new ZTBusinessException("\u91c7\u8d2d\u65b9\u5f0f\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBo.getVendorSource())) {
            throw new ZTBusinessException("\u6f5c\u5728\u4f9b\u5e94\u5546\u6765\u6e90\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBo.getVendorCode())) {
            throw new ZTBusinessException("\u4f9b\u5e94\u5546\u7f16\u7801\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBo.getSignDate())) {
            throw new ZTBusinessException("\u5408\u540c\u7b7e\u8ba2\u65f6\u95f4\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBo.getContractAmount())) {
            throw new ZTBusinessException("\u5408\u540c\u91d1\u989d\u4e3a\u7a7a");
        }
        String regex = "\\d+(\\.\\d{1,2})?";
        if (!reqBo.getContractAmount().matches(regex)) {
            throw new ZTBusinessException("\u5408\u540c\u91d1\u989d\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        if (AgrEnum.OpsContractType.DJ.getCode().equals(reqBo.getContractType())) {
            if (!StringUtils.hasText((String)reqBo.getAgreementTentativeAmount())) {
                throw new ZTBusinessException("\u6682\u4f30\u603b\u4ef7\u5408\u540c/\u5355\u4ef7\u5408\u540c\u6682\u4f30\u603b\u4ef7\u5408\u540c\u4e3a\u7a7a");
            }
            if (!reqBo.getAgreementTentativeAmount().matches(regex)) {
                throw new ZTBusinessException("\u5408\u540c\u91d1\u989d\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
        }
        if (!StringUtils.hasText((String)reqBo.getContractSigningAmount())) {
            reqBo.setContractSigningAmount(null);
        }
        if (!StringUtils.hasText((String)reqBo.getAgreementTentativeAmount())) {
            reqBo.setAgreementTentativeAmount(null);
        }
        if (!StringUtils.hasText((String)reqBo.getCreator())) {
            throw new ZTBusinessException("\u8d77\u8349\u4eba\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBo.getCreatorOrgCode())) {
            throw new ZTBusinessException("\u8d77\u8349\u4eba\u6240\u5c5e\u5355\u4f4d\u7f16\u7801\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBo.getCurrencyCode())) {
            throw new ZTBusinessException("\u5e01\u79cd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBo.getIsElePurchase())) {
            throw new ZTBusinessException("\u662f\u5426\u7535\u5b50\u91c7\u8d2d\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBo.getIsConstructionProject())) {
            throw new ZTBusinessException("\u662f\u5426\u5de5\u7a0b\u5efa\u8bbe\u9879\u76ee\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBo.getContractStatus())) {
            throw new ZTBusinessException("\u5408\u540c\u72b6\u6001\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBo.getSupplierName())) {
            throw new ZTBusinessException("\u4f9b\u5e94\u5546\u8054\u7cfb\u4eba\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBo.getSupplierPhone())) {
            throw new ZTBusinessException("\u4f9b\u5e94\u5546\u8054\u7cfb\u4eba\u8054\u7cfb\u65b9\u5f0f\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBo.getAdjustPrice())) {
            throw new ZTBusinessException("\u8c03\u4ef7\u673a\u5236\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBo.getContractualRelationship())) {
            throw new ZTBusinessException("\u5408\u540c\u5173\u7cfb\u4e3a\u7a7a");
        }
        if (AgrEnum.OpsPayMethod.JDJEFK.toString().equals(reqBo.getPayMethod())) {
            if (CollectionUtils.isEmpty((Collection)reqBo.getPaymentList())) {
                throw new ZTBusinessException("\u5206\u9636\u6bb5\u6309\u91d1\u989d\u652f\u4ed8\u65f6\uff0c\u5206\u9636\u6bb5\u652f\u4ed8\u6761\u6b3e\u4e3a\u7a7a");
            }
            paymentBOS = reqBo.getPaymentList().stream().filter(o -> !StringUtils.hasText((String)o.getPaymentName())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(paymentBOS)) {
                throw new ZTBusinessException("\u5206\u9636\u6bb5\u6309\u91d1\u989d\u652f\u4ed8\u65f6\uff0c\u652f\u4ed8\u8282\u70b9\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (AgrEnum.OpsPayMethod.JDBLFK.toString().equals(reqBo.getPayMethod())) {
            if (CollectionUtils.isEmpty((Collection)reqBo.getPaymentList())) {
                throw new ZTBusinessException("\u5206\u9636\u6bb5\u6309\u6bd4\u4f8b\u652f\u4ed8\u65f6\uff0c\u5206\u9636\u6bb5\u652f\u4ed8\u6761\u6b3e\u4e3a\u7a7a");
            }
            paymentBOS = reqBo.getPaymentList().stream().filter(o -> !StringUtils.hasText((String)o.getPaymentName()) || null == o.getPaymentValue()).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(paymentBOS)) {
                throw new ZTBusinessException("\u5206\u9636\u6bb5\u6309\u6bd4\u4f8b\u652f\u4ed8\u65f6\uff0c\u652f\u4ed8\u8282\u70b9/\u652f\u4ed8\u6bd4\u4f8b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            BigDecimal reduceValueSum = reqBo.getPaymentList().stream().map(OpsContractPaymentBO::getPaymentValue).map(BigDecimal::new).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (reduceValueSum.compareTo(new BigDecimal("100")) != 0) {
                throw new BusinessException("8888", "\u5206\u9636\u6bb5\u4ed8\u6b3e-\u5404\u9636\u6bb5\u6bd4\u4f8b\u603b\u548c\u5fc5\u987b\u4e3a100");
            }
        }
        if (AgrEnum.OpsCenterPurchaseType.EJJC.getCode().equals(reqBo.getCenterPurchaseType()) && !StringUtils.hasText((String)reqBo.getCGSSDWJGBH())) {
            throw new ZTBusinessException("\u91c7\u8d2d\u5b9e\u65bd\u5355\u4f4d\u673a\u6784\u7f16\u53f7\u4e3a\u7a7a");
        }
        if (StringUtils.hasText((String)reqBo.getCGSSDWJGBH())) {
            EnterpriseOrgExtMapJoinBO purchaseOrgExtMapJoinBO = this.qryOrgId(reqBo.getCGSSDWJGBH());
            if (purchaseOrgExtMapJoinBO == null) {
                throw new ZTBusinessException("\u91c7\u8d2d\u5b9e\u65bd\u5355\u4f4d\u673a\u6784\u7f16\u53f7\u67e5\u8be2\u4e0d\u5b58\u5728!");
            }
            reqBo.setPurImpUnitOrgId(purchaseOrgExtMapJoinBO.getOrgId());
            reqBo.setPurImpUnitOrgName(purchaseOrgExtMapJoinBO.getOrgName());
        }
        if (!StringUtils.hasText((String)reqBo.getPaymentDays())) {
            throw new ZTBusinessException("\u8d26\u671f\u5929\u6570\u4e3a\u7a7a");
        }
        if (!this.isInteger(reqBo.getPaymentDays())) {
            throw new ZTBusinessException("\u8d26\u671f\u5929\u6570\u8bf7\u586b\u5199\u6574\u6570");
        }
        if (!AgrEnum.OpsContractType.GDZJ.getOpsCode().equals(reqBo.getContractType())) {
            if (!StringUtils.hasText((String)reqBo.getScopeType()) || AgrEnum.OpsScopeType.getByCode((String)reqBo.getScopeType()) == null) {
                throw new ZTBusinessException("\u9002\u7528\u8303\u56f4\u4e3a\u7a7a\u6216\u672a\u77e5\u7684\u8303\u56f4\u7c7b\u578b");
            }
        } else {
            reqBo.setScopeType(AgrEnum.OpsScopeType.SELF.getOpsScopeTypeCode());
            if (CollectionUtils.isEmpty((Collection)reqBo.getScopeList())) {
                OpsContractScopeBO contractScopeBO = new OpsContractScopeBO();
                contractScopeBO.setOrgCode(reqBo.getCreatorOrgCode());
                reqBo.setScopeList(Collections.singletonList(contractScopeBO));
            }
        }
        if (Arrays.asList(AgrEnum.OpsScopeType.PLATE.getOpsScopeTypeCode(), AgrEnum.OpsScopeType.MEMBER.getOpsScopeTypeCode()).contains(reqBo.getScopeType()) && CollectionUtils.isEmpty((Collection)reqBo.getScopeList())) {
            throw new ZTBusinessException("\u9002\u7528\u8303\u56f4\u4e3a\u677f\u5757\u3001\u6210\u5458\u5355\u4f4d\u65f6\uff0c\u9002\u7528\u5355\u4f4d\u5fc5\u586b");
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getItemList())) {
            List catalogCodes;
            Object sj;
            UccMaterialCommodityTypeBO uccMaterialCommodityTypeBo;
            Map<Object, Object> catalogAndVarietyMap;
            Map<Object, Object> catalogAndFreezeMap;
            List allCatalogCodes = reqBo.getItemList().stream().map(OpsContractItemBO::getCatalogCode).collect(Collectors.toList());
            CnncCatalogListQueryAbilityReqBO cnncCatalogListQueryAbilityReqBO = new CnncCatalogListQueryAbilityReqBO();
            cnncCatalogListQueryAbilityReqBO.setCatalogCodes(allCatalogCodes);
            CnncCatalogListQueryAbilityRspBO cnncCatalogListQueryAbilityRspBO = this.cnncCatalogListQueryAbilityService.qryCatalogList(cnncCatalogListQueryAbilityReqBO);
            if (!CollectionUtils.isEmpty((Collection)cnncCatalogListQueryAbilityRspBO.getCatalogBOList())) {
                catalogAndFreezeMap = cnncCatalogListQueryAbilityRspBO.getCatalogBOList().stream().collect(Collectors.toMap(UccEMdmCatalogBO::getCatalogCode, obj -> {
                    if (YesNoEnum.NO.getType().equals(obj.getFreezeFlag()) && YesNoEnum.NO.getType().equals(obj.getIsDelete())) {
                        return YesNoEnum.NO.getType();
                    }
                    return YesNoEnum.YES.getType();
                }, (a, b) -> a));
                catalogAndVarietyMap = cnncCatalogListQueryAbilityRspBO.getCatalogBOList().stream().collect(Collectors.toMap(UccEMdmCatalogBO::getCatalogCode, UccEMdmCatalogBO::getVariety, (a, b) -> a));
            } else {
                catalogAndFreezeMap = Collections.emptyMap();
                catalogAndVarietyMap = Collections.emptyMap();
            }
            for (OpsContractItemBO item : reqBo.getItemList()) {
                if (!StringUtils.hasText((String)item.getContractItemId()) || !StringUtils.hasText((String)item.getContractItemCode())) {
                    throw new ZTBusinessException("\u5408\u540c\u660e\u7ec6ID\u6216\u5408\u540c\u660e\u7ec6\u7f16\u53f7\u4e3a\u7a7a");
                }
                if (!StringUtils.hasText((String)item.getItemName())) {
                    throw new ZTBusinessException("\u660e\u7ec6[" + item.getContractItemCode() + "]\u7269\u9879\u540d\u79f0\u4e3a\u7a7a");
                }
                if (!StringUtils.hasText((String)item.getPurchaseType())) {
                    throw new ZTBusinessException("\u660e\u7ec6[" + item.getContractItemCode() + "]\u91c7\u8d2d\u7c7b\u578b\u4e3a\u7a7a");
                }
                if (!StringUtils.hasText((String)item.getCatalogCode())) {
                    throw new ZTBusinessException("\u660e\u7ec6[" + item.getContractItemCode() + "]\u7269\u9879\u5206\u7c7b\u4e3a\u7a7a");
                }
                if (!StringUtils.hasText((String)item.getMeasureName())) {
                    throw new ZTBusinessException("\u660e\u7ec6[" + item.getContractItemCode() + "]\u8ba1\u91cf\u5355\u4f4d\u4e3a\u7a7a");
                }
                if (!StringUtils.hasText((String)item.getSupplyCycle())) {
                    throw new ZTBusinessException("\u660e\u7ec6[" + item.getContractItemCode() + "]\u4f9b\u8d27\u5468\u671f\u4e3a\u7a7a");
                }
                if (!this.isInteger(item.getSupplyCycle())) {
                    throw new ZTBusinessException("\u4f9b\u8d27\u5468\u671f\u8bf7\u586b\u5199\u6574\u6570");
                }
                if (AgrEnum.Variety.WZ.getCode().toString().equals(item.getPurchaseType())) {
                    if (!StringUtils.hasText((String)item.getTaxRate())) {
                        throw new ZTBusinessException("\u660e\u7ec6[" + item.getContractItemCode() + "]\u7a0e\u7387\u4e3a\u7a7a");
                    }
                    if (!StringUtils.hasText((String)item.getMaterialCode())) {
                        throw new ZTBusinessException("\u660e\u7ec6[" + item.getContractItemCode() + "]\u7269\u8d44\u7f16\u7801\u4e3a\u7a7a");
                    }
                    if (!StringUtils.hasText((String)item.getProducingArea())) {
                        throw new ZTBusinessException("\u660e\u7ec6[" + item.getContractItemCode() + "]\u7269\u8d44\u4ea7\u5730\u4e3a\u7a7a");
                    }
                } else {
                    Integer freeze = (Integer)catalogAndFreezeMap.get(item.getCatalogCode());
                    if (YesNoEnum.NO.getType().equals(freeze)) {
                        if (!StringUtils.hasText((String)item.getMaterialCode())) {
                            throw new ZTBusinessException("\u660e\u7ec6[" + item.getContractItemCode() + "]\u7269\u8d44\u7f16\u7801\u4e3a\u7a7a");
                        }
                    } else {
                        Integer variety = (Integer)catalogAndVarietyMap.get(item.getCatalogCode());
                        if (AgrEnum.Variety.GC.getCode().equals(variety) || AgrEnum.Variety.FW.getCode().equals(variety)) {
                            item.setMaterialCode(null);
                        }
                    }
                }
                if (!StringUtils.hasText((String)item.getBuyNumber())) {
                    throw new ZTBusinessException("\u660e\u7ec6[" + item.getContractItemCode() + "]\u6570\u91cf\u4e3a\u7a7a");
                }
                if (!StringUtils.hasText((String)item.getBuyPrice())) {
                    throw new ZTBusinessException("\u660e\u7ec6[" + item.getContractItemCode() + "]\u5355\u4ef7\u4e3a\u7a7a");
                }
                if (!StringUtils.hasText((String)item.getTotalPrice())) {
                    throw new ZTBusinessException("\u660e\u7ec6[" + item.getContractItemCode() + "]\u603b\u4ef7\u4e3a\u7a7a");
                }
                if (new BigDecimal(item.getBuyNumber()).compareTo(AgrCommConstant.MAX_NUMBER) > 0) {
                    throw new ZTBusinessException("\u660e\u7ec6[" + item.getContractItemCode() + "]\u6570\u91cf\u8d85\u51fa\u53ef\u63a5\u6536\u6700\u5927\u8303\u56f4\uff0812\u4f4d\u6574\u6570+6\u4f4d\u5c0f\u6570\uff09");
                }
                if (new BigDecimal(item.getBuyPrice()).compareTo(AgrCommConstant.MAX_PRICE) > 0) {
                    throw new ZTBusinessException("\u660e\u7ec6[" + item.getContractItemCode() + "]\u5355\u4ef7\u8d85\u51fa\u53ef\u63a5\u6536\u6700\u5927\u8303\u56f4\uff0814\u4f4d\u6574\u6570+4\u4f4d\u5c0f\u6570\uff09");
                }
                if (new BigDecimal(item.getTotalPrice()).compareTo(AgrCommConstant.MAX_PRICE) > 0) {
                    throw new ZTBusinessException("\u660e\u7ec6[" + item.getContractItemCode() + "]\u603b\u4ef7\u8d85\u51fa\u53ef\u63a5\u6536\u6700\u5927\u8303\u56f4\uff0814\u4f4d\u6574\u6570+4\u4f4d\u5c0f\u6570\uff09");
                }
                if (!StringUtils.hasText((String)item.getCurrency())) {
                    throw new ZTBusinessException("\u660e\u7ec6[" + item.getContractItemCode() + "]\u5e01\u79cd\u4e3a\u7a7a");
                }
                if (!StringUtils.hasText((String)item.getWarantty())) {
                    throw new ZTBusinessException("\u660e\u7ec6[" + item.getContractItemCode() + "]\u8d28\u4fdd\u671f\u4e3a\u7a7a");
                }
                if (!this.isInteger(item.getWarantty())) {
                    throw new ZTBusinessException("\u8d28\u4fdd\u671f\u8bf7\u586b\u5199\u6574\u6570");
                }
                if (StringUtils.hasText((String)item.getDifferencesAcceptance())) continue;
                throw new ZTBusinessException("\u660e\u7ec6[" + item.getContractItemCode() + "]\u662f\u5426\u5141\u8bb8\u5dee\u5f02\u9a8c\u6536\u4e3a\u7a7a");
            }
            List materialCodes = reqBo.getItemList().stream().map(OpsContractItemBO::getMaterialCode).filter(StringUtils::hasText).distinct().collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(materialCodes)) {
                UccQryCommodityTypeByMaterialReqBO uccQryCommodityTypeByMaterialReqBo = new UccQryCommodityTypeByMaterialReqBO();
                uccQryCommodityTypeByMaterialReqBo.setMaterialCodes(materialCodes);
                UccQryCommodityTypeByMaterialRspBO uccQryCommodityTypeByMaterialRspBo = this.uccQryCommodityTypeByMaterialService.qryCommodityTypeByMaterial(uccQryCommodityTypeByMaterialReqBo);
                if (!"0000".equals(uccQryCommodityTypeByMaterialRspBo.getRespCode()) || CollectionUtils.isEmpty((Collection)uccQryCommodityTypeByMaterialRspBo.getMaterialTypes())) {
                    throw new ZTBusinessException("\u6821\u9a8c\u660e\u7ec6\u7269\u8d44\u7f16\u7801\u5931\u8d25");
                }
                Map<String, UccMaterialCommodityTypeBO> collectByMaterialCode = uccQryCommodityTypeByMaterialRspBo.getMaterialTypes().stream().collect(Collectors.toMap(UccMaterialCommodityTypeBO::getMaterialCode, bo -> bo, (a, b) -> a));
                HashSet<String> sjCheckMaterial = new HashSet<String>();
                HashSet<String> sjCheckMaterialAndL3Catalog = new HashSet<String>();
                for (OpsContractItemBO item : reqBo.getItemList()) {
                    if (!StringUtils.hasText((String)item.getMaterialCode())) continue;
                    uccMaterialCommodityTypeBo = collectByMaterialCode.get(item.getMaterialCode());
                    if (uccMaterialCommodityTypeBo == null || CollectionUtils.isEmpty((Map)uccMaterialCommodityTypeBo.getTypeIdAndName())) {
                        sjCheckMaterial.add(item.getMaterialCode());
                        continue;
                    }
                    if (item.getCatalogCode().equals(uccMaterialCommodityTypeBo.getL3CatalogCode())) continue;
                    sjCheckMaterialAndL3Catalog.add(item.getMaterialCode());
                }
                if (!CollectionUtils.isEmpty(sjCheckMaterial)) {
                    sj = new StringJoiner(",", "[", "]");
                    sjCheckMaterial.forEach(((StringJoiner)sj)::add);
                    throw new ZTBusinessException("\u660e\u7ec6\u7269\u8d44\u7f16\u7801" + sj + "\u4e0d\u5b58\u5728");
                }
                if (!CollectionUtils.isEmpty(sjCheckMaterialAndL3Catalog)) {
                    sj = new StringJoiner(",", "[", "]");
                    sjCheckMaterialAndL3Catalog.forEach(((StringJoiner)sj)::add);
                    throw new ZTBusinessException("\u660e\u7ec6\u7269\u8d44\u7f16\u7801" + sj + "\u5bf9\u5e94\u7684\u7269\u8d44\u5206\u7c7b\u4e0d\u5b58\u5728\u6216\u4e0d\u4e00\u81f4");
                }
            }
            if (!CollectionUtils.isEmpty(catalogCodes = reqBo.getItemList().stream().map(OpsContractItemBO::getCatalogCode).filter(str -> StringUtils.hasText((String)str) && YesNoEnum.YES.getType().equals(catalogAndFreezeMap.get(str))).distinct().collect(Collectors.toList()))) {
                UccQryCommodityTypeByMaterialReqBO uccQryCommodityTypeByMaterialReqBo = new UccQryCommodityTypeByMaterialReqBO();
                uccQryCommodityTypeByMaterialReqBo.setSecondCatalogs(catalogCodes);
                UccQryCommodityTypeByMaterialRspBO uccQryCommodityTypeByMaterialRspBo = this.uccQryCommodityTypeByMaterialService.qryCommodityTypeByl2CatalogCode(uccQryCommodityTypeByMaterialReqBo);
                if (!"0000".equals(uccQryCommodityTypeByMaterialRspBo.getRespCode()) || CollectionUtils.isEmpty((Collection)uccQryCommodityTypeByMaterialRspBo.getMaterialTypes())) {
                    throw new ZTBusinessException("\u6821\u9a8c\u660e\u7ec6\u7269\u8d44\u5206\u7c7b\u5931\u8d25");
                }
                Map<String, UccMaterialCommodityTypeBO> collectByCatalogCode = uccQryCommodityTypeByMaterialRspBo.getMaterialTypes().stream().collect(Collectors.toMap(UccMaterialCommodityTypeBO::getL2CatalogCode, bo -> bo, (a, b) -> a));
                HashSet<String> sjCheckCatalogCode = new HashSet<String>();
                for (OpsContractItemBO item : reqBo.getItemList()) {
                    if (!YesNoEnum.YES.getType().equals(catalogAndFreezeMap.get(item.getCatalogCode())) || (uccMaterialCommodityTypeBo = collectByCatalogCode.get(item.getCatalogCode())) != null && !CollectionUtils.isEmpty((Map)uccMaterialCommodityTypeBo.getTypeIdAndName())) continue;
                    sjCheckCatalogCode.add(item.getCatalogCode());
                }
                if (!CollectionUtils.isEmpty(sjCheckCatalogCode)) {
                    sj = new StringJoiner(",", "[", "]");
                    sjCheckCatalogCode.forEach(((StringJoiner)sj)::add);
                    throw new ZTBusinessException("\u660e\u7ec6\u7269\u8d44\u5206\u7c7b" + sj + "\u4e0d\u5b58\u5728");
                }
            }
        }
    }

    private EnterpriseOrgExtMapJoinBO qryOrgId(String esbOrgCode) {
        EnterpriseOrgExtMapJoinBO enterpriseOrgExtMapJoinBO = null;
        UmcOrgExtMapOperateAbilityReqBO umcOrgExtMapOperateAbilityReqBO = new UmcOrgExtMapOperateAbilityReqBO();
        umcOrgExtMapOperateAbilityReqBO.setFieldValue(esbOrgCode);
        umcOrgExtMapOperateAbilityReqBO.setFieldCode("esbOrgCode");
        umcOrgExtMapOperateAbilityReqBO.setOperateType(UmcCommConstant.UmcOrgExtMapOperateStatus.JOIN_QRY);
        UmcOrgExtMapOperateAbilityRspBO umcOrgExtMapOperateAbilityRspBO = this.umcOrgExtMapOperateAbilityService.operate(umcOrgExtMapOperateAbilityReqBO);
        if (!"0000".equals(umcOrgExtMapOperateAbilityRspBO.getRespCode())) {
            throw new ZTBusinessException("\u67e5\u8be2\u7edf\u4e00\u8ba4\u8bc1\u552f\u4e00\u6807\u8bc6\u5931\u8d25");
        }
        if (!CollectionUtils.isEmpty((Collection)umcOrgExtMapOperateAbilityRspBO.getRows())) {
            enterpriseOrgExtMapJoinBO = (EnterpriseOrgExtMapJoinBO)umcOrgExtMapOperateAbilityRspBO.getRows().get(0);
        }
        return enterpriseOrgExtMapJoinBO;
    }

    public boolean isInteger(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

