/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.ability.impl;

import com.ohaotian.plugin.base.bo.RspPage;
import com.tydic.agreement.ability.SrmAgreementContractCheckAbilityService;
import com.tydic.agreement.ability.bo.SrmAgreementContractCheckAbilityReqBO;
import com.tydic.agreement.ability.bo.SrmAgreementContractCheckAbilityRspBO;
import com.tydic.agreement.dao.SrmContractItemMapper;
import com.tydic.agreement.dao.SrmContractMapper;
import com.tydic.agreement.dao.po.SrmContractItemPO;
import com.tydic.agreement.dao.po.SrmContractPO;
import com.tydic.contract.api.maintenance.bo.ContractSupplierSaleReqBO;
import com.tydic.contract.api.maintenance.bo.ContractSupplierSaleRspBO;
import com.tydic.contract.api.maintenance.service.QryContractSupplierListSaleService;
import com.tydic.uccext.bo.UccMaterialCommodityTypeBO;
import com.tydic.uccext.bo.UccQryCommodityTypeByMaterialReqBO;
import com.tydic.uccext.bo.UccQryCommodityTypeByMaterialRspBO;
import com.tydic.uccext.service.UccQryCommodityTypeByMaterialService;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_TEST/2.0.0/com.tydic.agreement.ability.SrmAgreementContractCheckAbilityService"})
public class SrmAgreementContractCheckAbilityServiceImpl
implements SrmAgreementContractCheckAbilityService {
    @Autowired
    private SrmContractMapper srmContractMapper;
    @Autowired
    private SrmContractItemMapper srmContractItemMapper;
    @Autowired
    private UccQryCommodityTypeByMaterialService uccQryCommodityTypeByMaterialService;
    @Autowired
    private QryContractSupplierListSaleService qryContractSupplierListSaleService;

    @PostMapping(value={"checkContract"})
    public SrmAgreementContractCheckAbilityRspBO checkContract(@RequestBody SrmAgreementContractCheckAbilityReqBO reqBo) {
        SrmAgreementContractCheckAbilityRspBO rspBo = new SrmAgreementContractCheckAbilityRspBO();
        if (reqBo == null || reqBo.getContractId() == null || !StringUtils.hasText((String)reqBo.getSrmContractCode())) {
            rspBo.setCheckResult(Boolean.valueOf(false));
            rspBo.setRespCode("0001");
            rspBo.setRespDesc("\u8bf7\u6c42\u5fc5\u4f20\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        SrmContractPO srmContractPo = new SrmContractPO();
        srmContractPo.setContractCode(reqBo.getSrmContractCode());
        srmContractPo = this.srmContractMapper.getModelBy(srmContractPo);
        if (srmContractPo == null) {
            rspBo.setCheckResult(Boolean.valueOf(false));
            rspBo.setRespCode("0002");
            rspBo.setRespDesc("\u672a\u67e5\u8be2\u5230SRM\u534f\u8bae\u4fe1\u606f");
            return rspBo;
        }
        SrmContractItemPO srmContractItemPo = new SrmContractItemPO();
        srmContractItemPo.setContractCode(reqBo.getSrmContractCode());
        List<SrmContractItemPO> srmContractItemPos = this.srmContractItemMapper.getList(srmContractItemPo);
        if (CollectionUtils.isEmpty(srmContractItemPos)) {
            rspBo.setCheckResult(Boolean.valueOf(true));
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u6210\u529f");
            return rspBo;
        }
        List srmMaterial = srmContractItemPos.stream().map(SrmContractItemPO::getMaterialId).distinct().collect(Collectors.toList());
        UccQryCommodityTypeByMaterialReqBO uccQryCommodityTypeByMaterialReqBo = new UccQryCommodityTypeByMaterialReqBO();
        uccQryCommodityTypeByMaterialReqBo.setMaterialCodes(srmMaterial);
        UccQryCommodityTypeByMaterialRspBO uccQryCommodityTypeByMaterialRspBo = this.uccQryCommodityTypeByMaterialService.qryCommodityTypeByMaterial(uccQryCommodityTypeByMaterialReqBo);
        if (!"0000".equals(uccQryCommodityTypeByMaterialRspBo.getRespCode())) {
            rspBo.setCheckResult(Boolean.valueOf(false));
            rspBo.setRespCode("0002");
            rspBo.setRespDesc("\u67e5\u8be2SRM\u534f\u8bae\u660e\u7ec6\u7269\u8d44\u7f16\u7801\u4fe1\u606f\u5931\u8d25");
            return rspBo;
        }
        Map<String, UccMaterialCommodityTypeBO> uccMaterial = uccQryCommodityTypeByMaterialRspBo.getMaterialTypes().stream().collect(Collectors.toMap(UccMaterialCommodityTypeBO::getMaterialCode, obj -> obj, (a, b) -> a));
        if (srmMaterial.size() != uccMaterial.keySet().size()) {
            rspBo.setCheckResult(Boolean.valueOf(false));
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u6210\u529f");
            return rspBo;
        }
        ContractSupplierSaleReqBO contractSupplierSaleReqBO = new ContractSupplierSaleReqBO();
        contractSupplierSaleReqBO.setContractId(reqBo.getContractId());
        contractSupplierSaleReqBO.setPageNo(-1);
        contractSupplierSaleReqBO.setPageSize(-1);
        RspPage contractSupplierSalePage = this.qryContractSupplierListSaleService.selecContractSupplierList(contractSupplierSaleReqBO);
        Set contractTypes = null;
        if (contractSupplierSalePage == null || CollectionUtils.isEmpty((Collection)contractSupplierSalePage.getRows())) {
            rspBo.setCheckResult(Boolean.valueOf(false));
            rspBo.setRespCode("0002");
            rspBo.setRespDesc("\u672a\u67e5\u8be2\u5230\u5165\u9a7b\u5408\u540c\u4fe1\u606f");
            return rspBo;
        }
        contractTypes = contractSupplierSalePage.getRows().stream().map(ContractSupplierSaleRspBO::getCategoryId).collect(Collectors.toSet());
        long typeIsNullCount = uccMaterial.values().stream().filter(bo -> CollectionUtils.isEmpty((Map)bo.getTypeIdAndName())).count();
        if (typeIsNullCount > 0L) {
            rspBo.setCheckResult(Boolean.valueOf(false));
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u6210\u529f");
            return rspBo;
        }
        for (Map.Entry<String, UccMaterialCommodityTypeBO> entry : uccMaterial.entrySet()) {
            Set uccTypes = entry.getValue().getTypeIdAndName().keySet();
            boolean anyExists = false;
            for (Long typeId : uccTypes) {
                if (!contractTypes.contains(typeId)) continue;
                anyExists = true;
                break;
            }
            if (anyExists) continue;
            rspBo.setCheckResult(Boolean.valueOf(false));
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u6210\u529f");
            return rspBo;
        }
        rspBo.setCheckResult(Boolean.valueOf(true));
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

