/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.ability.impl;

import com.tydic.agreement.ability.SrmContractBindCheckAbilityService;
import com.tydic.agreement.ability.bo.SrmContractBindCheckReqBO;
import com.tydic.agreement.ability.bo.SrmContractBindCheckRspBO;
import com.tydic.agreement.constant.AgrCommConstant;
import com.tydic.agreement.constant.AgrEnum;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.SrmContractMapper;
import com.tydic.agreement.dao.SrmContractRelUpperMapper;
import com.tydic.agreement.dao.po.AgreementPO;
import com.tydic.agreement.dao.po.SrmContractPO;
import com.tydic.agreement.dao.po.SrmContractRelUpperPO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_TEST/2.0.0/com.tydic.agreement.ability.SrmContractBindCheckAbilityService"})
public class SrmContractBindCheckAbilityServiceImpl
implements SrmContractBindCheckAbilityService {
    @Autowired
    private SrmContractMapper srmContractMapper;
    @Autowired
    private SrmContractRelUpperMapper srmContractRelUpperMapper;
    @Autowired
    private AgreementMapper agreementMapper;

    @PostMapping(value={"dealSrmContractBindCheck"})
    public SrmContractBindCheckRspBO dealSrmContractBindCheck(@RequestBody SrmContractBindCheckReqBO reqBo) {
        SrmContractBindCheckRspBO rspBo = new SrmContractBindCheckRspBO();
        if (reqBo == null || !StringUtils.hasText((String)reqBo.getUpperContractCode())) {
            rspBo.setRespCode("0001");
            rspBo.setRespDesc("\u8bf7\u6c42\u5fc5\u586b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        SrmContractPO srmContractPo = new SrmContractPO();
        srmContractPo.setContractCode(reqBo.getUpperContractCode());
        int srmCount = this.srmContractMapper.getCheckBy(srmContractPo);
        if (srmCount < 1) {
            rspBo.setRespCode("0002");
            rspBo.setRespDesc("\u8be5\u534f\u8bae\u4fe1\u606f\u4e0d\u5b58\u5728");
            return rspBo;
        }
        AgreementPO agreementPo = new AgreementPO();
        agreementPo.setRelSystem(AgrEnum.RelSystem.SRM.toString());
        agreementPo.setExtContractCode(reqBo.getUpperContractCode());
        agreementPo.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        AgreementPO agrModel = this.agreementMapper.getModelBy(agreementPo);
        if (agrModel != null) {
            SrmContractRelUpperPO srmContractRelUpperPo = new SrmContractRelUpperPO();
            srmContractRelUpperPo.setAgreementId(agrModel.getAgreementId());
            SrmContractRelUpperPO relModel = this.srmContractRelUpperMapper.getModelBy(srmContractRelUpperPo);
            if (relModel != null) {
                rspBo.setCheckResult(Boolean.valueOf(true));
                srmContractPo.setContractCode(relModel.getUpperContractCode());
                SrmContractPO srmModel = this.srmContractMapper.getModelBy(srmContractPo);
                if (srmModel != null) {
                    rspBo.setSrmContractCode(srmModel.getContractCode());
                    rspBo.setSrmContractName(srmContractPo.getContractName());
                    rspBo.setEcpContractCode(srmModel.getEcpContractCode());
                    rspBo.setEcpContractName(srmContractPo.getEcpContractName());
                }
            } else {
                rspBo.setCheckResult(Boolean.valueOf(false));
            }
        } else {
            rspBo.setCheckResult(Boolean.valueOf(false));
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

