/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.ability.impl;

import com.alibaba.fastjson.JSONArray;
import com.ohaotian.plugin.db.Page;
import com.tydic.agreement.ability.SrmContractQueryAbilityService;
import com.tydic.agreement.ability.bo.ExtContractInfoBO;
import com.tydic.agreement.ability.bo.SrmContractInfoBO;
import com.tydic.agreement.ability.bo.SrmContractQueryReqBO;
import com.tydic.agreement.ability.bo.SrmContractQueryRspBO;
import com.tydic.agreement.dao.AgrCustomizeMapper;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_TEST/2.0.0/com.tydic.agreement.ability.SrmContractQueryAbilityService"})
public class SrmContractQueryAbilityServiceImpl
implements SrmContractQueryAbilityService {
    @Autowired
    private AgrCustomizeMapper agrCustomizeMapper;
    @Value(value="${cnecc_org_id}")
    private Long cneccOrgId;

    @PostMapping(value={"qrySrmContract"})
    public SrmContractQueryRspBO qrySrmContract(@RequestBody SrmContractQueryReqBO reqBo) {
        SrmContractQueryRspBO rspBo = new SrmContractQueryRspBO();
        if (reqBo == null || reqBo.getQueryType() == null) {
            rspBo.setRespCode("0001");
            rspBo.setRespDesc("\u8bf7\u6c42\u5fc5\u4f20\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        if (reqBo.getQueryType() != 0 && reqBo.getQueryType() != 1 && reqBo.getQueryType() != 2) {
            rspBo.setRespCode("0002");
            rspBo.setRespDesc("\u672a\u77e5\u7684\u67e5\u8be2\u7c7b\u578b");
            return rspBo;
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        rspBo.setPageNo(Integer.valueOf(1));
        rspBo.setTotal(Integer.valueOf(1));
        rspBo.setRecordsTotal(Integer.valueOf(0));
        rspBo.setRows(null);
        if (reqBo.getCompanyId() == null || !StringUtils.hasText((String)reqBo.getOrgPath())) {
            return rspBo;
        }
        int index = reqBo.getOrgPath().indexOf(this.cneccOrgId.toString());
        if (reqBo.getQueryType() != 0 && index == -1) {
            return rspBo;
        }
        String path = reqBo.getOrgPath().substring(index);
        reqBo.setOrgPath(path);
        Page page = new Page(reqBo.getPageNo().intValue(), reqBo.getPageSize().intValue());
        List<ExtContractInfoBO> extContractListPage = this.agrCustomizeMapper.getExtContractListPage(reqBo, null, (Page<ExtContractInfoBO>)page);
        List srmContractListPage = JSONArray.parseArray((String)JSONArray.toJSONString(extContractListPage), SrmContractInfoBO.class);
        rspBo.setRows(srmContractListPage);
        rspBo.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBo.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBo.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        return rspBo;
    }
}

