/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.agreement.ability.AgrAgreementScopeSyncQueueAbilityService;
import com.tydic.agreement.ability.SrmContractSyncAbilityService;
import com.tydic.agreement.ability.bo.SrmContractInfoBO;
import com.tydic.agreement.ability.bo.SrmContractItemBO;
import com.tydic.agreement.ability.bo.SrmContractSyncReqBO;
import com.tydic.agreement.ability.bo.SrmContractSyncRspBO;
import com.tydic.agreement.busi.SrmContractSyncBusiService;
import com.tydic.agreement.constant.AgrEnum;
import com.tydic.agreement.dao.AgrSyncContractInterfaceLogMapper;
import com.tydic.agreement.dao.po.AgrSyncContractInterfaceLogPO;
import com.tydic.agreement.external.srm.SrmContractSyncCallBackService;
import com.tydic.agreement.external.srm.bo.SrmContractSyncCallBackReqBO;
import com.tydic.agreement.external.srm.bo.SrmContractSyncCallBackRspBO;
import com.tydic.commodity.bo.busi.UccCommdMeasureInfoReqBo;
import com.tydic.commodity.bo.busi.UccCommdMeasureInfoRspBo;
import com.tydic.commodity.bo.busi.UccCommdMeasureReqBo;
import com.tydic.commodity.bo.busi.UccEMdmCatalogBO;
import com.tydic.commodity.busi.api.UccCommdMeasureInfoBusiService;
import com.tydic.commodity.busi.api.UccCommodityMeasureBo;
import com.tydic.commodity.enumType.YesNoEnum;
import com.tydic.enquiry.api.AddProjectInfoAbilityService;
import com.tydic.enquiry.api.QryProjectInfoListPageAbilityService;
import com.tydic.enquiry.api.bo.AddProjectInfoReqBO;
import com.tydic.enquiry.api.bo.AddProjectInfoRspBO;
import com.tydic.enquiry.api.bo.ProjectInfoBO;
import com.tydic.enquiry.api.bo.QryProjectInfoListPageReqBO;
import com.tydic.enquiry.api.bo.QryProjectInfoListPageRspBO;
import com.tydic.uccext.bo.CnncCatalogListQueryAbilityReqBO;
import com.tydic.uccext.bo.CnncCatalogListQueryAbilityRspBO;
import com.tydic.uccext.bo.UccMaterialCommodityTypeBO;
import com.tydic.uccext.bo.UccQryCommodityTypeByMaterialReqBO;
import com.tydic.uccext.bo.UccQryCommodityTypeByMaterialRspBO;
import com.tydic.uccext.service.CnncCatalogListQueryAbilityService;
import com.tydic.uccext.service.UccQryCommodityTypeByMaterialService;
import com.tydic.umc.common.EnterpriseOrgExtMapJoinBO;
import com.tydic.umcext.ability.org.UmcOrgExtMapOperateAbilityService;
import com.tydic.umcext.ability.org.bo.UmcOrgExtMapOperateAbilityReqBO;
import com.tydic.umcext.ability.org.bo.UmcOrgExtMapOperateAbilityRspBO;
import com.tydic.umcext.ability.supplier.UmcQrySupplierInfoDetailAbilityService;
import com.tydic.umcext.ability.supplier.UmcSupplierAccountEnableAbilityService;
import com.tydic.umcext.ability.supplier.bo.UmcQrySupplierInfoDetailAbilityReqBO;
import com.tydic.umcext.ability.supplier.bo.UmcQrySupplierInfoDetailAbilityRspBO;
import com.tydic.umcext.ability.supplier.bo.UmcSupplierAccountEnableAbilityReqBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class SrmContractSyncAbilityServiceImpl
implements SrmContractSyncAbilityService {
    private static final Logger log = LoggerFactory.getLogger(SrmContractSyncAbilityServiceImpl.class);
    private static final List<Integer> srmPurchaseTypeList = Arrays.asList(2, 3, 4);
    @Autowired
    private SrmContractSyncBusiService srmContractSyncBusiService;
    @Autowired
    private AgrSyncContractInterfaceLogMapper agrSyncContractInterfaceLogMapper;
    @Autowired
    private AgrAgreementScopeSyncQueueAbilityService agrAgreementScopeSyncQueueAbilityService;
    @Autowired
    private UmcOrgExtMapOperateAbilityService umcOrgExtMapOperateAbilityService;
    @Autowired
    private UmcQrySupplierInfoDetailAbilityService umcQrySupplierInfoDetailAbilityService;
    @Autowired
    private AddProjectInfoAbilityService addProjectInfoAbilityService;
    @Autowired
    private QryProjectInfoListPageAbilityService qryProjectInfoListPageAbilityService;
    @Autowired
    private UccQryCommodityTypeByMaterialService uccQryCommodityTypeByMaterialService;
    @Autowired
    private UmcSupplierAccountEnableAbilityService umcSupplierAccountEnableAbilityService;
    @Autowired
    private UccCommdMeasureInfoBusiService uccCommdMeasureInfoBusiService;
    @Autowired
    private CnncCatalogListQueryAbilityService cnncCatalogListQueryAbilityService;
    @Autowired
    private SrmContractSyncCallBackService srmContractSyncCallBackService;
    @Value(value="${cnecc_esb_org_code}")
    private String cneccEsbOrgCode;
    @Value(value="${srm_callback:true}")
    private Boolean srmCallback;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @Async(value="extContractSyncTheadPool")
    public void syncSrmContract(SrmContractSyncReqBO reqBo) {
        block65: {
            Object collect;
            AgrSyncContractInterfaceLogPO agrSyncContractInterfaceLogPo;
            Date now = new Date();
            boolean logFlag = true;
            long logId = Sequence.getInstance().nextId();
            HashSet<SrmContractSyncCallBackReqBO> failList = new HashSet<SrmContractSyncCallBackReqBO>();
            HashSet<SrmContractSyncCallBackReqBO> successList = new HashSet<SrmContractSyncCallBackReqBO>();
            boolean busiProcessFinish = false;
            String syncResult = AgrEnum.SuccessOrError.ERROR.getCode();
            SrmContractSyncRspBO rspBo = null;
            String failCode = "0";
            String successCode = "1";
            try {
                agrSyncContractInterfaceLogPo = new AgrSyncContractInterfaceLogPO();
                agrSyncContractInterfaceLogPo.setLogId(logId);
                agrSyncContractInterfaceLogPo.setCreateTime(now);
                agrSyncContractInterfaceLogPo.setRelSystem(AgrEnum.RelSystem.SRM.toString());
                agrSyncContractInterfaceLogPo.setInterfaceType(AgrEnum.SyncContractInterfaceType.receive.getType());
                agrSyncContractInterfaceLogPo.setInterfaceName(AgrEnum.SyncContractInterfaceName.syncSrmContract.toString());
                if (!CollectionUtils.isEmpty((Collection)reqBo.getContractList())) {
                    agrSyncContractInterfaceLogPo.setKeyParam(((SrmContractInfoBO)reqBo.getContractList().get(0)).getContractCode());
                }
                agrSyncContractInterfaceLogPo.setParams(JSON.toJSONString((Object)reqBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteBigDecimalAsPlain}));
                this.agrSyncContractInterfaceLogMapper.insert(agrSyncContractInterfaceLogPo);
            }
            catch (Exception ignore) {
                logFlag = false;
            }
            for (SrmContractInfoBO contract : reqBo.getContractList()) {
                if (!StringUtils.hasText((String)contract.getContractName())) {
                    failList.add(new SrmContractSyncCallBackReqBO(contract.getContractId(), contract.getContractCode(), null, failCode, "\u5408\u540c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a"));
                    continue;
                }
                if (!StringUtils.hasText((String)contract.getEcpContractCode())) {
                    failList.add(new SrmContractSyncCallBackReqBO(contract.getContractId(), contract.getContractCode(), null, failCode, "ECP\u5408\u540c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
                    continue;
                }
                if (!StringUtils.hasText((String)contract.getContractType()) || !StringUtils.hasText((String)contract.getPurchaseWay())) {
                    failList.add(new SrmContractSyncCallBackReqBO(contract.getContractId(), contract.getContractCode(), null, failCode, "\u5408\u540c\u7c7b\u578b\u3001\u91c7\u8d2d\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a"));
                    continue;
                }
                if (contract.getPurchaseWay().startsWith("00")) {
                    contract.setPurchaseWay(contract.getPurchaseWay().substring(2));
                }
                if (contract.getCenterPurchaseType() == null || contract.getPurchaseType() == null || contract.getVendorSource() == null || contract.getIsElePurchase() == null) {
                    failList.add(new SrmContractSyncCallBackReqBO(contract.getContractId(), contract.getContractCode(), null, failCode, "\u96c6\u4e2d\u91c7\u8d2d\u7c7b\u578b\u3001\u91c7\u8d2d\u7c7b\u578b\u3001\u6f5c\u5728\u4f9b\u5e94\u5546\u6765\u6e90\u3001\u662f\u5426\u7535\u5b50\u91c7\u8d2d\u4e0d\u80fd\u4e3a\u7a7a"));
                    continue;
                }
                if (srmPurchaseTypeList.contains(contract.getCenterPurchaseType()) && !StringUtils.hasText((String)contract.getPurImpUnitOrgCode())) {
                    failList.add(new SrmContractSyncCallBackReqBO(contract.getContractId(), contract.getContractCode(), null, failCode, "\u96c6\u4e2d\u91c7\u8d2d\u7c7b\u578b\u4e3a\u4e8c\u7ea7\u96c6\u91c7\uff08\u4e8c\u7ea7\u76f4\u63a5\u3001\u4e8c\u7ea7\u6388\u6743\u3001\u4e8c\u7ea7\u7ec4\u7ec7\uff09\u65f6\uff0c\u91c7\u8d2d\u5b9e\u65bd\u5355\u4f4d\u7ec4\u7ec7\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
                    continue;
                }
                if (contract.getSignDate() == null || contract.getEffDate() == null || contract.getExpDate() == null) {
                    failList.add(new SrmContractSyncCallBackReqBO(contract.getContractId(), contract.getContractCode(), null, failCode, "\u7b7e\u8ba2\u65f6\u95f4\u3001\u751f\u6548\u65f6\u95f4\u3001\u5931\u6548\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a"));
                    continue;
                }
                if (contract.getContractAmount() != null && contract.getContractAmount().compareTo(BigDecimal.ZERO) == 0) {
                    contract.setContractAmount(null);
                }
                if (!(StringUtils.hasText((String)contract.getVendorCode()) && StringUtils.hasText((String)contract.getOrgCode()) && StringUtils.hasText((String)contract.getCreatorOrgCode()))) {
                    failList.add(new SrmContractSyncCallBackReqBO(contract.getContractId(), contract.getContractCode(), null, failCode, "\u4f9b\u5e94\u5546\u7f16\u7801\u3001\u91c7\u8d2d\u5355\u4f4d\u7f16\u7801\u3001\u521b\u5efa\u4eba\u6240\u5c5e\u5355\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
                    continue;
                }
                if (!CollectionUtils.isEmpty((Collection)contract.getItemList())) {
                    List<String> catalogCodes = contract.getItemList().stream().map(SrmContractItemBO::getThirdCatalogId).distinct().collect(Collectors.toList());
                    HashMap existsCatalogCodesAndFreeeze = new HashMap(catalogCodes.size());
                    HashMap existsCatalogCodesAndVariety = new HashMap(catalogCodes.size());
                    if (!CollectionUtils.isEmpty(catalogCodes)) {
                        CnncCatalogListQueryAbilityReqBO cnncCatalogListQueryAbilityReqBO = new CnncCatalogListQueryAbilityReqBO();
                        cnncCatalogListQueryAbilityReqBO.setCatalogCodes(catalogCodes);
                        CnncCatalogListQueryAbilityRspBO cnncCatalogListQueryAbilityRspBO = this.cnncCatalogListQueryAbilityService.qryCatalogList(cnncCatalogListQueryAbilityReqBO);
                        if (!"0000".equals(cnncCatalogListQueryAbilityRspBO.getRespCode())) {
                            failList.add(new SrmContractSyncCallBackReqBO(contract.getContractId(), contract.getContractCode(), null, failCode, "\u5408\u540c\u660e\u7ec6-\u4e09\u7ea7\u7269\u8d44\u5206\u7c7b\u7f16\u7801\u6821\u9a8c\u5931\u8d25"));
                            break;
                        }
                        List catalogBOList = cnncCatalogListQueryAbilityRspBO.getCatalogBOList() == null ? new ArrayList() : cnncCatalogListQueryAbilityRspBO.getCatalogBOList();
                        catalogCodes.forEach(catalogCode -> {
                            for (UccEMdmCatalogBO catalogBO : catalogBOList) {
                                if (!catalogCode.equals(catalogBO.getCatalogCode())) continue;
                                existsCatalogCodesAndVariety.put(catalogCode, catalogBO.getVariety());
                                if (YesNoEnum.NO.getType().equals(catalogBO.getFreezeFlag()) && YesNoEnum.NO.getType().equals(catalogBO.getIsDelete())) {
                                    existsCatalogCodesAndFreeeze.put(catalogCode, YesNoEnum.NO.getType());
                                    break;
                                }
                                existsCatalogCodesAndFreeeze.put(catalogCode, YesNoEnum.YES.getType());
                                break;
                            }
                        });
                        if (existsCatalogCodesAndVariety.keySet().size() != catalogCodes.size()) {
                            StringJoiner sj = new StringJoiner(",");
                            catalogCodes.forEach(catalogCode -> {
                                if (!existsCatalogCodesAndVariety.containsKey(catalogCode)) {
                                    sj.add((CharSequence)catalogCode);
                                }
                            });
                            failList.add(new SrmContractSyncCallBackReqBO(contract.getContractId(), contract.getContractCode(), null, failCode, "\u5408\u540c\u660e\u7ec6-\u4e09\u7ea7\u7269\u8d44\u5206\u7c7b\u7f16\u7801\u6821\u9a8c\u5931\u8d25,\u4ee5\u4e0b\u4e09\u7ea7\u7269\u8d44\u5206\u7c7b\u7f16\u7801\u5728\u5546\u57ce\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728" + sj));
                            break;
                        }
                    }
                    boolean fail = false;
                    for (SrmContractItemBO item2 : contract.getItemList()) {
                        if (!StringUtils.hasText((String)item2.getThirdCatalogId())) {
                            failList.add(new SrmContractSyncCallBackReqBO(contract.getContractId(), contract.getContractCode(), null, failCode, "\u5408\u540c\u660e\u7ec6-\u4e09\u7ea7\u7269\u8d44\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
                            fail = true;
                            break;
                        }
                        Integer variety = (Integer)existsCatalogCodesAndVariety.get(item2.getThirdCatalogId());
                        if (AgrEnum.Variety.WZ.getCode().equals(variety)) {
                            if (!(StringUtils.hasText((String)item2.getMaterialId()) && StringUtils.hasText((String)item2.getMaterialName()) && StringUtils.hasText((String)item2.getScMaterialCode()))) {
                                failList.add(new SrmContractSyncCallBackReqBO(contract.getContractId(), contract.getContractCode(), null, failCode, "\u5408\u540c\u660e\u7ec6-\u7269\u8d44\u7f16\u7801\u3001\u7269\u8d44\u957f\u63cf\u8ff0\u3001\u81ea\u6709\u7269\u8d44\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
                                fail = true;
                                break;
                            }
                            if (!StringUtils.hasText((String)item2.getProducingArea())) {
                                item2.setProducingArea(AgrEnum.YesOrNo.YES.getCode().toString());
                            }
                        } else {
                            Integer freeze = (Integer)existsCatalogCodesAndFreeeze.get(item2.getThirdCatalogId());
                            if (!(!YesNoEnum.NO.getType().equals(freeze) || StringUtils.hasText((String)item2.getMaterialId()) && StringUtils.hasText((String)item2.getMaterialName()))) {
                                failList.add(new SrmContractSyncCallBackReqBO(contract.getContractId(), contract.getContractCode(), null, failCode, "\u5408\u540c\u660e\u7ec6-\u7269\u8d44\u7f16\u7801\u3001\u7269\u8d44\u957f\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a"));
                                fail = true;
                                break;
                            }
                        }
                        if (item2.getBuyNumber() == null || item2.getBuyPrice() == null) {
                            failList.add(new SrmContractSyncCallBackReqBO(contract.getContractId(), contract.getContractCode(), null, failCode, "\u5408\u540c\u660e\u7ec6-\u91c7\u8d2d\u6570\u91cf\u3001\u91c7\u8d2d\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a"));
                            fail = true;
                            break;
                        }
                        if (item2.getTaxRate() == null) {
                            failList.add(new SrmContractSyncCallBackReqBO(contract.getContractId(), contract.getContractCode(), null, failCode, "\u5408\u540c\u660e\u7ec6-\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a"));
                            fail = true;
                            break;
                        }
                        if (StringUtils.hasText((String)item2.getMeasureName())) continue;
                        failList.add(new SrmContractSyncCallBackReqBO(contract.getContractId(), contract.getContractCode(), null, failCode, "\u5408\u540c\u660e\u7ec6-\u8ba1\u91cf\u5355\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a"));
                        fail = true;
                        break;
                    }
                    if (fail) continue;
                    List<String> srmMaterial = contract.getItemList().stream().map(SrmContractItemBO::getMaterialId).filter(StringUtils::hasText).distinct().collect(Collectors.toList());
                    UccQryCommodityTypeByMaterialReqBO uccQryCommodityTypeByMaterialReqBo = new UccQryCommodityTypeByMaterialReqBO();
                    uccQryCommodityTypeByMaterialReqBo.setMaterialCodes(srmMaterial);
                    UccQryCommodityTypeByMaterialRspBO uccQryCommodityTypeByMaterialRspBo = this.uccQryCommodityTypeByMaterialService.qryCommodityTypeByMaterial(uccQryCommodityTypeByMaterialReqBo);
                    if (!"0000".equals(uccQryCommodityTypeByMaterialRspBo.getRespCode())) {
                        failList.add(new SrmContractSyncCallBackReqBO(contract.getContractId(), contract.getContractCode(), null, failCode, "\u5408\u540c\u660e\u7ec6-\u7269\u8d44\u7f16\u7801\u6821\u9a8c\u5931\u8d25"));
                        break;
                    }
                    List uccMaterialCommodityTypeBos = uccQryCommodityTypeByMaterialRspBo.getMaterialTypes() == null ? new ArrayList() : uccQryCommodityTypeByMaterialRspBo.getMaterialTypes();
                    List uccMaterial = uccMaterialCommodityTypeBos.stream().map(UccMaterialCommodityTypeBO::getMaterialCode).distinct().collect(Collectors.toList());
                    if (srmMaterial.size() != uccMaterial.size()) {
                        StringJoiner sj = new StringJoiner(",");
                        srmMaterial.forEach(mat -> {
                            if (!uccMaterial.contains(mat)) {
                                sj.add((CharSequence)mat);
                            }
                        });
                        failList.add(new SrmContractSyncCallBackReqBO(contract.getContractId(), contract.getContractCode(), null, failCode, "\u5408\u540c\u660e\u7ec6-\u7269\u8d44\u7f16\u7801\u6821\u9a8c\u5931\u8d25,\u4ee5\u4e0b\u7269\u8d44\u7f16\u7801\u5728\u5546\u57ce\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728" + sj));
                        break;
                    }
                    Map<String, UccMaterialCommodityTypeBO> collectByMaterialCode = uccQryCommodityTypeByMaterialRspBo.getMaterialTypes().stream().collect(Collectors.toMap(UccMaterialCommodityTypeBO::getMaterialCode, bo -> bo, (a, b) -> a));
                    HashSet<String> sjCheckMaterial = new HashSet<String>();
                    HashSet<String> sjCheckMaterialAndL3Catalog = new HashSet<String>();
                    for (SrmContractItemBO item3 : contract.getItemList()) {
                        if (!StringUtils.hasText((String)item3.getMaterialId())) continue;
                        UccMaterialCommodityTypeBO uccMaterialCommodityTypeBo = collectByMaterialCode.get(item3.getMaterialId());
                        if (uccMaterialCommodityTypeBo == null || CollectionUtils.isEmpty((Map)uccMaterialCommodityTypeBo.getTypeIdAndName())) {
                            sjCheckMaterial.add(item3.getMaterialId());
                            continue;
                        }
                        if (item3.getThirdCatalogId().equals(uccMaterialCommodityTypeBo.getL3CatalogCode())) continue;
                        sjCheckMaterialAndL3Catalog.add(item3.getMaterialId());
                    }
                    if (!CollectionUtils.isEmpty(sjCheckMaterialAndL3Catalog)) {
                        StringJoiner sj = new StringJoiner(",", "[", "]");
                        sjCheckMaterialAndL3Catalog.forEach(sj::add);
                        failList.add(new SrmContractSyncCallBackReqBO(contract.getContractId(), contract.getContractCode(), null, failCode, "\u660e\u7ec6\u7269\u8d44\u7f16\u7801" + sj + "\u5bf9\u5e94\u7684\u7269\u8d44\u5206\u7c7b\u4e0d\u5b58\u5728\u6216\u4e0d\u4e00\u81f4"));
                        break;
                    }
                    List collect2 = contract.getItemList().stream().filter(item -> contract.getContractId().equals(item.getContractId())).collect(Collectors.toList());
                    contract.setItemList(collect2);
                }
                if (CollectionUtils.isEmpty((Collection)contract.getScopeList())) {
                    failList.add(new SrmContractSyncCallBackReqBO(contract.getContractId(), contract.getContractCode(), null, failCode, "\u5408\u540c\u660e\u7ec6-\u5e94\u7528\u8303\u56f4\u4e3a\u7a7a!"));
                    break;
                }
                collect = contract.getScopeList().stream().filter(item -> contract.getContractId().equals(item.getContractId())).collect(Collectors.toList());
                contract.setScopeList((List)collect);
                Calendar calendar = Calendar.getInstance();
                if (contract.getEffDate() != null) {
                    calendar.setTime(contract.getEffDate());
                    calendar.set(10, 0);
                    calendar.set(12, 0);
                    calendar.set(13, 0);
                    contract.setEffDate(calendar.getTime());
                }
                if (contract.getExpDate() == null) continue;
                calendar.setTime(contract.getExpDate());
                calendar.set(10, 23);
                calendar.set(12, 59);
                calendar.set(13, 59);
                contract.setExpDate(calendar.getTime());
                if (!contract.getExpDate().before(new Date())) continue;
                failList.add(new SrmContractSyncCallBackReqBO(contract.getContractId(), contract.getContractCode(), null, failCode, "\u5408\u540c\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u65f6\u95f4!"));
                break;
            }
            List failContractId = failList.stream().map(SrmContractSyncCallBackReqBO::getPcHeaderId).collect(Collectors.toList());
            List paramCheckSuccessList = reqBo.getContractList().stream().filter(bo -> !failContractId.contains(bo.getContractId())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(paramCheckSuccessList)) {
                collect = paramCheckSuccessList.stream().collect(Collectors.toMap(SrmContractInfoBO::getContractId, bo -> bo, (a, b) -> a));
                ArrayList<SrmContractInfoBO> contractInfoBos = new ArrayList<SrmContractInfoBO>(collect.values());
                this.transOrgCode(contractInfoBos);
                this.checkEcpProject(contractInfoBos);
                reqBo.setContractList(contractInfoBos);
                rspBo = this.srmContractSyncBusiService.syncSrmContract(reqBo);
                busiProcessFinish = true;
                if ("0000".equals(rspBo.getRespCode())) {
                    syncResult = AgrEnum.SuccessOrError.SUCCESS.getCode();
                    try {
                        this.agrAgreementScopeSyncQueueAbilityService.dealScopeSyncAsync();
                    }
                    catch (Exception existsCatalogCodesAndVariety) {
                        // empty catch block
                    }
                    try {
                        UmcSupplierAccountEnableAbilityReqBO umcSupplierAccountEnableAbilityReqBo = new UmcSupplierAccountEnableAbilityReqBO();
                        umcSupplierAccountEnableAbilityReqBo.setSupplierIdList(contractInfoBos.stream().map(SrmContractInfoBO::getVendorId).collect(Collectors.toList()));
                        this.umcSupplierAccountEnableAbilityService.dealSupplierAccountEnable(umcSupplierAccountEnableAbilityReqBo);
                    }
                    catch (Exception umcSupplierAccountEnableAbilityReqBo) {
                        // empty catch block
                    }
                    try {
                        List<String> collectMeasureNames = contractInfoBos.stream().map(SrmContractInfoBO::getItemList).flatMap(Collection::stream).map(SrmContractItemBO::getMeasureName).distinct().collect(Collectors.toList());
                        if (!CollectionUtils.isEmpty(collectMeasureNames)) {
                            UccCommdMeasureInfoReqBo uccCommdMeasureInfoReqBo = new UccCommdMeasureInfoReqBo();
                            uccCommdMeasureInfoReqBo.setMeasureNames(collectMeasureNames);
                            UccCommdMeasureInfoRspBo uccCommdMeasureInfoRspBo = this.uccCommdMeasureInfoBusiService.queryByBinaryNames(uccCommdMeasureInfoReqBo);
                            if ("0000".equals(uccCommdMeasureInfoRspBo.getRespCode()) && !CollectionUtils.isEmpty((Collection)uccCommdMeasureInfoRspBo.getRows())) {
                                List uccCommodityMeasureBos = JSONArray.parseArray((String)JSONArray.toJSONString((Object)uccCommdMeasureInfoRspBo.getRows()), UccCommodityMeasureBo.class);
                                collectMeasureNames.removeAll(uccCommodityMeasureBos.stream().map(UccCommodityMeasureBo::getMeasureName).collect(Collectors.toList()));
                            }
                            if (!CollectionUtils.isEmpty(collectMeasureNames)) {
                                UccCommdMeasureReqBo uccCommdMeasureReqBo = new UccCommdMeasureReqBo();
                                uccCommdMeasureReqBo.setUsername("sys");
                                uccCommdMeasureReqBo.setMeasureType(Integer.valueOf(0));
                                collectMeasureNames.forEach(measureName -> {
                                    uccCommdMeasureReqBo.setMeasureName(measureName);
                                    this.uccCommdMeasureInfoBusiService.addMeasure(uccCommdMeasureReqBo);
                                });
                            }
                        }
                    }
                    catch (Exception collectMeasureNames) {
                        // empty catch block
                    }
                    successList.addAll(reqBo.getContractList().stream().map(bo -> new SrmContractSyncCallBackReqBO(bo.getContractId(), bo.getContractCode(), null, successCode, null)).collect(Collectors.toList()));
                } else {
                    SrmContractSyncRspBO finalRspBo = rspBo;
                    failList.addAll(reqBo.getContractList().stream().map(bo -> new SrmContractSyncCallBackReqBO(bo.getContractId(), bo.getContractCode(), null, failCode, finalRspBo.getRespDesc())).collect(Collectors.toList()));
                }
            }
            this.dealRsp(successList, failList);
            try {
                agrSyncContractInterfaceLogPo = new AgrSyncContractInterfaceLogPO();
                agrSyncContractInterfaceLogPo.setLogId(logId);
                agrSyncContractInterfaceLogPo.setDealTime(new Date());
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("success", successList);
                jsonObject.put("fail", failList);
                agrSyncContractInterfaceLogPo.setResult(jsonObject.toJSONString());
                agrSyncContractInterfaceLogPo.setDealResult(syncResult);
                if (logFlag) {
                    this.agrSyncContractInterfaceLogMapper.updateById(agrSyncContractInterfaceLogPo);
                    break block65;
                }
                agrSyncContractInterfaceLogPo.setCreateTime(now);
                agrSyncContractInterfaceLogPo.setRelSystem(AgrEnum.RelSystem.SRM.toString());
                agrSyncContractInterfaceLogPo.setInterfaceType(AgrEnum.SyncContractInterfaceType.receive.getType());
                agrSyncContractInterfaceLogPo.setInterfaceName(AgrEnum.SyncContractInterfaceName.syncSrmContract.toString());
                if (!CollectionUtils.isEmpty((Collection)reqBo.getContractList())) {
                    agrSyncContractInterfaceLogPo.setKeyParam(((SrmContractInfoBO)reqBo.getContractList().get(0)).getContractCode());
                }
                agrSyncContractInterfaceLogPo.setParams(JSON.toJSONString((Object)reqBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteBigDecimalAsPlain}));
                this.agrSyncContractInterfaceLogMapper.insert(agrSyncContractInterfaceLogPo);
            }
            catch (Exception agrSyncContractInterfaceLogPo2) {}
            break block65;
            catch (Exception e) {
                block66: {
                    try {
                        if (busiProcessFinish) {
                            if ("\u6210\u529f".equals(rspBo.getRespCode())) {
                                Set collect3 = reqBo.getContractList().stream().map(bo -> new SrmContractSyncCallBackReqBO(bo.getContractId(), bo.getContractCode(), null, successCode, null)).collect(Collectors.toSet());
                                successList.addAll(collect3);
                                this.dealRsp(successList, failList);
                            } else {
                                SrmContractSyncRspBO finalRspBo = rspBo;
                                List failContractId2 = failList.stream().map(SrmContractSyncCallBackReqBO::getPcHeaderId).collect(Collectors.toList());
                                List collect4 = reqBo.getContractList().stream().filter(bo -> !failContractId2.contains(bo.getContractId())).map(bo -> new SrmContractSyncCallBackReqBO(bo.getContractId(), bo.getContractCode(), null, failCode, finalRspBo.getRespDesc())).collect(Collectors.toList());
                                failList.addAll(collect4);
                                this.dealRsp(new HashSet<SrmContractSyncCallBackReqBO>(), failList);
                            }
                            break block66;
                        }
                        List failContractId3 = failList.stream().map(SrmContractSyncCallBackReqBO::getPcHeaderId).collect(Collectors.toList());
                        List collect5 = reqBo.getContractList().stream().filter(bo -> !failContractId3.contains(bo.getContractId())).map(bo -> new SrmContractSyncCallBackReqBO(bo.getContractId(), bo.getContractCode(), null, failCode, String.valueOf(e.getMessage()))).collect(Collectors.toList());
                        failList.addAll(collect5);
                        this.dealRsp(new HashSet<SrmContractSyncCallBackReqBO>(), failList);
                    }
                    catch (Throwable throwable) {
                        try {
                            AgrSyncContractInterfaceLogPO agrSyncContractInterfaceLogPo3 = new AgrSyncContractInterfaceLogPO();
                            agrSyncContractInterfaceLogPo3.setLogId(logId);
                            agrSyncContractInterfaceLogPo3.setDealTime(new Date());
                            JSONObject jsonObject = new JSONObject();
                            jsonObject.put("success", successList);
                            jsonObject.put("fail", failList);
                            agrSyncContractInterfaceLogPo3.setResult(jsonObject.toJSONString());
                            agrSyncContractInterfaceLogPo3.setDealResult(syncResult);
                            if (logFlag) {
                                this.agrSyncContractInterfaceLogMapper.updateById(agrSyncContractInterfaceLogPo3);
                            } else {
                                agrSyncContractInterfaceLogPo3.setCreateTime(now);
                                agrSyncContractInterfaceLogPo3.setRelSystem(AgrEnum.RelSystem.SRM.toString());
                                agrSyncContractInterfaceLogPo3.setInterfaceType(AgrEnum.SyncContractInterfaceType.receive.getType());
                                agrSyncContractInterfaceLogPo3.setInterfaceName(AgrEnum.SyncContractInterfaceName.syncSrmContract.toString());
                                if (!CollectionUtils.isEmpty((Collection)reqBo.getContractList())) {
                                    agrSyncContractInterfaceLogPo3.setKeyParam(((SrmContractInfoBO)reqBo.getContractList().get(0)).getContractCode());
                                }
                                agrSyncContractInterfaceLogPo3.setParams(JSON.toJSONString((Object)reqBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteBigDecimalAsPlain}));
                                this.agrSyncContractInterfaceLogMapper.insert(agrSyncContractInterfaceLogPo3);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
                try {
                    AgrSyncContractInterfaceLogPO agrSyncContractInterfaceLogPo4 = new AgrSyncContractInterfaceLogPO();
                    agrSyncContractInterfaceLogPo4.setLogId(logId);
                    agrSyncContractInterfaceLogPo4.setDealTime(new Date());
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("success", successList);
                    jsonObject.put("fail", failList);
                    agrSyncContractInterfaceLogPo4.setResult(jsonObject.toJSONString());
                    agrSyncContractInterfaceLogPo4.setDealResult(syncResult);
                    if (logFlag) {
                        this.agrSyncContractInterfaceLogMapper.updateById(agrSyncContractInterfaceLogPo4);
                    }
                    agrSyncContractInterfaceLogPo4.setCreateTime(now);
                    agrSyncContractInterfaceLogPo4.setRelSystem(AgrEnum.RelSystem.SRM.toString());
                    agrSyncContractInterfaceLogPo4.setInterfaceType(AgrEnum.SyncContractInterfaceType.receive.getType());
                    agrSyncContractInterfaceLogPo4.setInterfaceName(AgrEnum.SyncContractInterfaceName.syncSrmContract.toString());
                    if (!CollectionUtils.isEmpty((Collection)reqBo.getContractList())) {
                        agrSyncContractInterfaceLogPo4.setKeyParam(((SrmContractInfoBO)reqBo.getContractList().get(0)).getContractCode());
                    }
                    agrSyncContractInterfaceLogPo4.setParams(JSON.toJSONString((Object)reqBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteBigDecimalAsPlain}));
                    this.agrSyncContractInterfaceLogMapper.insert(agrSyncContractInterfaceLogPo4);
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dealRsp(Set<SrmContractSyncCallBackReqBO> successList, Set<SrmContractSyncCallBackReqBO> failList) {
        AgrSyncContractInterfaceLogPO agrSyncContractInterfaceLogPo = new AgrSyncContractInterfaceLogPO();
        String callbackResultStr = null;
        String dealResult = null;
        boolean logFlag = false;
        ArrayList<SrmContractSyncCallBackReqBO> resultList = new ArrayList<SrmContractSyncCallBackReqBO>(failList);
        resultList.addAll(successList);
        for (SrmContractSyncCallBackReqBO result : resultList) {
            block13: {
                long logId = Sequence.getInstance().nextId();
                try {
                    block12: {
                        agrSyncContractInterfaceLogPo.setLogId(logId);
                        agrSyncContractInterfaceLogPo.setCreateTime(new Date());
                        agrSyncContractInterfaceLogPo.setRelSystem(AgrEnum.RelSystem.SRM.toString());
                        agrSyncContractInterfaceLogPo.setInterfaceType(AgrEnum.SyncContractInterfaceType.callback.getType());
                        agrSyncContractInterfaceLogPo.setInterfaceName(AgrEnum.SyncContractInterfaceName.syncSrmContract.toString());
                        agrSyncContractInterfaceLogPo.setKeyParam(result.getPcNum());
                        agrSyncContractInterfaceLogPo.setParams(JSON.toJSONString((Object)result, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteBigDecimalAsPlain}));
                        this.agrSyncContractInterfaceLogMapper.insert(agrSyncContractInterfaceLogPo);
                        logFlag = true;
                        if (this.srmCallback.booleanValue()) {
                            try {
                                SrmContractSyncCallBackRspBO srmContractSyncCallBackRspBo = this.srmContractSyncCallBackService.dealSrmContractSyncCallBack(result);
                                callbackResultStr = JSON.toJSONString((Object)((Object)srmContractSyncCallBackRspBo), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteBigDecimalAsPlain});
                                if ("0000".equals(srmContractSyncCallBackRspBo.getRespCode())) {
                                    dealResult = AgrEnum.SuccessOrError.SUCCESS.getCode();
                                    break block12;
                                }
                                dealResult = AgrEnum.SuccessOrError.ERROR.getCode();
                            }
                            catch (Exception e) {
                                log.error("\u8c03\u7528\u56de\u8c03SRM\u901a\u77e5\u5408\u540c\u63a8\u9001\u5904\u7406\u7ed3\u679c\u63a5\u53e3\u5f02\u5e38" + e.getMessage(), (Throwable)e);
                                callbackResultStr = String.valueOf(e.getMessage());
                                dealResult = AgrEnum.SuccessOrError.ERROR.getCode();
                            }
                        } else {
                            callbackResultStr = "\u672a\u542f\u7528\u56de\u8c03srm\u7cfb\u7edf";
                            dealResult = AgrEnum.SuccessOrError.SUCCESS.getCode();
                        }
                    }
                    agrSyncContractInterfaceLogPo = new AgrSyncContractInterfaceLogPO();
                    agrSyncContractInterfaceLogPo.setLogId(logId);
                    agrSyncContractInterfaceLogPo.setDealTime(new Date());
                    agrSyncContractInterfaceLogPo.setResult(callbackResultStr);
                    agrSyncContractInterfaceLogPo.setDealResult(dealResult);
                    if (!logFlag) break block13;
                    this.agrSyncContractInterfaceLogMapper.updateById(agrSyncContractInterfaceLogPo);
                }
                catch (Exception e) {
                    block14: {
                        try {
                            log.error("\u56de\u8c03SRM\u901a\u77e5\u5408\u540c\u63a8\u9001\u5904\u7406\u7ed3\u679c\u5f02\u5e38" + e.getMessage(), (Throwable)e);
                            callbackResultStr = String.valueOf(e.getMessage());
                            dealResult = AgrEnum.SuccessOrError.ERROR.getCode();
                            agrSyncContractInterfaceLogPo = new AgrSyncContractInterfaceLogPO();
                            agrSyncContractInterfaceLogPo.setLogId(logId);
                            agrSyncContractInterfaceLogPo.setDealTime(new Date());
                            agrSyncContractInterfaceLogPo.setResult(callbackResultStr);
                            agrSyncContractInterfaceLogPo.setDealResult(dealResult);
                            if (!logFlag) break block14;
                            this.agrSyncContractInterfaceLogMapper.updateById(agrSyncContractInterfaceLogPo);
                        }
                        catch (Throwable throwable) {
                            agrSyncContractInterfaceLogPo = new AgrSyncContractInterfaceLogPO();
                            agrSyncContractInterfaceLogPo.setLogId(logId);
                            agrSyncContractInterfaceLogPo.setDealTime(new Date());
                            agrSyncContractInterfaceLogPo.setResult(callbackResultStr);
                            agrSyncContractInterfaceLogPo.setDealResult(dealResult);
                            if (logFlag) {
                                this.agrSyncContractInterfaceLogMapper.updateById(agrSyncContractInterfaceLogPo);
                            } else {
                                agrSyncContractInterfaceLogPo.setCreateTime(new Date());
                                agrSyncContractInterfaceLogPo.setRelSystem(AgrEnum.RelSystem.SRM.toString());
                                agrSyncContractInterfaceLogPo.setInterfaceType(AgrEnum.SyncContractInterfaceType.callback.getType());
                                agrSyncContractInterfaceLogPo.setInterfaceName(AgrEnum.SyncContractInterfaceName.syncSrmContract.toString());
                                agrSyncContractInterfaceLogPo.setKeyParam(result.getPcNum());
                                agrSyncContractInterfaceLogPo.setParams(JSON.toJSONString((Object)result, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteBigDecimalAsPlain}));
                                this.agrSyncContractInterfaceLogMapper.insert(agrSyncContractInterfaceLogPo);
                            }
                            throw throwable;
                        }
                        continue;
                    }
                    agrSyncContractInterfaceLogPo.setCreateTime(new Date());
                    agrSyncContractInterfaceLogPo.setRelSystem(AgrEnum.RelSystem.SRM.toString());
                    agrSyncContractInterfaceLogPo.setInterfaceType(AgrEnum.SyncContractInterfaceType.callback.getType());
                    agrSyncContractInterfaceLogPo.setInterfaceName(AgrEnum.SyncContractInterfaceName.syncSrmContract.toString());
                    agrSyncContractInterfaceLogPo.setKeyParam(result.getPcNum());
                    agrSyncContractInterfaceLogPo.setParams(JSON.toJSONString((Object)result, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteBigDecimalAsPlain}));
                    this.agrSyncContractInterfaceLogMapper.insert(agrSyncContractInterfaceLogPo);
                }
                continue;
            }
            agrSyncContractInterfaceLogPo.setCreateTime(new Date());
            agrSyncContractInterfaceLogPo.setRelSystem(AgrEnum.RelSystem.SRM.toString());
            agrSyncContractInterfaceLogPo.setInterfaceType(AgrEnum.SyncContractInterfaceType.callback.getType());
            agrSyncContractInterfaceLogPo.setInterfaceName(AgrEnum.SyncContractInterfaceName.syncSrmContract.toString());
            agrSyncContractInterfaceLogPo.setKeyParam(result.getPcNum());
            agrSyncContractInterfaceLogPo.setParams(JSON.toJSONString((Object)result, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteBigDecimalAsPlain}));
            this.agrSyncContractInterfaceLogMapper.insert(agrSyncContractInterfaceLogPo);
        }
    }

    private void checkEcpProject(List<SrmContractInfoBO> contractInfoBos) {
        contractInfoBos.forEach(contractInfoBo -> {
            if (StringUtils.hasText((String)contractInfoBo.getPackCode())) {
                QryProjectInfoListPageReqBO qryProjectInfoListPageReqBO = new QryProjectInfoListPageReqBO();
                qryProjectInfoListPageReqBO.setProjectCode(contractInfoBo.getPackCode());
                QryProjectInfoListPageRspBO qryProjectInfoListPageRspBO = this.qryProjectInfoListPageAbilityService.qryProjectInfoListPage(qryProjectInfoListPageReqBO);
                if (!CollectionUtils.isEmpty((Collection)qryProjectInfoListPageRspBO.getProjectInfoList())) {
                    contractInfoBo.setEcpProjectId(((ProjectInfoBO)qryProjectInfoListPageRspBO.getProjectInfoList().get(0)).getProjectId().toString());
                } else {
                    AddProjectInfoReqBO addProjectInfoReqBO = new AddProjectInfoReqBO();
                    ProjectInfoBO projectInfoBO = new ProjectInfoBO();
                    addProjectInfoReqBO.setProjectInfo(projectInfoBO);
                    projectInfoBO.setProjectCode(contractInfoBo.getPackCode());
                    projectInfoBO.setProjectName(contractInfoBo.getPackName());
                    addProjectInfoReqBO.setCompanyId(contractInfoBo.getOrgId());
                    addProjectInfoReqBO.setCompanyName(contractInfoBo.getOrgName());
                    AddProjectInfoRspBO addProjectInfoRspBO = this.addProjectInfoAbilityService.addProjectInfo(addProjectInfoReqBO);
                    if (!"0000".equals(addProjectInfoRspBO.getRespCode()) && !addProjectInfoRspBO.getRespDesc().contains("\u9879\u76ee\u7f16\u7801\u91cd\u590d")) {
                        throw new BusinessException("8888", "\u65b0\u589e\u9879\u76ee\u5931\u8d25\uff1a" + addProjectInfoRspBO.getRespDesc());
                    }
                    contractInfoBo.setEcpProjectId(addProjectInfoRspBO.getProjectId().toString());
                }
            }
        });
    }

    private void transOrgCode(List<SrmContractInfoBO> contractInfoBos) {
        contractInfoBos.forEach(contractInfoBo -> {
            EnterpriseOrgExtMapJoinBO vendorBo = this.qryOrgId(contractInfoBo.getVendorCode());
            UmcQrySupplierInfoDetailAbilityReqBO umcQrySupplierInfoDetailAbilityReqBO = new UmcQrySupplierInfoDetailAbilityReqBO();
            umcQrySupplierInfoDetailAbilityReqBO.setOrgIdWeb(vendorBo.getOrgId());
            UmcQrySupplierInfoDetailAbilityRspBO umcQrySupplierInfoDetailAbilityRspBO = this.umcQrySupplierInfoDetailAbilityService.qrySupplierInfoDetail(umcQrySupplierInfoDetailAbilityReqBO);
            if (!"0000".equals(umcQrySupplierInfoDetailAbilityRspBO.getRespCode())) {
                throw new BusinessException("8888", "\u67e5\u8be2\u4f9b\u5e94\u5546\u5931\u8d25:" + umcQrySupplierInfoDetailAbilityRspBO.getRespDesc());
            }
            if (umcQrySupplierInfoDetailAbilityRspBO.getSupplierId() == null) {
                throw new BusinessException("8888", "\u5bf9\u5e94\u4f9b\u5e94\u5546\u67e5\u8be2\u4e0d\u5b58\u5728!");
            }
            contractInfoBo.setVendorId(umcQrySupplierInfoDetailAbilityRspBO.getSupplierId());
            contractInfoBo.setVendorName(umcQrySupplierInfoDetailAbilityRspBO.getSupplierName());
            if (srmPurchaseTypeList.contains(contractInfoBo.getCenterPurchaseType())) {
                EnterpriseOrgExtMapJoinBO purchaseOrgExtMapJoinBO = this.qryOrgId(contractInfoBo.getPurImpUnitOrgCode());
                contractInfoBo.setPurImpUnitOrgId(purchaseOrgExtMapJoinBO.getOrgId());
                contractInfoBo.setPurImpUnitOrgName(purchaseOrgExtMapJoinBO.getOrgName());
            }
            EnterpriseOrgExtMapJoinBO orgBo = this.qryOrgId(contractInfoBo.getOrgCode());
            contractInfoBo.setOrgId(orgBo.getOrgId());
            contractInfoBo.setOrgName(orgBo.getOrgName());
            EnterpriseOrgExtMapJoinBO creatorOrgBo = this.qryOrgId(contractInfoBo.getCreatorOrgCode());
            contractInfoBo.setCreatorOrgId(creatorOrgBo.getOrgId());
            contractInfoBo.setCreatorOrgName(creatorOrgBo.getOrgName());
        });
    }

    private EnterpriseOrgExtMapJoinBO qryOrgId(String esbOrgCode) {
        EnterpriseOrgExtMapJoinBO enterpriseOrgExtMapJoinBO = null;
        UmcOrgExtMapOperateAbilityReqBO umcOrgExtMapOperateAbilityReqBO = new UmcOrgExtMapOperateAbilityReqBO();
        umcOrgExtMapOperateAbilityReqBO.setFieldValue(esbOrgCode);
        umcOrgExtMapOperateAbilityReqBO.setFieldCode("esbOrgCode");
        umcOrgExtMapOperateAbilityReqBO.setOperateType(Integer.valueOf(4));
        UmcOrgExtMapOperateAbilityRspBO umcOrgExtMapOperateAbilityRspBO = this.umcOrgExtMapOperateAbilityService.operate(umcOrgExtMapOperateAbilityReqBO);
        if (!"0000".equals(umcOrgExtMapOperateAbilityRspBO.getRespCode())) {
            throw new BusinessException("8888", "\u67e5\u8be2\u7edf\u4e00\u8ba4\u8bc1\u552f\u4e00\u6807\u8bc6\u5931\u8d25!");
        }
        if (!CollectionUtils.isEmpty((Collection)umcOrgExtMapOperateAbilityRspBO.getRows())) {
            enterpriseOrgExtMapJoinBO = (EnterpriseOrgExtMapJoinBO)umcOrgExtMapOperateAbilityRspBO.getRows().get(0);
        }
        if (enterpriseOrgExtMapJoinBO == null) {
            throw new ZTBusinessException("\u5355\u4f4d\u7f16\u7801\uff1a" + esbOrgCode + "\uff0c\u5bf9\u5e94\u5355\u4f4d\u67e5\u8be2\u4e0d\u5b58\u5728!");
        }
        return enterpriseOrgExtMapJoinBO;
    }
}

