/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.atom.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.agreement.atom.AgrCreateAgreementSkuAtomService;
import com.tydic.agreement.atom.bo.AgrCreateAgreementSkuAtomReqBO;
import com.tydic.agreement.atom.bo.AgrCreateAgreementSkuAtomRspBO;
import com.tydic.agreement.common.bo.AgrAgreementSkuBO;
import com.tydic.agreement.constant.AgrCommConstant;
import com.tydic.agreement.dao.AgreementSkuMapper;
import com.tydic.agreement.dao.po.AgreementSkuPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class AgrCreateAgreementSkuAtomServiceImpl
implements AgrCreateAgreementSkuAtomService {
    @Autowired
    private AgreementSkuMapper agreementSkuMapper;

    @Override
    public AgrCreateAgreementSkuAtomRspBO createAgreementSku(AgrCreateAgreementSkuAtomReqBO atomReqBO) {
        AgrCreateAgreementSkuAtomRspBO rsp = new AgrCreateAgreementSkuAtomRspBO();
        ArrayList<AgreementSkuPO> agrAgreementSkuPOs = new ArrayList<AgreementSkuPO>();
        ArrayList<Long> agreementSkuIds = new ArrayList<Long>();
        for (AgrAgreementSkuBO bo : atomReqBO.getAgrAgreementSkuBOs()) {
            AgreementSkuPO agreementSkuPO = new AgreementSkuPO();
            BeanUtils.copyProperties((Object)bo, (Object)agreementSkuPO);
            Long agreementSkuId = Sequence.getInstance().nextId();
            agreementSkuPO.setAgreementSkuId(agreementSkuId);
            agreementSkuPO.setAgreementId(atomReqBO.getAgreementId());
            agreementSkuPO.setAgreementVersion(atomReqBO.getAgreementVersion());
            agreementSkuPO.setSupplierId(atomReqBO.getSupplierId());
            agreementSkuPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
            if (null == agreementSkuPO.getFreezeFlag()) {
                agreementSkuPO.setFreezeFlag(AgrCommConstant.IsDelete.NORMAL);
            }
            if (null == agreementSkuPO.getEffectiveFlag()) {
                agreementSkuPO.setEffectiveFlag(AgrCommConstant.IsDelete.NORMAL);
            }
            agreementSkuPO.setSkuStatus(AgrCommConstant.SkuStatus.TO_BE_RELEASED);
            agreementSkuPO.setCreateLoginId(atomReqBO.getMemIdIn());
            agreementSkuPO.setCreateName(atomReqBO.getUsername());
            agreementSkuPO.setCreateTime(new Date());
            agreementSkuPO.setAcceptanceScale(bo.getAcceptanceScale());
            agreementSkuPO.setBuyPriceSum(new BigDecimal(agreementSkuPO.getBuyPrice()).multiply(agreementSkuPO.getBuyNumber()).longValue());
            agreementSkuPO.setSalePrice(new BigDecimal(agreementSkuPO.getBuyPrice()).add(new BigDecimal(agreementSkuPO.getBuyPrice()).multiply(new BigDecimal(agreementSkuPO.getMarkupRate().toString())).divide(new BigDecimal("100"))).longValue());
            if (StringUtils.hasText((String)agreementSkuPO.getMarkupValue())) {
                agreementSkuPO.setSalePrice(agreementSkuPO.getSalePrice() + new BigDecimal(agreementSkuPO.getMarkupValue()).multiply(new BigDecimal("10000")).longValue());
            }
            agreementSkuPO.setSalePriceSum(new BigDecimal(agreementSkuPO.getSalePrice()).multiply(agreementSkuPO.getBuyNumber()).longValue());
            agrAgreementSkuPOs.add(agreementSkuPO);
            agreementSkuIds.add(agreementSkuId);
        }
        int isInsert = this.agreementSkuMapper.insertBatch(agrAgreementSkuPOs);
        if (isInsert != agrAgreementSkuPOs.size()) {
            throw new BusinessException("0101", "\u63d2\u5165\u534f\u8bae\u660e\u7ec6\u8868\u5931\u8d25\uff01");
        }
        rsp.setAgreementSkuIds(agreementSkuIds);
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u534f\u8bae\u660e\u7ec6\u521b\u5efa\u6210\u529f\uff01");
        return rsp;
    }

    @Override
    public AgrCreateAgreementSkuAtomRspBO createExtAgreementSku(AgrCreateAgreementSkuAtomReqBO atomReqBO) {
        AgrCreateAgreementSkuAtomRspBO rsp = new AgrCreateAgreementSkuAtomRspBO();
        ArrayList<AgreementSkuPO> agrAgreementSkuPOs = new ArrayList<AgreementSkuPO>();
        for (AgrAgreementSkuBO bo : atomReqBO.getAgrAgreementSkuBOs()) {
            AgreementSkuPO agreementSkuPO = new AgreementSkuPO();
            BeanUtils.copyProperties((Object)bo, (Object)agreementSkuPO);
            Long agreementSkuId = Sequence.getInstance().nextId();
            agreementSkuPO.setAgreementSkuId(agreementSkuId);
            agreementSkuPO.setAgreementId(atomReqBO.getAgreementId());
            agreementSkuPO.setSupplierId(atomReqBO.getSupplierId());
            agreementSkuPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
            agreementSkuPO.setSkuStatus(AgrCommConstant.SkuStatus.TO_BE_RELEASED);
            agreementSkuPO.setCreateLoginId(atomReqBO.getMemIdIn());
            agreementSkuPO.setCreateName(atomReqBO.getUsername());
            agreementSkuPO.setCreateTime(new Date());
            agreementSkuPO.setAgreementVersion("null");
            agreementSkuPO.setManufacturer("null");
            agreementSkuPO.setBuyPriceSum(0L);
            agreementSkuPO.setMarkupRate(0.0);
            agreementSkuPO.setSalePrice(0L);
            agreementSkuPO.setSalePriceSum(0L);
            agreementSkuPO.setMeasureName("null");
            agreementSkuPO.setBuyNumber(BigDecimal.ZERO);
            agrAgreementSkuPOs.add(agreementSkuPO);
        }
        int isInsert = this.agreementSkuMapper.insertBatch(agrAgreementSkuPOs);
        if (isInsert != agrAgreementSkuPOs.size()) {
            throw new BusinessException("0101", "\u63d2\u5165\u534f\u8bae\u660e\u7ec6\u8868\u5931\u8d25\uff01");
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u534f\u8bae\u660e\u7ec6\u521b\u5efa\u6210\u529f\uff01");
        return rsp;
    }
}

