/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.atom.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.agreement.atom.AgrDicDictionaryAtomService;
import com.tydic.agreement.common.bo.AgrDicDictionaryBO;
import com.tydic.agreement.dao.AgrDicDictionaryMapper;
import com.tydic.agreement.dao.po.AgrDicDictionaryPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="agrDicDictionaryAtomService")
public class AgrDicDictionaryAtomServiceImpl
implements AgrDicDictionaryAtomService {
    @Autowired
    private AgrDicDictionaryMapper agrDicDictionaryMapper;
    @Autowired
    private CacheClient cacheService;

    @Override
    public Map<String, String> queryDictBySysCodeAndPcode(String sysCode, String pCode) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)sysCode)) {
            throw new BusinessException("0001", "sysCode\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)pCode)) {
            throw new BusinessException("0001", "pCode\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String redisKey = sysCode + "_" + pCode + "_";
        Object object = this.cacheService.get(redisKey);
        if (object != null) {
            List dicDictionary = (List)object;
            if (!CollectionUtils.isEmpty((Collection)dicDictionary)) {
                for (AgrDicDictionaryBO bo : dicDictionary) {
                    result.put(bo.getCode(), bo.getTitle());
                }
            }
        } else {
            AgrDicDictionaryPO dictionaryPO = new AgrDicDictionaryPO();
            dictionaryPO.setpCode(pCode);
            dictionaryPO.setSysCode(sysCode);
            List<AgrDicDictionaryPO> agrDicDictionaryPOList = this.agrDicDictionaryMapper.getListByCondition(dictionaryPO);
            if (!CollectionUtils.isEmpty(agrDicDictionaryPOList)) {
                ArrayList<AgrDicDictionaryBO> temp = new ArrayList<AgrDicDictionaryBO>();
                for (AgrDicDictionaryPO dicPO : agrDicDictionaryPOList) {
                    AgrDicDictionaryBO bo = new AgrDicDictionaryBO();
                    BeanUtils.copyProperties((Object)dicPO, (Object)bo);
                    temp.add(bo);
                    result.put(dicPO.getCode(), dicPO.getTitle());
                }
                this.cacheService.set(redisKey, temp);
            }
        }
        return result;
    }

    @Override
    public List<AgrDicDictionaryBO> queryDictBOBySysCodeAndPcode(String sysCode, String pCode) {
        ArrayList<AgrDicDictionaryBO> result = new ArrayList<AgrDicDictionaryBO>();
        if (StringUtils.isBlank((CharSequence)sysCode)) {
            throw new BusinessException("0001", "sysCode\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)pCode)) {
            throw new BusinessException("0001", "pCode\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String redisKey = sysCode + "_" + pCode + "_";
        Object object = this.cacheService.get(redisKey);
        if (object != null) {
            List dicDictionary = (List)object;
            return dicDictionary;
        }
        AgrDicDictionaryPO dictionaryPO = new AgrDicDictionaryPO();
        dictionaryPO.setpCode(pCode);
        dictionaryPO.setSysCode(sysCode);
        List<AgrDicDictionaryPO> agrDicDictionaryPOList = this.agrDicDictionaryMapper.getListByCondition(dictionaryPO);
        if (!CollectionUtils.isEmpty(agrDicDictionaryPOList)) {
            for (AgrDicDictionaryPO dicPO : agrDicDictionaryPOList) {
                AgrDicDictionaryBO bo = new AgrDicDictionaryBO();
                BeanUtils.copyProperties((Object)dicPO, (Object)bo);
                result.add(bo);
            }
            this.cacheService.set(redisKey, result);
        }
        return result;
    }

    @Override
    public String queryDictBySysCodeAndPcodeAndCode(String sysCode, String pCode, String code) {
        String result = null;
        if (StringUtils.isBlank((CharSequence)sysCode)) {
            throw new BusinessException("0001", "sysCode\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)pCode)) {
            throw new BusinessException("0001", "pCode\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)code)) {
            throw new BusinessException("0001", "code\uff01");
        }
        String redisKey = sysCode + "_" + pCode + "_";
        Object object = this.cacheService.get(redisKey);
        if (object != null) {
            List dicDictionary = (List)object;
            if (!CollectionUtils.isEmpty((Collection)dicDictionary)) {
                for (AgrDicDictionaryBO bo : dicDictionary) {
                    if (!code.equals(bo.getCode())) continue;
                    return bo.getTitle();
                }
            }
        } else {
            AgrDicDictionaryPO dictionaryPO = new AgrDicDictionaryPO();
            dictionaryPO.setpCode(pCode);
            dictionaryPO.setSysCode(sysCode);
            List<AgrDicDictionaryPO> agrDicDictionaryPOList = this.agrDicDictionaryMapper.getListByCondition(dictionaryPO);
            if (!CollectionUtils.isEmpty(agrDicDictionaryPOList)) {
                ArrayList<AgrDicDictionaryBO> bos = new ArrayList<AgrDicDictionaryBO>();
                for (AgrDicDictionaryPO dicPO : agrDicDictionaryPOList) {
                    AgrDicDictionaryBO bo = new AgrDicDictionaryBO();
                    BeanUtils.copyProperties((Object)dicPO, (Object)bo);
                    if (code.equals(bo.getCode())) {
                        result = bo.getTitle();
                    }
                    bos.add(bo);
                }
                this.cacheService.set(redisKey, bos);
            }
        }
        return result;
    }
}

