/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.agreement.busi.AgrAddDispatchInfoBusiService;
import com.tydic.agreement.busi.bo.AgrAddDispatchInfoServiceReqBO;
import com.tydic.agreement.busi.bo.AgrAddDispatchInfoServiceRspBO;
import com.tydic.agreement.common.bo.AgrProjectDispatchConfigBO;
import com.tydic.agreement.common.bo.AgrProjectDispatchItemConfigBO;
import com.tydic.agreement.constant.AgrCommConstant;
import com.tydic.agreement.dao.OpsContractMapper;
import com.tydic.agreement.dao.ProjectDispatchConfigMapper;
import com.tydic.agreement.dao.ProjectDispatchItemConfigMapper;
import com.tydic.agreement.dao.po.OpsContractPO;
import com.tydic.agreement.dao.po.ProjectDispatchConfigPO;
import com.tydic.agreement.dao.po.ProjectDispatchItemConfigPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class AgrAddDispatchInfoBusiServiceImpl
implements AgrAddDispatchInfoBusiService {
    private static final Logger log = LoggerFactory.getLogger(AgrAddDispatchInfoBusiServiceImpl.class);
    private final OpsContractMapper opsContractMapper;
    private final ProjectDispatchConfigMapper projectDispatchConfigMapper;
    private final ProjectDispatchItemConfigMapper projectDispatchItemConfigMapper;

    public AgrAddDispatchInfoBusiServiceImpl(OpsContractMapper opsContractMapper, ProjectDispatchConfigMapper projectDispatchConfigMapper, ProjectDispatchItemConfigMapper projectDispatchItemConfigMapper) {
        this.opsContractMapper = opsContractMapper;
        this.projectDispatchConfigMapper = projectDispatchConfigMapper;
        this.projectDispatchItemConfigMapper = projectDispatchItemConfigMapper;
    }

    public AgrAddDispatchInfoServiceRspBO addDispatchConfig(AgrAddDispatchInfoServiceReqBO reqBO) {
        AgrAddDispatchInfoServiceRspBO rspBO = new AgrAddDispatchInfoServiceRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        ProjectDispatchConfigPO projectDispatchConfigPO = this.buildProjectDispatchConfig(reqBO.getProjectDispatchConfigBO());
        int projectAddCount = this.projectDispatchConfigMapper.insert(projectDispatchConfigPO);
        if (projectAddCount < 1) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u9879\u76ee\u4e3b\u4f53\u4fe1\u606f\u5165\u5e93\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6838\u67e5\uff01");
            return rspBO;
        }
        List<ProjectDispatchItemConfigPO> projectDispatchItemConfigPOS = this.buildProjectDispatchItemConfig(reqBO.getProjectDispatchItemConfigBOS(), projectDispatchConfigPO);
        int projectItemAddCount = this.projectDispatchItemConfigMapper.insertBatch(projectDispatchItemConfigPOS);
        if (projectItemAddCount < 1) {
            throw new BusinessException("8888", "\u9879\u76ee\u8f6e\u6b21\u4fe1\u606f\u5165\u5e93\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6838\u67e5\uff01");
        }
        return rspBO;
    }

    private ProjectDispatchConfigPO buildProjectDispatchConfig(AgrProjectDispatchConfigBO projectDispatchConfigBO) {
        ProjectDispatchConfigPO projectDispatchConfigPO = new ProjectDispatchConfigPO();
        projectDispatchConfigPO.setId(Sequence.getInstance().nextId());
        projectDispatchConfigPO.setProjectCode(projectDispatchConfigBO.getProjectCode());
        projectDispatchConfigPO.setProjectName(projectDispatchConfigBO.getProjectName());
        projectDispatchConfigPO.setState(AgrCommConstant.DISPATCH_STATE.WAITE_APPROVAL);
        projectDispatchConfigPO.setUseSelectState(projectDispatchConfigBO.getUseSelectState());
        projectDispatchConfigPO.setProjectHandlerId(projectDispatchConfigBO.getProjectHandlerId());
        projectDispatchConfigPO.setProjectHandlerName(projectDispatchConfigBO.getProjectHandlerName());
        projectDispatchConfigPO.setCreateTime(new Date());
        projectDispatchConfigPO.setDispatchType(projectDispatchConfigBO.getDispatchType());
        projectDispatchConfigPO.setRejectTimesLimit(projectDispatchConfigBO.getRejectTimesLimit());
        projectDispatchConfigPO.setLastExecutionSeq(0);
        projectDispatchConfigPO.setCurrentRounds(1);
        projectDispatchConfigPO.setDispatchCode(projectDispatchConfigBO.getProjectCode() + "-PD");
        projectDispatchConfigPO.setVersion(1);
        return projectDispatchConfigPO;
    }

    private List<ProjectDispatchItemConfigPO> buildProjectDispatchItemConfig(List<AgrProjectDispatchItemConfigBO> projectDispatchItemConfigBOS, ProjectDispatchConfigPO projectDispatchConfigPO) {
        List<String> contractCodes = projectDispatchItemConfigBOS.stream().map(AgrProjectDispatchItemConfigBO::getContractCode).collect(Collectors.toList());
        Map<String, String> contractCodeMap = this.queryContractCode(contractCodes);
        ArrayList<ProjectDispatchItemConfigPO> projectDispatchItemConfigPOS = new ArrayList<ProjectDispatchItemConfigPO>();
        projectDispatchItemConfigBOS.forEach(bo -> {
            BigDecimal remainExecutableAmount;
            ProjectDispatchItemConfigPO projectDispatchItemConfigPO = new ProjectDispatchItemConfigPO();
            projectDispatchItemConfigPO.setId(Sequence.getInstance().nextId());
            projectDispatchItemConfigPO.setProjectCode(projectDispatchConfigPO.getProjectCode());
            projectDispatchItemConfigPO.setDispatchSequence(bo.getDispatchSequence());
            projectDispatchItemConfigPO.setContractCode(bo.getContractCode());
            projectDispatchItemConfigPO.setContractName(bo.getContractName());
            projectDispatchItemConfigPO.setEntAgreementCode(bo.getEntAgreementCode());
            projectDispatchItemConfigPO.setSupplierId(bo.getSupplierId());
            projectDispatchItemConfigPO.setSupplierName(bo.getSupplierName());
            projectDispatchItemConfigPO.setDispatchRounds(projectDispatchConfigPO.getCurrentRounds());
            projectDispatchItemConfigPO.setRoundsState(AgrCommConstant.IsDelete.NORMAL.intValue());
            projectDispatchItemConfigPO.setAmountLimit(bo.getAmountLimit());
            String agreementTentativeAmount = (String)contractCodeMap.get(bo.getContractCode());
            if (!StringUtils.hasText((String)agreementTentativeAmount)) {
                throw new BusinessException("8888", "\u9879\u76ee\u8f6e\u6b21\u4fe1\u606f\u5165\u5e93\u5931\u8d25\uff0c\u5408\u540c\u4fe1\u606f\u7684\u6682\u5b9a\u91d1\u989d\u4e3a\u7a7a\uff01");
            }
            try {
                remainExecutableAmount = new BigDecimal(agreementTentativeAmount);
            }
            catch (Exception e) {
                log.error("\u9879\u76ee\u8f6e\u6b21\u4fe1\u606f\u5165\u5e93\u5931\u8d25\uff0c\u91d1\u989d\u8f6c\u5316\u5931\u8d25\uff1a", (Throwable)e);
                throw new BusinessException("8888", "\u9879\u76ee\u8f6e\u6b21\u4fe1\u606f\u5165\u5e93\u5931\u8d25\uff0c\u5408\u540c\u4fe1\u606f\u7684\u6682\u5b9a\u91d1\u989d\u8f6c\u6362\u5931\u8d25\uff01");
            }
            if (remainExecutableAmount.compareTo(bo.getAmountLimit()) < 0) {
                throw new BusinessException("8888", "\u9879\u76ee\u8f6e\u6b21\u4fe1\u606f\u5165\u5e93\u5931\u8d25\uff0c\u4e0a\u9650\u91d1\u989d\u4e0d\u80fd\u8d85\u8fc7\u6682\u5b9a\u603b\u989d\uff01");
            }
            projectDispatchItemConfigPO.setRemainExecutableAmount(remainExecutableAmount);
            projectDispatchItemConfigPO.setExecutedAmount(BigDecimal.ZERO);
            projectDispatchItemConfigPO.setCycleRejectCnt(0);
            projectDispatchItemConfigPO.setWhetherExecutionCompleted(AgrCommConstant.PROJECT_ROUNDS_EXECUTE.IN_EXECUTION);
            projectDispatchItemConfigPO.setVersion(projectDispatchConfigPO.getVersion());
            projectDispatchItemConfigPOS.add(projectDispatchItemConfigPO);
        });
        return projectDispatchItemConfigPOS;
    }

    private Map<String, String> queryContractCode(List<String> contractCodes) {
        OpsContractPO opsContractPO = new OpsContractPO();
        opsContractPO.setContractCodeIn(contractCodes);
        List<OpsContractPO> opsContractPOList = this.opsContractMapper.getList(opsContractPO);
        if (CollectionUtils.isEmpty(opsContractPOList)) {
            throw new BusinessException("8888", "\u9879\u76ee\u8f6e\u6b21\u4fe1\u606f\u5165\u5e93\u5931\u8d25\uff0c\u672a\u67e5\u8be2\u5230\u5408\u540c\u4fe1\u606f\uff01");
        }
        return opsContractPOList.stream().collect(Collectors.toMap(OpsContractPO::getContractCode, OpsContractPO::getContractAmount, (key1, key2) -> key1));
    }
}

