/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.agreement.ability.bo.AgrAgreementScopeSyncQueueReqBO;
import com.tydic.agreement.ability.bo.AgrAgreementScopeSyncQueueRspBO;
import com.tydic.agreement.busi.AgrAgreementAddApprovalBusiService;
import com.tydic.agreement.busi.AgrAgreementScopeSyncQueueBusiService;
import com.tydic.agreement.busi.bo.AgrAgreementAddApprovalBusiReqBO;
import com.tydic.agreement.busi.bo.AgrAgreementAddApprovalBusiRspBO;
import com.tydic.agreement.common.bo.AgrAuditBO;
import com.tydic.agreement.constant.AgrCommConstant;
import com.tydic.agreement.constant.AgrEnum;
import com.tydic.agreement.dao.AgrAuditMapper;
import com.tydic.agreement.dao.AgrRelBusiPropLabelLogMapper;
import com.tydic.agreement.dao.AgrRelBusiPropLabelMapper;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.OpsContractMapper;
import com.tydic.agreement.dao.po.AgrAuditPO;
import com.tydic.agreement.dao.po.AgrRelBusiPropLabelLogPO;
import com.tydic.agreement.dao.po.AgrRelBusiPropLabelPO;
import com.tydic.agreement.dao.po.AgreementPO;
import com.tydic.uac.ability.UacNoTaskAuditOrderAuditAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditRspBO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class AgrAgreementAddApprovalBusiServiceImpl
implements AgrAgreementAddApprovalBusiService {
    private static final Logger log = LoggerFactory.getLogger(AgrAgreementAddApprovalBusiServiceImpl.class);
    @Autowired
    private UacNoTaskAuditOrderAuditAbilityService uacNoTaskAuditOrderAuditAbilityService;
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgrAuditMapper agrAuditMapper;
    @Autowired
    private AgrRelBusiPropLabelMapper agrRelBusiPropLabelMapper;
    @Autowired
    private AgrRelBusiPropLabelLogMapper agrRelBusiPropLabelLogMapper;
    @Value(value="${hasConfirmLike}")
    private Boolean hasConfirmLike;
    @Autowired
    private AgrAgreementScopeSyncQueueBusiService agrAgreementScopeSyncQueueBusiService;
    @Autowired
    private OpsContractMapper opsContractMapper;

    public AgrAgreementAddApprovalBusiRspBO approvalAgreementAdd(AgrAgreementAddApprovalBusiReqBO busiReqBO) {
        AgrAgreementAddApprovalBusiRspBO rsp = new AgrAgreementAddApprovalBusiRspBO();
        Map<String, Set<Long>> stepAgreementIdMap = this.validAgreementInfo(busiReqBO);
        HashMap<String, Object> variables = new HashMap<String, Object>();
        ArrayList<Long> agreementIds = new ArrayList<Long>();
        for (String stepId : stepAgreementIdMap.keySet()) {
            busiReqBO.setAgreementIds(new ArrayList(stepAgreementIdMap.get(stepId)));
            if (AgrCommConstant.AuditResult.ADOPT.equals(busiReqBO.getAuditResult())) {
                variables.put("acceptFlag", "1");
            } else if (AgrCommConstant.AuditResult.NOT_PASS.equals(busiReqBO.getAuditResult())) {
                variables.put("acceptFlag", "0");
            }
            Boolean processEndFlag = this.invokeProcess(busiReqBO, stepId, variables);
            if (processEndFlag.booleanValue()) {
                AgreementPO agrPO = new AgreementPO();
                agrPO.setAgreementIds(busiReqBO.getAgreementIds());
                agrPO.setSupplierId(busiReqBO.getSupplierId());
                List<AgreementPO> agreementPOS = this.agreementMapper.getList(agrPO);
                ArrayList<AgreementPO> opsAgreementPOS = new ArrayList<AgreementPO>();
                ArrayList<Long> otherAgreementIds = new ArrayList<Long>();
                for (AgreementPO po : agreementPOS) {
                    if (AgrEnum.RelSystem.OPS.toString().equalsIgnoreCase(po.getRelSystem())) {
                        AgreementPO opsAgrPO = new AgreementPO();
                        opsAgrPO.setAgreementId(po.getAgreementId());
                        opsAgrPO.setSupplierId(po.getSupplierId());
                        if (AgrCommConstant.AuditResult.ADOPT.equals(busiReqBO.getAuditResult())) {
                            if (StringUtils.hasText((String)po.getExtContractStatus())) {
                                opsAgrPO.setAgreementStatus(AgrEnum.AgrStatusCorrespondOpsContractStatusEnum.getagrStatus((String)po.getExtContractStatus()));
                            } else {
                                opsAgrPO.setAgreementStatus(AgrCommConstant.AgreementStatus.ENABLE);
                                this.insertPropLabelLog(busiReqBO);
                            }
                        } else if (AgrCommConstant.AuditResult.NOT_PASS.equals(busiReqBO.getAuditResult())) {
                            opsAgrPO.setAgreementStatus(AgrCommConstant.AgreementStatus.REJECT);
                        }
                        opsAgreementPOS.add(opsAgrPO);
                        agreementIds.add(po.getAgreementId());
                        continue;
                    }
                    otherAgreementIds.add(po.getAgreementId());
                }
                if (!CollectionUtils.isEmpty(otherAgreementIds)) {
                    AgreementPO agreementPO = new AgreementPO();
                    agreementPO.setAgreementIds(otherAgreementIds);
                    agreementPO.setSupplierId(busiReqBO.getSupplierId());
                    if (AgrCommConstant.AuditResult.ADOPT.equals(busiReqBO.getAuditResult())) {
                        agreementPO.setAgreementStatus(AgrCommConstant.AgreementStatus.ENABLE);
                        this.insertPropLabelLog(busiReqBO);
                    } else if (AgrCommConstant.AuditResult.NOT_PASS.equals(busiReqBO.getAuditResult())) {
                        agreementPO.setAgreementStatus(AgrCommConstant.AgreementStatus.REJECT);
                    }
                    int count = this.agreementMapper.updateByCondition(agreementPO);
                    if (count != busiReqBO.getAgreementIds().size()) {
                        throw new BusinessException("22005", "\u4fee\u6539\u534f\u8bae\u8868\u72b6\u6001\u5931\u8d25");
                    }
                    agreementIds.addAll(busiReqBO.getAgreementIds());
                }
                if (CollectionUtils.isEmpty(opsAgreementPOS)) continue;
                this.agreementMapper.updateBatchOpsAgreement(opsAgreementPOS);
                continue;
            }
            if (!this.hasConfirmLike.booleanValue()) continue;
            AgreementPO agreementPO1 = new AgreementPO();
            agreementPO1.setAgreementIds(busiReqBO.getAgreementIds());
            agreementPO1.setSupplierId(busiReqBO.getSupplierId());
            agreementPO1.setAgreementStatus(AgrCommConstant.AgreementStatus.IN_AUDIT);
            int count = this.agreementMapper.updateByCondition(agreementPO1);
            if (count == busiReqBO.getAgreementIds().size()) continue;
            throw new BusinessException("22005", "\u4fee\u6539\u534f\u8bae\u8868\u72b6\u6001\u5931\u8d25");
        }
        if (!CollectionUtils.isEmpty(agreementIds)) {
            AgrAgreementScopeSyncQueueReqBO agrAgreementScopeSyncQueueReqBO = new AgrAgreementScopeSyncQueueReqBO();
            agrAgreementScopeSyncQueueReqBO.setAgreementIds(agreementIds);
            AgrAgreementScopeSyncQueueRspBO agrAgreementScopeSyncQueueRspBO = this.agrAgreementScopeSyncQueueBusiService.addScopeSyncQueue(agrAgreementScopeSyncQueueReqBO);
            if (!"0000".equals(agrAgreementScopeSyncQueueRspBO.getRespCode())) {
                throw new BusinessException("22003", "\u534f\u8bae\u5e94\u7528\u8303\u56f4\u8bb0\u5f55\u5931\u8d25");
            }
        }
        rsp.setAgreementIds(agreementIds);
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u534f\u8bae\u65b0\u589e\u5ba1\u6279\u6210\u529f\uff01");
        return rsp;
    }

    private void insertPropLabelLog(AgrAgreementAddApprovalBusiReqBO busiReqBO) {
        AgrRelBusiPropLabelPO agrRelBusiPropLabelPO = new AgrRelBusiPropLabelPO();
        agrRelBusiPropLabelPO.setAgreementIdIn(busiReqBO.getAgreementIds());
        List<AgrRelBusiPropLabelPO> propLabelMapperList = this.agrRelBusiPropLabelMapper.getList(agrRelBusiPropLabelPO);
        ArrayList<AgrRelBusiPropLabelLogPO> agrRelBusiPropLabelLogPOS = new ArrayList<AgrRelBusiPropLabelLogPO>(propLabelMapperList.size());
        if (!CollectionUtils.isEmpty(propLabelMapperList)) {
            for (AgrRelBusiPropLabelPO po : propLabelMapperList) {
                AgrRelBusiPropLabelLogPO logPO = new AgrRelBusiPropLabelLogPO();
                BeanUtils.copyProperties((Object)po, (Object)logPO);
                Long logId = Sequence.getInstance().nextId();
                logPO.setLogId(logId);
                logPO.setCreateTime(new Date());
                logPO.setCreateUserId(busiReqBO.getUserId());
                logPO.setCreateUserName(busiReqBO.getUsername());
                logPO.setLogTime(new Date());
                agrRelBusiPropLabelLogPOS.add(logPO);
            }
            int countLog = this.agrRelBusiPropLabelLogMapper.insertBatch(agrRelBusiPropLabelLogPOS);
            if (countLog != agrRelBusiPropLabelLogPOS.size()) {
                throw new BusinessException("22005", "\u65b0\u589e\u534f\u8bae\u4e1a\u52a1\u5c5e\u6027\u6807\u7b7e\u5173\u8054\u65e5\u5fd7\u8868\u5931\u8d25");
            }
        }
    }

    private Map<String, Set<Long>> validAgreementInfo(AgrAgreementAddApprovalBusiReqBO busiReqBO) {
        HashMap<String, Set<Long>> result = new HashMap<String, Set<Long>>();
        AgreementPO agreementPO = new AgreementPO();
        agreementPO.setSupplierId(busiReqBO.getSupplierId());
        agreementPO.setAgreementIds(busiReqBO.getAgreementIds());
        agreementPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        List<AgreementPO> agreementPOS = this.agreementMapper.getList(agreementPO);
        if (CollectionUtils.isEmpty(agreementPOS)) {
            throw new BusinessException("22001", "\u534f\u8bae\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        HashSet<Long> statusErrors = new HashSet<Long>();
        HashSet<Long> agreementIds = new HashSet<Long>();
        for (AgreementPO po : agreementPOS) {
            if (!AgrCommConstant.AgreementStatus.IN_AUDIT.equals(po.getAgreementStatus()) && !AgrCommConstant.AgreementStatus.TO_CONFIRM.equals(po.getAgreementStatus())) {
                statusErrors.add(po.getAgreementId());
            }
            agreementIds.add(po.getAgreementId());
        }
        if (statusErrors.size() > 0) {
            throw new BusinessException("22002", "\u534f\u8bae\u3010" + statusErrors + "\u3011\u72b6\u6001\u4e0d\u662f\u5ba1\u6838\u4e2d\u6216\u8005\u5f85\u786e\u8ba4");
        }
        if (agreementIds.size() < busiReqBO.getAgreementIds().size()) {
            busiReqBO.getAgreementIds().removeAll(agreementIds);
            throw new BusinessException("22006", "\u534f\u8bae\u3010" + busiReqBO.getAgreementIds() + "\u3011\u4e0d\u5b58\u5728");
        }
        AgrAuditPO agrAuditPO = new AgrAuditPO();
        agrAuditPO.setObjType(AgrCommConstant.AuditObjType.AGREEMENT_AUDIT);
        agrAuditPO.setObjIds(agreementIds);
        agrAuditPO.setTabValue(1);
        agrAuditPO.setStationCodes(busiReqBO.getStationCodes());
        List<AgrAuditBO> agrAuditBOs = this.agrAuditMapper.getAuditInfoByObjIds(agrAuditPO);
        if (CollectionUtils.isEmpty(agrAuditBOs)) {
            throw new BusinessException("22001", "\u534f\u8bae\u4e0d\u5b58\u5728\u6d41\u7a0b\u4fe1\u606f");
        }
        HashSet stepIds = new HashSet();
        HashSet<Long> auditSize = new HashSet<Long>();
        Object stepId = null;
        for (AgrAuditBO agrAuditBO : agrAuditBOs) {
            HashSet<Long> agreeementIdSet = (HashSet<Long>)result.get(agrAuditBO.getStepId());
            if (null == agreeementIdSet) {
                agreeementIdSet = new HashSet<Long>();
            }
            agreeementIdSet.add(agrAuditBO.getObjId());
            result.put(agrAuditBO.getStepId(), agreeementIdSet);
            auditSize.add(agrAuditBO.getObjId());
        }
        if (auditSize.size() < busiReqBO.getAgreementIds().size()) {
            busiReqBO.getAgreementIds().removeAll(auditSize);
            throw new BusinessException("22006", "\u534f\u8bae\u3010" + busiReqBO.getAgreementIds() + "\u3011\u4e0d\u5b58\u5728\u6d41\u7a0b\u4fe1\u606f");
        }
        return result;
    }

    private Boolean invokeProcess(AgrAgreementAddApprovalBusiReqBO busiReqBO, String stepId, Map<String, Object> variables) {
        UacNoTaskAuditOrderAuditReqBO uacNoTaskAuditOrderAuditReqBO = new UacNoTaskAuditOrderAuditReqBO();
        uacNoTaskAuditOrderAuditReqBO.setObjId(busiReqBO.getAgreementIds());
        uacNoTaskAuditOrderAuditReqBO.setStepId(stepId);
        uacNoTaskAuditOrderAuditReqBO.setAuditResult(busiReqBO.getAuditResult());
        uacNoTaskAuditOrderAuditReqBO.setAuditAdvice(busiReqBO.getAuditAdvice());
        uacNoTaskAuditOrderAuditReqBO.setOperId(busiReqBO.getMemIdIn().toString());
        uacNoTaskAuditOrderAuditReqBO.setUsername(busiReqBO.getUsername());
        uacNoTaskAuditOrderAuditReqBO.setOperDept(busiReqBO.getOrgName());
        uacNoTaskAuditOrderAuditReqBO.setObjType(AgrCommConstant.AuditObjType.AGREEMENT_AUDIT);
        uacNoTaskAuditOrderAuditReqBO.setMsgFlag(Integer.valueOf(1));
        uacNoTaskAuditOrderAuditReqBO.setVariables(variables);
        log.debug("\u8c03\u7528\u5ba1\u6279\u6a21\u5757\u65e0\u6d41\u7a0b\u5ba1\u6279\u5355\u5ba1\u6279\u5165\u53c2\uff1a" + JSON.toJSONString((Object)uacNoTaskAuditOrderAuditReqBO));
        UacNoTaskAuditOrderAuditRspBO uacNoTaskAuditOrderAuditRspBO = this.uacNoTaskAuditOrderAuditAbilityService.dealAudit(uacNoTaskAuditOrderAuditReqBO);
        log.debug("\u8c03\u7528\u5ba1\u6279\u6a21\u5757\u65e0\u6d41\u7a0b\u5ba1\u6279\u5355\u5ba1\u6279\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)uacNoTaskAuditOrderAuditRspBO));
        if (!"0000".equals(uacNoTaskAuditOrderAuditRspBO.getRespCode())) {
            throw new BusinessException(uacNoTaskAuditOrderAuditRspBO.getRespCode(), uacNoTaskAuditOrderAuditRspBO.getRespDesc());
        }
        return uacNoTaskAuditOrderAuditRspBO.getNoneInstanceBO().getFinish();
    }
}

