/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.alibaba.fastjson.JSONArray;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.agreement.ability.bo.AgrAgreementScopeSyncQueueReqBO;
import com.tydic.agreement.ability.bo.AgrAgreementScopeSyncQueueRspBO;
import com.tydic.agreement.busi.AgrAgreementScopeSyncQueueBusiService;
import com.tydic.agreement.common.bo.AgreementScopeSyncQueueBO;
import com.tydic.agreement.constant.AgrEnum;
import com.tydic.agreement.dao.AgreementScopeSyncQueueMapper;
import com.tydic.agreement.dao.po.AgreementScopeSyncQueuePO;
import com.tydic.uac.exception.BusinessException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AgrAgreementScopeSyncQueueBusiServiceImpl
implements AgrAgreementScopeSyncQueueBusiService {
    @Autowired
    private AgreementScopeSyncQueueMapper agreementScopeSyncQueueMapper;

    public AgrAgreementScopeSyncQueueRspBO addOrgScopeSyncQueue(AgrAgreementScopeSyncQueueReqBO reqBO) {
        AgrAgreementScopeSyncQueueRspBO rspBO = new AgrAgreementScopeSyncQueueRspBO();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getOrgIds())) {
            ArrayList<AgreementScopeSyncQueuePO> agreementScopeSyncQueuePos = new ArrayList<AgreementScopeSyncQueuePO>();
            Date now = new Date();
            reqBO.getOrgIds().forEach(agrOrgScopeSyncBo -> agrOrgScopeSyncBo.getOrgScopes().forEach(agrOrgScopeBo -> {
                AgreementScopeSyncQueuePO po = new AgreementScopeSyncQueuePO();
                po.setId(Sequence.getInstance().nextId());
                po.setAgreementId(agrOrgScopeSyncBo.getAgreementId());
                po.setOrgId(agrOrgScopeBo.getOrgId());
                po.setScopeModeChange(agrOrgScopeBo.getScopeModeChange());
                po.setRunResult(AgrEnum.ScopeSyncQueueState.TO_BE_PROCESSED.getStateCode());
                po.setFailureCount(0);
                po.setCreateTime(now);
                agreementScopeSyncQueuePos.add(po);
            }));
            if (!CollectionUtils.isEmpty(agreementScopeSyncQueuePos)) {
                this.agreementScopeSyncQueueMapper.insertBatch(agreementScopeSyncQueuePos);
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public AgrAgreementScopeSyncQueueRspBO addScopeSyncQueue(AgrAgreementScopeSyncQueueReqBO reqBO) {
        AgrAgreementScopeSyncQueueRspBO rspBO = new AgrAgreementScopeSyncQueueRspBO();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getAgreementIds())) {
            ArrayList<AgreementScopeSyncQueuePO> agreementScopeSyncQueuePos = new ArrayList<AgreementScopeSyncQueuePO>();
            Date now = new Date();
            reqBO.getAgreementIds().forEach(agrId -> {
                AgreementScopeSyncQueuePO po = new AgreementScopeSyncQueuePO();
                po.setId(Sequence.getInstance().nextId());
                po.setAgreementId((Long)agrId);
                po.setRunResult(AgrEnum.ScopeSyncQueueState.TO_BE_PROCESSED.getStateCode());
                po.setFailureCount(0);
                po.setCreateTime(now);
                agreementScopeSyncQueuePos.add(po);
            });
            if (!CollectionUtils.isEmpty(agreementScopeSyncQueuePos)) {
                this.agreementScopeSyncQueueMapper.insertBatch(agreementScopeSyncQueuePos);
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public AgrAgreementScopeSyncQueueRspBO updateToInProcessAndGetList(AgrAgreementScopeSyncQueueReqBO reqBO) {
        AgrAgreementScopeSyncQueueRspBO rspBO = new AgrAgreementScopeSyncQueueRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        Page page = new Page(1, 100);
        AgreementScopeSyncQueuePO agreementScopeSyncQueuePO = new AgreementScopeSyncQueuePO();
        agreementScopeSyncQueuePO.setFailureCountIn(Arrays.asList(0, 1, 2, 3, 4, 5));
        agreementScopeSyncQueuePO.setRunResultIn(Arrays.asList(AgrEnum.ScopeSyncQueueState.TO_BE_PROCESSED.getStateCode(), AgrEnum.ScopeSyncQueueState.PROCESSING_FAILED.getStateCode()));
        agreementScopeSyncQueuePO.setOrderBy("failure_count asc,id asc");
        List<AgreementScopeSyncQueuePO> listPage = this.agreementScopeSyncQueueMapper.getListPage(agreementScopeSyncQueuePO, (Page<AgreementScopeSyncQueuePO>)page);
        if (CollectionUtils.isEmpty(listPage)) {
            return rspBO;
        }
        rspBO.setQueueList(JSONArray.parseArray((String)JSONArray.toJSONString(listPage), AgreementScopeSyncQueueBO.class));
        AgreementScopeSyncQueuePO setPo = new AgreementScopeSyncQueuePO();
        setPo.setRunResult(AgrEnum.ScopeSyncQueueState.IN_PROCESS.getStateCode());
        setPo.setUpdateTime(new Date());
        AgreementScopeSyncQueuePO wherePo = new AgreementScopeSyncQueuePO();
        wherePo.setIdIn(listPage.stream().map(AgreementScopeSyncQueuePO::getId).distinct().collect(Collectors.toList()));
        wherePo.setRunResultIn(Arrays.asList(AgrEnum.ScopeSyncQueueState.TO_BE_PROCESSED.getStateCode(), AgrEnum.ScopeSyncQueueState.PROCESSING_FAILED.getStateCode()));
        wherePo.setFailureCountIn(Arrays.asList(0, 1, 2, 3, 4, 5));
        int count = this.agreementScopeSyncQueueMapper.updateBy(setPo, wherePo);
        if (count != wherePo.getIdIn().size()) {
            throw new BusinessException("8888", "\u66f4\u65b0\u72b6\u6001\u4e3a\u5904\u7406\u4e2d\u5931\u8d25");
        }
        return rspBO;
    }

    public AgrAgreementScopeSyncQueueRspBO updateToFail(AgrAgreementScopeSyncQueueReqBO reqBO) {
        AgrAgreementScopeSyncQueueRspBO rspBO = new AgrAgreementScopeSyncQueueRspBO();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getQueueList())) {
            AgreementScopeSyncQueuePO setPo = new AgreementScopeSyncQueuePO();
            setPo.setRunResult(AgrEnum.ScopeSyncQueueState.PROCESSING_FAILED.getStateCode());
            setPo.setFailureCountChange(1);
            if (reqBO.getMsg() != null && reqBO.getMsg().length() > 4000) {
                reqBO.setMsg(reqBO.getMsg().substring(0, 4000));
            }
            setPo.setFailureReason(reqBO.getMsg());
            setPo.setUpdateTime(new Date());
            AgreementScopeSyncQueuePO wherePo = new AgreementScopeSyncQueuePO();
            wherePo.setIdIn(reqBO.getQueueList().stream().map(AgreementScopeSyncQueueBO::getId).distinct().collect(Collectors.toList()));
            this.agreementScopeSyncQueueMapper.updateBy(setPo, wherePo);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public AgrAgreementScopeSyncQueueRspBO updateToSuccess(AgrAgreementScopeSyncQueueReqBO reqBO) {
        AgrAgreementScopeSyncQueueRspBO rspBO = new AgrAgreementScopeSyncQueueRspBO();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getQueueList())) {
            AgreementScopeSyncQueuePO agreementScopeSyncQueuePO = new AgreementScopeSyncQueuePO();
            agreementScopeSyncQueuePO.setIdIn(reqBO.getQueueList().stream().map(AgreementScopeSyncQueueBO::getId).distinct().collect(Collectors.toList()));
            this.agreementScopeSyncQueueMapper.deleteBy(agreementScopeSyncQueuePO);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public AgrAgreementScopeSyncQueueRspBO updateInProcessToFail(AgrAgreementScopeSyncQueueReqBO reqBO) {
        AgrAgreementScopeSyncQueueRspBO rspBO = new AgrAgreementScopeSyncQueueRspBO();
        AgreementScopeSyncQueuePO redoQueuePo = new AgreementScopeSyncQueuePO();
        redoQueuePo.setRunResult(AgrEnum.ScopeSyncQueueState.IN_PROCESS.getStateCode());
        LocalDateTime localDateTime = LocalDateTime.now();
        localDateTime = localDateTime.minusHours(2L);
        redoQueuePo.setUpdateTimeEnd(Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant()));
        Page page = new Page(1, 100);
        List<AgreementScopeSyncQueuePO> redoQueueList = this.agreementScopeSyncQueueMapper.getListPage(redoQueuePo, (Page<AgreementScopeSyncQueuePO>)page);
        if (!CollectionUtils.isEmpty(redoQueueList)) {
            AgreementScopeSyncQueuePO busiRedoQueuePoSet = new AgreementScopeSyncQueuePO();
            busiRedoQueuePoSet.setRunResult(AgrEnum.ScopeSyncQueueState.PROCESSING_FAILED.getStateCode());
            busiRedoQueuePoSet.setUpdateTime(new Date());
            AgreementScopeSyncQueuePO busiRedoQueuePoWhere = new AgreementScopeSyncQueuePO();
            busiRedoQueuePoWhere.setIdIn(redoQueueList.stream().map(AgreementScopeSyncQueuePO::getId).collect(Collectors.toList()));
            busiRedoQueuePoWhere.setRunResult(AgrEnum.ScopeSyncQueueState.IN_PROCESS.getStateCode());
            this.agreementScopeSyncQueueMapper.updateBy(busiRedoQueuePoSet, busiRedoQueuePoWhere);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

