/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.agreement.busi.AgrAgreementSubmitBusiService;
import com.tydic.agreement.busi.bo.AgrAgreementSubmitBusiReqBO;
import com.tydic.agreement.busi.bo.AgrAgreementSubmitBusiRspBO;
import com.tydic.agreement.common.bo.AgrAgreementBO;
import com.tydic.agreement.constant.AgrCommConstant;
import com.tydic.agreement.constant.AgrEnum;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.AgreementSkuMapper;
import com.tydic.agreement.dao.po.AgreementPO;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="agrAgreementSubmitBusiService")
public class AgrAgreementSubmitBusiServiceImpl
implements AgrAgreementSubmitBusiService {
    private static final Logger log = LoggerFactory.getLogger(AgrAgreementSubmitBusiServiceImpl.class);
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgreementSkuMapper agreementSkuMapper;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Value(value="${hasConfirmLike}")
    private Boolean hasConfirmLike;

    public AgrAgreementSubmitBusiRspBO submitAgreementInfo(AgrAgreementSubmitBusiReqBO busiReqBO) {
        AgrAgreementSubmitBusiRspBO busiRspBO = new AgrAgreementSubmitBusiRspBO();
        int checkedWZVariety = this.agreementSkuMapper.checkWZVariety(busiReqBO.getAgreementId(), new HashSet<Integer>(Arrays.asList(AgrEnum.Variety.GC.getCode(), AgrEnum.Variety.FW.getCode())));
        if (AgrCommConstant.AgrSaveOrSubmit.SUBMIT.equals(busiReqBO.getOperType())) {
            int count;
            AgreementPO po = new AgreementPO();
            po.setAgreementId(busiReqBO.getAgreementId());
            po.setSupplierId(busiReqBO.getSupplierId());
            this.createProcess(busiReqBO.getAgreementId(), busiReqBO.getAgrAgreementBO());
            po.setAgreementStatus(AgrCommConstant.AgreementStatus.IN_AUDIT);
            if (this.hasConfirmLike.booleanValue() && !AgrEnum.RelSystem.SRM.toString().equalsIgnoreCase(busiReqBO.getAgrAgreementBO().getRelSystem())) {
                po.setAgreementStatus(AgrCommConstant.AgreementStatus.TO_CONFIRM);
            }
            if (checkedWZVariety > 1 && !AgrEnum.RelSystem.SRM.toString().equalsIgnoreCase(busiReqBO.getAgrAgreementBO().getRelSystem())) {
                po.setCorrectFlag(Byte.valueOf("1"));
            }
            if ((count = this.agreementMapper.updateByCondition(po)) < 1) {
                throw new BusinessException("22005", "\u66f4\u65b0\u534f\u8bae\u72b6\u6001\u5931\u8d25");
            }
        } else {
            AgreementPO po = new AgreementPO();
            po.setAgreementId(busiReqBO.getAgreementId());
            if (checkedWZVariety > 1 && !AgrEnum.RelSystem.SRM.toString().equalsIgnoreCase(busiReqBO.getAgrAgreementBO().getRelSystem())) {
                po.setCorrectFlag(Byte.valueOf("1"));
                int count = this.agreementMapper.updateByCondition(po);
                if (count < 1) {
                    throw new BusinessException("22005", "\u66f4\u65b0\u534f\u8bae\u72b6\u6001\u5931\u8d25");
                }
            }
        }
        if (checkedWZVariety > 1 && !AgrEnum.RelSystem.SRM.toString().equalsIgnoreCase(busiReqBO.getAgrAgreementBO().getRelSystem())) {
            busiRspBO.setCorrectFlag(Boolean.valueOf(true));
        }
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u534f\u8bae\u63d0\u4ea4\u4fdd\u5b58\u6210\u529f");
        return busiRspBO;
    }

    private void createProcess(Long agreementId, AgrAgreementBO agrAgreementBO) {
        ArrayList<ApprovalObjBO> approvalObjInfo = new ArrayList<ApprovalObjBO>();
        ApprovalObjBO approvalObjBO = new ApprovalObjBO();
        approvalObjBO.setObjType(AgrCommConstant.AuditObjType.AGREEMENT_AUDIT);
        approvalObjBO.setObjId(agreementId.toString());
        approvalObjInfo.add(approvalObjBO);
        ArrayList<UacNoTaskAuditCreateInfoReqBO> uacNoTaskAuditCreateInfoReqBOs = new ArrayList<UacNoTaskAuditCreateInfoReqBO>();
        UacNoTaskAuditCreateInfoReqBO uacNoTaskAuditCreateInfoReqBO = new UacNoTaskAuditCreateInfoReqBO();
        uacNoTaskAuditCreateInfoReqBO.setObjType(AgrCommConstant.AuditObjType.AGREEMENT_AUDIT);
        uacNoTaskAuditCreateInfoReqBO.setObjNum("1");
        uacNoTaskAuditCreateInfoReqBO.setOrderId(agreementId);
        uacNoTaskAuditCreateInfoReqBO.setRemark("\u534f\u8bae\u65b0\u589e\u5ba1\u6279");
        uacNoTaskAuditCreateInfoReqBO.setApprovalObjInfo(approvalObjInfo);
        uacNoTaskAuditCreateInfoReqBOs.add(uacNoTaskAuditCreateInfoReqBO);
        UacNoTaskAuditCreateReqBO uacNoTaskAuditCreateReqBO = new UacNoTaskAuditCreateReqBO();
        if (AgrCommConstant.agreementMode.PLAT_AGREEMENT.equals(agrAgreementBO.getAgreementMode())) {
            uacNoTaskAuditCreateReqBO.setProcDefKey("agreementPlatAudit");
        } else if (AgrCommConstant.agreementMode.UNIT_AGREEMENT.equals(agrAgreementBO.getAgreementMode())) {
            uacNoTaskAuditCreateReqBO.setProcDefKey("agreementPurchaseAudit");
        }
        uacNoTaskAuditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
        uacNoTaskAuditCreateReqBO.setCreateOperDept(agrAgreementBO.getVendorDepartmentName());
        uacNoTaskAuditCreateReqBO.setCreateOperId(agrAgreementBO.getProducerId().toString());
        uacNoTaskAuditCreateReqBO.setCreateOperName(agrAgreementBO.getProducerName());
        uacNoTaskAuditCreateReqBO.setCreateBusiReqBO(uacNoTaskAuditCreateInfoReqBOs);
        HashMap<String, Object> variables = new HashMap<String, Object>(4);
        if (AgrEnum.RelSystem.SRM.toString().equalsIgnoreCase(agrAgreementBO.getRelSystem())) {
            variables.put("hasConfirm", false);
            variables.put("acceptFlag", "1");
        } else {
            variables.put("hasConfirm", this.hasConfirmLike);
            if (!this.hasConfirmLike.booleanValue()) {
                variables.put("acceptFlag", "1");
            }
        }
        uacNoTaskAuditCreateReqBO.setVariables(variables);
        log.debug("\u8c03\u7528\u5ba1\u6279\u6a21\u5757\u65e0\u6d41\u7a0b\u5ba1\u6279\u5355\u521b\u5efaAPI\u5165\u53c2\uff1a" + JSON.toJSONString((Object)uacNoTaskAuditCreateReqBO));
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(uacNoTaskAuditCreateReqBO);
        log.debug("\u8c03\u7528\u5ba1\u6279\u6a21\u5757\u65e0\u6d41\u7a0b\u5ba1\u6279\u5355\u521b\u5efaAPI\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)uacNoTaskAuditCreateRspBO));
        if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
            throw new BusinessException(uacNoTaskAuditCreateRspBO.getRespCode(), uacNoTaskAuditCreateRspBO.getRespDesc());
        }
    }
}

