/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.agreement.busi.AgrAssignAgreementBusiService;
import com.tydic.agreement.busi.bo.AgrAssignAgreementBusiReqBO;
import com.tydic.agreement.busi.bo.AgrAssignAgreementBusiRspBO;
import com.tydic.agreement.constant.AgrCommConstant;
import com.tydic.agreement.dao.AgreementAssignLogMapper;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.po.AgreementAssignLogPO;
import com.tydic.agreement.dao.po.AgreementPO;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AgrAssignAgreementBusiServiceImpl
implements AgrAssignAgreementBusiService {
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgreementAssignLogMapper agreementAssignLogMapper;

    public AgrAssignAgreementBusiRspBO assignAgreement(AgrAssignAgreementBusiReqBO busiReqBO) {
        AgrAssignAgreementBusiRspBO rsp = new AgrAssignAgreementBusiRspBO();
        AgreementPO agreementPO = new AgreementPO();
        agreementPO.setAgreementId(busiReqBO.getAgreementId());
        agreementPO.setSupplierId(busiReqBO.getSupplierId());
        agreementPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        AgreementPO agreement = this.agreementMapper.getModelBy(agreementPO);
        if (null == agreement) {
            throw new BusinessException("22001", "\u4e0d\u5b58\u5728\u8be5\u534f\u8bae\uff01");
        }
        this.assign(busiReqBO);
        AgreementAssignLogPO agreementAssignLogPO = new AgreementAssignLogPO();
        agreementAssignLogPO.setAgreementAssignId(Sequence.getInstance().nextId());
        agreementAssignLogPO.setAgreementId(agreement.getAgreementId());
        agreementAssignLogPO.setAgreementName(agreement.getAgreementName());
        agreementAssignLogPO.setSupplierId(agreement.getSupplierId());
        agreementAssignLogPO.setSupplierName(agreement.getSupplierName());
        agreementAssignLogPO.setPreProducerId(agreement.getProducerId());
        agreementAssignLogPO.setPreProducerName(agreement.getProducerName());
        agreementAssignLogPO.setPostProducerId(busiReqBO.getPostProducerId());
        agreementAssignLogPO.setPostProducerName(busiReqBO.getPostProducerName());
        agreementAssignLogPO.setOperater(busiReqBO.getUsername());
        agreementAssignLogPO.setOperateTime(new Date());
        int isInsert = this.agreementAssignLogMapper.insert(agreementAssignLogPO);
        if (isInsert < 1) {
            throw new BusinessException("22003", "\u63d2\u5165\u6846\u67b6\u534f\u8bae\u914d\u7f6e\u8bb0\u5f55\u8868\u5931\u8d25\uff01");
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u534f\u8bae\u5206\u914d\u6210\u529f\uff01");
        return rsp;
    }

    private void assign(AgrAssignAgreementBusiReqBO busiReqBO) {
        AgreementPO agreementPO = new AgreementPO();
        agreementPO.setAgreementId(busiReqBO.getAgreementId());
        agreementPO.setSupplierId(busiReqBO.getSupplierId());
        agreementPO.setProducerId(busiReqBO.getPostProducerId());
        agreementPO.setProducerName(busiReqBO.getPostProducerName());
        agreementPO.setAssignStatus(AgrCommConstant.AssignStatus.BE_ASSIGN);
        agreementPO.setUpdateLoginId(busiReqBO.getMemIdIn());
        agreementPO.setUpdateName(busiReqBO.getUsername());
        agreementPO.setUpdateTime(new Date());
        int isUpdate = this.agreementMapper.updateByCondition(agreementPO);
        if (isUpdate < 1) {
            throw new BusinessException("22005", "\u534f\u8bae\u8868\u66f4\u65b0\u5931\u8d25\uff01");
        }
    }
}

